/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.editors;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.query.IBaseBuildEngineQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditor;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorInput;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.build.ComponentListProperty;
import com.ibm.team.enterprise.build.common.promotion.build.ComponentListPropertyParser;
import com.ibm.team.enterprise.build.common.promotion.build.IComponentListProperty;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.common.ui.EESharedImages;
import com.ibm.team.enterprise.common.ui.dialogs.MessagePromptDialog;
import com.ibm.team.enterprise.internal.promotion.ui.PromotionUIPlugin;
import com.ibm.team.enterprise.internal.promotion.ui.dialogs.PromotionBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.internal.promotion.ui.editors.AbstractConfigurationEditor;
import com.ibm.team.enterprise.internal.promotion.ui.editors.CheckboxExpandableComposite;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.utils.BuildUtils;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.client.internal.RepositoryItemProvider;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ComponentEntry;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractPromotionConfigurationEditor
extends AbstractConfigurationEditor {
    protected static final String VALIDATION_ERROR_NO_SOURCE_BUILD_DEFINITION = "validationErrorNoSourceBuildDefinition";
    protected static final String VALIDATION_ERROR_NO_TARGET_BUILD_DEFINITION = "validationErrorNoTargetBuildDefinition";
    protected static final String VALIDATION_ERROR_NO_SCAN_CONFIGURATION = "validationErrorNoScanConfiguration";
    protected static final String VALIDATION_ERROR_SOURCE_AND_TARGET_NO_MATCH = "validationErrorSourceAndTargetNoMatch";
    protected static final String VALIDATION_ERROR_PROMOTION_ENGINE_INVALID = "validationErrorPromotionEngineInvalid";
    protected static final String VALIDATION_ERROR_SOURCE_ENGINE_INVALID = "validationErrorSourceEngineInvalid";
    protected static final String VALIDATION_ERROR_TARGET_ENGINE_INVALID = "validationErrorTargetEngineInvalid";
    protected static final String VALIDATION_ERROR_INVALID_PROMOTION_TYPE = "validationErrorInvalidPromotionType";
    protected static final String VALIDATION_ERROR_INVALID_BUILD_FILE = "validationErrorInvalidBuildFile";
    protected static final String VALIDATION_WARN_NO_COMPONENT_SELECTED = "validationWarnNoComponentSelected";
    protected static final String VALIDATION_WARN_PUBLISH_BUILD_MAP_LINKS = "validationWarnPublishBuildMapLinks";
    private static final String BF_CONFIG_ELEMENT = "com.ibm.rational.buildforge.buildagent";
    private static final String BF_CONFIG_PROPERTY_HOSTNAME = "com.ibm.rational.buildforge.buildagent.hostname";
    protected static final String ERROR_PROMOTION_TYPE_NOT_SELECTED = "PromotionTypeNotSelected";
    protected static int SECTION_INDENT = 10;
    protected Hyperlink sourceBuildDefinitionLink;
    protected Text sourceBuildDefinitionTextField;
    protected Hyperlink targetBuildDefinitionLink;
    protected Text targetBuildDefinitionTextField;
    private Composite streamNoScanningWarningHolder;
    protected CheckboxExpandableComposite componentPromotionCheckbox;
    protected CheckboxTableViewer componentViewer;
    protected Button selectAllBtn;
    protected Button deselectAllBtn;
    protected CheckboxExpandableComposite workItemPromotionCheckbox;
    protected Combo workItemPromotionTypeCombo;
    protected Combo includeWorkItemChildrenCombo;
    protected Combo considerIgnoredChangesCombo;
    protected Combo includeImpactedOutputCombo;
    protected Combo ignoreValidationErrorForImpactedFilesCombo;
    protected Button createSnapshotCheckbox;
    protected Button skipTimestampValidationCheckbox;
    protected Button publishBuildMapCheckbox;
    protected Button useGeneratedBuildFileCheckbox;
    protected Button useCustomBuildFileCheckbox;
    protected Text customBuildFileTextField;
    protected Text customBuildTargetTextField;
    protected Text antHomeTextField;
    protected Text antArgumentTextField;
    protected Text workingDirectoryTextField;
    protected Text javaHomeTextField;
    protected Text javaArgumentTextField;
    protected Text propertyFileTextField;
    private UIUpdaterJob getScanConfigurationJob;
    private final List<IBuildEngine> allBuildEngines = new LinkedList<IBuildEngine>();

    public AbstractPromotionConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new FormLayout());
        this.layoutSections(parent);
        this.fetchSourceAndTargetBuildDefinitions();
        this.fetchAllBuildEngines();
    }

    protected abstract void layoutSections(Composite var1);

    protected abstract PromotionInfo.PromotionBuildType getPromotionBuildType();

    protected Section createScopeSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 320);
        section.setText(Messages.AbstractPromotionConfigurationEditor_SECTION_SCOPE_LABEL);
        section.setLayout((Layout)new FillLayout());
        Composite sectionContainer = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(sectionContainer);
        section.setClient((Control)sectionContainer);
        this.sourceBuildDefinitionLink = toolkit.createHyperlink(sectionContainer, Messages.PromotionConfigurationEditor_CONFIG_SOURCE_LABEL, 0);
        this.sourceBuildDefinitionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractPromotionConfigurationEditor.this.openBuildDefinition((IBuildDefinition)AbstractPromotionConfigurationEditor.this.sourceBuildDefinitionLink.getData());
            }
        });
        this.sourceBuildDefinitionTextField = toolkit.createText(sectionContainer, "");
        this.sourceBuildDefinitionTextField.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.sourceBuildDefinitionTextField);
        Button sourceBuildDefinitionBrowseBtn = toolkit.createButton(sectionContainer, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_BROWSE, 8);
        sourceBuildDefinitionBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionBuildDefinitionSelectionDialog dlg = AbstractPromotionConfigurationEditor.this.getBuildDefinitionSelectionDialog((IBuildDefinition)AbstractPromotionConfigurationEditor.this.targetBuildDefinitionLink.getData());
                if (dlg.open() == 0) {
                    IBuildDefinition buildDefinition = dlg.getFirstSelectedBuildDefinition();
                    AbstractPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.sourceDefinition", buildDefinition.getItemId().getUuidValue());
                    AbstractPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.componentList", "");
                    AbstractPromotionConfigurationEditor.this.updateSourceInfoUI(buildDefinition, false);
                    AbstractPromotionConfigurationEditor.this.updateComponentViewer();
                    AbstractPromotionConfigurationEditor.this.setDirty(true);
                    AbstractPromotionConfigurationEditor.this.validate();
                    AbstractPromotionConfigurationEditor.this.validateBuildEngines();
                }
            }
        });
        this.targetBuildDefinitionLink = toolkit.createHyperlink(sectionContainer, Messages.PromotionConfigurationEditor_CONFIG_TARGET_LABEL, 0);
        this.targetBuildDefinitionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractPromotionConfigurationEditor.this.openBuildDefinition((IBuildDefinition)AbstractPromotionConfigurationEditor.this.targetBuildDefinitionLink.getData());
            }
        });
        this.targetBuildDefinitionTextField = toolkit.createText(sectionContainer, "");
        this.targetBuildDefinitionTextField.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.targetBuildDefinitionTextField);
        Button targetBuildDefinitionBrowseBtn = toolkit.createButton(sectionContainer, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_BROWSE, 8);
        targetBuildDefinitionBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionBuildDefinitionSelectionDialog dlg = AbstractPromotionConfigurationEditor.this.getBuildDefinitionSelectionDialog((IBuildDefinition)AbstractPromotionConfigurationEditor.this.sourceBuildDefinitionLink.getData());
                if (dlg.open() == 0) {
                    IBuildDefinition buildDefinition = dlg.getFirstSelectedBuildDefinition();
                    AbstractPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.targetDefinition", buildDefinition.getItemId().getUuidValue());
                    AbstractPromotionConfigurationEditor.this.updateTargetInfoUI(buildDefinition, false);
                    AbstractPromotionConfigurationEditor.this.fetchScanConfigurationStatusInBackground(buildDefinition);
                    AbstractPromotionConfigurationEditor.this.setDirty(true);
                    AbstractPromotionConfigurationEditor.this.validate();
                    AbstractPromotionConfigurationEditor.this.validateBuildEngines();
                }
            }
        });
        this.streamNoScanningWarningHolder = this.createScanningWarningHolder(sectionContainer, this.targetBuildDefinitionTextField);
        GridDataFactory.fillDefaults().span(3, 1).hint(0, 0).applyTo((Control)this.streamNoScanningWarningHolder);
        return section;
    }

    protected Section createPromotionTypeSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 320);
        section.setText(Messages.AbstractPromotionConfigurationEditor_SECTION_PROMOTION_TYPE_LABEL);
        section.setLayout((Layout)new FillLayout());
        Composite sectionContainer = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(sectionContainer);
        section.setClient((Control)sectionContainer);
        boolean isComponentPromotionSelected = this.getBooleanProperty("com.ibm.team.enterprise.promotion.type.comp") || this.getBooleanProperty("com.ibm.team.enterprise.promotion.type.both", true);
        this.componentPromotionCheckbox = new CheckboxExpandableComposite(sectionContainer, Messages.PromotionConfigurationEditor_TAB_TITLE_COMPONENT, isComponentPromotionSelected ? 2 : 0);
        this.componentPromotionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isComponentPromotionSelected = AbstractPromotionConfigurationEditor.this.componentPromotionCheckbox.getSelection();
                boolean isWorkItemPromotionSelected = AbstractPromotionConfigurationEditor.this.workItemPromotionCheckbox.getSelection();
                boolean isComponentPromotionOnly = isComponentPromotionSelected && !isWorkItemPromotionSelected;
                boolean isWorkItemPromotionOnly = isWorkItemPromotionSelected && !isComponentPromotionSelected;
                boolean isBothPromotion = isComponentPromotionSelected && isWorkItemPromotionSelected;
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.type.wi", isWorkItemPromotionOnly);
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.type.comp", isComponentPromotionOnly);
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.type.both", isBothPromotion);
                AbstractPromotionConfigurationEditor.this.updateComponentViewer();
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        Composite componentPromotionComposite = toolkit.createComposite((Composite)this.componentPromotionCheckbox);
        this.componentPromotionCheckbox.setClient((Control)componentPromotionComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(componentPromotionComposite);
        Label label = toolkit.createLabel(componentPromotionComposite, Messages.PromotionConfigurationEditor_CONFIG_COMPONENT_LABEL);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        Table componentTable = toolkit.createTable(componentPromotionComposite, 66338);
        componentTable.setSize(200, 150);
        GridDataFactory.fillDefaults().grab(true, false).hint(200, 150).applyTo((Control)componentTable);
        this.componentViewer = new CheckboxTableViewer(componentTable);
        this.componentViewer.setContentProvider((IContentProvider)new ComponentSelectionContentProvider());
        this.componentViewer.setLabelProvider((IBaseLabelProvider)new ComponentSelectionLabelProvider());
        this.componentViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractPromotionConfigurationEditor.this.saveComponentSelectionToBuildProperty();
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        Composite buttonComposite = toolkit.createComposite(componentPromotionComposite);
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.pack = false;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridDataFactory.fillDefaults().grab(false, true).align(4, 1).applyTo((Control)buttonComposite);
        this.selectAllBtn = toolkit.createButton(buttonComposite, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_SELECTALL, 8);
        this.selectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.componentViewer.getTable().getItemCount() > 0) {
                    AbstractPromotionConfigurationEditor.this.componentViewer.setAllChecked(true);
                }
                AbstractPromotionConfigurationEditor.this.saveComponentSelectionToBuildProperty();
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        this.deselectAllBtn = toolkit.createButton(buttonComposite, Messages.PromotionConfigurationEditor_CONFIG_BUTTON_DESELECT, 8);
        this.deselectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.componentViewer.getTable().getItemCount() > 0) {
                    AbstractPromotionConfigurationEditor.this.componentViewer.setAllChecked(false);
                }
                AbstractPromotionConfigurationEditor.this.saveComponentSelectionToBuildProperty();
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        this.updateSelectAndDeselectButtonStates();
        boolean isWorkItemPromotionSelected = this.getBooleanProperty("com.ibm.team.enterprise.promotion.type.wi") || this.getBooleanProperty("com.ibm.team.enterprise.promotion.type.both", true);
        this.workItemPromotionCheckbox = new CheckboxExpandableComposite(sectionContainer, Messages.PromotionConfigurationEditor_TAB_TITLE_WORKITEM, isWorkItemPromotionSelected ? 2 : 0);
        this.workItemPromotionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isComponentPromotionSelected = AbstractPromotionConfigurationEditor.this.componentPromotionCheckbox.getSelection();
                boolean isWorkItemPromotionSelected = AbstractPromotionConfigurationEditor.this.workItemPromotionCheckbox.getSelection();
                boolean isComponentPromotionOnly = isComponentPromotionSelected && !isWorkItemPromotionSelected;
                boolean isWorkItemPromotionOnly = isWorkItemPromotionSelected && !isComponentPromotionSelected;
                boolean isBothPromotion = isComponentPromotionSelected && isWorkItemPromotionSelected;
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.type.wi", isWorkItemPromotionOnly);
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.type.comp", isComponentPromotionOnly);
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.type.both", isBothPromotion);
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        Composite workItemPromotionComposite = toolkit.createComposite((Composite)this.workItemPromotionCheckbox);
        this.workItemPromotionCheckbox.setClient((Control)workItemPromotionComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(workItemPromotionComposite);
        Label descLabel = toolkit.createLabel(workItemPromotionComposite, Messages.AbstractPromotionConfigurationEditor_WI_PROMOTION_OPTIONS_DESC, 64);
        GC gc = new GC((Drawable)descLabel.getDisplay());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        GridDataFactory.fillDefaults().span(2, 1).hint(300, height * 3 + 5).applyTo((Control)descLabel);
        toolkit.createLabel(workItemPromotionComposite, Messages.AbstractPromotionConfigurationEditor_WI_PROMOTION_TYPE_LABEL);
        this.workItemPromotionTypeCombo = new Combo(workItemPromotionComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).minSize(150, -1).applyTo((Control)this.workItemPromotionTypeCombo);
        this.workItemPromotionTypeCombo.add(Messages.AbstractPromotionConfigurationEditor_USER_SPECIFIED_OPTION);
        this.workItemPromotionTypeCombo.add(Messages.PromotionWorkItemWizardPage_TEXT_SOURCEANDOUTPUTS);
        this.workItemPromotionTypeCombo.add(Messages.PromotionWorkItemWizardPage_TEXT_SOURCEONLY);
        this.workItemPromotionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = AbstractPromotionConfigurationEditor.this.workItemPromotionTypeCombo.getSelectionIndex();
                if (selectedIndex == 0) {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion", "true");
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.sourceonly", "false");
                } else if (selectedIndex == 1) {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion", "false");
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.sourceonly", "false");
                } else {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion", "false");
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.sourceonly", "true");
                }
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        boolean isUserSpecified = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.decide.in.promotion", true);
        boolean isPromoteSourceOnly = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.sourceonly");
        if (isUserSpecified) {
            this.workItemPromotionTypeCombo.select(0);
        } else if (isPromoteSourceOnly) {
            this.workItemPromotionTypeCombo.select(2);
        } else {
            this.workItemPromotionTypeCombo.select(1);
        }
        toolkit.createLabel(workItemPromotionComposite, Messages.PromotionWorkItemWizardPage_TEXT_INCLUDECHILDREN);
        this.includeWorkItemChildrenCombo = new Combo(workItemPromotionComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.includeWorkItemChildrenCombo);
        this.includeWorkItemChildrenCombo.add(Messages.AbstractPromotionConfigurationEditor_USER_SPECIFIED_OPTION);
        this.includeWorkItemChildrenCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_ENABLED);
        this.includeWorkItemChildrenCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_DISABLED);
        this.includeWorkItemChildrenCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.includeWorkItemChildrenCombo.getSelectionIndex() == 0) {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.include.children", Boolean.TRUE.toString());
                } else {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.include.children", String.valueOf(AbstractPromotionConfigurationEditor.this.includeWorkItemChildrenCombo.getSelectionIndex() == 1));
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.include.children", Boolean.FALSE.toString());
                }
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        isUserSpecified = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.decide.include.children", true);
        boolean isAlwaysEnabled = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.include.children");
        if (isUserSpecified) {
            this.includeWorkItemChildrenCombo.select(0);
        } else if (isAlwaysEnabled) {
            this.includeWorkItemChildrenCombo.select(1);
        } else {
            this.includeWorkItemChildrenCombo.select(2);
        }
        toolkit.createLabel(workItemPromotionComposite, Messages.PromotionWorkItemWizardPage_TEXT_INCLUDEIMPACTED);
        this.includeImpactedOutputCombo = new Combo(workItemPromotionComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.includeImpactedOutputCombo);
        this.includeImpactedOutputCombo.add(Messages.AbstractPromotionConfigurationEditor_USER_SPECIFIED_OPTION);
        this.includeImpactedOutputCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_ENABLED);
        this.includeImpactedOutputCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_DISABLED);
        this.includeImpactedOutputCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.includeImpactedOutputCombo.getSelectionIndex() == 0) {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted", Boolean.TRUE.toString());
                } else {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.include.impacted", String.valueOf(AbstractPromotionConfigurationEditor.this.includeImpactedOutputCombo.getSelectionIndex() == 1));
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted", Boolean.FALSE.toString());
                }
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        isUserSpecified = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.decide.include.impacted", true);
        isAlwaysEnabled = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.include.impacted");
        if (isUserSpecified) {
            this.includeImpactedOutputCombo.select(0);
        } else if (isAlwaysEnabled) {
            this.includeImpactedOutputCombo.select(1);
        } else {
            this.includeImpactedOutputCombo.select(2);
        }
        this.createLabelWithTooltip(workItemPromotionComposite, Messages.PromotionWorkItemWizardPage_TEXT_IGNORECHANGES, Messages.AbstractPromotionConfigurationEditor_DESC_IGNORECHANGES, toolkit);
        this.considerIgnoredChangesCombo = new Combo(workItemPromotionComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.considerIgnoredChangesCombo);
        this.considerIgnoredChangesCombo.add(Messages.AbstractPromotionConfigurationEditor_USER_SPECIFIED_OPTION);
        this.considerIgnoredChangesCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_ENABLED);
        this.considerIgnoredChangesCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_DISABLED);
        this.considerIgnoredChangesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.considerIgnoredChangesCombo.getSelectionIndex() == 0) {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes", Boolean.TRUE.toString());
                } else {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.ignore.changes", String.valueOf(AbstractPromotionConfigurationEditor.this.considerIgnoredChangesCombo.getSelectionIndex() == 1));
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes", Boolean.FALSE.toString());
                }
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        isUserSpecified = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.decide.ignore.changes", true);
        isAlwaysEnabled = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.ignore.changes");
        if (isUserSpecified) {
            this.considerIgnoredChangesCombo.select(0);
        } else if (isAlwaysEnabled) {
            this.considerIgnoredChangesCombo.select(1);
        } else {
            this.considerIgnoredChangesCombo.select(2);
        }
        this.createLabelWithTooltip(workItemPromotionComposite, Messages.PromotionWorkItemWizardPage_TEXT_IGNOREVALIDATIONERRORFORIMPACTEDFILES, Messages.AbstractPromotionConfigurationEditor_DESC_IGNOREVALIDATIONERRORFORIMPACTEDFILES, toolkit);
        this.ignoreValidationErrorForImpactedFilesCombo = new Combo(workItemPromotionComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.ignoreValidationErrorForImpactedFilesCombo);
        this.ignoreValidationErrorForImpactedFilesCombo.add(Messages.AbstractPromotionConfigurationEditor_USER_SPECIFIED_OPTION);
        this.ignoreValidationErrorForImpactedFilesCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_ENABLED);
        this.ignoreValidationErrorForImpactedFilesCombo.add(Messages.AbstractPromotionConfigurationEditor_ALWAYS_DISABLED);
        this.ignoreValidationErrorForImpactedFilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.ignoreValidationErrorForImpactedFilesCombo.getSelectionIndex() == 0) {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.ignore.validation.error.for.impacted.files", Boolean.TRUE.toString());
                } else {
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.ignore.validation.error.for.impacted.files", String.valueOf(AbstractPromotionConfigurationEditor.this.ignoreValidationErrorForImpactedFilesCombo.getSelectionIndex() == 1));
                    AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.workitem.decide.ignore.validation.error.for.impacted.files", Boolean.FALSE.toString());
                }
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        isUserSpecified = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.decide.ignore.validation.error.for.impacted.files", true);
        isAlwaysEnabled = this.getBooleanProperty("com.ibm.team.enterprise.promotion.workitem.ignore.validation.error.for.impacted.files");
        if (isUserSpecified) {
            this.ignoreValidationErrorForImpactedFilesCombo.select(0);
        } else if (isAlwaysEnabled) {
            this.ignoreValidationErrorForImpactedFilesCombo.select(1);
        } else {
            this.ignoreValidationErrorForImpactedFilesCombo.select(2);
        }
        return section;
    }

    protected Section createAdvancedOptionsSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 320);
        section.setText(Messages.AbstractPromotionConfigurationEditor_SECTION_ADVANCED_LABEL);
        section.setLayout((Layout)new FillLayout());
        Composite sectionContainer = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(sectionContainer);
        section.setClient((Control)sectionContainer);
        this.createSnapshotCheckbox = toolkit.createButton(sectionContainer, Messages.PromotionConfigurationEditor_CREATE_SNAPSHOT_LABEL, 32);
        GridDataFactory.fillDefaults().applyTo((Control)this.createSnapshotCheckbox);
        this.createSnapshotCheckbox.setSelection(this.getBooleanProperty("com.ibm.team.enterprise.promotion.createSnapshot"));
        this.createSnapshotCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.createSnapshot", AbstractPromotionConfigurationEditor.this.createSnapshotCheckbox.getSelection());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        this.skipTimestampValidationCheckbox = toolkit.createButton(sectionContainer, Messages.PromotionConfigurationEditor_SKIP_TIMESTAMP_CHECK_LABEL, 32);
        GridDataFactory.fillDefaults().applyTo((Control)this.skipTimestampValidationCheckbox);
        this.skipTimestampValidationCheckbox.setSelection(this.getBooleanProperty("com.ibm.team.enterprise.promotion.skipTimestampCheck"));
        this.skipTimestampValidationCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("com.ibm.team.enterprise.promotion.skipTimestampCheck", AbstractPromotionConfigurationEditor.this.skipTimestampValidationCheckbox.getSelection());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        this.publishBuildMapCheckbox = toolkit.createButton(sectionContainer, Messages.PromotionConfigurationEditor_BUTTON_BUILDMAPLINKS, 32);
        GridDataFactory.fillDefaults().applyTo((Control)this.publishBuildMapCheckbox);
        this.publishBuildMapCheckbox.setSelection(!this.getBooleanProperty("team.enterprise.promotion.suppressBuildMapLinks", true));
        this.publishBuildMapCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean shouldContinueWithSelection;
                if (AbstractPromotionConfigurationEditor.this.publishBuildMapCheckbox.getSelection() && !(shouldContinueWithSelection = MessagePromptDialog.openQuestion((Shell)AbstractPromotionConfigurationEditor.this.getSite().getShell(), (String)Messages.AbstractPromotionConfigurationEditor_PROMOTION_QUESTION_TITLE, (String)Messages.AbstractPromotionConfigurationEditor_CONFIRM_PUBLISH_BUILDMAP, (IPreferenceStore)PromotionUIPlugin.getDefault().getPreferenceStore(), (String)"promptPublishingBuildMapLinks"))) {
                    e.doit = false;
                    AbstractPromotionConfigurationEditor.this.publishBuildMapCheckbox.setSelection(!AbstractPromotionConfigurationEditor.this.publishBuildMapCheckbox.getSelection());
                    return;
                }
                AbstractPromotionConfigurationEditor.this.setProperty("team.enterprise.promotion.suppressBuildMapLinks", !AbstractPromotionConfigurationEditor.this.publishBuildMapCheckbox.getSelection());
                AbstractPromotionConfigurationEditor.this.addPublishBuildMapLinkWarning();
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        this.addPublishBuildMapLinkWarning();
        return section;
    }

    protected Section createAntConfigurationSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 258);
        section.setText(Messages.AbstractPromotionConfigurationEditor_SECTION_ANT_CONFIGURATION_LABEL);
        section.setLayout((Layout)new FillLayout());
        Composite sectionContainer = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionContainer);
        section.setClient((Control)sectionContainer);
        this.useGeneratedBuildFileCheckbox = toolkit.createButton(sectionContainer, Messages.PromotionConfigurationEditor_TARGET_BUTTON_GENERATE, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.useGeneratedBuildFileCheckbox);
        String customBuildFile = this.getProperty("teamz.build.ant.buildFile", "");
        this.useGeneratedBuildFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.useGeneratedBuildFileCheckbox.getSelection()) {
                    AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildFile", "");
                    AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildTarget", "");
                }
                AbstractPromotionConfigurationEditor.this.updateBuildFileFields(AbstractPromotionConfigurationEditor.this.useGeneratedBuildFileCheckbox.getSelection());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        this.useCustomBuildFileCheckbox = toolkit.createButton(sectionContainer, Messages.PromotionConfigurationEditor_TARGET_BUTTON_CUSTOM, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.useCustomBuildFileCheckbox);
        this.useCustomBuildFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPromotionConfigurationEditor.this.useCustomBuildFileCheckbox.getSelection()) {
                    AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildFile", AbstractPromotionConfigurationEditor.this.customBuildFileTextField.getText().trim());
                    AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildTarget", AbstractPromotionConfigurationEditor.this.customBuildTargetTextField.getText().trim());
                } else {
                    AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildFile", "");
                    AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildTarget", "");
                }
                AbstractPromotionConfigurationEditor.this.updateBuildFileFields(AbstractPromotionConfigurationEditor.this.useGeneratedBuildFileCheckbox.getSelection());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        Label customBuildFileLabel = toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_TARGET_BUILDFILE_LABEL);
        GridDataFactory.fillDefaults().indent(20, -1).applyTo((Control)customBuildFileLabel);
        this.customBuildFileTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.customBuildFileTextField);
        this.customBuildFileTextField.setText(customBuildFile.isEmpty() ? "" : this.getProperty("teamz.build.ant.buildFile"));
        this.customBuildFileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildFile", AbstractPromotionConfigurationEditor.this.customBuildFileTextField.getText().trim());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
                AbstractPromotionConfigurationEditor.this.validate();
            }
        });
        Label customBuildTargetLabel = toolkit.createLabel(sectionContainer, Messages.PromotionConfigurationEditor_TARGET_BUILDTARGET_LABEL);
        GridDataFactory.fillDefaults().indent(20, -1).applyTo((Control)customBuildTargetLabel);
        this.customBuildTargetTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.customBuildTargetTextField);
        this.customBuildTargetTextField.setText(customBuildFile.isEmpty() ? "" : this.getProperty("teamz.build.ant.buildTarget"));
        this.customBuildTargetTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.buildTarget", AbstractPromotionConfigurationEditor.this.customBuildTargetTextField.getText().trim());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        this.updateBuildFileFields(customBuildFile.isEmpty());
        toolkit.createLabel(sectionContainer, Messages.AntzConfigurationEditor_ANT_HOME_LABEL);
        this.antHomeTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.antHomeTextField);
        this.antHomeTextField.setText(this.getProperty("teamz.build.ant.antHome"));
        this.antHomeTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.antHome", AbstractPromotionConfigurationEditor.this.antHomeTextField.getText().trim());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        toolkit.createLabel(sectionContainer, Messages.AntzConfigurationEditor_ANT_ARGS_LABEL);
        this.antArgumentTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.antArgumentTextField);
        this.antArgumentTextField.setText(this.getProperty("teamz.build.ant.antArgs", "-verbose"));
        this.antArgumentTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.antArgs", AbstractPromotionConfigurationEditor.this.antArgumentTextField.getText());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        toolkit.createLabel(sectionContainer, Messages.AntzConfigurationEditor_WORKING_DIR_LABEL);
        this.workingDirectoryTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.workingDirectoryTextField);
        this.workingDirectoryTextField.setText(this.getProperty("teamz.build.ant.workingDir"));
        this.workingDirectoryTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.workingDir", AbstractPromotionConfigurationEditor.this.workingDirectoryTextField.getText().trim());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        toolkit.createLabel(sectionContainer, Messages.AntzConfigurationEditor_JAVA_HOME_LABEL);
        this.javaHomeTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.javaHomeTextField);
        this.javaHomeTextField.setText(this.getProperty("teamz.build.ant.javaHome"));
        this.javaHomeTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.javaHome", AbstractPromotionConfigurationEditor.this.javaHomeTextField.getText().trim());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        toolkit.createLabel(sectionContainer, Messages.AntzConfigurationEditor_VM_ARGS_LABEL);
        this.javaArgumentTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.javaArgumentTextField);
        this.javaArgumentTextField.setText(this.getProperty("teamz.build.ant.javaVMArgs", "-Xquickstart"));
        this.javaArgumentTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.javaVMArgs", AbstractPromotionConfigurationEditor.this.javaArgumentTextField.getText().trim());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        toolkit.createLabel(sectionContainer, Messages.AntzConfigurationEditor_PROPERTIES_LABEL);
        this.propertyFileTextField = toolkit.createText(sectionContainer, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.propertyFileTextField);
        this.propertyFileTextField.setText(this.getProperty("teamz.build.ant.propertiesFile"));
        this.propertyFileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPromotionConfigurationEditor.this.setProperty("teamz.build.ant.propertiesFile", AbstractPromotionConfigurationEditor.this.propertyFileTextField.getText().trim());
                AbstractPromotionConfigurationEditor.this.setDirty(true);
            }
        });
        return section;
    }

    protected void updateBuildFileFields(boolean useGeneratedBuildFile) {
        this.useGeneratedBuildFileCheckbox.setSelection(useGeneratedBuildFile);
        this.useCustomBuildFileCheckbox.setSelection(!useGeneratedBuildFile);
        this.customBuildFileTextField.setEnabled(!useGeneratedBuildFile);
        this.customBuildTargetTextField.setEnabled(!useGeneratedBuildFile);
    }

    @Override
    public boolean validate() {
        this.validateBuildDefinitions();
        if (this.componentPromotionCheckbox != null && this.workItemPromotionCheckbox != null) {
            if (!this.componentPromotionCheckbox.getSelection() && !this.workItemPromotionCheckbox.getSelection()) {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_INVALID_PROMOTION_TYPE, Messages.AbstractPromotionConfigurationEditor_ERROR_INVALID_PROMOTION_TYPE, (Control)this.componentPromotionCheckbox);
            } else {
                this.removeMessage(VALIDATION_ERROR_INVALID_PROMOTION_TYPE, (Control)this.componentPromotionCheckbox);
            }
        }
        this.validateComponents();
        if (this.useCustomBuildFileCheckbox != null && this.customBuildFileTextField != null) {
            if (this.useCustomBuildFileCheckbox.getSelection() && this.customBuildFileTextField.getText().trim().isEmpty()) {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_INVALID_BUILD_FILE, Messages.PromotionConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.customBuildFileTextField);
            } else {
                this.removeMessage(VALIDATION_ERROR_INVALID_BUILD_FILE, (Control)this.customBuildFileTextField);
            }
        }
        return super.validate();
    }

    protected void validateBuildDefinitions() {
        IBuildDefinition sourceBuildDefinition;
        if (this.sourceBuildDefinitionTextField == null || this.targetBuildDefinitionTextField == null) {
            return;
        }
        if (this.sourceBuildDefinitionTextField.getText().trim().isEmpty()) {
            this.addErrorMessageForRequiredField(VALIDATION_ERROR_NO_SOURCE_BUILD_DEFINITION, Messages.PromotionConfigurationEditor_SOURCE_BUILDDEF_REQUIRED, (Control)this.sourceBuildDefinitionTextField);
        } else {
            this.removeMessage(VALIDATION_ERROR_NO_SOURCE_BUILD_DEFINITION, (Control)this.sourceBuildDefinitionTextField);
        }
        if (this.targetBuildDefinitionTextField.getText().trim().isEmpty()) {
            this.addErrorMessageForRequiredField(VALIDATION_ERROR_NO_TARGET_BUILD_DEFINITION, Messages.PromotionConfigurationEditor_TARGET_BUILDDEF_REQUIRED, (Control)this.targetBuildDefinitionTextField);
        } else {
            this.removeMessage(VALIDATION_ERROR_NO_TARGET_BUILD_DEFINITION, (Control)this.targetBuildDefinitionTextField);
        }
        IBuildDefinition targetBuildDefinition = (IBuildDefinition)this.targetBuildDefinitionTextField.getData();
        if (targetBuildDefinition != null) {
            IScanConfiguration scanConfiguration = (IScanConfiguration)this.targetBuildDefinitionTextField.getData("scanConfiguration");
            IWorkspace stream = (IWorkspace)this.targetBuildDefinitionTextField.getData("stream");
            if (scanConfiguration == null && stream != null) {
                this.addWarningMessage(VALIDATION_ERROR_NO_SCAN_CONFIGURATION, NLS.bind((String)Messages.PromotionConfigurationEditor_STREAM_NOT_SUPPORT_SCANNING_WARNING, (Object)targetBuildDefinition.getId(), (Object)stream.getName()), (Control)this.streamNoScanningWarningHolder);
            } else {
                this.removeMessage(VALIDATION_ERROR_NO_SCAN_CONFIGURATION, (Control)this.streamNoScanningWarningHolder);
            }
        }
        if ((sourceBuildDefinition = (IBuildDefinition)this.sourceBuildDefinitionTextField.getData()) != null && targetBuildDefinition != null) {
            String targetBuildTemplateId;
            String sourceBuildTemplateId = sourceBuildDefinition.getPropertyValue("com.ibm.team.build.internal.template.id", "");
            if (!sourceBuildTemplateId.equals(targetBuildTemplateId = targetBuildDefinition.getPropertyValue("com.ibm.team.build.internal.template.id", ""))) {
                this.addErrorMessageForRequiredField(VALIDATION_ERROR_SOURCE_AND_TARGET_NO_MATCH, Messages.PromotionConfigurationEditor_DIFFERENT_TEMPLATE_ERROR, (Control)this.sourceBuildDefinitionTextField);
            } else {
                this.removeMessage(VALIDATION_ERROR_SOURCE_AND_TARGET_NO_MATCH, (Control)this.sourceBuildDefinitionTextField);
            }
        }
    }

    protected void validateComponents() {
        if (this.componentPromotionCheckbox == null || this.componentViewer == null || this.componentViewer.getInput() instanceof String) {
            return;
        }
        if (this.componentPromotionCheckbox.getSelection()) {
            if (this.componentViewer.getCheckedElements().length == 0) {
                this.addWarningMessage(VALIDATION_WARN_NO_COMPONENT_SELECTED, Messages.PromotionConfigurationEditor_WARNING_NOCOMPONENTS, (Control)this.componentViewer.getTable());
            } else {
                this.removeMessage(VALIDATION_WARN_NO_COMPONENT_SELECTED, (Control)this.componentViewer.getTable());
            }
        } else {
            this.removeMessage(VALIDATION_WARN_NO_COMPONENT_SELECTED, (Control)this.componentViewer.getTable());
        }
    }

    private boolean areBuildEnginesOnSameHost(List<IBuildEngine> buildEngines, IBuildEngine buildEngine) {
        if (buildEngine == null) {
            if (buildEngines.size() < 2) {
                return true;
            }
            buildEngine = buildEngines.get(0);
        } else if (buildEngines.size() < 1) {
            return true;
        }
        String host = buildEngine.getConfigurationPropertyValue(BF_CONFIG_ELEMENT, BF_CONFIG_PROPERTY_HOSTNAME, "");
        for (IBuildEngine nextBuildEngine : buildEngines) {
            String nextHost = nextBuildEngine.getConfigurationPropertyValue(BF_CONFIG_ELEMENT, BF_CONFIG_PROPERTY_HOSTNAME, "");
            if (host.equalsIgnoreCase(nextHost)) continue;
            return false;
        }
        return true;
    }

    private void validateBuildEngines() {
        IBuildEngine promotionBuildEngine;
        List supportingEngines = ((BuildDefinitionEditor)this.getEditor()).getSupportingEngines();
        if (!this.areBuildEnginesOnSameHost(supportingEngines, null)) {
            this.addErrorMessage(VALIDATION_ERROR_PROMOTION_ENGINE_INVALID, Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_MISMATCH_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_MISMATCH_LONG));
            return;
        }
        this.removeMessage(VALIDATION_ERROR_PROMOTION_ENGINE_INVALID);
        IBuildEngine iBuildEngine = promotionBuildEngine = supportingEngines.size() > 0 ? (IBuildEngine)supportingEngines.get(0) : null;
        if (promotionBuildEngine == null) {
            return;
        }
        List<IBuildEngine> buildEngines = this.getSupportedBuildEngines((IBuildDefinition)this.sourceBuildDefinitionTextField.getData());
        if (!this.areBuildEnginesOnSameHost(buildEngines, promotionBuildEngine)) {
            this.addErrorMessage(VALIDATION_ERROR_SOURCE_ENGINE_INVALID, Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_SOURCE_MISMATCH_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_SOURCE_MISMATCH_LONG));
        } else {
            this.removeMessage(VALIDATION_ERROR_SOURCE_ENGINE_INVALID);
        }
        buildEngines = this.getSupportedBuildEngines((IBuildDefinition)this.targetBuildDefinitionTextField.getData());
        if (!this.areBuildEnginesOnSameHost(buildEngines, promotionBuildEngine)) {
            this.addErrorMessage(VALIDATION_ERROR_TARGET_ENGINE_INVALID, Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_TARGET_MISMATCH_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.promotion.ui", Messages.PromotionConfigurationEditor_ERROR_HOSTNAME_TARGET_MISMATCH_LONG));
        } else {
            this.removeMessage(VALIDATION_ERROR_TARGET_ENGINE_INVALID);
        }
    }

    protected void addPublishBuildMapLinkWarning() {
        if (this.publishBuildMapCheckbox.getSelection()) {
            this.addWarningMessage(VALIDATION_WARN_PUBLISH_BUILD_MAP_LINKS, Messages.AbstractPromotionConfigurationEditor_WARN_PUBLISH_BUILDMAP, (Control)this.publishBuildMapCheckbox);
        } else {
            this.removeMessage(VALIDATION_WARN_PUBLISH_BUILD_MAP_LINKS, (Control)this.publishBuildMapCheckbox);
        }
    }

    protected void fetchSourceAndTargetBuildDefinitions() {
        this.updateSourceInfoUI(null, true);
        this.updateTargetInfoUI(null, true);
        UIUpdaterJob job = new UIUpdaterJob(NLS.bind((String)Messages.AbstractPromotionConfigurationEditor_FETCH_SOURCE_AND_TARGET_JOB_LABEL, (Object)this.workingCopy.getId())){
            private IBuildDefinition sourceBuildDefinition;
            private IBuildDefinition targetBuildDefinition;
            private IWorkspace targetStream;
            private IScanConfiguration targetScanConfiguration;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    IBuildDefinitionHandle buildDefinitionHandle;
                    String buildDefinitionUuidValue = AbstractPromotionConfigurationEditor.this.getProperty("team.enterprise.promotion.sourceDefinition");
                    if (buildDefinitionUuidValue != null && !buildDefinitionUuidValue.isEmpty()) {
                        buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefinitionUuidValue), null);
                        this.sourceBuildDefinition = (IBuildDefinition)AbstractPromotionConfigurationEditor.this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)buildDefinitionHandle, 0, Arrays.asList(IBuildDefinition.PROPERTY_ID, IBuildDefinition.PROPERTY_PROPERTIES), monitor);
                    }
                    if ((buildDefinitionUuidValue = AbstractPromotionConfigurationEditor.this.getProperty("team.enterprise.promotion.targetDefinition")) != null && !buildDefinitionUuidValue.isEmpty()) {
                        buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefinitionUuidValue), null);
                        this.targetBuildDefinition = (IBuildDefinition)AbstractPromotionConfigurationEditor.this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)buildDefinitionHandle, 0, Arrays.asList(IBuildDefinition.PROPERTY_ID, IBuildDefinition.PROPERTY_PROPERTIES), monitor);
                        this.targetStream = AbstractPromotionConfigurationEditor.this.getAssociatedStream(this.targetBuildDefinition, monitor);
                        this.targetScanConfiguration = AbstractPromotionConfigurationEditor.this.getScanConfiguration((IWorkspaceHandle)this.targetStream);
                    }
                }
                catch (TeamRepositoryException e) {
                    PromotionUIPlugin.log(e);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                AbstractPromotionConfigurationEditor.this.updateSourceInfoUI(this.sourceBuildDefinition, false);
                AbstractPromotionConfigurationEditor.this.updateTargetInfoUI(this.targetBuildDefinition, false);
                AbstractPromotionConfigurationEditor.this.updateTargetScanningStatus(this.targetStream, this.targetScanConfiguration);
                AbstractPromotionConfigurationEditor.this.updateComponentViewer();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void updateSourceInfoUI(IBuildDefinition buildDefinition, boolean pending) {
        if (buildDefinition == null) {
            if (pending) {
                this.sourceBuildDefinitionTextField.setText(Messages.PromotionConfigurationEditor_JOBNAME_PENDING);
            } else {
                this.sourceBuildDefinitionTextField.setText("");
            }
            this.sourceBuildDefinitionLink.setUnderlined(false);
        } else {
            this.sourceBuildDefinitionLink.setUnderlined(true);
            this.sourceBuildDefinitionTextField.setText(buildDefinition.getId());
        }
        this.sourceBuildDefinitionLink.setData((Object)buildDefinition);
        this.sourceBuildDefinitionTextField.setData((Object)buildDefinition);
    }

    protected void updateTargetInfoUI(IBuildDefinition buildDefinition, boolean pending) {
        if (buildDefinition == null) {
            if (pending) {
                this.targetBuildDefinitionTextField.setText(Messages.PromotionConfigurationEditor_JOBNAME_PENDING);
            } else {
                this.targetBuildDefinitionTextField.setText("");
            }
            this.targetBuildDefinitionLink.setUnderlined(false);
        } else {
            this.targetBuildDefinitionLink.setUnderlined(true);
            this.targetBuildDefinitionTextField.setText(buildDefinition.getId());
        }
        this.targetBuildDefinitionLink.setData((Object)buildDefinition);
        this.targetBuildDefinitionTextField.setData((Object)buildDefinition);
    }

    protected void updateTargetScanningStatus(IWorkspace stream, IScanConfiguration scanConfiguration) {
        this.targetBuildDefinitionTextField.setData("scanConfiguration", (Object)scanConfiguration);
        this.targetBuildDefinitionTextField.setData("stream", (Object)stream);
    }

    protected void openBuildDefinition(IBuildDefinition buildDefinition) {
        if (buildDefinition == null) {
            return;
        }
        try {
            IProcessArea processArea = (IProcessArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildDefinition.getProcessArea(), 0, (IProgressMonitor)new NullProgressMonitor());
            BuildDefinitionEditorInput input = new BuildDefinitionEditorInput(buildDefinition, processArea, this.getTeamRepository(), false);
            this.getSite().getPage().openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildDefinitionEditor");
        }
        catch (Exception e) {
            PromotionUIPlugin.log(e);
            this.openError(NLS.bind((String)Messages.AbstractPromotionConfigurationEditor_ERROR_OPEN_BUILD_DEIFNITION, (Object)buildDefinition.getId()));
        }
    }

    protected void openError(String message) {
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.PromotionAction_ErrorDialog_Title, (String)message);
    }

    protected PromotionBuildDefinitionSelectionDialog getBuildDefinitionSelectionDialog(IBuildDefinition buildDefinition) {
        String excludeUuidValue = buildDefinition == null ? null : buildDefinition.getItemId().getUuidValue();
        return new PromotionBuildDefinitionSelectionDialog(this.getEditorSite().getShell(), BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_TITLE, BuildUIDialogMessages.RequestBuildDialog_SELECT_DEFINITION_MESSAGE, false, false, excludeUuidValue, this.getPromotionBuildType(), this.workingCopy, this.workingCopy != null ? this.workingCopy.getProcessArea() : null);
    }

    protected IWorkspace getAssociatedStream(IBuildDefinition buildDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String buildWorkspaceUuidValue = this.getDependencyBuildProperty("teamz.scm.workspaceUUID", buildDefinition);
        if (buildWorkspaceUuidValue != null) {
            CurrentFlows cf;
            IWorkspaceHandle buildWorkspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildWorkspaceUuidValue), null);
            IWorkspace buildWorkspace = (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildWorkspaceHandle, 0, (IProgressMonitor)progress.newChild(50));
            if (buildWorkspace != null && (cf = ((Workspace)buildWorkspace).getCurrentFlows()) != null && cf.getDefaultDeliverFlow() != null) {
                IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(cf.getDefaultDeliverFlow(), null);
                return (IWorkspace)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)streamHandle, 0, Collections.singletonList(IWorkspace.NAME_PROPERTY), (IProgressMonitor)progress.newChild(50));
            }
        }
        return null;
    }

    protected IScanConfiguration getScanConfiguration(IWorkspaceHandle streamHandle) throws TeamRepositoryException {
        IScdClient scdClient = (IScdClient)this.getTeamRepository().getClientLibrary(IScdClient.class);
        return scdClient.getScanConfiguration(streamHandle);
    }

    protected void fetchScanConfigurationStatusInBackground(final IBuildDefinition buildDefinition) {
        if (this.getScanConfigurationJob != null) {
            this.getScanConfigurationJob.cancel();
        }
        this.getScanConfigurationJob = new UIUpdaterJob(Messages.AbstractPromotionConfigurationEditor_FETCH_SCD_SCANNING_STATUS_JOB_LABEL){
            private IScanConfiguration scanConfiguration;
            private IWorkspace stream;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    this.stream = AbstractPromotionConfigurationEditor.this.getAssociatedStream(buildDefinition, monitor);
                    this.scanConfiguration = AbstractPromotionConfigurationEditor.this.getScanConfiguration((IWorkspaceHandle)this.stream);
                }
                catch (TeamRepositoryException e) {
                    PromotionUIPlugin.log(e);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                AbstractPromotionConfigurationEditor.this.updateTargetScanningStatus(this.stream, this.scanConfiguration);
                return Status.OK_STATUS;
            }
        };
        this.getScanConfigurationJob.schedule();
        try {
            this.getScanConfigurationJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void fetchAllBuildEngines() {
        Job job = new Job(Messages.AbstractPromotionConfigurationEditor_FETCH_BUILD_ENGINES_JOB_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IItemManager itemManager = AbstractPromotionConfigurationEditor.this.getTeamRepository().itemManager();
                    IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildEngineQueryModel.IBuildEngineQueryModel.ROOT);
                    ItemQueryIterator iter = new ItemQueryIterator(ClientFactory.getTeamBuildClient((ITeamRepository)AbstractPromotionConfigurationEditor.this.getTeamRepository()), itemQuery, IQueryService.EMPTY_PARAMETERS);
                    while (iter.hasNext(monitor)) {
                        List engineHandles = iter.next(512, monitor);
                        AbstractPromotionConfigurationEditor.this.allBuildEngines.addAll(itemManager.fetchCompleteItems(engineHandles, 1, monitor));
                    }
                    Iterator enginesIter = AbstractPromotionConfigurationEditor.this.allBuildEngines.iterator();
                    while (enginesIter.hasNext()) {
                        Object next = enginesIter.next();
                        if (next != null) continue;
                        enginesIter.remove();
                    }
                }
                catch (TeamRepositoryException e) {
                    PromotionUIPlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected List<IBuildEngine> getSupportedBuildEngines(IBuildDefinition buildDefinition) {
        if (buildDefinition == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IBuildEngine> buildEngines = new ArrayList<IBuildEngine>();
        for (IBuildEngine buildEngine : this.allBuildEngines) {
            if (!buildEngine.supportsBuildDefinition((IBuildDefinitionHandle)buildDefinition)) continue;
            buildEngines.add(buildEngine);
        }
        return buildEngines;
    }

    private void updateComponentViewer() {
        final IBuildDefinition sourceBuildDefinition = (IBuildDefinition)this.sourceBuildDefinitionTextField.getData();
        UIUpdaterJob job = new UIUpdaterJob(""){
            List<IComponent> components;

            public IStatus runInBackground(IProgressMonitor monitor) {
                String workspaceUUID = DependencyBuildPropertyFactory.getInstance().getBuildPropertyValue("teamz.scm.workspaceUUID", sourceBuildDefinition);
                try {
                    IWorkspaceHandle sourceBuildWorkspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null);
                    IWorkspaceHandle sourceBuildWorkspaceStream = BuildUtils.getDefaultAcceptFlow(sourceBuildWorkspace, AbstractPromotionConfigurationEditor.this.getTeamRepository());
                    RepositoryItemProvider provider = new RepositoryItemProvider(AbstractPromotionConfigurationEditor.this.getTeamRepository());
                    Collection compsEntryCollection = provider.fetchComponentEntriesFor(sourceBuildWorkspaceStream, monitor);
                    ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(compsEntryCollection.size());
                    for (ComponentEntry compEntry : compsEntryCollection) {
                        componentHandles.add(compEntry.getComponent());
                    }
                    this.components = AbstractPromotionConfigurationEditor.this.getTeamRepository().itemManager().fetchPartialItems(componentHandles, 0, Arrays.asList(IComponent.NAME_PROPERTY), monitor);
                    Collections.sort(this.components, new Comparator<IComponent>(){

                        @Override
                        public int compare(IComponent component1, IComponent component2) {
                            return component1.getName().compareTo(component2.getName());
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    this.components = new ArrayList<IComponent>(0);
                    PromotionUIPlugin.log(e);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (AbstractPromotionConfigurationEditor.this.componentViewer != null) {
                    AbstractPromotionConfigurationEditor.this.componentViewer.setInput(this.components);
                    AbstractPromotionConfigurationEditor.this.componentViewer.refresh();
                    String componentListValue = AbstractPromotionConfigurationEditor.this.getProperty("team.enterprise.promotion.componentList");
                    if (componentListValue != null && !componentListValue.isEmpty()) {
                        List componentProperties = ComponentListPropertyParser.getInstance().decodeString(componentListValue);
                        ArrayList<String> componentUuids = new ArrayList<String>(componentProperties.size());
                        for (IComponentListProperty componentProperty : componentProperties) {
                            componentUuids.add(componentProperty.getComponentUUID());
                        }
                        if (componentUuids.size() > 0) {
                            int i = 0;
                            while (i < AbstractPromotionConfigurationEditor.this.componentViewer.getTable().getItemCount()) {
                                String componentUuid;
                                Object element = AbstractPromotionConfigurationEditor.this.componentViewer.getElementAt(i);
                                String string = componentUuid = element instanceof IComponent ? ((IComponent)element).getItemId().getUuidValue() : "";
                                if (componentUuids.contains(componentUuid)) {
                                    AbstractPromotionConfigurationEditor.this.componentViewer.setChecked(element, true);
                                }
                                ++i;
                            }
                        }
                    }
                    AbstractPromotionConfigurationEditor.this.updateSelectAndDeselectButtonStates();
                    AbstractPromotionConfigurationEditor.this.validateComponents();
                }
                return Status.OK_STATUS;
            }
        };
        if (this.componentPromotionCheckbox.getSelection()) {
            if (sourceBuildDefinition != null) {
                this.componentViewer.setInput((Object)Messages.PromotionConfigurationEditor_JOBNAME_PENDING);
                job.schedule();
            } else {
                this.componentViewer.setInput((Object)Collections.EMPTY_LIST);
            }
        } else {
            this.componentViewer.setInput((Object)Collections.EMPTY_LIST);
        }
    }

    private void saveComponentSelectionToBuildProperty() {
        Object[] checkedElements;
        ArrayList<ComponentListProperty> componentList = new ArrayList<ComponentListProperty>();
        Object[] objectArray = checkedElements = this.componentViewer.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof IComponent) {
                componentList.add(new ComponentListProperty(((IComponent)checkedElement).getItemId().getUuidValue()));
            }
            ++n2;
        }
        String componentProperties = ComponentListPropertyParser.getInstance().encodeString(componentList);
        this.setProperty("team.enterprise.promotion.componentList", componentProperties);
        this.updateSelectAndDeselectButtonStates();
    }

    private void updateSelectAndDeselectButtonStates() {
        boolean hasItem;
        this.selectAllBtn.setEnabled(true);
        this.deselectAllBtn.setEnabled(true);
        boolean bl = hasItem = this.componentViewer.getTable().getItemCount() > 0;
        if (hasItem) {
            if (this.componentViewer.getTable().getItemCount() == this.componentViewer.getCheckedElements().length) {
                this.selectAllBtn.setEnabled(false);
            }
            if (this.componentViewer.getCheckedElements().length == 0) {
                this.deselectAllBtn.setEnabled(false);
            }
        } else {
            this.selectAllBtn.setEnabled(false);
            this.deselectAllBtn.setEnabled(false);
        }
    }

    private Composite createScanningWarningHolder(final Composite composite, final Text textField) {
        Composite holder = new Composite(composite, 0){

            public boolean setFocus() {
                boolean isFocus = textField.setFocus();
                if (isFocus) {
                    final IWorkspace stream = (IWorkspace)textField.getData("stream");
                    boolean yes = MessageDialog.openQuestion((Shell)composite.getShell(), (String)Messages.PromotionConfigurationEditor_SCD_SCANNING_DIALOG_TITLE, (String)NLS.bind((String)Messages.PromotionConfigurationEditor_SCD_SCANNING_DIALOG_PROMPT, (Object)stream.getName()));
                    if (yes) {
                        UIUpdaterJob job = new UIUpdaterJob(NLS.bind((String)Messages.PromotionConfigurationEditor_SCD_CREATE_SCAN_CONFIGURATION_JOB, (Object)stream.getName())){
                            private IScanConfiguration scanConfiguration;

                            public IStatus runInBackground(IProgressMonitor monitor) {
                                try {
                                    this.scanConfiguration = ((IScdClient)AbstractPromotionConfigurationEditor.this.getTeamRepository().getClientLibrary(IScdClient.class)).createAndSaveDefaultScanConfiguration(stream);
                                }
                                catch (TeamRepositoryException e) {
                                    PromotionUIPlugin.log(e);
                                }
                                return Status.OK_STATUS;
                            }

                            public IStatus runInUI(IProgressMonitor monitor) {
                                textField.setData("scanConfiguration", (Object)this.scanConfiguration);
                                AbstractPromotionConfigurationEditor.this.removeMessage(AbstractPromotionConfigurationEditor.VALIDATION_ERROR_NO_SCAN_CONFIGURATION, (Control)AbstractPromotionConfigurationEditor.this.streamNoScanningWarningHolder);
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                }
                return isFocus;
            }
        };
        holder.setVisible(false);
        return holder;
    }

    private Label createLabelWithTooltip(Composite parent, String text, String tooltip, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        Label label = toolkit.createLabel(composite, text);
        Label image = toolkit.createLabel(composite, "");
        image.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
        image.setToolTipText(tooltip);
        return label;
    }

    class ComponentSelectionContentProvider
    implements IStructuredContentProvider {
        ComponentSelectionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[]{inputElement};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ComponentSelectionLabelProvider
    implements ITableLabelProvider {
        ComponentSelectionLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IComponent) {
                return ((IComponent)element).getName();
            }
            return element.toString();
        }
    }
}

