/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.build.PromotionBuildPropertyFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractConfigurationEditor
extends AbstractConfigurationElementEditor {
    protected static final int OK = 0;
    protected static final int ERROR = 1;
    protected static final int WARNING = 2;
    static List<String> PROPERTY_IDS = new ArrayList<String>();
    private final Set<String> validationErrors = new HashSet<String>();
    private final Set<String> validationWarnings = new HashSet<String>(1);
    protected IBuildDefinition workingCopy;

    static {
        PROPERTY_IDS.add("team.promotion.zos.script");
        PROPERTY_IDS.add("com.ibm.team.enterprise.promotion.skipTimestampCheck");
        PROPERTY_IDS.add("team.promotion.zos.tempPdsPrefix");
        PROPERTY_IDS.add("team.enterprise.promotion.suppressBuildMapLinks");
        PROPERTY_IDS.add("team.enterprise.promotion.ibmi.preCommand");
        PROPERTY_IDS.add("team.enterprise.promotion.ibmi.postCommand");
        PROPERTY_IDS.add("team.promotion.ibmi.pfRestoreMethod");
        PROPERTY_IDS.add("team.promotion.ibmi.pfRestoreCommand");
    }

    public AbstractConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.workingCopy = definition;
    }

    public boolean validate() {
        this.setPageStatusIndicator(this.hasErrors(), this.hasWarnings());
        return !this.hasErrors();
    }

    public IBuildDefinition getWorkingCopy() {
        return this.workingCopy;
    }

    public void addWarningMessage(Object id, String message, Control control) {
        super.addWarningMessage(id, message, control);
        this.validationWarnings.add(id.toString());
    }

    public void addErrorMessageForRequiredField(Object id, String message, Control control) {
        super.addErrorMessageForRequiredField(id, message, control);
        this.validationErrors.add(id.toString());
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        super.addErrorMessage(id, message, status);
        if (status.getSeverity() == 4) {
            this.validationErrors.add(id.toString());
        } else if (status.getSeverity() == 2) {
            this.validationWarnings.add(id.toString());
        }
    }

    public void removeMessage(Object id, Control control) {
        super.removeMessage(id, control);
        if (this.validationErrors.contains(id.toString())) {
            this.validationErrors.remove(id.toString());
        } else if (this.validationWarnings.contains(id.toString())) {
            this.validationWarnings.remove(id.toString());
        }
    }

    protected boolean hasErrors() {
        return !this.validationErrors.isEmpty();
    }

    protected boolean hasWarnings() {
        return !this.validationWarnings.isEmpty();
    }

    protected String getProperty(String propertyId) {
        return this.getProperty(propertyId, "");
    }

    protected String getProperty(String propertyId, String defaultValue) {
        if (PROPERTY_IDS.contains(propertyId)) {
            return this.workingCopy.getPropertyValue(propertyId, defaultValue);
        }
        String value = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue(propertyId, this.getId(), this.workingCopy);
        return value == null ? defaultValue : value;
    }

    protected boolean getBooleanProperty(String propertyId) {
        return this.getBooleanProperty(propertyId, false);
    }

    protected boolean getBooleanProperty(String propertyId, boolean defaultValue) {
        return Boolean.parseBoolean(this.getProperty(propertyId, Boolean.toString(defaultValue)));
    }

    protected void setProperty(String propertyId, String value) {
        if (PROPERTY_IDS.contains(propertyId)) {
            this.workingCopy.setProperty(propertyId, value);
        } else {
            PromotionBuildPropertyFactory.getInstance().setConfigurationPropertyValue(propertyId, value, this.getId(), this.workingCopy);
        }
    }

    protected void setProperty(String propertyId, boolean value) {
        this.setProperty(propertyId, String.valueOf(value));
    }

    protected String getDependencyBuildProperty(String propertyId, IBuildDefinition buildDefinition) {
        return DependencyBuildPropertyFactory.getInstance().getBuildPropertyValue(propertyId, buildDefinition);
    }
}

