/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.dialogs;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.ui.dialogs.requestbuild.IRequestBuildSectionFactory;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.build.common.promotion.build.ComponentListProperty;
import com.ibm.team.enterprise.build.common.promotion.build.ComponentListPropertyParser;
import com.ibm.team.enterprise.build.common.promotion.build.IComponentListProperty;
import com.ibm.team.enterprise.build.common.promotion.build.PromotionBuildPropertyFactory;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionBuildUtil;
import com.ibm.team.enterprise.internal.promotion.ui.utils.BuildUtils;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class PromotionRequestBuildSection
extends RequestBuildSection
implements SelectionListener,
ICheckStateListener {
    private boolean fIsPreviewBuild = false;
    private boolean fIncludesUnsupportedBuild;
    private String fComponentListValue = null;
    private Composite fPromotionBuildOptionsComposite;
    private Button fPreviewBuildButton;
    private Text fPreviewBuildText;
    private CheckboxTableViewer componentTableViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private String noBuildResultString;
    private String noSnapshotString = null;
    private IBuildResult buildResult = null;
    private IBuildDefinition sourceDefinition = null;
    private String promotionConfigurationElementId = null;
    private final List<ComponentListTableItem> tableList = new ArrayList<ComponentListTableItem>();

    public PromotionRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
    }

    protected String getSectionName() {
        return com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionRequestBuildDialog_OPTIONS;
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        ((GridData)this.getSection().getLayoutData()).exclude = true;
        this.getSection().setVisible(false);
    }

    protected void createSectionContent(Section section) {
        if (this.fPromotionBuildOptionsComposite != null && !this.fPromotionBuildOptionsComposite.isDisposed()) {
            this.fPromotionBuildOptionsComposite.dispose();
        }
        this.fPromotionBuildOptionsComposite = new Composite((Composite)section, 0);
        this.fPromotionBuildOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(4, false);
        layout.marginLeft = 10;
        this.fPromotionBuildOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.fPromotionBuildOptionsComposite);
        if (PromotionBuildUtil.isPromotionBuild((IBuildDefinition)this.getSite().getBuildDefinition())) {
            ((GridData)this.getSection().getLayoutData()).exclude = false;
            this.getSection().setVisible(true);
            this.fPreviewBuildButton = new Button(this.fPromotionBuildOptionsComposite, 32);
            this.fPreviewBuildButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionRequestBuildDialog_PREVIEW_BUILD_BUTTON);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.verticalIndent = 5;
            this.fPreviewBuildButton.setLayoutData((Object)gridData);
            this.fPreviewBuildButton.addSelectionListener(this.getPreviewBuildButtonListener());
            this.fPreviewBuildButton.setSelection(this.fIsPreviewBuild);
            this.fPreviewBuildText = new Text(this.fPromotionBuildOptionsComposite, 72);
            this.fPreviewBuildText.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionRequestBuildDialog_PREVIEW_BUILD_DESCRIPTION);
            gridData = new GridData(768);
            gridData.horizontalIndent = 10;
            gridData.widthHint = 300;
            gridData.horizontalSpan = 4;
            this.fPreviewBuildText.setLayoutData((Object)gridData);
            this.createComponentSelectionComponents(this.fPromotionBuildOptionsComposite);
            this.getSection().setExpanded(true);
        } else {
            Label noOptionsLabel = new Label(this.fPromotionBuildOptionsComposite, 64);
            noOptionsLabel.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionRequestBuildDialog_NO_OPTIONS);
        }
    }

    private void createComponentSelectionComponents(Composite parent) {
        Label fComponentSelectionLabel = new Label(parent, 0);
        fComponentSelectionLabel.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionConfigurationEditor_CONFIG_COMPONENT_LABEL);
        GridDataFactory.fillDefaults().span(4, 1).indent(-1, 5).applyTo((Control)fComponentSelectionLabel);
        Table componentTable = new Table(parent, 68386);
        componentTable.setSize(200, 150);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).indent(10, -1).hint(-1, 115).applyTo((Control)componentTable);
        componentTable.pack();
        this.componentTableViewer = new CheckboxTableViewer(componentTable);
        ComponentSelectionTableContentProvider componentTableContentProvider = new ComponentSelectionTableContentProvider();
        ComponentSelectionTableLabelProvider componentTableLabelProvider = new ComponentSelectionTableLabelProvider();
        this.componentTableViewer.setContentProvider((IContentProvider)componentTableContentProvider);
        this.componentTableViewer.setLabelProvider((IBaseLabelProvider)componentTableLabelProvider);
        this.componentTableViewer.setInput((Object)this.sourceDefinition);
        this.setCheckedComponents();
        this.componentTableViewer.addCheckStateListener((ICheckStateListener)this);
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo(buttonComposite);
        this.selectAllButton = new Button(buttonComposite, 8);
        this.selectAllButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionConfigurationEditor_CONFIG_BUTTON_SELECTALL);
        GridDataFactory.fillDefaults().applyTo((Control)this.selectAllButton);
        this.selectAllButton.addSelectionListener((SelectionListener)this);
        this.deselectAllButton = new Button(buttonComposite, 8);
        this.deselectAllButton.setText(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionConfigurationEditor_CONFIG_BUTTON_DESELECT);
        GridDataFactory.fillDefaults().applyTo((Control)this.deselectAllButton);
        this.deselectAllButton.addSelectionListener((SelectionListener)this);
        this.updateSelectionState();
    }

    private void setCheckedComponents() {
        TableItem[] tableItems;
        String promotionComponentList = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("team.enterprise.promotion.componentList", this.promotionConfigurationElementId, this.getSite().getBuildDefinition());
        ArrayList<String> componentPropertyUUIDList = new ArrayList<String>();
        List promotionComponentPropertyList = ComponentListPropertyParser.getInstance().decodeString(promotionComponentList);
        for (IComponentListProperty prop : promotionComponentPropertyList) {
            componentPropertyUUIDList.add(prop.getComponentUUID());
        }
        TableItem[] tableItemArray = tableItems = this.componentTableViewer.getTable().getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem t = tableItemArray[n2];
            IComponent tableItemComponent = ((ComponentListTableItem)t.getData()).getComponent();
            String tableItemComponentUUIDValue = tableItemComponent.getItemId().getUuidValue();
            if (componentPropertyUUIDList.contains(tableItemComponentUUIDValue)) {
                t.setChecked(true);
            }
            ++n2;
        }
        this.fComponentListValue = this.getCurrentComponentListPropertyValue();
    }

    private IBuildDefinition resolveBuildDefinition(String uuidValue) {
        if (this.getTeamRepository() != null && !uuidValue.isEmpty()) {
            IItemHandle definitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuidValue), null);
            try {
                return (IBuildDefinition)this.getTeamRepository().itemManager().fetchCompleteItem(definitionHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return null;
    }

    private ITeamRepository getTeamRepository() {
        return this.getSite().getTeamRepository();
    }

    private SelectionListener getPreviewBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromotionRequestBuildSection.this.fIsPreviewBuild = PromotionRequestBuildSection.this.fPreviewBuildButton.getSelection();
            }
        };
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        if (PromotionBuildUtil.isPromotionBuild((IBuildDefinition)this.getSite().getBuildDefinition())) {
            IBuildProperty buildLabelPrefix;
            PromotionBuildPropertyFactory.getInstance().setBuildProperty("teamz.build.dependency.previewBuild", Boolean.toString(this.fIsPreviewBuild), buildDefinition);
            if (this.fIsPreviewBuild && (buildLabelPrefix = PromotionBuildPropertyFactory.getInstance().getBuildProperty("buildLabelPrefix", buildDefinition)) == null) {
                PromotionBuildPropertyFactory.getInstance().setBuildProperty("buildLabelPrefix", String.valueOf(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionRequestBuildDialog_PREVIEW_BUILD_LABEL_PREFIX) + " ", buildDefinition);
            }
            if (this.fComponentListValue != null) {
                PromotionBuildPropertyFactory.getInstance().setBuildProperty("team.enterprise.promotion.componentList", this.fComponentListValue, buildDefinition);
            }
        }
    }

    public void initialize(IProgressMonitor monitor) throws Exception {
        this.promotionConfigurationElementId = PromotionBuildPropertyFactory.getInstance().resolvePropertyId("com.ibm.team.enterprise.promotion.build", this.getSite().getBuildDefinition());
        String sourceDefUUID = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("team.enterprise.promotion.sourceDefinition", this.promotionConfigurationElementId, this.getSite().getBuildDefinition());
        if (sourceDefUUID != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
            this.sourceDefinition = this.resolveBuildDefinition(sourceDefUUID);
            if (this.sourceDefinition == null) {
                throw new NullPointerException(com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionRequestBuildDialog_SOURCE_BUILD_MISSING);
            }
            if (IBuildUtility.isOldDependencyBuild((IBuildDefinition)this.sourceDefinition)) {
                this.fIncludesUnsupportedBuild = true;
            }
            TeamRepository sourceDefRepo = (TeamRepository)this.sourceDefinition.getOrigin();
            String workspaceUUID = DependencyBuildPropertyFactory.getInstance().getBuildPropertyValue("teamz.scm.workspaceUUID", this.sourceDefinition);
            try {
                IWorkspace sourceDefWorkspace = BuildUtils.getWorkspaceFromUUID(workspaceUUID, (ITeamRepository)sourceDefRepo);
                IWorkspaceHandle sourceDefFlowStream = BuildUtils.getDefaultAcceptFlow((IWorkspaceHandle)sourceDefWorkspace, (ITeamRepository)sourceDefRepo);
                IWorkspaceConnection sourceDefWSConnection = BuildUtils.getWorkspaceConnection((ITeamRepository)sourceDefRepo, sourceDefFlowStream, (IProgressMonitor)subMonitor.newChild(20));
                List comps = sourceDefWSConnection.getComponents();
                if (!comps.isEmpty()) {
                    ArrayList<IComponentHandle> compHandles = new ArrayList<IComponentHandle>(comps.size());
                    for (Object compObject : comps) {
                        if (!(compObject instanceof IComponentHandle)) continue;
                        compHandles.add((IComponentHandle)compObject);
                    }
                    List components = this.getTeamRepository().itemManager().fetchCompleteItems(compHandles, 0, (IProgressMonitor)subMonitor.newChild(20 * compHandles.size()));
                    for (IComponent component : components) {
                        this.tableList.add(new ComponentListTableItem(component));
                    }
                }
                this.buildResult = this.getBuildResult(sourceDefRepo, this.sourceDefinition, (IProgressMonitor)subMonitor.newChild(20));
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    private IBuildResult getBuildResult(TeamRepository repo, IBuildDefinition def, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IQueryService fQueryService = repo.getQueryService();
        IBuildResult sourceBuildResult = null;
        IBaseBuildResultQueryModel.IBuildResultQueryModel queryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        boolean found = false;
        long buildStartTime = Long.MAX_VALUE;
        do {
            IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
            IPredicate one = queryModel.buildDefinition()._eq(itemQuery.newItemHandleArg());
            IPredicate two = queryModel.buildState()._in(new String[]{BuildState.INCOMPLETE.name(), BuildState.COMPLETED.name(), BuildState.IN_PROGRESS.name(), BuildState.NOT_STARTED.name()});
            IPredicate three = queryModel.personalBuild()._isFalse();
            IPredicate four = queryModel.buildStartTime()._lt((INumeric)itemQuery.newLongArg());
            itemQuery.filter(one._and(two)._and(three)._and(four));
            itemQuery.orderByDsc((IField)queryModel.buildStartTime());
            itemQuery.setResultLimit(1);
            IItemQueryPage queryPage = fQueryService.queryItems(itemQuery, new Object[]{IBuildDefinition.ITEM_TYPE.createItemHandle(def.getItemId(), null), buildStartTime}, 1);
            IItemHandle[] itemHandles = queryPage.handlesAsArray();
            if (itemHandles.length == 0) {
                return null;
            }
            sourceBuildResult = (IBuildResult)repo.itemManager().fetchCompleteItem(itemHandles[0], 0, (IProgressMonitor)subMonitor.newChild(20));
            if (this.isPreviewBuildResult((ITeamRepository)repo, (IBuildResultHandle)sourceBuildResult)) {
                buildStartTime = sourceBuildResult.getBuildStartTime();
                continue;
            }
            found = true;
        } while (!found);
        return sourceBuildResult;
    }

    protected boolean grabVertical() {
        return true;
    }

    private void updateSelectionState() {
        int numChecked = this.componentTableViewer.getCheckedElements().length;
        int totalItems = this.componentTableViewer.getTable().getItemCount();
        if (numChecked == 0) {
            this.deselectAllButton.setEnabled(false);
            this.selectAllButton.setEnabled(true);
        } else if (numChecked == totalItems) {
            this.deselectAllButton.setEnabled(true);
            this.selectAllButton.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.selectAllButton || eventSource == this.deselectAllButton) {
            this.componentTableViewer.setAllChecked(eventSource == this.selectAllButton);
            this.checkStateChanged(null);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.fComponentListValue = this.getCurrentComponentListPropertyValue();
        this.updateSelectionState();
        this.getSite().revalidate();
    }

    private String getCurrentComponentListPropertyValue() {
        ArrayList<ComponentListProperty> componentList = new ArrayList<ComponentListProperty>();
        Object[] objectArray = this.componentTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof ComponentListTableItem) {
                componentList.add(new ComponentListProperty((IComponentHandle)((ComponentListTableItem)item).getComponent()));
            }
            ++n2;
        }
        String encodedString = ComponentListPropertyParser.getInstance().encodeString(componentList);
        return encodedString;
    }

    private boolean isPreviewBuildResult(ITeamRepository repository, IBuildResultHandle buildResultHandle) throws TeamRepositoryException {
        IBuildResultContribution[] buildResultContributions;
        ITeamBuildClient teamBuildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        IBuildResultContribution[] iBuildResultContributionArray = buildResultContributions = teamBuildClient.getBuildResultContributions(buildResultHandle, new String[]{IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID}, null);
        int n = buildResultContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution buildResultContribution = iBuildResultContributionArray[n2];
            if ("build.properties".equals(buildResultContribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME))) {
                IContent content = buildResultContribution.getExtendedContributionData();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                repository.contentManager().retrieveContent(content, (OutputStream)baos, null);
                Properties properties = new Properties();
                try {
                    properties.load(new ByteArrayInputStream(baos.toByteArray()));
                    baos.close();
                }
                catch (IOException e) {
                    throw new TeamRepositoryException(e.getLocalizedMessage());
                }
                return Boolean.parseBoolean(DependencyBuildPropertyFactory.getInstance().getBuildPropertyValue("teamz.build.dependency.previewBuild", properties));
            }
            ++n2;
        }
        return false;
    }

    public boolean validate2() {
        if (this.fIncludesUnsupportedBuild) {
            this.getSite().addErrorMessage((Object)this, Messages.DEPRECATED_TEMPLATE_NOT_SUPPORTED);
            return false;
        }
        if (this.componentTableViewer != null) {
            if (this.noBuildResultString != null) {
                this.getSite().addWarningMessage((Object)this, this.noBuildResultString);
                return true;
            }
            if (this.componentTableViewer.getCheckedElements().length == 0) {
                this.getSite().addErrorMessage((Object)this, com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionRequestBuildDialog_ERROR_NOCOMPONENTS);
                return false;
            }
            if (this.componentTableViewer.getCheckedElements().length > 0) {
                this.getSite().removeErrorMessage((Object)this);
                return true;
            }
            if (this.noSnapshotString != null) {
                this.getSite().addWarningMessage((Object)this, this.noSnapshotString);
                return true;
            }
            String elementID = PromotionBuildUtil.isIBMiPromotionBuild((IBuildDefinition)this.getSite().getBuildDefinition()) ? "com.ibm.team.enterprise.ibmi.promotion.build" : "com.ibm.team.enterprise.promotion.build";
            String buildPropertyOnlyWIPromotion = PromotionBuildPropertyFactory.getInstance().getConfigurationPropertyValue("com.ibm.team.enterprise.promotion.type.wi", elementID, this.getSite().getBuildDefinition());
            if (Boolean.parseBoolean(buildPropertyOnlyWIPromotion)) {
                this.getSite().addWarningMessage((Object)this, com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionWorkItemWizardPage_ERROR_INVALID_PROMOTION_DEF_COMP);
                return false;
            }
        }
        return true;
    }

    protected class ComponentListTableItem {
        private final IComponent component;

        public ComponentListTableItem(IComponent comp) {
            this.component = comp;
        }

        public IComponent getComponent() {
            return this.component;
        }
    }

    protected class ComponentSelectionTableContentProvider
    implements IStructuredContentProvider {
        private List<ComponentListTableItem> contentList = null;

        protected ComponentSelectionTableContentProvider() {
        }

        public List<ComponentListTableItem> getItemList() {
            return this.contentList;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object oldInput, Object newInput) {
            Object input = newInput;
            if (input != null) {
                if (input instanceof String) {
                    IBuildDefinition buildDef = PromotionRequestBuildSection.this.resolveBuildDefinition((String)input);
                    input = buildDef;
                }
                if (input != null && input instanceof IBuildDefinition) {
                    PromotionRequestBuildSection.this.noBuildResultString = null;
                    PromotionRequestBuildSection.this.noSnapshotString = null;
                    if (this.contentList != null) {
                        this.contentList.clear();
                    } else {
                        this.contentList = new ArrayList<ComponentListTableItem>();
                    }
                    if (PromotionRequestBuildSection.this.buildResult == null) {
                        PromotionRequestBuildSection.this.noBuildResultString = com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionConfigurationEditor_ERROR_NOBUILDRESULT;
                    } else if (PromotionRequestBuildSection.this.buildResult.getState().equals((Object)BuildState.NOT_STARTED)) {
                        PromotionRequestBuildSection.this.noSnapshotString = com.ibm.team.enterprise.internal.promotion.ui.nls.Messages.PromotionConfigurationEditor_ERROR_NOBUILDRESULTCOMPONENTS;
                    }
                    if (!PromotionRequestBuildSection.this.tableList.isEmpty()) {
                        this.contentList.addAll(PromotionRequestBuildSection.this.tableList);
                    }
                } else if (this.contentList != null) {
                    this.contentList.clear();
                } else {
                    this.contentList = new ArrayList<ComponentListTableItem>();
                }
            }
        }

        public Object[] getElements(Object arg0) {
            return this.contentList == null ? null : this.contentList.toArray();
        }
    }

    protected class ComponentSelectionTableLabelProvider
    implements ITableLabelProvider {
        private IItemManager itemManager = null;

        protected ComponentSelectionTableLabelProvider() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object item, int arg1) {
            if (this.itemManager == null) {
                this.itemManager = PromotionRequestBuildSection.this.getTeamRepository().itemManager();
            }
            if (item instanceof ComponentListTableItem) {
                IComponent compItem = ((ComponentListTableItem)item).getComponent();
                String columnText = compItem.getName();
                return columnText;
            }
            return null;
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    public static class Factory
    implements IRequestBuildSectionFactory {
        public RequestBuildSection createRequestBuildSection(RequestBuildSectionSite site) {
            return new PromotionRequestBuildSection(site);
        }
    }
}

