/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PromotionErrorDialog
extends IconAndMessageDialog {
    private StyledText detailedMessageBox = null;
    public static boolean AUTOMATED_MODE = false;
    private Button detailsButton;
    private final String title;
    private boolean listCreated = false;
    private final String messageDetail;
    private boolean cancelEnabled = true;

    public PromotionErrorDialog(Shell parentShell, String dialogTitle, String message, String reason, String detail, boolean enabledCancelButton) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = message == null ? reason : JFaceResources.format((String)"Reason", (Object[])new Object[]{message, reason});
        this.cancelEnabled = enabledCancelButton;
        this.messageDetail = detail;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.cancelEnabled) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        }
        this.createDetailsButton(parent);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createMessageArea(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        return this.getErrorImage();
    }

    private void createDetailMessageContent(Composite parent) {
        this.detailedMessageBox = new StyledText(parent, 2624);
        GridData labelGridData = new GridData(1808);
        labelGridData.heightHint = 150;
        this.detailedMessageBox.setLayoutData((Object)labelGridData);
        this.detailedMessageBox.setText(this.messageDetail);
    }

    public int open() {
        if (!AUTOMATED_MODE) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    private boolean listContentExists() {
        return this.messageDetail != null && !"".equals(this.messageDetail);
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.listCreated) {
            this.detailedMessageBox.dispose();
            this.listCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDetailMessageContent((Composite)this.getContents());
            this.listCreated = true;
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.getContents().getShell().layout();
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    public boolean close() {
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.listCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.listContentExists();
    }

    protected boolean isResizable() {
        return true;
    }
}

