/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.dialogs;

import com.ibm.icu.text.Collator;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.internal.promotion.ui.nls.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PromotionDefinitionSelectionDialog
extends BuildDefinitionSelectionDialog {
    private static final String EMPTY_STRING = Messages.PromotionDefinitionSelectionDialog_EmptyResultErrorMessage;
    private static final Object[] EMPTY_RESULT = new Object[0];
    protected IProcessArea fCallerContext;
    private Combo fScopeBrowseCombo;
    private SearchScope fSearchScope;
    private final boolean fAllowBroaderContext;

    public PromotionDefinitionSelectionDialog(Shell parent, String title, String description, IProcessArea callerProcessArea, boolean allowBroaderContext) {
        this(parent, title, description, callerProcessArea, allowBroaderContext, false);
    }

    public PromotionDefinitionSelectionDialog(Shell parent, String title, String description, IProcessArea callerProcessArea, boolean allowBroaderContext, boolean allowMultiple) {
        super(parent, title, description, allowMultiple, false);
        this.fCallerContext = callerProcessArea;
        this.fSearchScope = callerProcessArea == null ? SearchScope.CONNECTED_REPOS : SearchScope.SCOPED;
        this.fAllowBroaderContext = allowBroaderContext;
    }

    public PromotionDefinitionSelectionDialog(Shell parent, IProcessArea callerProcessArea, boolean allowBroaderContext) {
        this(parent, callerProcessArea, allowBroaderContext, false);
    }

    public PromotionDefinitionSelectionDialog(Shell parent, IProcessArea callerProcessArea, boolean allowBroaderContext, boolean allowMultiple) {
        this(parent, Messages.PromotionDefinitionSelectionDialog_DefaultTitle, Messages.PromotionDefinitionSelectionDialog_DefaultDesc, callerProcessArea, allowBroaderContext, allowMultiple);
    }

    protected Job createFetchJob() {
        return new FetchPromotionDefinitionsInContextJob(this);
    }

    private boolean isPromotion(IBuildDefinition depBuildDefinition) {
        return depBuildDefinition.getConfigurationElement("com.ibm.team.enterprise.promotion.build") != null || depBuildDefinition.getConfigurationElement("com.ibm.team.enterprise.ibmi.promotion.build") != null;
    }

    protected boolean shouldDisplay(IBuildDefinition buildDefinition) {
        return true;
    }

    public void setEmptyListMessage(String message) {
        super.setEmptyListMessage(EMPTY_STRING);
    }

    protected void init(String title, String message, boolean isMultiSelectAllowed) {
        super.init(title, message, isMultiSelectAllowed);
        if (this.fCallerContext == null) {
            this.fSearchScope = SearchScope.CONNECTED_REPOS;
        }
        this.fFetchingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PromotionDefinitionSelectionDialog.this.getShell() == null || PromotionDefinitionSelectionDialog.this.getShell().isDisposed()) {
                            return;
                        }
                        if (PromotionDefinitionSelectionDialog.this.fFilteredList != null && !PromotionDefinitionSelectionDialog.this.fFilteredList.isEmpty() && PromotionDefinitionSelectionDialog.this.fFilteredList.getSelection().length > 0 && PromotionDefinitionSelectionDialog.this.fFilteredList.getSelection()[0].toString().equals(EMPTY_STRING)) {
                            PromotionDefinitionSelectionDialog.this.fFilteredList.setElements(EMPTY_RESULT);
                        }
                        PromotionDefinitionSelectionDialog.this.validateCurrentSelection();
                    }
                });
            }
        });
    }

    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        if (this.fAllowBroaderContext) {
            ArrayList<String> items = null;
            new ArrayList(SearchScope.values().length);
            if (this.fCallerContext != null) {
                items = new ArrayList(SearchScope.values().length);
                SearchScope[] searchScopeArray = SearchScope.values();
                int n = searchScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchScope scope = searchScopeArray[n2];
                    items.add(scope.label);
                    ++n2;
                }
            } else {
                items = new ArrayList<String>(1);
                items.add(SearchScope.CONNECTED_REPOS.label);
            }
            this.fScopeBrowseCombo = new Combo(composite, 12);
            this.fScopeBrowseCombo.setItems(items.toArray(new String[items.size()]));
            this.fScopeBrowseCombo.select(this.fSearchScope.ordinal());
            this.fScopeBrowseCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = PromotionDefinitionSelectionDialog.this.fScopeBrowseCombo.getSelectionIndex();
                    SearchScope newScope = SearchScope.values()[index];
                    PromotionDefinitionSelectionDialog.this.fSearchScope = newScope;
                    if (!PromotionDefinitionSelectionDialog.this.isFetchingDone() && PromotionDefinitionSelectionDialog.this.fFetchingJob != null) {
                        PromotionDefinitionSelectionDialog.this.fFetchingJob.cancel();
                    }
                    PromotionDefinitionSelectionDialog.this.fFetchingJob = PromotionDefinitionSelectionDialog.this.createFetchJob();
                    PromotionDefinitionSelectionDialog.this.fFetchingJob.schedule();
                }
            });
            this.fScopeBrowseCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        return label;
    }

    protected ITeamRepository[] getConnectedRepositories() {
        Set connectedRepositories = ConnectedProjectAreaRegistryHelper.getConnectedRepositories();
        return connectedRepositories.toArray(new ITeamRepository[connectedRepositories.size()]);
    }

    private class FetchPromotionDefinitionsInContextJob
    extends TeamBuildJob {
        private final PromotionDefinitionSelectionDialog fPromoDefsSelectionDialog;
        protected IBuildDefinition[] fFetchedPromoDefinitions;
        protected int fConnectedRepositoryCount;

        public FetchPromotionDefinitionsInContextJob(PromotionDefinitionSelectionDialog dialog) {
            super(Messages.PromotionDefinitionSelectionDialog_FetchingMessage, false);
            this.fConnectedRepositoryCount = 0;
            this.fPromoDefsSelectionDialog = dialog;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.updateDialogStatus(this.getStatus());
            switch (PromotionDefinitionSelectionDialog.this.fSearchScope) {
                case CONNECTED_REPOS: {
                    return this.doFetch(monitor, null);
                }
                case CURRENT_REPO: 
                case SCOPED: {
                    return this.doFetch(monitor, (ITeamRepository)PromotionDefinitionSelectionDialog.this.fCallerContext.getProjectArea().getOrigin());
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus doFetch(IProgressMonitor monitor, ITeamRepository teamRepo) throws Exception {
            ITeamRepository[] connectedRepositories;
            ITeamRepository[] iTeamRepositoryArray;
            ArrayList<IBuildDefinition> allBuilds = new ArrayList<IBuildDefinition>();
            ArrayList<IStatus> errors = null;
            if (teamRepo == null) {
                iTeamRepositoryArray = PromotionDefinitionSelectionDialog.this.getConnectedRepositories();
            } else {
                ITeamRepository[] iTeamRepositoryArray2 = new ITeamRepository[1];
                iTeamRepositoryArray = iTeamRepositoryArray2;
                iTeamRepositoryArray2[0] = teamRepo;
            }
            ITeamRepository[] iTeamRepositoryArray3 = connectedRepositories = iTeamRepositoryArray;
            int n = connectedRepositories.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repository = iTeamRepositoryArray3[n2];
                if (repository.loggedIn()) {
                    try {
                        IBuildDefinition[] definitions = this.fetchPromotionDefinitions(repository, monitor);
                        allBuilds.addAll(Arrays.asList(definitions));
                        ++this.fConnectedRepositoryCount;
                    }
                    catch (OperationCanceledException exception) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception exception) {
                        String repoId;
                        if (errors == null) {
                            errors = new ArrayList<IStatus>();
                        }
                        if ((repoId = repository.getName()) == null || repoId.length() == 0) {
                            repoId = repository.getRepositoryURI();
                        }
                        String errorMessage = NLS.bind((String)Messages.FetchBuildDefinitionStatusRecordsJob_ERROR_CONNECTING_TO_REPOSITORY_X, (Object)repoId);
                        errors.add(this.createStatus(errorMessage, exception));
                    }
                }
                ++n2;
            }
            this.fFetchedPromoDefinitions = allBuilds.toArray(new IBuildDefinition[allBuilds.size()]);
            IStatus status = Status.OK_STATUS;
            if (errors != null) {
                String message = null;
                message = connectedRepositories.length == 1 ? Messages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_REPOSITORY : (this.fConnectedRepositoryCount == 0 ? Messages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_ANY_REPOSITORIES : Messages.FetchBuildDefinitionStatusRecordsJob_COULD_NOT_CONNECT_TO_ALL_REPOSITORIES);
                IStatus[] statuses = errors.toArray(new IStatus[errors.size()]);
                status = new MultiStatus(BuildUIPlugin.getUniqueIdentifier(), 0, statuses, message, null);
            }
            return status;
        }

        protected void jobFinished(IStatus status) {
            if (status.getSeverity() == 8) {
                this.fFetchedPromoDefinitions = null;
                return;
            }
            this.updateDialogStatus(status);
        }

        protected boolean isBuildDefinitionSelectionDialogDisposed() {
            return this.fPromoDefsSelectionDialog.getShell() == null || this.fPromoDefsSelectionDialog.getShell().isDisposed();
        }

        protected void asyncExec(Runnable runnable) {
            Display.getDefault().asyncExec(runnable);
        }

        protected void updateDialogStatus(final IStatus status) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FetchPromotionDefinitionsInContextJob.this.isBuildDefinitionSelectionDialogDisposed()) {
                        return;
                    }
                    FetchPromotionDefinitionsInContextJob.this.fPromoDefsSelectionDialog.setFetchingDone();
                    FetchPromotionDefinitionsInContextJob.this.fPromoDefsSelectionDialog.setListElements(FetchPromotionDefinitionsInContextJob.this.fFetchedPromoDefinitions);
                    IStatus updateStatus = null;
                    if (status != null && !status.isOK()) {
                        updateStatus = status;
                    }
                    if (updateStatus != null) {
                        FetchPromotionDefinitionsInContextJob.this.updateBuildDefinitionSelectionDialogStatus(updateStatus);
                    }
                }
            });
        }

        protected void updateBuildDefinitionSelectionDialogStatus(IStatus updateStatus) {
            this.fPromoDefsSelectionDialog.setStatus(updateStatus);
        }

        protected IProcessAreaHandle[] getContextHierarchy(IProcessArea pArea, IProgressMonitor monitor) throws TeamRepositoryException {
            ArrayList<Object> result = new ArrayList<Object>();
            if (pArea instanceof IProjectArea) {
                IProjectArea projectArea = (IProjectArea)pArea;
                result.addAll(projectArea.getTeamAreas());
                result.add(pArea);
            }
            if (pArea instanceof ITeamArea) {
                ITeamArea teamArea = (ITeamArea)pArea;
                ITeamRepository teamRepository = (ITeamRepository)PromotionDefinitionSelectionDialog.this.fCallerContext.getOrigin();
                IItemManager itemManager = teamRepository.itemManager();
                IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, monitor);
                ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
                ITeamArea teamHandle = teamArea;
                do {
                    result.add(teamHandle);
                } while ((teamHandle = hierarchy.getParent((ITeamAreaHandle)teamHandle)) != null);
                result.add(projectArea);
            }
            return result.toArray(new IProcessAreaHandle[result.size()]);
        }

        protected IBuildDefinition[] fetchPromotionDefinitions(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
            IProcessAreaHandle[] processAreaHandles = null;
            processAreaHandles = !PromotionDefinitionSelectionDialog.this.fSearchScope.equals((Object)SearchScope.SCOPED) ? ConnectedProjectAreaRegistryHelper.getAllSelectedProcessAreas((ITeamRepository)repository) : this.getContextHierarchy(PromotionDefinitionSelectionDialog.this.fCallerContext, monitor);
            Comparator<IBuildDefinition> comparator = new Comparator<IBuildDefinition>(){
                Collator collator = Collator.getInstance();

                @Override
                public int compare(IBuildDefinition buildDefinition1, IBuildDefinition buildDefinition2) {
                    if (buildDefinition1 != null && buildDefinition2 != null) {
                        return this.collator.compare(buildDefinition1.getId(), buildDefinition2.getId());
                    }
                    if (buildDefinition1 == null && buildDefinition2 == null) {
                        return 0;
                    }
                    if (buildDefinition1 == null) {
                        return -1;
                    }
                    return 1;
                }
            };
            TreeSet<IBuildDefinition> promoDefinitions = new TreeSet<IBuildDefinition>(comparator);
            if (processAreaHandles != null && processAreaHandles.length > 0) {
                int current = 0;
                while (current < processAreaHandles.length) {
                    IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
                    IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
                    int end = Math.min(processAreaHandles.length, current + 1000);
                    ArrayList<IProcessAreaHandle> parms = new ArrayList<IProcessAreaHandle>(end - current);
                    IItemHandleInputArg[] itemHandleArgs = new IItemHandleInputArg[end - current];
                    int i = 0;
                    while (i < itemHandleArgs.length) {
                        itemHandleArgs[i] = query.newItemHandleArg();
                        parms.add(processAreaHandles[current + i]);
                        ++i;
                    }
                    IPredicate filter = ((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea()._in(itemHandleArgs);
                    query.filter(filter);
                    IItemManager itemManager = repository.itemManager();
                    ItemQueryIterator iter = new ItemQueryIterator(ClientFactory.getTeamBuildClient((ITeamRepository)repository), query, parms.toArray());
                    while (iter.hasNext(monitor)) {
                        List definitionHandles = iter.next(512, monitor);
                        List buildDefns = itemManager.fetchCompleteItems(definitionHandles, 0, monitor);
                        for (IBuildDefinition buildDefinition : buildDefns) {
                            if (buildDefinition == null || !PromotionDefinitionSelectionDialog.this.isPromotion(buildDefinition) || !PromotionDefinitionSelectionDialog.this.shouldDisplay(buildDefinition)) continue;
                            promoDefinitions.add(buildDefinition);
                        }
                    }
                    current += 1000;
                }
            }
            return promoDefinitions.toArray(new IBuildDefinition[promoDefinitions.size()]);
        }
    }

    public static enum SearchScope {
        CONNECTED_REPOS(Messages.PromotionDefinitionSelectionDialog_ShowAllReposOption),
        CURRENT_REPO(Messages.PromotionDefinitionSelectionDialog_ShowCurrentRepoOption),
        SCOPED(Messages.PromotionDefinitionSelectionDialog_ShowCurrentProcessOption);

        private String label;

        private SearchScope(String label) {
            this.label = label;
        }

        String getLabe() {
            return this.label;
        }
    }
}

