/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.build.ui.dialogs.EnterpriseBuildDefinitionSelectionDialog;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class PromotionBuildDefinitionSelectionDialog
extends EnterpriseBuildDefinitionSelectionDialog {
    private String excludeUUID = null;
    private final PromotionInfo.PromotionBuildType promotionBuildType;
    private final IBuildDefinition promotionBuildDefinition;

    public PromotionBuildDefinitionSelectionDialog(Shell parent, String title, String message, boolean isMultiSelectAllowed, boolean showRepository, String excludeUUID, PromotionInfo.PromotionBuildType promotionBuildType, IBuildDefinition promotionBuildDefinition, IProcessAreaHandle processArea) {
        super(parent, title, message, isMultiSelectAllowed, showRepository, processArea);
        this.excludeUUID = excludeUUID;
        this.promotionBuildType = promotionBuildType;
        this.promotionBuildDefinition = promotionBuildDefinition;
    }

    public void setListElements(Object[] elements) {
        ArrayList<IBuildDefinition> buildDefs = null;
        boolean isAtLeastOneBuildDefinition = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currObject = objectArray[n2];
            if (currObject instanceof IBuildDefinition) {
                boolean isInSameRepository;
                IBuildDefinition currBuildDef = (IBuildDefinition)currObject;
                if (!isAtLeastOneBuildDefinition) {
                    isAtLeastOneBuildDefinition = true;
                }
                if (buildDefs == null) {
                    buildDefs = new ArrayList<IBuildDefinition>();
                }
                if ((isInSameRepository = this.isInSameRepository(currBuildDef)) && this.isRightBuildTemplate(currBuildDef)) {
                    if (this.excludeUUID != null) {
                        if (!currBuildDef.getItemId().getUuidValue().equalsIgnoreCase(this.excludeUUID)) {
                            buildDefs.add(currBuildDef);
                        }
                    } else {
                        buildDefs.add(currBuildDef);
                    }
                }
            }
            ++n2;
        }
        if (buildDefs != null && !buildDefs.isEmpty()) {
            super.setListElements(buildDefs.toArray());
        } else if (isAtLeastOneBuildDefinition) {
            super.setListElements(buildDefs.toArray());
        } else {
            super.setListElements(elements);
        }
    }

    private boolean isInSameRepository(IBuildDefinition depBuildDefinition) {
        if (this.promotionBuildDefinition != null) {
            ITeamRepository promotionBuildRepository = (ITeamRepository)this.promotionBuildDefinition.getProcessArea().getOrigin();
            ITeamRepository depBuildRepository = (ITeamRepository)depBuildDefinition.getProcessArea().getOrigin();
            if (promotionBuildRepository != null && depBuildRepository != null) {
                return promotionBuildRepository.getId().equals((Object)depBuildRepository.getId());
            }
        }
        return true;
    }

    private boolean isRightBuildTemplate(IBuildDefinition depBuildDefinition) {
        if (this.promotionBuildType != null) {
            if (this.promotionBuildType == PromotionInfo.PromotionBuildType.ibmi) {
                return IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)depBuildDefinition);
            }
            if (this.promotionBuildType == PromotionInfo.PromotionBuildType.zos || this.promotionBuildType == PromotionInfo.PromotionBuildType.oldzos) {
                return IBuildUtility.isZOSDependencyBuild((IBuildDefinition)depBuildDefinition) || IBuildUtility.isOldDependencyBuild((IBuildDefinition)depBuildDefinition);
            }
        }
        return IBuildUtility.isDependencyBuild((IBuildDefinition)depBuildDefinition) || IBuildUtility.isOldDependencyBuild((IBuildDefinition)depBuildDefinition);
    }
}

