/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.promotion.ui.browser;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.common.promotion.impl.PromotionReportCssNlsHelper;
import com.ibm.team.enterprise.internal.build.ui.browser.AbstractOpenLocalFileInBrowserFromBuildResultHandler;
import com.ibm.team.enterprise.internal.build.ui.browser.IOpenLocalFileInBrowserHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;

public class OpenPromotionReportInBrowerHandler
extends AbstractOpenLocalFileInBrowserFromBuildResultHandler
implements IOpenLocalFileInBrowserHandler {
    private static final String ENTERPRISE_RESOURCES_PROMOTION_REPORT = "promotionReport";
    private static final String ENTERPRISE_RESOURCES_PROMOTION_INFO = "promotionInfo";
    private static final String FILE_EXTENSION_HTM = ".htm";
    private static final String DEFAULT_TEMP_FOLDER = "java.io.tmpdir";

    public boolean canOpen(URI uri) {
        return uri != null && this.isEnterpriseResource(uri.toString());
    }

    public File getLocalFile(URI uri) {
        String fileName = null;
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(uri);
        if (buildResultHandle != null) {
            if (uri.toString().contains(ENTERPRISE_RESOURCES_PROMOTION_REPORT)) {
                fileName = ENTERPRISE_RESOURCES_PROMOTION_REPORT + buildResultHandle.getItemId().getUuidValue() + FILE_EXTENSION_HTM;
            } else if (uri.toString().contains(ENTERPRISE_RESOURCES_PROMOTION_INFO)) {
                fileName = ENTERPRISE_RESOURCES_PROMOTION_INFO + buildResultHandle.getItemId().getUuidValue() + FILE_EXTENSION_HTM;
            }
        }
        File file = new File(System.getProperty(DEFAULT_TEMP_FOLDER), fileName);
        file.deleteOnExit();
        return file;
    }

    public boolean alwaysOverwrite() {
        return true;
    }

    private boolean isCurrentClicked(String clickedUri, String fileNameExtension) {
        if (clickedUri.contains(ENTERPRISE_RESOURCES_PROMOTION_REPORT) && fileNameExtension.contains(ENTERPRISE_RESOURCES_PROMOTION_REPORT)) {
            return true;
        }
        return clickedUri.contains(ENTERPRISE_RESOURCES_PROMOTION_INFO) && fileNameExtension.contains(ENTERPRISE_RESOURCES_PROMOTION_INFO);
    }

    public void generateLocalContent(URI uri, File file, ITeamRepository repository) throws Exception {
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(uri);
        IBuildResult buildResult = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, null);
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        IBuildResultContribution[] contributions = buildClient.getBuildResultContributions((IBuildResultHandle)buildResult, IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, null);
        if (contributions.length > 0) {
            IBuildResultContribution[] iBuildResultContributionArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultContribution contribution = iBuildResultContributionArray[n2];
                String fileName = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
                if (this.isCurrentClicked(uri.toString(), fileName)) {
                    try (ByteArrayOutputStream baos = null;){
                        IContent content = contribution.getExtendedContributionData();
                        int BUFFER_SIZE = 8192;
                        baos = new ByteArrayOutputStream(8192);
                        repository.contentManager().retrieveContent(content, (OutputStream)baos, null);
                        String encoding = content.getCharacterEncoding();
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        this.transformXml2Html(new ByteArrayInputStream(baos.toByteArray()), new PromotionReportCssNlsHelper().getTranslatedContent(fileName), file);
                    }
                }
                ++n2;
            }
        }
    }

    private boolean isEnterpriseResource(String uri) {
        return uri.contains(ENTERPRISE_RESOURCES_PROMOTION_REPORT) || uri.contains(ENTERPRISE_RESOURCES_PROMOTION_INFO);
    }
}

