/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.internal.process.ui.aspect.CreateWorkItemsAspectEditor;
import com.ibm.team.enterprise.internal.process.ui.aspect.InputDialogWithVars;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.process.internal.ide.ui.editors.form.IDevelopmentLineProxy;
import com.ibm.team.process.internal.ide.ui.editors.form.IIterationStructureProxy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SetupProjectAspectEditor
extends CreateWorkItemsAspectEditor {
    private static final String TAG_TEAM_AREA = "team-area";
    private static final String TAG_COMPONENTS = "components";
    private static final String TAG_COMPONENT = "component";
    private static final String TAG_WORKSPACE = "workspace";
    private static final String TAG_CATEGORY = "category";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_DEVELOPMENT_LINE = "timeline";
    private static final String ATTR_STAGE_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String[] VAR_STREAM_NAME = new String[]{Messages.SetupProjectAspectEditor_streamName, "${stream-name}"};
    private static final String[][] TEAM_AREA_NAME_VARS = new String[][]{VAR_PROJECT_AREA_NAME};
    private static final String[][] WORKSPACE_NAME_VARS = new String[][]{VAR_PROJECT_AREA_NAME, VAR_TEAM_AREA_NAME, VAR_STREAM_NAME};
    private Model fModel;
    private ListViewer fComponentsViewer;
    private Button fAddComponentButton;
    private Button fRemoveComponentButton;
    private Composite fComponentsComposite;
    private final ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (e.widget == SetupProjectAspectEditor.this.fTeamAreaNameText) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.teamAreaName = SetupProjectAspectEditor.this.fTeamAreaNameText.getText();
            }
            SetupProjectAspectEditor.this.setDirty();
        }
    };
    private Composite fTeamAreaDetailsComposite;
    private Text fTeamAreaNameText;
    private IIterationStructureProxy fIterationStructure;
    private ComboViewer fDevelopmentLineComboViewer;
    private IPropertyChangeListener fIterationStructureChangeListener;
    private final List<StageForm> fStageForms = new ArrayList<StageForm>();
    private Label fStageCountLabel;
    private final List<CategoryForm> fCategoryForms = new ArrayList<CategoryForm>();
    private Label fCategoryCountLabel;
    private Composite fCategoriesComposite;
    private Composite fStagesComposite;

    @Override
    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.fModel = new Model();
        this.fIterationStructure = ((AbstractProcessAspect)this.getAspect()).getIterationStructure();
    }

    @Override
    public void restoreState(IMemento memento) {
        IMemento workspaceMemento;
        IMemento teamAreaMemento = memento.getChild(TAG_TEAM_AREA);
        this.fModel.createTeamArea = true;
        this.fModel.teamAreaName = SetupProjectAspectEditor.getAttrib(teamAreaMemento, "name", "");
        this.fModel.developmentLineId = SetupProjectAspectEditor.getAttrib(teamAreaMemento, ATTR_DEVELOPMENT_LINE, "");
        IMemento componentsMemento = memento.getChild(TAG_COMPONENTS);
        this.fModel.componentNames.clear();
        if (componentsMemento != null) {
            IMemento[] componentMementos = componentsMemento.getChildren(TAG_COMPONENT);
            int i = 0;
            while (i < componentMementos.length) {
                this.fModel.componentNames.add(SetupProjectAspectEditor.getAttrib(componentMementos[i], "name", ""));
                ++i;
            }
        }
        this.fModel.createWorkspace = (workspaceMemento = memento.getChild(TAG_WORKSPACE)) != null;
        this.fModel.workspaceName = SetupProjectAspectEditor.getAttrib(workspaceMemento, "name", "");
        this.fModel.workspaceDescription = SetupProjectAspectEditor.getAttrib(workspaceMemento, ATTR_DESCRIPTION, "");
        this.fModel.stages.clear();
        IMemento stagesMemento = memento.getChild("stages");
        if (stagesMemento != null) {
            IMemento[] StageMementos = stagesMemento.getChildren("stage");
            int i = 0;
            while (i < StageMementos.length) {
                IMemento StageMemento = StageMementos[i];
                Stage Stage2 = new Stage();
                Stage2.name = SetupProjectAspectEditor.getAttrib(StageMemento, "name", "");
                Stage2.description = SetupProjectAspectEditor.getAttrib(StageMemento, ATTR_DESCRIPTION, "");
                this.fModel.stages.add(Stage2);
                ++i;
            }
        }
        this.fModel.categories.clear();
        IMemento workitemsMemento = memento.getChild("workitems");
        if (workitemsMemento != null) {
            IMemento[] categoryMementos = workitemsMemento.getChildren(TAG_CATEGORY);
            int i = 0;
            while (i < categoryMementos.length) {
                IMemento categoryMemento = categoryMementos[i];
                Category category = new Category();
                category.path = SetupProjectAspectEditor.getAttrib(categoryMemento, ATTR_PATH, "");
                category.htmlDescription = SetupProjectAspectEditor.getAttrib(categoryMemento, "htmlDescription", "");
                this.fModel.categories.add(category);
                ++i;
            }
        }
        super.restoreState(memento);
    }

    @Override
    public boolean saveState(IMemento memento) {
        IMemento workitemsMemento;
        IMemento teamAreaMemento = memento.createChild(TAG_TEAM_AREA);
        teamAreaMemento.putString("name", this.fModel.teamAreaName);
        teamAreaMemento.putString(ATTR_DEVELOPMENT_LINE, this.fModel.developmentLineId);
        IMemento componentsMemento = memento.createChild(TAG_COMPONENTS);
        for (String componentName : this.fModel.componentNames) {
            componentsMemento.createChild(TAG_COMPONENT).putString("name", componentName);
        }
        if (!this.fModel.stages.isEmpty()) {
            workitemsMemento = memento.createChild("stages");
            for (Stage Stage2 : this.fModel.stages) {
                IMemento StageMemento = workitemsMemento.createChild("stage");
                StageMemento.putString("name", Stage2.name);
                StageMemento.putString(ATTR_DESCRIPTION, SetupProjectAspectEditor.convertLineSeparators(Stage2.description));
            }
        }
        if (!this.fModel.categories.isEmpty()) {
            workitemsMemento = memento.createChild("workitems");
            for (Category category : this.fModel.categories) {
                IMemento categoryMemento = workitemsMemento.createChild(TAG_CATEGORY);
                categoryMemento.putString(ATTR_PATH, category.path);
                categoryMemento.putString("htmlDescription", SetupProjectAspectEditor.convertLineSeparators(category.htmlDescription));
            }
        }
        return super.saveState(memento);
    }

    @Override
    protected void createContents(Composite parent, FormToolkit toolkit) {
        Composite contentArea = this.createContentArea(parent, toolkit);
        this.createTeamAreaSection(contentArea, toolkit);
        this.createStreamAndWorkspaceSection(contentArea, toolkit);
        this.createStagesSection(contentArea, toolkit);
        this.createCategoriesSection(contentArea, toolkit);
        this.createTemplatesHeader(contentArea, toolkit);
        this.hookModifyListeners();
    }

    private void createCategoriesSection(Composite parent, FormToolkit toolkit) {
        this.fCategoriesComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fCategoriesComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 10).applyTo(this.fCategoriesComposite);
        this.createCategoriesHeader(this.fCategoriesComposite, toolkit);
    }

    private void createStagesSection(Composite parent, FormToolkit toolkit) {
        this.fStagesComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fStagesComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 10).applyTo(this.fStagesComposite);
        this.createStagesHeader(this.fStagesComposite, toolkit);
    }

    private void createStagesHeader(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.fStageCountLabel = toolkit.createLabel(composite, "");
        this.fStageCountLabel.setFont(SetupProjectAspectEditor.getBoldFont());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fStageCountLabel);
        Button newButton = toolkit.createButton(composite, Messages.SetupProjectAspectEditor_7, 8);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupProjectAspectEditor.this.doNewStage();
            }
        });
    }

    private void createCategoriesHeader(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.fCategoryCountLabel = toolkit.createLabel(composite, "");
        this.fCategoryCountLabel.setFont(SetupProjectAspectEditor.getBoldFont());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fCategoryCountLabel);
        Button newButton = toolkit.createButton(composite, Messages.SetupProjectAspectEditor_3, 8);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupProjectAspectEditor.this.doNewCategory();
            }
        });
    }

    private void updateVisibility(boolean reflowIfNeeded) {
        boolean reflowNeeded = this.updateVisibility(this.fModel.createTeamArea, this.fTeamAreaDetailsComposite);
        if (reflowNeeded && reflowIfNeeded) {
            this.getSite().reflow();
        }
    }

    private boolean updateVisibility(boolean makeVisible, Composite composite) {
        if (makeVisible != composite.getVisible()) {
            composite.setVisible(makeVisible);
            ((GridData)composite.getLayoutData()).exclude = !makeVisible;
            return true;
        }
        return false;
    }

    protected void createTeamAreaSection(final Composite parent, FormToolkit toolkit) {
        Label sectionLabel = toolkit.createLabel(parent, Messages.SetupProjectAspectEditor_teamArea_section);
        sectionLabel.setFont(SetupProjectAspectEditor.getBoldFont());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sectionLabel);
        this.fTeamAreaDetailsComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fTeamAreaDetailsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 5).spacing(10, 5).applyTo(this.fTeamAreaDetailsComposite);
        this.fTeamAreaNameText = this.createSingleLineText(this.fTeamAreaDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_teamArea_label, Messages.SetupProjectAspectEditor_teamArea_message, TEAM_AREA_NAME_VARS);
        this.fDevelopmentLineComboViewer = this.createComboViewer(this.fTeamAreaDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_devLine_label);
        this.fDevelopmentLineComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fDevelopmentLineComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDevelopmentLineProxy) {
                    IDevelopmentLineProxy line = (IDevelopmentLineProxy)element;
                    return line.getName();
                }
                return super.getText(element);
            }
        });
        final Display display = parent.getDisplay();
        this.fIterationStructureChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!parent.isDisposed()) {
                            SetupProjectAspectEditor.this.updateDevelopmentLines();
                        }
                    }
                });
            }
        };
        this.fIterationStructure.addPropertyChangeListener(this.fIterationStructureChangeListener);
        this.updateDevelopmentLines();
        this.fDevelopmentLineComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                String lineId = null;
                if (sel.size() == 1) {
                    IDevelopmentLineProxy line = (IDevelopmentLineProxy)sel.getFirstElement();
                    lineId = line.getId();
                }
                if (lineId == null) {
                    lineId = "";
                }
                if (!lineId.equals(((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.developmentLineId)) {
                    ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.developmentLineId = lineId;
                    SetupProjectAspectEditor.this.setDirty();
                }
            }
        });
    }

    private void updateDevelopmentLines() {
        IDevelopmentLineProxy[] developmentLines = this.fIterationStructure.getDevelopmentLines();
        this.fDevelopmentLineComboViewer.setInput((Object)developmentLines);
        int i = 0;
        while (i < developmentLines.length) {
            IDevelopmentLineProxy line = developmentLines[i];
            if (line.getId().equals(this.fModel.developmentLineId)) {
                this.fDevelopmentLineComboViewer.setSelection((ISelection)new StructuredSelection((Object)line));
                return;
            }
            ++i;
        }
        this.fDevelopmentLineComboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fIterationStructureChangeListener != null) {
            this.fIterationStructure.removePropertyChangeListener(this.fIterationStructureChangeListener);
            this.fIterationStructureChangeListener = null;
        }
    }

    protected void createStreamAndWorkspaceSection(Composite parent, FormToolkit toolkit) {
        this.fComponentsComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fComponentsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(this.fComponentsComposite);
        Composite innerDetailsComposite = toolkit.createComposite(this.fComponentsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)innerDetailsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 5).applyTo(innerDetailsComposite);
        Label componentsLabel = toolkit.createLabel(innerDetailsComposite, Messages.SetupProjectAspectEditor_components_label);
        GridDataFactory.fillDefaults().applyTo((Control)componentsLabel);
        Composite componentsComposite = toolkit.createComposite(innerDetailsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)componentsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(componentsComposite);
        this.fComponentsViewer = new ListViewer(componentsComposite);
        this.fComponentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fComponentsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fComponentsViewer.setSorter(new ViewerSorter());
        int h = this.fComponentsViewer.getList().getItemHeight() * 3;
        h = this.fComponentsViewer.getList().computeTrim((int)0, (int)0, (int)100, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, false).hint(100, h).applyTo((Control)this.fComponentsViewer.getList());
        this.fComponentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SetupProjectAspectEditor.this.handleComponentSelection((IStructuredSelection)event.getSelection());
            }
        });
        Composite buttonsComposite = toolkit.createComposite(componentsComposite);
        GridDataFactory.fillDefaults().applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().applyTo(buttonsComposite);
        this.fAddComponentButton = toolkit.createButton(buttonsComposite, Messages.SetupProjectAspectEditor_components_add, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fAddComponentButton);
        this.fAddComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupProjectAspectEditor.this.doAddComponent();
            }
        });
        this.fRemoveComponentButton = toolkit.createButton(buttonsComposite, Messages.SetupProjectAspectEditor_components_remove, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRemoveComponentButton);
        this.fRemoveComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupProjectAspectEditor.this.doRemoveComponents();
            }
        });
        this.updateComponentButtonsEnablement((IStructuredSelection)StructuredSelection.EMPTY);
    }

    protected void doAddComponent() {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return "";
                }
                return null;
            }
        };
        InputDialogWithVars inputDialog = new InputDialogWithVars(this.fComponentsViewer.getList().getShell(), Messages.SetupProjectAspectEditor_add_component_title, Messages.SetupProjectAspectEditor_add_component_message, Messages.SetupProjectAspectEditor_add_component_default, validator, VARS_TOOLTIP, WORKSPACE_NAME_VARS);
        if (inputDialog.open() == 0) {
            String componentName = inputDialog.getValue();
            this.fModel.componentNames.add(componentName);
            this.fComponentsViewer.refresh();
            this.fComponentsViewer.setSelection((ISelection)new StructuredSelection((Object)componentName));
            this.setDirty();
        }
    }

    protected void doRemoveComponents() {
        IStructuredSelection selection = (IStructuredSelection)this.fComponentsViewer.getSelection();
        this.fModel.componentNames.removeAll(selection.toList());
        this.fComponentsViewer.refresh();
        this.setDirty();
    }

    private void handleComponentSelection(IStructuredSelection selection) {
        this.updateComponentButtonsEnablement(selection);
    }

    private void updateComponentButtonsEnablement(IStructuredSelection selection) {
        this.fRemoveComponentButton.setEnabled(!selection.isEmpty());
    }

    private Text createSingleLineText(Composite parent, FormToolkit toolkit, String labelText, String message, String[][] vars) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(vars == null ? 2 : 3).applyTo(composite);
        Label label = toolkit.createLabel(composite, labelText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        Text text = toolkit.createText(composite, "", (message == null ? 4 : 128) | 0x800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(100, -1).applyTo((Control)text);
        if (message != null) {
            text.setMessage(message);
        }
        if (vars != null) {
            this.createVarsButton(composite, text, toolkit, vars);
        }
        return text;
    }

    private ComboViewer createComboViewer(Composite parent, FormToolkit toolkit, String labelText) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = toolkit.createLabel(composite, labelText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        ComboViewer comboViewer = new ComboViewer(composite);
        toolkit.adapt((Control)comboViewer.getCombo(), true, false);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)comboViewer.getCombo());
        return comboViewer;
    }

    private void hookModifyListeners() {
        this.fTeamAreaNameText.addModifyListener(this.fModifyListener);
    }

    private void unhookModifyListeners() {
        this.fTeamAreaNameText.removeModifyListener(this.fModifyListener);
    }

    @Override
    protected void updateUI() {
        this.fComponentsViewer.setInput(this.fModel.componentNames);
        this.unhookModifyListeners();
        this.fTeamAreaNameText.setText(this.fModel.teamAreaName);
        this.hookModifyListeners();
        this.updateVisibility(false);
        this.disposeStageForms();
        this.createStageForms();
        this.updateStageCount();
        this.disposeCategoryForms();
        this.createCategoryForms();
        this.updateCategoryCount();
        super.updateUI();
    }

    private void updateStageCount() {
        this.fStageCountLabel.setText(NLS.bind((String)Messages.SetupProjectAspectEditor_8, (Object)Integer.toString(this.fModel.stages.size())));
    }

    private void createStageForms() {
        int index = 0;
        for (Stage Stage2 : this.fModel.stages) {
            this.fStageForms.add(new StageForm(Stage2, this.fStagesComposite, this.fToolkit, index++));
        }
    }

    private void disposeStageForms() {
        for (StageForm form : this.fStageForms) {
            form.dispose();
        }
        this.fStageForms.clear();
    }

    private void doNewStage() {
        Stage Stage2 = new Stage();
        Stage2.name = Messages.SetupProjectAspectEditor_9;
        Stage2.description = Messages.AcceptTeamInvitationAspectEditor_8;
        StageForm form = new StageForm(Stage2, this.fStagesComposite, this.fToolkit, this.fModel.stages.size());
        this.fModel.stages.add(Stage2);
        this.fStageForms.add(form);
        this.updateStageCount();
        this.setDirty();
        this.getContentArea().layout();
        this.getSite().reflow();
        form.activate();
    }

    private void doDeleteStage(Stage Stage2, StageForm form) {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.AcceptTeamInvitationAspectEditor_9, (String)NLS.bind((String)Messages.SetupProjectAspectEditor_10, (Object)Stage2.name))) {
            form.dispose();
            this.fModel.stages.remove(Stage2);
            this.fStageForms.remove(form);
            this.updateStageCount();
            this.updateStageIndices();
            this.setDirty();
            this.getSite().reflow();
        }
    }

    private void updateStageIndices() {
        int index = 0;
        for (StageForm form : this.fStageForms) {
            form.setIndex(index++);
        }
    }

    private void createCategoryForms() {
        int index = 0;
        for (Category category : this.fModel.categories) {
            this.fCategoryForms.add(new CategoryForm(category, this.fCategoriesComposite, this.fToolkit, index++));
        }
    }

    private void updateCategoryCount() {
        this.fCategoryCountLabel.setText(NLS.bind((String)Messages.SetupProjectAspectEditor_4, (Object)Integer.toString(this.fModel.categories.size())));
    }

    private void disposeCategoryForms() {
        for (CategoryForm form : this.fCategoryForms) {
            form.dispose();
        }
        this.fCategoryForms.clear();
    }

    private void doNewCategory() {
        Category category = new Category();
        category.path = Messages.SetupProjectAspectEditor_5;
        category.htmlDescription = Messages.AcceptTeamInvitationAspectEditor_8;
        CategoryForm form = new CategoryForm(category, this.fCategoriesComposite, this.fToolkit, this.fModel.categories.size());
        this.fModel.categories.add(category);
        this.fCategoryForms.add(form);
        this.updateCategoryCount();
        this.setDirty();
        this.getContentArea().layout();
        this.getSite().reflow();
        form.activate();
    }

    private void doDeleteCategory(Category category, CategoryForm form) {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.AcceptTeamInvitationAspectEditor_9, (String)NLS.bind((String)Messages.SetupProjectAspectEditor_6, (Object)category.path))) {
            form.dispose();
            this.fModel.categories.remove(category);
            this.fCategoryForms.remove(form);
            this.updateCategoryCount();
            this.updateCategoryIndices();
            this.setDirty();
            this.getSite().reflow();
        }
    }

    private void updateCategoryIndices() {
        int index = 0;
        for (CategoryForm form : this.fCategoryForms) {
            form.setIndex(index++);
        }
    }

    static class Category {
        String path = "";
        String htmlDescription = "";

        Category() {
        }
    }

    class CategoryForm {
        private final Category fCategory;
        private final Composite fComposite;
        private final Label fPathLabel;
        private final Text fPathText;
        private final Text fDescriptionText;

        CategoryForm(final Category category, Composite parent, FormToolkit toolkit, int index) {
            this.fCategory = category;
            this.fComposite = toolkit.createComposite(parent);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fComposite);
            GridLayoutFactory.fillDefaults().applyTo(this.fComposite);
            if (index != 0) {
                Label separator = toolkit.createLabel(this.fComposite, "", 258);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
            }
            Composite pathComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pathComposite);
            GridLayoutFactory.fillDefaults().numColumns(4).applyTo(pathComposite);
            this.fPathLabel = toolkit.createLabel(pathComposite, "");
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.fPathLabel);
            this.fPathText = toolkit.createText(pathComposite, category.path, 2180);
            this.fPathText.setMessage(Messages.SetupProjectAspectEditor_0);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(150, -1).applyTo((Control)this.fPathText);
            SetupProjectAspectEditor.this.createVarsButton(pathComposite, this.fPathText, toolkit, CATEGORY_PATH_VARS);
            ToolBar toolbar = new ToolBar(pathComposite, 0);
            toolkit.adapt((Control)toolbar, true, false);
            ToolItem deleteItem = new ToolItem(toolbar, 0);
            deleteItem.setImage(JazzResources.getImageWithDefault((ResourceManager)SetupProjectAspectEditor.this.fResourceManager, (ImageDescriptor)DELETE_IMAGE_DESCRIPTOR));
            deleteItem.setToolTipText(Messages.SetupProjectAspectEditor_1);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)toolbar);
            deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetupProjectAspectEditor.this.doDeleteCategory(category, CategoryForm.this);
                }
            });
            Composite descriptionComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)descriptionComposite);
            GridLayoutFactory.fillDefaults().applyTo(descriptionComposite);
            Label descriptionLabel = toolkit.createLabel(descriptionComposite, Messages.AcceptTeamInvitationAspectEditor_1);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)descriptionLabel);
            this.fDescriptionText = toolkit.createText(descriptionComposite, category.htmlDescription, 2626);
            int h = this.fDescriptionText.getLineHeight() * 3;
            h = this.fDescriptionText.computeTrim((int)0, (int)0, (int)100, (int)h).height;
            GridDataFactory.fillDefaults().grab(true, false).hint(150, h).applyTo((Control)this.fDescriptionText);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (e.widget == CategoryForm.this.fPathText) {
                        ((CategoryForm)CategoryForm.this).fCategory.path = CategoryForm.this.fPathText.getText();
                        SetupProjectAspectEditor.this.setDirty();
                    } else if (e.widget == CategoryForm.this.fDescriptionText) {
                        ((CategoryForm)CategoryForm.this).fCategory.htmlDescription = CategoryForm.this.fDescriptionText.getText();
                        SetupProjectAspectEditor.this.setDirty();
                    }
                }
            };
            this.fPathText.addModifyListener(modifyListener);
            this.fDescriptionText.addModifyListener(modifyListener);
            this.setIndex(index);
        }

        void setIndex(int index) {
            this.fPathLabel.setText(NLS.bind((String)Messages.SetupProjectAspectEditor_2, (Object)Integer.toString(index + 1)));
        }

        void dispose() {
            this.fComposite.dispose();
        }

        public void activate() {
            this.fDescriptionText.setFocus();
            this.fPathText.setFocus();
            this.fPathText.selectAll();
        }
    }

    static class Model {
        protected boolean createTeamArea = true;
        String teamAreaName = "";
        String developmentLineId = "";
        List<String> componentNames = new ArrayList<String>();
        boolean createWorkspace = true;
        String workspaceName = "";
        String workspaceDescription = "";
        List<Stage> stages = new ArrayList<Stage>();
        List<Category> categories = new ArrayList<Category>();

        Model() {
        }
    }

    static class SectionCheckbox {
        private final String fText;
        private final Button fButton;
        private final Label fLabel;

        SectionCheckbox(Composite parent, FormToolkit toolkit, String text) {
            this.fText = text;
            Composite composite = toolkit.createComposite(parent);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(3, 0).applyTo(composite);
            this.fButton = toolkit.createButton(composite, "", 32);
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateLabel();
                }
            });
            this.fLabel = toolkit.createLabel(composite, text);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fLabel);
            this.fLabel.setFont(SetupProjectAspectEditor.getBoldFont());
        }

        public boolean getSelection() {
            return this.fButton.getSelection();
        }

        public void addSelectionListener(SelectionListener listener) {
            this.fButton.addSelectionListener(listener);
        }

        public void setSelection(boolean selection) {
            this.fButton.setSelection(selection);
            this.updateLabel();
        }

        private void updateLabel() {
            this.fLabel.setText(this.fButton.getSelection() ? NLS.bind((String)Messages.SetupProjectAspectEditor_checkBoxSectionFmt, (Object)this.fText) : this.fText);
        }
    }

    static class Stage {
        String name = "";
        String description = "";

        Stage() {
        }
    }

    class StageForm {
        private final Stage fStage;
        private final Composite fComposite;
        private final Label fPathLabel;
        private final Text fPathText;
        private final Text fDescriptionText;

        StageForm(final Stage Stage2, Composite parent, FormToolkit toolkit, int index) {
            this.fStage = Stage2;
            this.fComposite = toolkit.createComposite(parent);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fComposite);
            GridLayoutFactory.fillDefaults().applyTo(this.fComposite);
            if (index != 0) {
                Label separator = toolkit.createLabel(this.fComposite, "", 258);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
            }
            Composite pathComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pathComposite);
            GridLayoutFactory.fillDefaults().numColumns(4).applyTo(pathComposite);
            this.fPathLabel = toolkit.createLabel(pathComposite, "");
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.fPathLabel);
            this.fPathText = toolkit.createText(pathComposite, Stage2.name, 2180);
            this.fPathText.setMessage(Messages.SetupProjectAspectEditor_0);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(150, -1).applyTo((Control)this.fPathText);
            SetupProjectAspectEditor.this.createVarsButton(pathComposite, this.fPathText, toolkit, CATEGORY_PATH_VARS);
            ToolBar toolbar = new ToolBar(pathComposite, 0);
            toolkit.adapt((Control)toolbar, true, false);
            ToolItem deleteItem = new ToolItem(toolbar, 0);
            deleteItem.setImage(JazzResources.getImageWithDefault((ResourceManager)SetupProjectAspectEditor.this.fResourceManager, (ImageDescriptor)DELETE_IMAGE_DESCRIPTOR));
            deleteItem.setToolTipText(Messages.SetupProjectAspectEditor_1);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)toolbar);
            deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetupProjectAspectEditor.this.doDeleteStage(Stage2, StageForm.this);
                }
            });
            Composite descriptionComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)descriptionComposite);
            GridLayoutFactory.fillDefaults().applyTo(descriptionComposite);
            Label descriptionLabel = toolkit.createLabel(descriptionComposite, Messages.AcceptTeamInvitationAspectEditor_1);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)descriptionLabel);
            this.fDescriptionText = toolkit.createText(descriptionComposite, Stage2.description, 2626);
            int h = this.fDescriptionText.getLineHeight() * 3;
            h = this.fDescriptionText.computeTrim((int)0, (int)0, (int)100, (int)h).height;
            GridDataFactory.fillDefaults().grab(true, false).hint(150, h).applyTo((Control)this.fDescriptionText);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (e.widget == StageForm.this.fPathText) {
                        ((StageForm)StageForm.this).fStage.name = StageForm.this.fPathText.getText();
                        SetupProjectAspectEditor.this.setDirty();
                    } else if (e.widget == StageForm.this.fDescriptionText) {
                        ((StageForm)StageForm.this).fStage.description = StageForm.this.fDescriptionText.getText();
                        SetupProjectAspectEditor.this.setDirty();
                    }
                }
            };
            this.fPathText.addModifyListener(modifyListener);
            this.fDescriptionText.addModifyListener(modifyListener);
            this.setIndex(index);
        }

        void setIndex(int index) {
            this.fPathLabel.setText(NLS.bind((String)Messages.SetupProjectAspectEditor_2, (Object)Integer.toString(index + 1)));
        }

        void dispose() {
            this.fComposite.dispose();
        }

        public void activate() {
            this.fDescriptionText.setFocus();
            this.fPathText.setFocus();
            this.fPathText.selectAll();
        }
    }
}

