/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.internal.common.common.process.TypeElement;
import com.ibm.team.enterprise.internal.process.ui.aspect.AspectEditorUtil;
import com.ibm.team.enterprise.internal.process.ui.aspect.ResultWorkItem;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.ICategory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResultWorkItemAspectEditor
extends ProcessAspectEditor {
    private final String fConfigurationDataId;
    private List<TypeElement> fTypeElements;
    private List<ICategory> fCategories;
    private ResultWorkItem fResultWorkItem;
    private Button fDisableButton;
    private Combo fWorkItemTypeCombo;
    private Combo fWorkItemFiledAgainstCombo;

    private void readWorkItemTypes() {
        ModelElement workItemTypesElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
        this.fTypeElements = AspectEditorUtil.readTypeElements(workItemTypesElement);
    }

    private void getWorkItemCategories() {
        IProcessContainerWorkingCopy workingCopy = this.getAspect().getProcessContainerWorkingCopy();
        if (workingCopy instanceof IProcessAreaWorkingCopy) {
            IProcessAreaWorkingCopy processArea = (IProcessAreaWorkingCopy)workingCopy;
            this.fetchCategories((IProjectArea)processArea.getUnderlyingProcessArea());
        } else {
            this.fCategories = new ArrayList<ICategory>();
        }
    }

    private void fetchCategories(final IProjectArea underlyingProcessArea) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                IWorkItemClient workItemClient = (IWorkItemClient)((ITeamRepository)underlyingProcessArea.getOrigin()).getClientLibrary(IWorkItemClient.class);
                try {
                    ResultWorkItemAspectEditor.this.fCategories = workItemClient.findCategories((IProjectAreaHandle)underlyingProcessArea, ICategory.DEFAULT_PROFILE, null);
                }
                catch (TeamRepositoryException e) {
                    ResultWorkItemAspectEditor.this.fCategories = new ArrayList();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.init();
    }

    private void init() {
        ModelElement data;
        this.readWorkItemTypes();
        this.getWorkItemCategories();
        this.fResultWorkItem = new ResultWorkItem();
        ModelElement root = this.getAspect().getConfigurationElement();
        if (root != null && "resultWorkItem".equals((data = (ModelElement)root.getChildElements().get(0)).getName())) {
            this.fResultWorkItem.setDisable(data.getAttribute("disable"));
            this.fResultWorkItem.setWorkItemTypeId(data.getAttribute("workItemTypeId"));
            this.fResultWorkItem.setWorkItemFiledAgainst(data.getAttribute("workItemFiledAgainst"));
        }
    }

    public void restoreState(IMemento memento) {
        IMemento resultWorkItemMemento = memento.getChild("resultWorkItem");
        if (resultWorkItemMemento != null) {
            if (resultWorkItemMemento.getBoolean("disable") != null && resultWorkItemMemento.getBoolean("disable").booleanValue()) {
                this.fResultWorkItem.setDisable(true);
            }
            this.fResultWorkItem.setWorkItemTypeId(resultWorkItemMemento.getString("workItemTypeId"));
            this.fResultWorkItem.setWorkItemFiledAgainst(resultWorkItemMemento.getString("workItemFiledAgainst"));
        }
    }

    public ResultWorkItemAspectEditor(String processAspectId) {
        this.fConfigurationDataId = processAspectId;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        this.createDisableButton(parent, toolkit);
        this.createWorkItemTypeCombo(parent, toolkit);
        this.createWorkItemFiledAgainstCombo(parent, toolkit);
        this.updateWidgets();
    }

    private void updateWidgets() {
        this.fDisableButton.setSelection(this.fResultWorkItem.getDisable());
        this.updateWorkItemTypeCombo();
        this.updateWorkItemFiledAgainstCombo();
    }

    private void createDisableButton(Composite parent, FormToolkit toolkit) {
        this.fDisableButton = new Button(parent, 32);
        this.fDisableButton.setText(Messages.ResultWorkItemEditor_DISABLE_BUTTON);
        this.fDisableButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ResultWorkItemAspectEditor.this.fResultWorkItem.setDisable(ResultWorkItemAspectEditor.this.fDisableButton.getSelection());
                ResultWorkItemAspectEditor.this.setDirty();
            }
        });
        toolkit.createLabel(parent, "");
    }

    private void createWorkItemTypeCombo(Composite parent, FormToolkit toolkit) {
        Label typeLabel = toolkit.createLabel(parent, Messages.ResultWorkItemEditor_WORK_ITEM_TYPE_COMBO);
        GridDataFactory.swtDefaults().applyTo((Control)typeLabel);
        this.fWorkItemTypeCombo = new Combo(parent, 8);
        toolkit.adapt((Control)this.fWorkItemTypeCombo, true, false);
        this.fWorkItemTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TypeElement element = (TypeElement)ResultWorkItemAspectEditor.this.fTypeElements.get(ResultWorkItemAspectEditor.this.fWorkItemTypeCombo.getSelectionIndex());
                ResultWorkItemAspectEditor.this.fResultWorkItem.setWorkItemTypeId(element.getId());
                ResultWorkItemAspectEditor.this.fResultWorkItem.setDirty(true);
                ResultWorkItemAspectEditor.this.setDirty();
            }
        });
        for (TypeElement element : this.fTypeElements) {
            this.fWorkItemTypeCombo.add(element.getName());
        }
    }

    private void updateWorkItemTypeCombo() {
        if (this.fResultWorkItem != null && this.fResultWorkItem.getWorkItemTypeId() != null) {
            String typeId = this.fResultWorkItem.getWorkItemTypeId();
            boolean foundIt = false;
            int i = 0;
            while (i < this.fTypeElements.size() && !foundIt) {
                if (typeId.equals(this.fTypeElements.get(i).getId())) {
                    foundIt = true;
                    this.fWorkItemTypeCombo.select(i);
                }
                ++i;
            }
        }
    }

    private void createWorkItemFiledAgainstCombo(Composite parent, FormToolkit toolkit) {
        Label typeLabel = toolkit.createLabel(parent, Messages.ResultWorkItemEditor_WORK_ITEM_FILED_AGAINST_COMBO);
        GridDataFactory.swtDefaults().applyTo((Control)typeLabel);
        this.fWorkItemFiledAgainstCombo = new Combo(parent, 8);
        toolkit.adapt((Control)this.fWorkItemFiledAgainstCombo, true, false);
        this.fWorkItemFiledAgainstCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ICategory category = (ICategory)ResultWorkItemAspectEditor.this.fCategories.get(ResultWorkItemAspectEditor.this.fWorkItemFiledAgainstCombo.getSelectionIndex());
                ResultWorkItemAspectEditor.this.fResultWorkItem.setWorkItemFiledAgainst(category.getName());
                ResultWorkItemAspectEditor.this.fResultWorkItem.setDirty(true);
                ResultWorkItemAspectEditor.this.setDirty();
            }
        });
        for (ICategory category : this.fCategories) {
            this.fWorkItemFiledAgainstCombo.add(category.getName());
        }
    }

    private void updateWorkItemFiledAgainstCombo() {
        if (this.fResultWorkItem.getWorkItemFiledAgainst() != null) {
            String filedAgainst = this.fResultWorkItem.getWorkItemFiledAgainst();
            boolean foundIt = false;
            int i = 0;
            while (i < this.fCategories.size() && !foundIt) {
                if (filedAgainst.equals(this.fCategories.get(i).getName())) {
                    foundIt = true;
                    this.fWorkItemFiledAgainstCombo.select(i);
                }
                ++i;
            }
        }
    }

    public void dispose() {
    }

    public void revert() {
        this.init();
        this.updateWidgets();
        this.setDirty(false);
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        memento.putString("id", this.fConfigurationDataId);
        String namespace = this.getAspect().getSchemaNamespaceURI();
        if (namespace != null) {
            memento.putString("xmlns", namespace);
        }
        IMemento resultWorkItemMemento = memento.createChild("resultWorkItem");
        resultWorkItemMemento.putBoolean("disable", this.fResultWorkItem.getDisable());
        if (this.fResultWorkItem.getWorkItemTypeId() != null) {
            resultWorkItemMemento.putString("workItemTypeId", this.fResultWorkItem.getWorkItemTypeId());
        }
        if (this.fResultWorkItem.getWorkItemFiledAgainst() != null) {
            resultWorkItemMemento.putString("workItemFiledAgainst", this.fResultWorkItem.getWorkItemFiledAgainst());
        }
        return true;
    }
}

