/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.enterprise.build.ui.dialogs.DependencyBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.buildablesubset.common.process.ProcessConstants;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RequireSubsetAspectEditor
extends OperationDetailsAspectEditor {
    private static final String REQUEST_BUTTON_KEY = "request.type";
    private static final String SCOPE_BUTTON_KEY = "scope.type";
    private InitialConfiguration initConfig;
    private TableViewer fScopedBuildsTableV;
    private Button[] fRequestScopeButton = new Button[ProcessConstants.ATT_SUBSET_REQTYPES_VALUES.length];
    private Button[] fChangeScopeButton = new Button[ProcessConstants.ATT_SUBSET_SCOPETYPES_VALUES.length];

    public boolean saveState(IMemento memento) {
        Button scopeButton;
        IMemento requireSubSetMemento = memento.createChild("requireSubset");
        Button[] buttonArray = this.fChangeScopeButton;
        int n = this.fChangeScopeButton.length;
        int n2 = 0;
        while (n2 < n) {
            scopeButton = buttonArray[n2];
            if (scopeButton.getSelection()) {
                requireSubSetMemento.putString("request.scope", (String)scopeButton.getData(SCOPE_BUTTON_KEY));
                break;
            }
            ++n2;
        }
        buttonArray = this.fRequestScopeButton;
        n = this.fRequestScopeButton.length;
        n2 = 0;
        while (n2 < n) {
            scopeButton = buttonArray[n2];
            if (scopeButton.getSelection()) {
                requireSubSetMemento.putString("request.types", (String)scopeButton.getData(REQUEST_BUTTON_KEY));
                break;
            }
            ++n2;
        }
        TableItem[] items = this.fScopedBuildsTableV.getTable().getItems();
        if (items != null && items.length > 0) {
            IMemento scopeMemento = requireSubSetMemento.createChild("scope");
            TableItem[] tableItemArray = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray[n4];
                IMemento bDefScope = scopeMemento.createChild("buildDefinition");
                IBuildDefinition bDef = (IBuildDefinition)item.getData();
                bDefScope.putString("uuid", bDef.getItemId().getUuidValue());
                ++n4;
            }
        }
        return true;
    }

    public void restoreState(IMemento memento) {
        IMemento requireSubSetMemento = memento.getChild("requireSubset");
        if (requireSubSetMemento != null) {
            IMemento[] bDefsMementos;
            this.initConfig = new InitialConfiguration(requireSubSetMemento.getString("request.scope"), requireSubSetMemento.getString("request.types"), null);
            IMemento scopeMemento = requireSubSetMemento.getChild("scope");
            if (scopeMemento != null && (bDefsMementos = scopeMemento.getChildren()) != null && bDefsMementos.length > 0) {
                IMemento[] iMementoArray = bDefsMementos;
                int n = bDefsMementos.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento bDefsMemento = iMementoArray[n2];
                    if (bDefsMemento.getType().equals("buildDefinition")) {
                        this.initConfig.addInitialBuild(bDefsMemento.getString("uuid"));
                    }
                    ++n2;
                }
            }
        } else {
            this.initConfig = new InitialConfiguration("any", "any", null);
            this.setDirty();
        }
    }

    public void createControl(final Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(1, 8).numColumns(1).applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.RequireSubsetAspectEditor_1);
        heading.setFont(this.getBoldFont());
        Composite buildsComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(5, 1).numColumns(1).applyTo(buildsComposite);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, true).applyTo((Control)buildsComposite);
        heading = toolkit.createLabel(buildsComposite, Messages.RequireSubsetAspectEditor_4);
        GridDataFactory.fillDefaults().align(16384, 128).span(3, 1).grab(true, true).applyTo((Control)heading);
        this.fRequestScopeButton[0] = toolkit.createButton(buildsComposite, Messages.RequireSubsetAspectEditor_5, 16);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fRequestScopeButton[0]);
        this.fRequestScopeButton[0].setData(REQUEST_BUTTON_KEY, (Object)"team");
        this.fRequestScopeButton[0].addSelectionListener((SelectionListener)new SimpleDirtyAdapter());
        this.fRequestScopeButton[1] = toolkit.createButton(buildsComposite, Messages.RequireSubsetAspectEditor_6, 16);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fRequestScopeButton[1]);
        this.fRequestScopeButton[1].setData(REQUEST_BUTTON_KEY, (Object)"personal");
        this.fRequestScopeButton[1].addSelectionListener((SelectionListener)new SimpleDirtyAdapter());
        this.fRequestScopeButton[2] = toolkit.createButton(buildsComposite, Messages.RequireSubsetAspectEditor_7, 16);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fRequestScopeButton[2]);
        this.fRequestScopeButton[2].setData(REQUEST_BUTTON_KEY, (Object)"any");
        this.fRequestScopeButton[2].addSelectionListener((SelectionListener)new SimpleDirtyAdapter());
        Composite changeOptComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(5, 1).numColumns(1).applyTo(changeOptComposite);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, true).applyTo((Control)changeOptComposite);
        heading = toolkit.createLabel(changeOptComposite, Messages.RequireSubsetAspectEditor_2);
        this.fChangeScopeButton[0] = toolkit.createButton(changeOptComposite, Messages.RequireSubsetAspectEditor_0, 16);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fChangeScopeButton[0]);
        this.fChangeScopeButton[0].setData(SCOPE_BUTTON_KEY, (Object)"incremental");
        this.fChangeScopeButton[0].addSelectionListener((SelectionListener)new SimpleDirtyAdapter());
        this.fChangeScopeButton[1] = toolkit.createButton(changeOptComposite, Messages.RequireSubsetAspectEditor_12, 16);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fChangeScopeButton[1]);
        this.fChangeScopeButton[1].setData(SCOPE_BUTTON_KEY, (Object)"full");
        this.fChangeScopeButton[1].addSelectionListener((SelectionListener)new SimpleDirtyAdapter());
        this.fChangeScopeButton[2] = toolkit.createButton(changeOptComposite, Messages.RequireSubsetAspectEditor_13, 16);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fChangeScopeButton[2]);
        this.fChangeScopeButton[2].setData(SCOPE_BUTTON_KEY, (Object)"any");
        this.fChangeScopeButton[2].addSelectionListener((SelectionListener)new SimpleDirtyAdapter());
        heading = toolkit.createLabel(parent, Messages.RequireSubsetAspectEditor_8);
        heading.setFont(this.getBoldFont());
        heading = toolkit.createLabel(parent, Messages.RequireSubsetAspectEditor_9);
        Composite scopeBuildsComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(5, 1).numColumns(2).applyTo(scopeBuildsComposite);
        GridDataFactory.fillDefaults().align(16384, 128).indent(10, 0).grab(true, true).applyTo((Control)scopeBuildsComposite);
        this.fScopedBuildsTableV = new TableViewer(scopeBuildsComposite, 2818);
        toolkit.adapt((Control)this.fScopedBuildsTableV.getTable(), true, true);
        this.fScopedBuildsTableV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fScopedBuildsTableV.setLabelProvider((IBaseLabelProvider)new BuildDefinitionLabelProvider());
        this.fScopedBuildsTableV.setInput(new ArrayList());
        int h = this.fScopedBuildsTableV.getTable().getItemHeight() * 2;
        h = this.fScopedBuildsTableV.getTable().computeTrim((int)0, (int)0, (int)500, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, true).hint(300, h).applyTo((Control)this.fScopedBuildsTableV.getTable());
        Composite buttonComposite = toolkit.createComposite(scopeBuildsComposite);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(buttonComposite);
        Button addBuildButton = toolkit.createButton(buttonComposite, Messages.RequireSubsetAspectEditor_10, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)addBuildButton);
        addBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyBuildDefinitionSelectionDialog dlg = new DependencyBuildDefinitionSelectionDialog(parent.getShell(), false, null);
                dlg.setAllowDuplicates(false);
                dlg.setMultipleSelection(true);
                if (dlg.open() == 0) {
                    Object[] selections;
                    Object[] objectArray = selections = dlg.getResult();
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selection = objectArray[n2];
                        if (selection instanceof IBuildDefinition && !((ArrayList)RequireSubsetAspectEditor.this.fScopedBuildsTableV.getInput()).contains(selection)) {
                            ((ArrayList)RequireSubsetAspectEditor.this.fScopedBuildsTableV.getInput()).add(selection);
                            if (!RequireSubsetAspectEditor.this.isDirty()) {
                                RequireSubsetAspectEditor.this.setDirty();
                            }
                        }
                        ++n2;
                    }
                    if (RequireSubsetAspectEditor.this.isDirty()) {
                        RequireSubsetAspectEditor.this.fScopedBuildsTableV.refresh();
                    }
                }
            }
        });
        final Button removeBuildButton = toolkit.createButton(buttonComposite, Messages.RequireSubsetAspectEditor_11, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)removeBuildButton);
        removeBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = RequireSubsetAspectEditor.this.fScopedBuildsTableV.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ((ArrayList)RequireSubsetAspectEditor.this.fScopedBuildsTableV.getInput()).removeAll(ss.toList());
                    RequireSubsetAspectEditor.this.setDirty();
                    RequireSubsetAspectEditor.this.fScopedBuildsTableV.refresh();
                }
            }
        });
        removeBuildButton.setEnabled(false);
        this.fScopedBuildsTableV.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                removeBuildButton.setEnabled(selection != null && !selection.isEmpty());
            }
        });
        this.computeInitialButtonsStatus();
    }

    private void computeInitialButtonsStatus() {
        Button button;
        Button[] buttonArray = this.fChangeScopeButton;
        int n = this.fChangeScopeButton.length;
        int n2 = 0;
        while (n2 < n) {
            button = buttonArray[n2];
            if (button.getData(SCOPE_BUTTON_KEY).equals(this.initConfig.getScopeTypeValue())) {
                button.setSelection(true);
                break;
            }
            ++n2;
        }
        buttonArray = this.fRequestScopeButton;
        n = this.fRequestScopeButton.length;
        n2 = 0;
        while (n2 < n) {
            button = buttonArray[n2];
            if (button.getData(REQUEST_BUTTON_KEY).equals(this.initConfig.getRequestTypeValue())) {
                button.setSelection(true);
                break;
            }
            ++n2;
        }
        Job populateStreamsDataJob = new Job("Populate build definitions data"){

            protected IStatus run(IProgressMonitor monitor) {
                RequireSubsetAspectEditor.this.readAndLoadBuildDefinitions();
                return Status.OK_STATUS;
            }
        };
        populateStreamsDataJob.setSystem(true);
        populateStreamsDataJob.schedule();
    }

    public void dispose() {
    }

    private void readAndLoadBuildDefinitions() {
        IProcessItem processItem = this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        final ITeamRepository repo = (ITeamRepository)processItem.getOrigin();
        Job job = new Job(Messages.RequireSubsetAspectEditor_14){
            List<IBuildDefinition> initialBuilds;

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (RequireSubsetAspectEditor.this.initConfig.hasBuildsConfigured()) {
                        this.initialBuilds = repo.itemManager().fetchCompleteItems(new ArrayList<IBuildDefinitionHandle>(RequireSubsetAspectEditor.this.initConfig.getHandles()), 0, null);
                        ((ArrayList)RequireSubsetAspectEditor.this.fScopedBuildsTableV.getInput()).addAll(this.initialBuilds);
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.process.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = RequireSubsetAspectEditor.this.fScopedBuildsTableV.getTable().getDisplay();
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (RequireSubsetAspectEditor.this.fScopedBuildsTableV.getTable().isDisposed()) {
                                        return;
                                    }
                                    RequireSubsetAspectEditor.this.fScopedBuildsTableV.refresh();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    private static class InitialConfiguration {
        private scopeType changeItems;
        private requestType request;
        private List<IBuildDefinitionHandle> initialScope;

        public InitialConfiguration(String scopeLiteral, String requestLiteral, List<IBuildDefinitionHandle> scope) {
            this.changeItems = scopeType.getValueForLiteral(scopeLiteral);
            this.request = requestType.getValueForLiteral(requestLiteral);
            this.initialScope = scope == null ? new ArrayList() : scope;
        }

        public void addInitialBuild(String uUid) {
            IBuildDefinitionHandle bh = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uUid), null);
            this.initialScope.add(bh);
        }

        public List<IBuildDefinitionHandle> getHandles() {
            return this.initialScope;
        }

        public String getScopeTypeValue() {
            return this.changeItems.getValue();
        }

        public String getRequestTypeValue() {
            return this.request.getValue();
        }

        public boolean hasBuildsConfigured() {
            return !this.initialScope.isEmpty();
        }

        private static enum requestType {
            TEAM("team"),
            PERSONAL("personal"),
            ANY("any");

            private String value;

            private requestType(String value) {
                this.value = value;
            }

            public static requestType getValueForLiteral(String literal) {
                if (literal.equalsIgnoreCase("team")) {
                    return TEAM;
                }
                if (literal.equalsIgnoreCase("personal")) {
                    return PERSONAL;
                }
                return ANY;
            }

            public String getValue() {
                return this.value;
            }
        }

        private static enum scopeType {
            FULL("full"),
            INCREMENTAL("incremental"),
            ANY("any");

            private String value;

            private scopeType(String value) {
                this.value = value;
            }

            public static scopeType getValueForLiteral(String literal) {
                if (literal.equalsIgnoreCase("full")) {
                    return FULL;
                }
                if (literal.equalsIgnoreCase("incremental")) {
                    return INCREMENTAL;
                }
                return ANY;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    private class SimpleDirtyAdapter
    extends SelectionAdapter {
        private SimpleDirtyAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!RequireSubsetAspectEditor.this.isDirty()) {
                RequireSubsetAspectEditor.this.setDirty();
            }
        }
    }
}

