/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.enterprise.internal.common.common.process.BuildDefinitionElement;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.enterprise.internal.promotion.ui.dialogs.PromotionDefinitionSelectionDialog;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PromotionRunTargetBuildEditor
extends OperationDetailsAspectEditor {
    private TableViewer fPromotionsOverrideTable;
    private Button defRunBuildCheckbox;
    private Button defUseSubsetCheckbox;
    private Button defIncludeImpactedCheckBox;
    private Button runBuildCheckbox;
    private Button useSubsetCheckbox;
    private Button includeImpactedCheckBox;
    private RunBuildModifyListener runBuildCheckboxListener;
    private UseSubsetModifyListener useSubsetModifyListener;
    private IncludeImpactsModifyListener includeImpactsModifyListener;
    private IMemento runTargetBuildMemento;
    private BuildDefinitionElement defaultConfig;
    private Map<UUID, BuildDefinitionElement> promosConfig;
    private Composite optionsOverrideComposite;

    public boolean saveState(IMemento memento) {
        TableItem[] items;
        IMemento runTargetBuildElement = memento.createChild("runTargetBuild");
        IMemento buildElement = runTargetBuildElement.createChild("buildDefinition");
        buildElement.putBoolean("default", true);
        IMemento runBuildElement = buildElement.createChild("runBuild");
        runBuildElement.putBoolean("value", this.defRunBuildCheckbox.getSelection());
        if (this.defUseSubsetCheckbox.getSelection()) {
            IMemento useSubsetElement = buildElement.createChild("useSubset");
            useSubsetElement.putBoolean("value", this.defUseSubsetCheckbox.getSelection());
            useSubsetElement.putBoolean("includeImpacts", this.defIncludeImpactedCheckBox.getSelection());
        }
        if ((items = this.fPromotionsOverrideTable.getTable().getItems()) != null && items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                IBuildDefinition bDef = (IBuildDefinition)item.getData();
                buildElement = runTargetBuildElement.createChild("buildDefinition");
                buildElement.putString("uuid", bDef.getItemId().getUuidValue());
                BuildDefinitionElement elemConfig = this.promosConfig.get(bDef.getItemId());
                runBuildElement = buildElement.createChild("runBuild");
                runBuildElement.putBoolean("value", elemConfig.isRunTargetBuild());
                if (elemConfig.isUseSubset()) {
                    IMemento useSubsetElement = buildElement.createChild("useSubset");
                    useSubsetElement.putBoolean("value", elemConfig.isUseSubset());
                    useSubsetElement.putBoolean("includeImpacts", elemConfig.isIncludeImpacts());
                }
                ++n2;
            }
        }
        return true;
    }

    public void restoreState(IMemento memento) {
        IMemento[] buildElements;
        this.runTargetBuildMemento = memento.getChild("runTargetBuild");
        this.defaultConfig = new BuildDefinitionElement(null, "", Collections.EMPTY_LIST);
        if (this.runTargetBuildMemento == null) {
            this.defaultConfig.setRunTargetBuild(true);
            this.setDirty();
            return;
        }
        IMemento[] iMementoArray = buildElements = this.runTargetBuildMemento.getChildren("buildDefinition");
        int n = buildElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento buildElement = iMementoArray[n2];
            if (buildElement.getBoolean("default") != null && buildElement.getBoolean("default").booleanValue()) {
                this.setConfigurationValues(this.defaultConfig, buildElement);
            } else {
                UUID uuid = UUID.valueOf((String)buildElement.getString("uuid"));
                BuildDefinitionElement promoConfig = new BuildDefinitionElement(uuid, "", Collections.EMPTY_LIST);
                this.setConfigurationValues(promoConfig, buildElement);
                if (this.promosConfig == null) {
                    this.promosConfig = new HashMap<UUID, BuildDefinitionElement>();
                }
                this.promosConfig.put(uuid, promoConfig);
            }
            ++n2;
        }
    }

    private void setConfigurationValues(BuildDefinitionElement element, IMemento mementoElement) {
        IMemento useSubsetElement;
        IMemento runBuildElement = mementoElement.getChild("runBuild");
        if (runBuildElement != null) {
            element.setRunTargetBuild(runBuildElement.getBoolean("value").booleanValue());
        }
        if ((useSubsetElement = mementoElement.getChild("useSubset")) != null) {
            element.setUseSubset(useSubsetElement.getBoolean("value").booleanValue());
            Boolean inclImpactsSubset = useSubsetElement.getBoolean("includeImpacts");
            if (inclImpactsSubset == null) {
                element.setIncludeImpacts(false);
            } else {
                element.setIncludeImpacts(inclImpactsSubset.booleanValue());
            }
        }
    }

    public void createControl(final Composite parent, FormToolkit toolkit) {
        this.runBuildCheckboxListener = new RunBuildModifyListener();
        this.useSubsetModifyListener = new UseSubsetModifyListener();
        this.includeImpactsModifyListener = new IncludeImpactsModifyListener();
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        Composite defaultComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(defaultComposite);
        Label heading = toolkit.createLabel(defaultComposite, Messages.PromotionRunTargetBuildEditor_Default);
        heading.setFont(this.getBoldFont());
        toolkit.createLabel(defaultComposite, Messages.PromotionRunTargetBuildEditor_BehaviorLabel);
        this.defRunBuildCheckbox = toolkit.createButton(defaultComposite, Messages.PromotionRunTargetBuildEditor_RUN_BUILD_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.defRunBuildCheckbox);
        this.defRunBuildCheckbox.addSelectionListener((SelectionListener)this.runBuildCheckboxListener);
        Composite useSubsetComposite = toolkit.createComposite(defaultComposite);
        GridLayoutFactory.fillDefaults().margins(20, 0).numColumns(1).applyTo(useSubsetComposite);
        this.defUseSubsetCheckbox = toolkit.createButton(useSubsetComposite, Messages.PromotionRunTargetBuildEditor_USE_SUBSET_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.defUseSubsetCheckbox);
        this.defUseSubsetCheckbox.addSelectionListener((SelectionListener)this.useSubsetModifyListener);
        Composite includeImpactsComposite = toolkit.createComposite(useSubsetComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(includeImpactsComposite);
        this.defIncludeImpactedCheckBox = toolkit.createButton(includeImpactsComposite, Messages.PromotionRunTargetBuildEditor_INCLUDE_IMPACTED_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.defIncludeImpactedCheckBox);
        this.defIncludeImpactedCheckBox.addSelectionListener((SelectionListener)this.includeImpactsModifyListener);
        Composite overrideComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(overrideComposite);
        heading = toolkit.createLabel(defaultComposite, Messages.PromotionRunTargetBuildEditor_PromosLabel);
        heading.setFont(this.getBoldFont());
        toolkit.createLabel(defaultComposite, Messages.PromotionRunTargetBuildEditor_PromosBehaviorLabel);
        Composite promosOverrideComposite = toolkit.createComposite(overrideComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 1).numColumns(3).applyTo(promosOverrideComposite);
        GridDataFactory.fillDefaults().align(16384, 128).indent(10, 0).grab(true, true).applyTo((Control)promosOverrideComposite);
        this.fPromotionsOverrideTable = new TableViewer(promosOverrideComposite, 2818);
        toolkit.adapt((Control)this.fPromotionsOverrideTable.getTable(), true, true);
        this.fPromotionsOverrideTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fPromotionsOverrideTable.setLabelProvider((IBaseLabelProvider)new BuildDefinitionLabelProvider());
        this.fPromotionsOverrideTable.setInput(new ArrayList());
        int h = this.fPromotionsOverrideTable.getTable().getItemHeight() * 2;
        h = this.fPromotionsOverrideTable.getTable().computeTrim((int)0, (int)0, (int)500, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, true).hint(300, h).applyTo((Control)this.fPromotionsOverrideTable.getTable());
        Composite buttonComposite = toolkit.createComposite(promosOverrideComposite);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(buttonComposite);
        Button addBuildButton = toolkit.createButton(buttonComposite, Messages.RequireSubsetAspectEditor_10, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)addBuildButton);
        addBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProcessAreaWorkingCopy processArea = (IProcessAreaWorkingCopy)PromotionRunTargetBuildEditor.this.getAspect().getProcessContainerWorkingCopy();
                PromotionDefinitionSelectionDialog dlg = new PromotionDefinitionSelectionDialog(parent.getShell(), processArea.getUnderlyingProcessArea(), false, true){

                    protected boolean shouldDisplay(IBuildDefinition buildDefinition) {
                        ArrayList existingEntries = (ArrayList)PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getInput();
                        return !existingEntries.contains(buildDefinition);
                    }
                };
                if (dlg.open() == 0) {
                    Object[] selections;
                    Object firstNewItem = null;
                    Object[] objectArray = selections = dlg.getResult();
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selection = objectArray[n2];
                        if (selection instanceof IBuildDefinition && !((ArrayList)PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getInput()).contains(selection)) {
                            ((ArrayList)PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getInput()).add(selection);
                            PromotionRunTargetBuildEditor.this.setDirty();
                            BuildDefinitionElement element = PromotionRunTargetBuildEditor.this.getBuildDefinitionElement((IBuildDefinition)selection);
                            element.setRunTargetBuild(true);
                            if (firstNewItem == null) {
                                firstNewItem = selection;
                            }
                        }
                        ++n2;
                    }
                    if (firstNewItem != null) {
                        PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.refresh();
                        PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.setSelection((ISelection)new StructuredSelection(firstNewItem));
                    }
                }
            }
        });
        final Button removeBuildButton = toolkit.createButton(buttonComposite, Messages.RequireSubsetAspectEditor_11, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)removeBuildButton);
        removeBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ((ArrayList)PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getInput()).removeAll(ss.toList());
                    for (Object element : ss.toList()) {
                        if (!(element instanceof IBuildDefinition)) continue;
                        PromotionRunTargetBuildEditor.this.promosConfig.remove(((IBuildDefinition)element).getItemId());
                    }
                    PromotionRunTargetBuildEditor.this.setDirty();
                    PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.refresh();
                }
            }
        });
        removeBuildButton.setEnabled(false);
        this.fPromotionsOverrideTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                removeBuildButton.setEnabled(selection != null && !selection.isEmpty());
                PromotionRunTargetBuildEditor.this.updateCheckboxEnablement();
            }
        });
        this.optionsOverrideComposite = toolkit.createComposite(promosOverrideComposite);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)this.optionsOverrideComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(this.optionsOverrideComposite);
        this.runBuildCheckbox = toolkit.createButton(this.optionsOverrideComposite, Messages.PromotionRunTargetBuildEditor_RUN_BUILD_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.runBuildCheckbox);
        this.runBuildCheckbox.addSelectionListener((SelectionListener)this.runBuildCheckboxListener);
        Composite useSubsetOverrideComposite = toolkit.createComposite(this.optionsOverrideComposite);
        GridLayoutFactory.fillDefaults().margins(20, 0).numColumns(1).applyTo(useSubsetOverrideComposite);
        this.useSubsetCheckbox = toolkit.createButton(useSubsetOverrideComposite, Messages.PromotionRunTargetBuildEditor_USE_SUBSET_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.useSubsetCheckbox);
        this.useSubsetCheckbox.addSelectionListener((SelectionListener)this.useSubsetModifyListener);
        Composite includeImpactsOverrideComposite = toolkit.createComposite(useSubsetOverrideComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(includeImpactsOverrideComposite);
        this.includeImpactedCheckBox = toolkit.createButton(includeImpactsOverrideComposite, Messages.PromotionRunTargetBuildEditor_INCLUDE_IMPACTED_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.includeImpactedCheckBox);
        this.includeImpactedCheckBox.addSelectionListener((SelectionListener)this.includeImpactsModifyListener);
        this.computeInitialButtonsStatus();
    }

    private void updateCheckboxEnablement() {
        BuildDefinitionElement element = this.getCurrentEditBuild();
        if (element.isDefault()) {
            this.optionsOverrideComposite.setEnabled(false);
            this.optionsOverrideComposite.setVisible(false);
        } else {
            this.optionsOverrideComposite.setEnabled(true);
            this.optionsOverrideComposite.setVisible(true);
            this.runBuildCheckbox.setSelection(element.isRunTargetBuild());
            this.useSubsetCheckbox.setEnabled(this.runBuildCheckbox.getSelection());
            this.useSubsetCheckbox.setSelection(element.isUseSubset());
            this.includeImpactedCheckBox.setEnabled(this.runBuildCheckbox.getSelection() && this.useSubsetCheckbox.getSelection());
            this.includeImpactedCheckBox.setSelection(element.isIncludeImpacts());
        }
        this.defRunBuildCheckbox.setVisible(true);
        this.defUseSubsetCheckbox.setVisible(true);
        this.defIncludeImpactedCheckBox.setVisible(true);
        this.defUseSubsetCheckbox.setEnabled(this.defRunBuildCheckbox.getSelection());
        this.defIncludeImpactedCheckBox.setEnabled(this.defRunBuildCheckbox.getSelection() && this.defUseSubsetCheckbox.getSelection());
    }

    private void updateSubsetCheckBox(BuildDefinitionElement buildDefinition, boolean isDefault) {
        if (isDefault) {
            if (this.defRunBuildCheckbox != null && !this.defRunBuildCheckbox.isDisposed() && this.defUseSubsetCheckbox != null && !this.defUseSubsetCheckbox.isDisposed()) {
                this.defUseSubsetCheckbox.setEnabled(this.defRunBuildCheckbox.getSelection());
                if (!this.defRunBuildCheckbox.getSelection()) {
                    this.defUseSubsetCheckbox.setSelection(false);
                    buildDefinition.setUseSubset(false);
                }
                this.updateIncludeImpactedCheckBox(buildDefinition, isDefault);
            }
        } else if (this.runBuildCheckbox != null && !this.runBuildCheckbox.isDisposed() && this.useSubsetCheckbox != null && !this.useSubsetCheckbox.isDisposed()) {
            this.useSubsetCheckbox.setEnabled(this.runBuildCheckbox.getSelection());
            if (!this.runBuildCheckbox.getSelection()) {
                this.useSubsetCheckbox.setSelection(false);
                buildDefinition.setUseSubset(false);
            }
            this.updateIncludeImpactedCheckBox(buildDefinition, isDefault);
        }
    }

    private void updateIncludeImpactedCheckBox(BuildDefinitionElement buildDefinition, boolean isDefault) {
        if (isDefault) {
            if (this.defRunBuildCheckbox != null && !this.defRunBuildCheckbox.isDisposed() && this.defUseSubsetCheckbox != null && !this.defUseSubsetCheckbox.isDisposed()) {
                this.defIncludeImpactedCheckBox.setEnabled(this.defUseSubsetCheckbox.getSelection());
                if (!this.defUseSubsetCheckbox.getSelection()) {
                    this.defIncludeImpactedCheckBox.setSelection(false);
                    buildDefinition.setIncludeImpacts(false);
                }
            }
        } else if (this.runBuildCheckbox != null && !this.runBuildCheckbox.isDisposed() && this.useSubsetCheckbox != null && !this.useSubsetCheckbox.isDisposed()) {
            this.includeImpactedCheckBox.setEnabled(this.useSubsetCheckbox.getSelection());
            if (!this.useSubsetCheckbox.getSelection()) {
                this.includeImpactedCheckBox.setSelection(false);
                buildDefinition.setIncludeImpacts(false);
            }
        }
    }

    public void dispose() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.runTargetBuildMemento = null;
    }

    private BuildDefinitionElement getCurrentEditBuild() {
        IStructuredSelection selection = (IStructuredSelection)this.fPromotionsOverrideTable.getSelection();
        if (selection == null || selection.isEmpty()) {
            this.optionsOverrideComposite.setVisible(false);
            this.optionsOverrideComposite.setEnabled(false);
            return this.defaultConfig;
        }
        Object sel = selection.getFirstElement();
        if (sel instanceof IBuildDefinition) {
            IBuildDefinition selectedDef = (IBuildDefinition)sel;
            return this.getBuildDefinitionElement(selectedDef);
        }
        return null;
    }

    private BuildDefinitionElement getBuildDefinitionElement(IBuildDefinition def) {
        if (this.promosConfig == null) {
            this.promosConfig = new HashMap<UUID, BuildDefinitionElement>();
        }
        if (!this.promosConfig.containsKey(def.getItemId())) {
            BuildDefinitionElement newElement = new BuildDefinitionElement(def, Collections.EMPTY_LIST);
            this.promosConfig.put(def.getItemId(), newElement);
        }
        return this.promosConfig.get(def.getItemId());
    }

    private void computeInitialButtonsStatus() {
        this.optionsOverrideComposite.setVisible(false);
        this.optionsOverrideComposite.setEnabled(false);
        this.defRunBuildCheckbox.setSelection(this.defaultConfig.isRunTargetBuild());
        this.defUseSubsetCheckbox.setSelection(this.defaultConfig.isUseSubset());
        this.defIncludeImpactedCheckBox.setSelection(this.defaultConfig.isIncludeImpacts());
        this.defIncludeImpactedCheckBox.setEnabled(this.defRunBuildCheckbox.getSelection() && this.defUseSubsetCheckbox.getSelection());
        Job populateStreamsDataJob = new Job("Populate build definitions data"){

            protected IStatus run(IProgressMonitor monitor) {
                PromotionRunTargetBuildEditor.this.readAndLoadPromotionDefinitions();
                return Status.OK_STATUS;
            }
        };
        populateStreamsDataJob.setSystem(true);
        populateStreamsDataJob.schedule();
    }

    private void readAndLoadPromotionDefinitions() {
        IProcessItem processItem = this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        final ITeamRepository repo = (ITeamRepository)processItem.getOrigin();
        Job job = new Job("Retrieve promotion definitions"){
            List<IBuildDefinition> initialPromos;

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (PromotionRunTargetBuildEditor.this.promosConfig != null && !PromotionRunTargetBuildEditor.this.promosConfig.isEmpty()) {
                        ArrayList<IBuildDefinitionHandle> handles = new ArrayList<IBuildDefinitionHandle>();
                        for (UUID elementUUID : PromotionRunTargetBuildEditor.this.promosConfig.keySet()) {
                            handles.add((IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(elementUUID, null));
                        }
                        this.initialPromos = repo.itemManager().fetchCompleteItems(handles, 0, null);
                        ((ArrayList)PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getInput()).addAll(this.initialPromos);
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.process.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getTable().getDisplay();
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.getTable().isDisposed()) {
                                        return;
                                    }
                                    PromotionRunTargetBuildEditor.this.fPromotionsOverrideTable.refresh();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    class IncludeImpactsModifyListener
    extends SelectionAdapter {
        IncludeImpactsModifyListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            BuildDefinitionElement buildDefinition = PromotionRunTargetBuildEditor.this.getCurrentEditBuild();
            buildDefinition.setIncludeImpacts(button.getSelection());
            PromotionRunTargetBuildEditor.this.setDirty();
        }
    }

    class RunBuildModifyListener
    extends SelectionAdapter {
        RunBuildModifyListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            BuildDefinitionElement buildDefinition = PromotionRunTargetBuildEditor.this.getCurrentEditBuild();
            buildDefinition.setRunTargetBuild(button.getSelection());
            if (button == PromotionRunTargetBuildEditor.this.runBuildCheckbox) {
                PromotionRunTargetBuildEditor.this.updateSubsetCheckBox(buildDefinition, false);
            } else {
                PromotionRunTargetBuildEditor.this.updateSubsetCheckBox(buildDefinition, true);
            }
            PromotionRunTargetBuildEditor.this.setDirty();
        }
    }

    class UseSubsetModifyListener
    extends SelectionAdapter {
        UseSubsetModifyListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            BuildDefinitionElement buildDefinition = PromotionRunTargetBuildEditor.this.getCurrentEditBuild();
            buildDefinition.setUseSubset(button.getSelection());
            if (button == PromotionRunTargetBuildEditor.this.useSubsetCheckbox) {
                PromotionRunTargetBuildEditor.this.updateIncludeImpactedCheckBox(buildDefinition, false);
            } else {
                PromotionRunTargetBuildEditor.this.updateIncludeImpactedCheckBox(buildDefinition, true);
            }
            PromotionRunTargetBuildEditor.this.setDirty();
        }
    }
}

