/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.internal.common.common.process.BuildDefinitionElement;
import com.ibm.team.enterprise.internal.process.ui.aspect.AspectEditorUtil;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PromotionRequireBuildMapCheckEditor
extends OperationDetailsAspectEditor {
    private Map<UUID, BuildDefinitionElement> buildDefinitionMap;
    private IMemento requireBuildMapCheckMemento;
    private Combo buildDefinitionCombo;
    private UUID defaultConfigurationUUID;
    private Button overrideDefaultCheckbox;
    private Button checkBuildMapForSourceOnlyCheckBox;
    private Button checkIgnoreBuildMapValidationCheckBox;
    private final String TAG_CHECK_BUILD_MAP_SOURCE_ONLY = "checkBuildMapForSourceOnly";
    private final String TAG_IGNORE_BUILD_MAP_VALIDATION = "ignoreBuildMapValidation";
    private final String TAG_REQUIRE_BUILD_MAP_CHECK = "requireBuildMapCheck";

    private BuildDefinitionElement getCurrentEditBuild() {
        String buildDefinition = this.buildDefinitionCombo.getText();
        UUID buildDefintionUUID = (UUID)this.buildDefinitionCombo.getData(buildDefinition);
        return this.buildDefinitionMap.get(buildDefintionUUID);
    }

    public boolean saveState(IMemento memento) {
        IMemento requireBuildMapCheckElement = memento.createChild("requireBuildMapCheck");
        for (BuildDefinitionElement build : this.buildDefinitionMap.values()) {
            boolean checkBuildMap = build.isCheckBuildMapForSourceOnly();
            boolean ignoreBuildMapValidation = build.isCheckIgnoreBuildMapValidaiton();
            if (!build.isDirty()) continue;
            IMemento buildElement = requireBuildMapCheckElement.createChild("buildDefinition");
            if (build.isDefault()) {
                buildElement.putBoolean("default", true);
            } else {
                buildElement.putString("uuid", build.getUUID().getUuidValue());
            }
            IMemento requireBuildMapCheckValueElement = buildElement.createChild("checkBuildMapForSourceOnly");
            requireBuildMapCheckValueElement.putBoolean("value", checkBuildMap);
            IMemento ignoreBuildMapValidationValueElement = buildElement.createChild("ignoreBuildMapValidation");
            if (checkBuildMap) {
                ignoreBuildMapValidationValueElement.putBoolean("value", ignoreBuildMapValidation);
                continue;
            }
            ignoreBuildMapValidationValueElement.putBoolean("value", false);
        }
        this.restoreState(memento);
        return true;
    }

    private void readPreviousSavedStates() {
        IMemento[] buildElements;
        BuildDefinitionElement build;
        if (this.requireBuildMapCheckMemento == null && (build = this.buildDefinitionMap.get(this.defaultConfigurationUUID)) != null) {
            build.setDirty();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PromotionRequireBuildMapCheckEditor.this.setDirty();
                }
            });
            return;
        }
        IMemento[] iMementoArray = buildElements = this.requireBuildMapCheckMemento.getChildren("buildDefinition");
        int n = buildElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento buildElement = iMementoArray[n2];
            UUID buildUUID = buildElement.getBoolean("default") != null && buildElement.getBoolean("default") != false ? this.defaultConfigurationUUID : UUID.valueOf((String)buildElement.getString("uuid"));
            BuildDefinitionElement build2 = this.buildDefinitionMap.get(buildUUID);
            if (build2 != null) {
                IMemento thisElement;
                IMemento[] elements;
                IMemento[] iMementoArray2 = elements = buildElement.getChildren("checkBuildMapForSourceOnly");
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    thisElement = iMementoArray2[n4];
                    boolean checkBuildMapForSourceOnly = thisElement.getBoolean("value");
                    build2.setCheckBuildMapForSourceOnly(checkBuildMapForSourceOnly);
                    ++n4;
                }
                iMementoArray2 = elements = buildElement.getChildren("ignoreBuildMapValidation");
                n3 = elements.length;
                n4 = 0;
                while (n4 < n3) {
                    thisElement = iMementoArray2[n4];
                    boolean ignoreBuildMapValidation = thisElement.getBoolean("value");
                    build2.setCheckIgnoreBuildMapValidaiton(ignoreBuildMapValidation);
                    ++n4;
                }
                build2.setDirty();
            }
            ++n2;
        }
    }

    protected String[] getBuildDefinitionTemplateIds() {
        return new String[]{"com.ibm.team.enterprise.promotion.zos", "com.ibm.team.enterprise.promotion.ibmi"};
    }

    private boolean isSavedBuildDefinition(BuildDefinitionElement buildDef) {
        IMemento[] buildElements;
        if (this.requireBuildMapCheckMemento == null) {
            return false;
        }
        IMemento[] iMementoArray = buildElements = this.requireBuildMapCheckMemento.getChildren("buildDefinition");
        int n = buildElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento buildElement = iMementoArray[n2];
            UUID buildUUID = buildElement.getBoolean("default") != null && buildElement.getBoolean("default") != false ? this.defaultConfigurationUUID : UUID.valueOf((String)buildElement.getString("uuid"));
            if (buildDef.isDefault() && this.defaultConfigurationUUID.getUuidValue().equals(buildUUID.getUuidValue())) {
                return true;
            }
            if (buildUUID.equals((Object)buildDef.getUUID())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void readBuildDefinitions() {
        final IProcessContainerWorkingCopy workingCopy = this.getAspect().getProcessContainerWorkingCopy();
        Job job = new Job(Messages.RetrieveBuildDefinitionJob_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PromotionRequireBuildMapCheckEditor.this.buildDefinitionMap = new HashMap();
                    if (workingCopy instanceof IProcessAreaWorkingCopy) {
                        IBuildDefinition[] buildDefinitions;
                        IProcessAreaWorkingCopy processArea = (IProcessAreaWorkingCopy)workingCopy;
                        IBuildDefinition[] iBuildDefinitionArray = buildDefinitions = AspectEditorUtil.getBuildDefinitions(PromotionRequireBuildMapCheckEditor.this.getBuildDefinitionTemplateIds(), processArea.getUnderlyingProcessArea().getProjectArea(), monitor);
                        int n = buildDefinitions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBuildDefinition buildDefinition = iBuildDefinitionArray[n2];
                            PromotionRequireBuildMapCheckEditor.this.buildDefinitionMap.put(buildDefinition.getItemId(), new BuildDefinitionElement(buildDefinition));
                            ++n2;
                        }
                    }
                    PromotionRequireBuildMapCheckEditor.this.defaultConfigurationUUID = UUID.generate();
                    PromotionRequireBuildMapCheckEditor.this.buildDefinitionMap.put(PromotionRequireBuildMapCheckEditor.this.defaultConfigurationUUID, new BuildDefinitionElement(null));
                    PromotionRequireBuildMapCheckEditor.this.readPreviousSavedStates();
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.process.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PromotionRequireBuildMapCheckEditor.this.buildDefinitionCombo != null && !PromotionRequireBuildMapCheckEditor.this.buildDefinitionCombo.isDisposed()) {
                            PromotionRequireBuildMapCheckEditor.this.fillBuildDefinitionCombo();
                            PromotionRequireBuildMapCheckEditor.this.buildDefinitionCombo.select(0);
                            PromotionRequireBuildMapCheckEditor.this.initializeCheckBoxesDisplay();
                        }
                    }
                });
            }
        });
    }

    public void restoreState(IMemento memento) {
        this.requireBuildMapCheckMemento = memento.getChild("requireBuildMapCheck");
    }

    private void fillBuildDefinitionCombo() {
        this.buildDefinitionCombo.removeAll();
        for (BuildDefinitionElement buildElement : this.buildDefinitionMap.values()) {
            if (buildElement.isDefault()) {
                this.buildDefinitionCombo.add(buildElement.getName(), 0);
                this.buildDefinitionCombo.setData(buildElement.getName(), (Object)this.defaultConfigurationUUID);
                continue;
            }
            this.buildDefinitionCombo.add(buildElement.getName());
            this.buildDefinitionCombo.setData(buildElement.getName(), (Object)buildElement.getUUID());
        }
    }

    public void updateOverrideBehavior() {
        BuildDefinitionElement selectedBuildDef = this.getCurrentEditBuild();
        boolean enabled = this.overrideDefaultCheckbox.getSelection();
        if (enabled) {
            this.checkBuildMapForSourceOnlyCheckBox.setEnabled(true);
            selectedBuildDef.setDirty();
        } else {
            this.checkBuildMapForSourceOnlyCheckBox.setSelection(false);
            this.checkIgnoreBuildMapValidationCheckBox.setSelection(false);
            this.checkBuildMapForSourceOnlyCheckBox.setEnabled(false);
            this.checkIgnoreBuildMapValidationCheckBox.setEnabled(false);
            selectedBuildDef.setCheckBuildMapForSourceOnly(false);
            selectedBuildDef.setCheckIgnoreBuildMapValidaiton(false);
            selectedBuildDef.setDirty(false);
        }
        this.setDirty();
    }

    public void updateCheckBuildMapBahavior() {
        BuildDefinitionElement selectedBuildDef = this.getCurrentEditBuild();
        boolean checked = this.checkBuildMapForSourceOnlyCheckBox.getSelection();
        selectedBuildDef.setCheckBuildMapForSourceOnly(checked);
        this.checkIgnoreBuildMapValidationCheckBox.setEnabled(checked);
        if (!checked) {
            this.checkIgnoreBuildMapValidationCheckBox.setSelection(false);
            selectedBuildDef.setCheckIgnoreBuildMapValidaiton(false);
        }
        selectedBuildDef.setDirty();
        this.setDirty();
    }

    public void updateIgnoreBuildMapValidationBahavior() {
        BuildDefinitionElement selectedBuildDef = this.getCurrentEditBuild();
        boolean checked = this.checkIgnoreBuildMapValidationCheckBox.getSelection();
        selectedBuildDef.setCheckIgnoreBuildMapValidaiton(checked);
        selectedBuildDef.setDirty();
        this.setDirty();
    }

    public void initializeCheckBoxesDisplay() {
        BuildDefinitionElement buildDef = this.getCurrentEditBuild();
        boolean checkBuildMapValidation = buildDef.isCheckBuildMapForSourceOnly();
        this.checkBuildMapForSourceOnlyCheckBox.setVisible(true);
        this.checkIgnoreBuildMapValidationCheckBox.setVisible(true);
        this.checkBuildMapForSourceOnlyCheckBox.setSelection(false);
        this.checkIgnoreBuildMapValidationCheckBox.setSelection(false);
        if (buildDef.isDefault()) {
            this.overrideDefaultCheckbox.setVisible(false);
            ((GridData)this.overrideDefaultCheckbox.getLayoutData()).exclude = true;
            boolean isSavedDef = this.isSavedBuildDefinition(buildDef);
            if (isSavedDef) {
                this.checkBuildMapForSourceOnlyCheckBox.setEnabled(true);
                this.checkBuildMapForSourceOnlyCheckBox.setSelection(checkBuildMapValidation);
                if (checkBuildMapValidation) {
                    boolean ignoreBuildMapValidation = buildDef.isCheckIgnoreBuildMapValidaiton();
                    this.checkIgnoreBuildMapValidationCheckBox.setEnabled(true);
                    this.checkIgnoreBuildMapValidationCheckBox.setSelection(ignoreBuildMapValidation);
                } else {
                    this.checkIgnoreBuildMapValidationCheckBox.setEnabled(false);
                }
            } else {
                this.checkBuildMapForSourceOnlyCheckBox.setEnabled(true);
                this.checkIgnoreBuildMapValidationCheckBox.setEnabled(false);
            }
        } else {
            this.overrideDefaultCheckbox.setVisible(true);
            ((GridData)this.overrideDefaultCheckbox.getLayoutData()).exclude = false;
            boolean isSavedDef = this.isSavedBuildDefinition(buildDef);
            if (isSavedDef) {
                this.overrideDefaultCheckbox.setSelection(true);
                this.checkBuildMapForSourceOnlyCheckBox.setEnabled(true);
                this.checkBuildMapForSourceOnlyCheckBox.setSelection(checkBuildMapValidation);
                if (checkBuildMapValidation) {
                    boolean ignoreBuildMapValidation = buildDef.isCheckIgnoreBuildMapValidaiton();
                    this.checkIgnoreBuildMapValidationCheckBox.setEnabled(true);
                    this.checkIgnoreBuildMapValidationCheckBox.setSelection(ignoreBuildMapValidation);
                } else {
                    this.checkIgnoreBuildMapValidationCheckBox.setEnabled(false);
                }
            } else {
                this.overrideDefaultCheckbox.setSelection(false);
                this.checkBuildMapForSourceOnlyCheckBox.setEnabled(false);
                this.checkIgnoreBuildMapValidationCheckBox.setEnabled(false);
            }
        }
        this.checkIgnoreBuildMapValidationCheckBox.getParent().layout();
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        Composite topComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(topComposite);
        toolkit.createLabel(topComposite, Messages.RequiredWorkItemStateEditor_PROMOTION_DEFINITION_LABEL);
        this.buildDefinitionCombo = new Combo(topComposite, 0x80000C);
        GridDataFactory.fillDefaults().grab(true, false).minSize(200, -1).applyTo((Control)this.buildDefinitionCombo);
        this.buildDefinitionCombo.add(Messages.RetrieveBuildDefinitionJob_PENDING_LABEL);
        this.buildDefinitionCombo.select(0);
        this.buildDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PromotionRequireBuildMapCheckEditor.this.initializeCheckBoxesDisplay();
            }
        });
        Composite bottomComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(bottomComposite);
        this.overrideDefaultCheckbox = toolkit.createButton(bottomComposite, Messages.PromotionRunTargetBuildEditor_OVERRIDE_DEFAULT_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.overrideDefaultCheckbox);
        this.overrideDefaultCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PromotionRequireBuildMapCheckEditor.this.updateOverrideBehavior();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.checkBuildMapForSourceOnlyCheckBox = toolkit.createButton(bottomComposite, Messages.PromotionRequireBuildMapCheckEditor_CHECK_BUILD_MAP_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.checkBuildMapForSourceOnlyCheckBox);
        this.checkBuildMapForSourceOnlyCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PromotionRequireBuildMapCheckEditor.this.updateCheckBuildMapBahavior();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.checkIgnoreBuildMapValidationCheckBox = toolkit.createButton(bottomComposite, Messages.PromotionRequireBuildMapCheckEditor_IGNORE_BUILD_MAP_VALIDATION_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.checkIgnoreBuildMapValidationCheckBox);
        this.checkIgnoreBuildMapValidationCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PromotionRequireBuildMapCheckEditor.this.updateIgnoreBuildMapValidationBahavior();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.overrideDefaultCheckbox.setVisible(false);
        this.checkIgnoreBuildMapValidationCheckBox.setVisible(false);
        this.checkBuildMapForSourceOnlyCheckBox.setVisible(false);
        this.readBuildDefinitions();
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.requireBuildMapCheckMemento = null;
    }

    public void dispose() {
    }
}

