/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.internal.process.ui.aspect.StreamSelectionDialog;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.enterprise.process.ui.ProcessUIActivator;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PreventDeliveryEditor
extends OperationDetailsAspectEditor {
    private org.eclipse.swt.widgets.List streamList;
    private Button addButton;
    private Button removeButton;
    private ITeamRepository repository;
    private IMemento previousStreamsElement;
    private List<IWorkspace> streams;

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.repository = (ITeamRepository)this.getProjectAreaHandle().getOrigin();
    }

    public boolean saveState(IMemento memento) {
        StringBuffer buffer = new StringBuffer();
        String[] streams = this.streamList.getItems();
        if (streams != null && streams.length > 0) {
            Iterator<String> streamIterator = Arrays.asList(streams).iterator();
            while (streamIterator.hasNext()) {
                buffer.append(this.streamList.getData(streamIterator.next()));
                if (!streamIterator.hasNext()) continue;
                buffer.append(',');
            }
        }
        IMemento streamsElement = memento.createChild("streams");
        streamsElement.putString("uuids", buffer.toString());
        return true;
    }

    public void restoreState(IMemento memento) {
        this.previousStreamsElement = memento.getChild("streams");
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        String previousValue;
        final Shell parentShell = parent.getShell();
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(parent);
        Label label = toolkit.createLabel(parent, Messages.PreventDeliveryEditor_STREAMS_LABEL);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        this.streamList = new org.eclipse.swt.widgets.List(parent, 2562);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData.heightHint = 30;
        gridData.widthHint = 100;
        this.streamList.setLayoutData((Object)gridData);
        if (this.previousStreamsElement != null && (previousValue = this.previousStreamsElement.getString("uuids")) != null) {
            String[] previousUuids;
            List<IWorkspace> streams = this.getAllStreams(this.repository, parent.getDisplay());
            String[] stringArray = previousUuids = previousValue.split(",");
            int n = previousUuids.length;
            int n2 = 0;
            while (n2 < n) {
                String previousUuid = stringArray[n2];
                IWorkspace stream = this.findStreamByUuid(streams, previousUuid);
                this.addStreamToUI(stream);
                ++n2;
            }
        }
        Composite buttonComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(buttonComposite);
        this.addButton = toolkit.createButton(buttonComposite, Messages.PreventDeliveryEditor_ADD_BTN_LABEL, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.addButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<IWorkspace> selectedStreams;
                List streams = PreventDeliveryEditor.this.getAllStreams(PreventDeliveryEditor.this.repository, parentShell.getDisplay());
                StreamSelectionDialog dlg = new StreamSelectionDialog(parentShell);
                dlg.setMultipleSelection(true);
                dlg.setElements(streams.toArray());
                if (dlg.open() == 0 && (selectedStreams = dlg.getSelectedStreams()) != null && selectedStreams.size() > 0) {
                    boolean dirty = false;
                    for (IWorkspace selectedStream : selectedStreams) {
                        if (!PreventDeliveryEditor.this.addStreamToUI(selectedStream)) continue;
                        dirty = true;
                    }
                    if (dirty) {
                        PreventDeliveryEditor.this.setDirty();
                    }
                }
            }
        });
        this.removeButton = toolkit.createButton(buttonComposite, Messages.PreventDeliveryEditor_REMOVE_BTN_LABEL, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] selectedStreams = PreventDeliveryEditor.this.streamList.getSelection();
                if (selectedStreams != null && selectedStreams.length > 0) {
                    String[] stringArray = selectedStreams;
                    int n = selectedStreams.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String selectedStream = stringArray[n2];
                        PreventDeliveryEditor.this.removeStreamFromUI(selectedStream);
                        ++n2;
                    }
                    PreventDeliveryEditor.this.setDirty();
                }
            }
        });
    }

    public void dispose() {
    }

    private IProjectAreaHandle getProjectAreaHandle() {
        return ((IProcessAreaWorkingCopy)this.getAspect().getProcessContainerWorkingCopy()).getUnderlyingProcessArea().getProjectArea();
    }

    private List<IWorkspace> getAllStreams(final ITeamRepository teamRepository, Display display) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
                    IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository);
                    List streamHandles = workspaceManager.findWorkspaces(criteria, Integer.MAX_VALUE, null);
                    PreventDeliveryEditor.this.streams.addAll(teamRepository.itemManager().fetchCompleteItems(streamHandles, 0, null));
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        if (this.streams == null) {
            this.streams = new ArrayList<IWorkspace>();
            try {
                try {
                    if (display == null) {
                        display = Display.getCurrent();
                    }
                    display.getActiveShell().setCursor(Display.getCurrent().getSystemCursor(1));
                    ModalContext.run((IRunnableWithProgress)operation, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)Display.getCurrent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String errorMessage = NLS.bind((String)Messages.PreventDeliveryEditor_ERROR_RETRIEVE_STREAMS, (Object)e.getMessage());
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.PreventDeliveryEditor_ERROR_DIALOG_TITLE, (String)errorMessage);
                    ProcessUIActivator.logError(errorMessage, e);
                    display.getActiveShell().setCursor(null);
                }
            }
            finally {
                display.getActiveShell().setCursor(null);
            }
        }
        return this.streams;
    }

    private boolean addStreamToUI(IWorkspace stream) {
        if (stream == null) {
            return false;
        }
        String streamUuid = stream.getItemId().getUuidValue();
        int i = 0;
        while (i < this.streamList.getItemCount()) {
            String value = (String)this.streamList.getData(this.streamList.getItem(i));
            if (value.equals(streamUuid)) {
                return true;
            }
            ++i;
        }
        this.streamList.add(stream.getName());
        this.streamList.setData(stream.getName(), (Object)streamUuid);
        return true;
    }

    private void removeStreamFromUI(String stream) {
        this.streamList.remove(stream);
        this.streamList.setData(stream, null);
    }

    private IWorkspace findStreamByUuid(List<IWorkspace> streams, String uuid) {
        for (IWorkspace stream : streams) {
            if (!stream.getItemId().getUuidValue().equals(uuid)) continue;
            return stream;
        }
        return null;
    }
}

