/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.common.common.process.IStateContainerElement;
import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.enterprise.internal.common.common.process.TypeElement;
import com.ibm.team.enterprise.internal.process.ui.aspect.AspectEditorUtil;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class ModeledElementLabelProvider
extends CellLabelProvider {
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final ProcessAspect processAspect;

    public ModeledElementLabelProvider(ProcessAspect processAspect) {
        this.processAspect = processAspect;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (cell.getColumnIndex() == 0 && element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            cell.setText(typeElement.getName());
            if (typeElement.getIcon() != null) {
                cell.setImage(this.getImage(element, typeElement.getIcon()));
            } else {
                cell.setImage(null);
            }
            if (typeElement.hasStates()) {
                cell.setForeground(null);
            } else {
                cell.setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
            }
        } else if (cell.getColumnIndex() == 0 && element instanceof CategoryElement) {
            CategoryElement categoryElement = (CategoryElement)element;
            cell.setText(categoryElement.getIdentifier());
            cell.setImage(JazzResources.getImage((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.TYPE_CATEGORY, null));
            if (categoryElement.hasStates()) {
                cell.setForeground(null);
            } else {
                cell.setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
            }
        } else if (cell.getColumnIndex() == 1 && element instanceof IStateContainerElement) {
            IStateContainerElement stateContainerElement = (IStateContainerElement)element;
            cell.setText(stateContainerElement.getStatesAsString());
            if (stateContainerElement.hasStates()) {
                cell.setForeground(null);
            } else {
                cell.setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
            }
        }
    }

    private Image getImage(final Object element, String iconPath) {
        return AspectEditorUtil.getImage(this.processAspect.getProcessContainerWorkingCopy(), iconPath, this.fResourceManager, new Runnable(){

            @Override
            public void run() {
                ModeledElementLabelProvider.this.fireChanged(element);
            }
        });
    }

    private void fireChanged(Object element) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }
}

