/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LangDefinitionCheckEditor
extends OperationDetailsAspectEditor {
    private IMemento requireLangDefCheckMemento;
    private List fileExtensionList;
    private Button buttonAdd;
    private Button buttonDel;
    private final String COMA = ",";
    private final String EMPTY = "";
    private final String TAG_LANG_DEF_CHECK = "requireLangDefCheck";
    private final String TAG_FILE_EXTENSIONS = "fileExtensions";
    private final String REX_VALID_FILE_EXTENSION = "^(([a-zA-Z])*([0-9])*)+";

    private void loadSettings() {
        String[] fileExtensions;
        String fileExtensionStr;
        IMemento fileExtensionsElement;
        if (this.requireLangDefCheckMemento != null && (fileExtensionsElement = this.requireLangDefCheckMemento.getChild("fileExtensions")) != null && (fileExtensionStr = fileExtensionsElement.getString("value")) != null && (fileExtensions = fileExtensionStr.split(",")) != null) {
            int i = 0;
            while (i < fileExtensions.length) {
                this.fileExtensionList.add(fileExtensions[i]);
                ++i;
            }
        }
        this.fileExtensionList.getParent().layout();
    }

    public boolean saveState(IMemento memento) {
        IMemento requireLangDefCheckElement = memento.createChild("requireLangDefCheck");
        IMemento fileExtensionsElement = requireLangDefCheckElement.createChild("fileExtensions");
        this.fileExtensionList.getItems();
        StringBuilder extensions = new StringBuilder();
        int i = 0;
        while (i < this.fileExtensionList.getItemCount()) {
            if (i != 0) {
                extensions.append(",");
            }
            extensions.append(this.fileExtensionList.getItem(i));
            ++i;
        }
        fileExtensionsElement.putString("value", extensions.toString());
        this.restoreState(memento);
        return true;
    }

    public void restoreState(IMemento memento) {
        this.requireLangDefCheckMemento = memento.getChild("requireLangDefCheck");
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        Composite outerComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).applyTo(outerComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outerComposite);
        Label descrption = toolkit.createLabel(outerComposite, Messages.LangDefinitionCheckEditor_FILE_EXTENSIONS, 64);
        descrption.pack();
        GridDataFactory.fillDefaults().grab(true, false).hint(35, -1).applyTo((Control)descrption);
        descrption.setFont(this.getBoldFont());
        this.fileExtensionList = new List(outerComposite, 2560);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 80).applyTo((Control)this.fileExtensionList);
        Composite innnerComposite = toolkit.createComposite(outerComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(innnerComposite);
        GridDataFactory.fillDefaults().grab(false, true).align(4, 1).applyTo((Control)innnerComposite);
        this.buttonAdd = toolkit.createButton(innnerComposite, Messages.RequireSubsetAspectEditor_10, 8);
        this.buttonDel = toolkit.createButton(innnerComposite, Messages.RequireSubsetAspectEditor_11, 8);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.buttonAdd);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.buttonDel);
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDlg = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.LangDefinitionCheckEditor_INPUT_DIALOG_TITLE, Messages.LangDefinitionCheckEditor_INPUT_DIALOG_DESCRIPTION, "", new IInputValidator(){

                    public String isValid(String extName) {
                        Pattern pattern = Pattern.compile("^(([a-zA-Z])*([0-9])*)+");
                        Matcher match = pattern.matcher(extName);
                        if (!"".equals(extName) && match.matches()) {
                            if (LangDefinitionCheckEditor.this.isDuplicateExtension(extName)) {
                                return Messages.LangDefinitionCheckEditor_INPUT_DIALOG_DUPLCATE_EXTENSION;
                            }
                            return null;
                        }
                        return Messages.LangDefinitionCheckEditor_INPUT_DIALOG_INVALID_EXTENSION;
                    }
                });
                if (inputDlg.open() == 0) {
                    LangDefinitionCheckEditor.this.fileExtensionList.add(inputDlg.getValue());
                    LangDefinitionCheckEditor.this.setDirty();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttonDel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (-1 != LangDefinitionCheckEditor.this.fileExtensionList.getSelectionIndex()) {
                    LangDefinitionCheckEditor.this.fileExtensionList.remove(LangDefinitionCheckEditor.this.fileExtensionList.getSelectionIndex());
                    LangDefinitionCheckEditor.this.setDirty();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.loadSettings();
    }

    private boolean isDuplicateExtension(String extName) {
        int i = 0;
        while (i < this.fileExtensionList.getItemCount()) {
            if (this.fileExtensionList.getItem(i).equals(extName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
    }
}

