/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.enterprise.internal.common.common.process.StateElement;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class EditWorkItemStatesDialog
extends SelectionStatusDialog {
    private boolean hasMadeSelection = false;
    private CheckboxTableViewer viewer;
    private final CategoryElement category;
    private final StateElement[] disabledStates;
    private final StateElement[] selectedStates;

    public EditWorkItemStatesDialog(Shell parent, CategoryElement category, String title, StateElement[] disableStates, StateElement[] selectedStates) {
        super(parent);
        this.category = category;
        this.setTitle(title);
        this.disabledStates = disableStates;
        this.selectedStates = selectedStates;
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().spacing(-1, 10).margins(10, 10).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.EditWorkItemStateDialog_DESCRIPTION);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        GridDataFactory.fillDefaults().grab(true, true).minSize(300, 250).applyTo((Control)this.viewer.getTable());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                if (element != null && element instanceof CategoryElement) {
                    return ((CategoryElement)element).getAvailableStates().toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object oldObject, Object newObject) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof StateElement) {
                    return ((StateElement)element).getName();
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }
        });
        this.viewer.setInput((Object)this.category);
        this.grayOutDisabledStates();
        this.viewer.setCheckedElements((Object[])this.selectedStates);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object object = event.getElement();
                if (EditWorkItemStatesDialog.this.viewer.getGrayed(object)) {
                    EditWorkItemStatesDialog.this.viewer.setChecked(object, false);
                }
                EditWorkItemStatesDialog.this.hasMadeSelection = true;
                EditWorkItemStatesDialog.this.validateSelection();
            }
        });
        this.validateSelection();
        return composite;
    }

    protected void validateSelection() {
        if (this.viewer.getCheckedElements().length == 0) {
            this.updateStatus((IStatus)new Status(4, "com.ibm.team.enterprise.process.ui", Messages.RequiredWorkItemsStateEditor_NO_STATE_SELECTION_ERROR));
        } else {
            this.updateStatus((IStatus)new Status(0, "com.ibm.team.enterprise.process.ui", ""));
        }
    }

    protected void updateStatus(IStatus status) {
        if (!this.hasMadeSelection && status != null) {
            Status newStatus = new Status(0, status.getPlugin(), status.getCode(), "", status.getException());
            super.updateStatus((IStatus)newStatus);
        } else {
            super.updateStatus(status);
        }
    }

    protected void grayOutDisabledStates() {
        int count = this.viewer.getTable().getItemCount();
        int i = 0;
        while (i < count) {
            StateElement next = (StateElement)this.viewer.getElementAt(i);
            StateElement[] stateElementArray = this.disabledStates;
            int n = this.disabledStates.length;
            int n2 = 0;
            while (n2 < n) {
                StateElement state = stateElementArray[n2];
                if (next.getIdentifier().equals(state.getIdentifier())) {
                    this.viewer.setGrayed((Object)next, true);
                    this.viewer.getTable().getItem(i).setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
                }
                ++n2;
            }
            ++i;
        }
    }

    protected void okPressed() {
        this.setSelectionResult(this.viewer.getCheckedElements());
        super.okPressed();
    }
}

