/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.enterprise.internal.common.common.process.StateElement;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class EditWorkItemStateDialog
extends SelectionStatusDialog {
    private boolean hasMadeSelection = false;
    private List stateList;
    private CategoryElement category;
    private StateElement selectedState;

    public EditWorkItemStateDialog(Shell parent, CategoryElement category, String title, StateElement selectedState) {
        super(parent);
        this.category = category;
        this.setTitle(title);
        this.selectedState = selectedState;
    }

    protected void computeResult() {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().spacing(-1, 10).margins(10, 10).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.EditWorkItemStateDialog_DESCRIPTION_2);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.stateList = new List(composite, 2052);
        GridDataFactory.fillDefaults().grab(true, true).minSize(300, 250).applyTo((Control)this.stateList);
        if (this.category != null) {
            for (StateElement stateElement : this.category.getAvailableStates()) {
                this.stateList.add(stateElement.getName());
                this.stateList.setData(stateElement.getName(), (Object)stateElement);
            }
        }
        if (this.selectedState != null) {
            this.stateList.setSelection(new String[]{this.selectedState.getName()});
        }
        this.validateSelection();
        return composite;
    }

    protected void validateSelection() {
        if (this.stateList.getSelection().length == 0) {
            this.updateStatus((IStatus)new Status(4, "com.ibm.team.enterprise.process.ui", Messages.RequiredWorkItemsStateEditor_NO_STATE_SELECTION_ERROR));
        } else {
            this.updateStatus((IStatus)new Status(0, "com.ibm.team.enterprise.process.ui", ""));
        }
    }

    protected void updateStatus(IStatus status) {
        if (!this.hasMadeSelection && status != null) {
            Status newStatus = new Status(0, status.getPlugin(), status.getCode(), "", status.getException());
            super.updateStatus((IStatus)newStatus);
        } else {
            super.updateStatus(status);
        }
    }

    protected void okPressed() {
        String[] selection = this.stateList.getSelection();
        Object[] states = selection.length > 0 ? new StateElement[]{(StateElement)this.stateList.getData(selection[0])} : new StateElement[]{};
        this.setSelectionResult(states);
        super.okPressed();
    }
}

