/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildSubsetAspectEditor
extends ProcessAspectEditor {
    private Combo visibilityCombo;
    private Button requestTeamBuild;
    private SubsetSettings settings;

    protected boolean saveState(IMemento memento) {
        memento.putString("id", "com.ibm.team.enterprise.process.configuration.build.subsets");
        String namespace = this.getAspect().getSchemaNamespaceURI();
        if (namespace != null) {
            memento.putString("xmlns", namespace);
        }
        IMemento newSubsetsMemento = memento.createChild("newSubsets");
        newSubsetsMemento.putString("visibility", this.settings.visibility);
        IMemento requestBuildTypeMemento = memento.createChild("requestBuildType");
        requestBuildTypeMemento.putString("teamBuild", String.valueOf(this.settings.teamBuild));
        return true;
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.init();
    }

    private void init() {
        this.settings = new SubsetSettings();
        ModelElement root = this.getAspect().getConfigurationElement();
        if (root != null) {
            for (ModelElement element : root.getChildElements()) {
                if ("newSubsets".equals(element.getName())) {
                    this.settings.visibility = element.getAttribute("visibility");
                    continue;
                }
                if (!"requestBuildType".equals(element.getName())) continue;
                this.settings.teamBuild = Boolean.parseBoolean(element.getAttribute("teamBuild"));
            }
        }
    }

    private void updateWidgets() {
        this.updateVisibilityCombo();
        this.updateRequestBuildType();
    }

    private void updateVisibilityCombo() {
        if (this.settings != null && this.visibilityCombo != null && !this.visibilityCombo.isDisposed()) {
            this.visibilityCombo.select("private".equals(this.settings.visibility) ? 1 : 0);
        }
    }

    private void updateRequestBuildType() {
        if (this.settings != null && this.requestTeamBuild != null && !this.requestTeamBuild.isDisposed()) {
            this.requestTeamBuild.setSelection(this.settings.teamBuild);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        this.createVisibilityCombo(parent, toolkit);
        this.createRequestTeamBuildButton(parent, toolkit);
        this.updateWidgets();
    }

    private void createVisibilityCombo(Composite parent, FormToolkit toolkit) {
        Label typeLabel = toolkit.createLabel(parent, Messages.BuildSubsetAspectEditor_VISIBILITY_COMBO_LABEL);
        GridDataFactory.swtDefaults().applyTo((Control)typeLabel);
        this.visibilityCombo = new Combo(parent, 8);
        toolkit.adapt((Control)this.visibilityCombo, true, false);
        this.visibilityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((BuildSubsetAspectEditor)BuildSubsetAspectEditor.this).settings.visibility = BuildSubsetAspectEditor.this.visibilityCombo.getSelectionIndex() == 1 ? "private" : "scoped";
                BuildSubsetAspectEditor.this.setDirty(true);
            }
        });
        this.visibilityCombo.setItems(new String[]{Messages.BuildSubsetAspectEditor_VISIBILITY_SCOPED, Messages.BuildSubsetAspectEditor_VISIBILITY_PRIVATE});
    }

    private void createRequestTeamBuildButton(Composite parent, FormToolkit toolkit) {
        this.requestTeamBuild = toolkit.createButton(parent, Messages.BuildSubsetAspectEditor_REQUEST_TEAM_BUILD_LABEL, 32);
        this.requestTeamBuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((BuildSubsetAspectEditor)BuildSubsetAspectEditor.this).settings.teamBuild = BuildSubsetAspectEditor.this.requestTeamBuild.getSelection();
                BuildSubsetAspectEditor.this.setDirty(true);
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.requestTeamBuild);
    }

    public void revert() {
        this.init();
        this.updateWidgets();
        this.setDirty(false);
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    public void dispose() {
        if (this.visibilityCombo != null) {
            this.visibilityCombo.dispose();
        }
        if (this.requestTeamBuild != null) {
            this.requestTeamBuild.dispose();
        }
    }

    private class SubsetSettings {
        String visibility = "scoped";
        boolean teamBuild;

        private SubsetSettings() {
        }
    }
}

