/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.enterprise.internal.common.common.process.StateElement;
import com.ibm.team.enterprise.internal.common.common.process.TypeElement;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.client.internal.util.RemoteImages;
import com.ibm.team.workitem.common.internal.ResourceLocation;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IconResolver;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class AspectEditorUtil {
    public static final String WORKFLOWS_CONFIGURATION_POINT = "com.ibm.team.workitem.configuration.workflow";

    public static String getTypeCategoryDisplayName(CategoryElement category) {
        if (category == null || category.getTypes() == null || category.getTypes().isEmpty()) {
            return null;
        }
        Iterator iter = category.getTypes().iterator();
        String list = ((TypeElement)iter.next()).getName();
        while (iter.hasNext()) {
            list = NLS.bind((String)Messages.AspectEditorUtil_LIST_OF_TYPES, (Object)list, (Object)((TypeElement)iter.next()).getName());
        }
        return NLS.bind((String)Messages.AspectEditorUtil_CATEGORYID_LIST, (Object)list, (Object)category.getIdentifier());
    }

    public static List<CategoryElement> readTypeCategories(ModelElement workItemTypesElement, Map<String, String> workFlowBindings, ModelElement workFlowElement) {
        ArrayList<CategoryElement> typeCategories = new ArrayList<CategoryElement>();
        if (workItemTypesElement != null) {
            for (ModelElement element : workItemTypesElement.getChildElements()) {
                if (!"type".equals(element.getName())) continue;
                AspectEditorUtil.readType(element, typeCategories);
            }
        }
        for (CategoryElement cat : typeCategories) {
            String workFlowId = workFlowBindings.get(cat.getIdentifier());
            if (workFlowId == null) continue;
            cat.addAllAvailableStates(AspectEditorUtil.readAllStates(workFlowElement, workFlowId));
        }
        return typeCategories;
    }

    public static List<TypeElement> readTypeElements(ModelElement workItemTypesElement) {
        ArrayList<CategoryElement> typeCategories = new ArrayList<CategoryElement>();
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        if (workItemTypesElement != null) {
            for (ModelElement element : workItemTypesElement.getChildElements()) {
                if (!"type".equals(element.getName())) continue;
                typeElements.add(AspectEditorUtil.readType(element, typeCategories));
            }
        }
        return typeElements;
    }

    private static TypeElement readType(ModelElement element, List<CategoryElement> categories) {
        String cat = element.getAttribute("category");
        CategoryElement category = null;
        for (CategoryElement tc : categories) {
            if (!tc.getIdentifier().equals(cat)) continue;
            category = tc;
            break;
        }
        if (category == null) {
            category = new CategoryElement(cat);
            categories.add(category);
        }
        TypeElement type = AspectEditorUtil.readTypeElement(element, category);
        category.addType(type);
        return type;
    }

    private static TypeElement readTypeElement(ModelElement typeElement, CategoryElement category) {
        String dimmedIcon;
        String id = typeElement.getAttribute("id");
        String name = typeElement.getAttribute("name");
        String icon = typeElement.getAttribute("icon");
        if ("".equals(icon)) {
            icon = null;
        }
        if ("".equals(dimmedIcon = typeElement.getAttribute("dimmedicon"))) {
            dimmedIcon = null;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        if (typeElement.getChildElements() != null) {
            for (ModelElement e : typeElement.getChildElements()) {
                String alName;
                if (!"alias".equals(e.getName()) || (alName = e.getAttribute("name")) == null) continue;
                aliases.add(alName);
            }
        }
        return new TypeElement(category, id, name, icon, dimmedIcon, aliases);
    }

    public static Map<String, String> getWorkFlowBindings(ModelElement configurationElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (configurationElement != null) {
            for (ModelElement element : configurationElement.getChildElements()) {
                String workFlowId;
                String categoryId;
                if (!"workItemCategoryBinding".equals(element.getName()) || (categoryId = element.getAttribute("workItemCategoryId")) == null || (workFlowId = element.getAttribute("workflowId")) == null) continue;
                map.put(categoryId, workFlowId);
            }
        }
        return map;
    }

    private static StateElement readState(ModelElement stateElement) {
        String id = stateElement.getAttribute("id");
        String name = stateElement.getAttribute("name");
        String group = stateElement.getAttribute("group");
        String icon = stateElement.getAttribute("icon");
        if ("".equals(icon)) {
            icon = null;
        }
        return new StateElement(id, name, group, icon);
    }

    private static List<StateElement> readAllStates(ModelElement configurationElement, String workFlowId) {
        ArrayList<StateElement> states = new ArrayList<StateElement>();
        for (ModelElement workFlowDefinitionElement : configurationElement.getChildElements()) {
            if (!"workflowDefinition".equals(workFlowDefinitionElement.getName()) || !workFlowId.equals(workFlowDefinitionElement.getAttribute("id"))) continue;
            for (ModelElement workFlowElement : workFlowDefinitionElement.getChildElements()) {
                for (ModelElement childElement : workFlowElement.getChildElements()) {
                    if (!"state".equals(childElement.getName())) continue;
                    states.add(AspectEditorUtil.readState(childElement));
                }
            }
            return states;
        }
        return states;
    }

    public static Image getImage(IProcessContainerWorkingCopy workingCopy, String iconUrl, ResourceManager resourceManager, Runnable handler) {
        ImageDescriptor image = AspectEditorUtil.getImageDescriptor(workingCopy, iconUrl, handler);
        if (image == null) {
            return null;
        }
        return JazzResources.getImage((ResourceManager)resourceManager, (ImageDescriptor)image, null);
    }

    private static ImageDescriptor getImageDescriptor(IProcessContainerWorkingCopy workingCopy, String iconUrl, Runnable handler) {
        if (iconUrl.startsWith("processattachment")) {
            IProcessAttachmentHandle[] iProcessAttachmentHandleArray = workingCopy.getProcessAttachments().getAttachments();
            int n = iProcessAttachmentHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessAttachmentHandle handle = iProcessAttachmentHandleArray[n2];
                if (AspectEditorUtil.extractPath(iconUrl).equals(workingCopy.getProcessAttachments().getPath(handle))) {
                    File localFile = workingCopy.getProcessAttachments().getLocalFile(handle);
                    if (localFile == null) break;
                    return ImageDescriptor.createFromFile(null, (String)localFile.getAbsolutePath());
                }
                ++n2;
            }
        }
        try {
            ITeamRepository repository = (ITeamRepository)workingCopy.getUnderlyingProcessItem().getOrigin();
            URL url = ResourceLocation.getResourceURL((IProcessContainerHandle)((IProcessContainerHandle)workingCopy.getUnderlyingProcessItem()), (URI)new URI(iconUrl), (String)repository.getRepositoryURI());
            if (ResourceLocation.isImageContentServiceURL((URL)url)) {
                URL cached = RemoteImages.getCachedImageContentServiceURL((URI)url.toURI());
                if (cached == null) {
                    new IconResolver(repository, url, handler).schedule();
                    return ImagePool.EMPTY_ICON;
                }
                return WorkItemUI.getImageDescriptor((URL)cached);
            }
            return WorkItemUI.getImageDescriptor((URL)url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String extractPath(String relativeIconUrl) {
        int index = relativeIconUrl.indexOf("://") + 2;
        if (index == 1) {
            index = relativeIconUrl.indexOf(":/") + 1;
        }
        if (index > 0) {
            return relativeIconUrl.substring(index);
        }
        return relativeIconUrl;
    }

    public static IBuildDefinition[] getBuildDefinitions(String[] templateIds, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        IQueryService queryService = ((TeamRepository)repository).getQueryService();
        IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel buildDefinitionQueryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildDefinitionQueryModel);
        List processAreaHandles = ConnectedProjectAreaRegistry.getDefault().getSelectedProcessAreas(projectAreaHandle, false);
        processAreaHandles.add(projectAreaHandle);
        IItemHandleInputArg[] itemHandleArgs = new IItemHandleInputArg[processAreaHandles.size()];
        int i = 0;
        while (i < processAreaHandles.size()) {
            itemHandleArgs[i] = query.newItemHandleArg();
            ++i;
        }
        IPredicate filter = ((BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)buildDefinitionQueryModel).processArea()._in(itemHandleArgs);
        query.filter(filter);
        IItemQueryPage queryPage = queryService.queryItems(query, processAreaHandles.toArray(), Integer.MAX_VALUE);
        IItemHandle[] itemHandles = queryPage.handlesAsArray();
        List buildDefinitions = repository.itemManager().fetchCompleteItems(Arrays.asList(itemHandles), 0, monitor);
        ArrayList<IBuildDefinition> foundBuildDefinitions = new ArrayList<IBuildDefinition>();
        block1: for (IBuildDefinition buildDefinition : buildDefinitions) {
            String id = buildDefinition.getPropertyValue("com.ibm.team.build.internal.template.id", "");
            String[] stringArray = templateIds;
            int n = templateIds.length;
            int n2 = 0;
            while (n2 < n) {
                String templateId = stringArray[n2];
                if (id.equals(templateId)) {
                    foundBuildDefinitions.add(buildDefinition);
                    continue block1;
                }
                ++n2;
            }
        }
        return foundBuildDefinitions.toArray(new IBuildDefinition[foundBuildDefinitions.size()]);
    }
}

