/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.internal.common.common.process.AbstractModeledElement;
import com.ibm.team.enterprise.internal.common.common.process.BuildDefinitionElement;
import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.enterprise.internal.common.common.process.StateElement;
import com.ibm.team.enterprise.internal.common.common.process.TypeElement;
import com.ibm.team.enterprise.internal.process.ui.aspect.AspectEditorUtil;
import com.ibm.team.enterprise.internal.process.ui.aspect.EditWorkItemStatesDialog;
import com.ibm.team.enterprise.internal.process.ui.aspect.ModeledElementContentProvider;
import com.ibm.team.enterprise.internal.process.ui.aspect.ModeledElementLabelProvider;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractRequiredWorkItemStateEditor
extends OperationDetailsAspectEditor {
    private List<CategoryElement> configurationCategories;
    private TreeViewer statesViewer;
    private Combo buildDefinitionCombo;
    private UUID defaultConfigurationUUID;
    private Map<UUID, BuildDefinitionElement> buildDefinitionMap;
    private ModeledElementLabelProvider labelProvider;
    private IMemento requireWorkItemStatesMemento;
    private boolean arePreviousStatesDirty;

    protected abstract String[] getBuildDefinitionTemplateIds();

    protected abstract void setConfigurationDefinitionLabel(Composite var1, FormToolkit var2);

    public void restoreState(IMemento memento) {
        this.requireWorkItemStatesMemento = memento.getChild("requireWorkItemStates");
    }

    private void readPreviousSavedStates() {
        IMemento[] buildElements;
        if (this.requireWorkItemStatesMemento == null) {
            return;
        }
        IMemento[] iMementoArray = buildElements = this.requireWorkItemStatesMemento.getChildren("buildDefinition");
        int n = buildElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento buildElement = iMementoArray[n2];
            UUID buildUUID = buildElement.getBoolean("default") != null && buildElement.getBoolean("default") != false ? this.defaultConfigurationUUID : UUID.valueOf((String)buildElement.getString("uuid"));
            BuildDefinitionElement build = this.buildDefinitionMap.get(buildUUID);
            if (build != null) {
                IMemento[] categoryElements;
                IMemento[] iMementoArray2 = categoryElements = buildElement.getChildren("category");
                int n3 = categoryElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento categoryElement = iMementoArray2[n4];
                    CategoryElement category = build.getCategory(categoryElement.getID());
                    if (category != null) {
                        IMemento[] stateElements;
                        IMemento[] typeElements;
                        IMemento[] iMementoArray3 = typeElements = categoryElement.getChildren("type");
                        int n5 = typeElements.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IMemento typeElement = iMementoArray3[n6];
                            TypeElement type = category.getType(typeElement.getID());
                            if (type != null) {
                                IMemento[] stateElements2;
                                IMemento[] iMementoArray4 = stateElements2 = typeElement.getChildren("state");
                                int n7 = stateElements2.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IMemento stateElement = iMementoArray4[n8];
                                    StateElement state = category.getAvailableState(stateElement.getID());
                                    if (state != null) {
                                        type.addState(state);
                                    } else if (!this.arePreviousStatesDirty) {
                                        this.arePreviousStatesDirty = true;
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                        IMemento[] iMementoArray5 = stateElements = categoryElement.getChildren("state");
                        int n9 = stateElements.length;
                        n5 = 0;
                        while (n5 < n9) {
                            IMemento stateElement = iMementoArray5[n5];
                            StateElement state = category.getAvailableState(stateElement.getID());
                            if (state != null) {
                                category.addState(state);
                            } else if (!this.arePreviousStatesDirty) {
                                this.arePreviousStatesDirty = true;
                            }
                            ++n5;
                        }
                    }
                    ++n4;
                }
                build.setDirty();
            }
            ++n2;
        }
    }

    public boolean saveState(IMemento memento) {
        IMemento requireWorkItemStatesElement = memento.createChild("requireWorkItemStates");
        for (BuildDefinitionElement build : this.buildDefinitionMap.values()) {
            if (!build.isDirty()) continue;
            IMemento buildElement = requireWorkItemStatesElement.createChild("buildDefinition");
            if (build.isDefault()) {
                buildElement.putBoolean("default", true);
            } else {
                buildElement.putString("uuid", build.getUUID().getUuidValue());
            }
            for (CategoryElement category : build.getCategories()) {
                IMemento categoryElement = null;
                for (TypeElement type : category.getTypes()) {
                    if (!type.hasStates()) continue;
                    if (categoryElement == null) {
                        categoryElement = buildElement.createChild("category", category.getIdentifier());
                    }
                    IMemento typeElement = categoryElement.createChild("type", type.getIdentifier());
                    for (StateElement state : type.getStates()) {
                        IMemento stateElement = typeElement.createChild("state", state.getIdentifier());
                        stateElement.putString("label", state.getName());
                    }
                }
                for (StateElement state : category.getStates()) {
                    if (categoryElement == null) {
                        categoryElement = buildElement.createChild("category", category.getIdentifier());
                    }
                    IMemento stateElement = categoryElement.createChild("state", state.getIdentifier());
                    stateElement.putString("label", state.getName());
                }
            }
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        Composite topComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(topComposite);
        this.setConfigurationDefinitionLabel(topComposite, toolkit);
        this.buildDefinitionCombo = new Combo(topComposite, 0x80000C);
        GridDataFactory.fillDefaults().grab(true, false).minSize(200, -1).applyTo((Control)this.buildDefinitionCombo);
        this.buildDefinitionCombo.add(Messages.RetrieveBuildDefinitionJob_PENDING_LABEL);
        this.buildDefinitionCombo.select(0);
        this.buildDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AbstractRequiredWorkItemStateEditor.this.statesViewer != null) {
                    AbstractRequiredWorkItemStateEditor.this.statesViewer.setInput((Object)AbstractRequiredWorkItemStateEditor.this.getCurrentEditBuild().getCategories());
                    AbstractRequiredWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        this.readBuildDefinitions();
        Composite bottomComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(bottomComposite);
        Tree tree = new Tree(bottomComposite, 67586);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 180).applyTo((Control)tree);
        tree.setHeaderVisible(true);
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(250);
        treeColumn.setResizable(true);
        treeColumn.setText(Messages.RequiredWorkItemStateEditor_CATEGORY_OR_TYPE_LABEL);
        treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(250);
        treeColumn.setResizable(true);
        treeColumn.setText(Messages.RequiredWorkItemStateEditor_STATES_LABEL);
        this.statesViewer = new TreeViewer(tree);
        this.labelProvider = new ModeledElementLabelProvider(this.getAspect());
        this.statesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.statesViewer.setContentProvider((IContentProvider)new ModeledElementContentProvider());
        this.statesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractRequiredWorkItemStateEditor.this.editState((IStructuredSelection)AbstractRequiredWorkItemStateEditor.this.statesViewer.getSelection());
                AbstractRequiredWorkItemStateEditor.this.getCurrentEditBuild().setDirty();
                AbstractRequiredWorkItemStateEditor.this.setDirty();
                if (AbstractRequiredWorkItemStateEditor.this.statesViewer != null) {
                    AbstractRequiredWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        Composite bottomRightComposite = toolkit.createComposite(bottomComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(bottomRightComposite);
        GridDataFactory.fillDefaults().grab(false, true).indent(-1, this.statesViewer.getTree().getHeaderHeight()).applyTo((Control)bottomRightComposite);
        final Button editButton = toolkit.createButton(bottomRightComposite, Messages.RequiredWorkItemStateEditor_EDIT, 0x800000);
        editButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRequiredWorkItemStateEditor.this.editState((IStructuredSelection)AbstractRequiredWorkItemStateEditor.this.statesViewer.getSelection());
                AbstractRequiredWorkItemStateEditor.this.getCurrentEditBuild().setDirty();
                AbstractRequiredWorkItemStateEditor.this.setDirty();
                if (AbstractRequiredWorkItemStateEditor.this.statesViewer != null) {
                    AbstractRequiredWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        final Button clearButton = toolkit.createButton(bottomRightComposite, Messages.ModifyWorkItemStateEditor_CLEAR, 0x800000);
        clearButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        clearButton.setEnabled(false);
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRequiredWorkItemStateEditor.this.clearStates((IStructuredSelection)AbstractRequiredWorkItemStateEditor.this.statesViewer.getSelection());
                AbstractRequiredWorkItemStateEditor.this.getCurrentEditBuild().setDirty();
                AbstractRequiredWorkItemStateEditor.this.setDirty();
                if (AbstractRequiredWorkItemStateEditor.this.statesViewer != null) {
                    AbstractRequiredWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        this.statesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!editButton.isDisposed()) {
                    editButton.setEnabled(((IStructuredSelection)AbstractRequiredWorkItemStateEditor.this.statesViewer.getSelection()).size() == 1);
                }
                if (!clearButton.isDisposed()) {
                    boolean enabled = false;
                    if (((IStructuredSelection)AbstractRequiredWorkItemStateEditor.this.statesViewer.getSelection()).size() == 1) {
                        TypeElement type = (TypeElement)((IStructuredSelection)AbstractRequiredWorkItemStateEditor.this.statesViewer.getSelection()).getFirstElement();
                        enabled = type.hasStates();
                    }
                    clearButton.setEnabled(enabled);
                }
            }
        });
    }

    private void editState(IStructuredSelection selection) {
        block9: {
            Object[] selectedObjects;
            StateElement[] selectedStates;
            String dialogTitle;
            AbstractModeledElement element = (AbstractModeledElement)selection.getFirstElement();
            CategoryElement category = null;
            TypeElement type = null;
            if (element instanceof CategoryElement) {
                category = (CategoryElement)element;
            } else if (element instanceof TypeElement) {
                type = (TypeElement)element;
                category = type.getCategory();
            }
            if (type != null) {
                dialogTitle = NLS.bind((String)Messages.EditWorkItemStateDialog_TITLE, (Object)type.getName());
                selectedStates = new StateElement[type.getStates().size()];
                type.getStates().toArray(selectedStates);
            } else {
                dialogTitle = NLS.bind((String)Messages.EditWorkItemStateDialog_TITLE, (Object)category.getName());
                selectedStates = new StateElement[]{};
            }
            EditWorkItemStatesDialog dialog = new EditWorkItemStatesDialog(Display.getCurrent().getActiveShell(), category, dialogTitle, new StateElement[0], selectedStates);
            int rc = dialog.open();
            if (rc != 0 || (selectedObjects = dialog.getResult()).length <= 0) break block9;
            if (type != null) {
                type.clearStates();
                Object[] objectArray = selectedObjects;
                int n = selectedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedObject = objectArray[n2];
                    type.addState((StateElement)selectedObject);
                    ++n2;
                }
            } else {
                Object[] objectArray = selectedObjects;
                int n = selectedObjects.length;
                int n3 = 0;
                while (n3 < n) {
                    Object selectedObject = objectArray[n3];
                    category.addState((StateElement)selectedObject);
                    ++n3;
                }
            }
        }
    }

    private void clearStates(IStructuredSelection selection) {
        AbstractModeledElement element = (AbstractModeledElement)selection.getFirstElement();
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement type = (TypeElement)element;
        type.clearStates();
    }

    private void readCategories() {
        ModelElement workItemTypeElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
        ModelElement workFlowBindingElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding");
        Map<String, String> workFlowBindings = AspectEditorUtil.getWorkFlowBindings(workFlowBindingElement);
        ModelElement workFlowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
        this.configurationCategories = AspectEditorUtil.readTypeCategories(workItemTypeElement, workFlowBindings, workFlowElement);
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.readCategories();
        this.requireWorkItemStatesMemento = null;
        this.arePreviousStatesDirty = false;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    private void readBuildDefinitions() {
        final IProcessContainerWorkingCopy workingCopy = this.getAspect().getProcessContainerWorkingCopy();
        Job job = new Job(Messages.RetrieveBuildDefinitionJob_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AbstractRequiredWorkItemStateEditor.this.buildDefinitionMap = new HashMap();
                    if (workingCopy instanceof IProcessAreaWorkingCopy) {
                        IBuildDefinition[] buildDefinitions;
                        IProcessAreaWorkingCopy processArea = (IProcessAreaWorkingCopy)workingCopy;
                        IBuildDefinition[] iBuildDefinitionArray = buildDefinitions = AspectEditorUtil.getBuildDefinitions(AbstractRequiredWorkItemStateEditor.this.getBuildDefinitionTemplateIds(), processArea.getUnderlyingProcessArea().getProjectArea(), monitor);
                        int n = buildDefinitions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBuildDefinition buildDefinition = iBuildDefinitionArray[n2];
                            AbstractRequiredWorkItemStateEditor.this.buildDefinitionMap.put(buildDefinition.getItemId(), new BuildDefinitionElement(buildDefinition, AbstractRequiredWorkItemStateEditor.this.configurationCategories));
                            ++n2;
                        }
                    }
                    AbstractRequiredWorkItemStateEditor.this.defaultConfigurationUUID = UUID.generate();
                    AbstractRequiredWorkItemStateEditor.this.buildDefinitionMap.put(AbstractRequiredWorkItemStateEditor.this.defaultConfigurationUUID, new BuildDefinitionElement(null, AbstractRequiredWorkItemStateEditor.this.configurationCategories));
                    AbstractRequiredWorkItemStateEditor.this.readPreviousSavedStates();
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.process.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractRequiredWorkItemStateEditor.this.buildDefinitionCombo != null && !AbstractRequiredWorkItemStateEditor.this.buildDefinitionCombo.isDisposed()) {
                            AbstractRequiredWorkItemStateEditor.this.fillBuildDefinitionCombo();
                            AbstractRequiredWorkItemStateEditor.this.buildDefinitionCombo.select(0);
                            AbstractRequiredWorkItemStateEditor.this.statesViewer.setInput((Object)AbstractRequiredWorkItemStateEditor.this.getCurrentEditBuild().getCategories());
                            AbstractRequiredWorkItemStateEditor.this.statesViewer.refresh();
                            if (AbstractRequiredWorkItemStateEditor.this.arePreviousStatesDirty) {
                                AbstractRequiredWorkItemStateEditor.this.setDirty(AbstractRequiredWorkItemStateEditor.this.arePreviousStatesDirty);
                            }
                        }
                    }
                });
            }
        });
    }

    private void fillBuildDefinitionCombo() {
        this.buildDefinitionCombo.removeAll();
        for (BuildDefinitionElement buildElement : this.buildDefinitionMap.values()) {
            if (buildElement.isDefault()) {
                this.buildDefinitionCombo.add(buildElement.getName(), 0);
                this.buildDefinitionCombo.setData(buildElement.getName(), (Object)this.defaultConfigurationUUID);
                continue;
            }
            this.buildDefinitionCombo.add(buildElement.getName());
            this.buildDefinitionCombo.setData(buildElement.getName(), (Object)buildElement.getUUID());
        }
    }

    private BuildDefinitionElement getCurrentEditBuild() {
        String buildDefinition = this.buildDefinitionCombo.getText();
        UUID buildDefintionUUID = (UUID)this.buildDefinitionCombo.getData(buildDefinition);
        return this.buildDefinitionMap.get(buildDefintionUUID);
    }
}

