/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.internal.common.common.process.AbstractModeledElement;
import com.ibm.team.enterprise.internal.common.common.process.BuildDefinitionElement;
import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.enterprise.internal.common.common.process.StateElement;
import com.ibm.team.enterprise.internal.common.common.process.TypeElement;
import com.ibm.team.enterprise.internal.process.ui.aspect.AspectEditorUtil;
import com.ibm.team.enterprise.internal.process.ui.aspect.EditWorkItemStateDialog;
import com.ibm.team.enterprise.internal.process.ui.aspect.ModeledElementContentProvider;
import com.ibm.team.enterprise.internal.process.ui.aspect.ModeledElementLabelProvider;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractModifyWorkItemStateEditor
extends OperationDetailsAspectEditor {
    private List<CategoryElement> configurationCategories;
    private TreeViewer statesViewer;
    private Combo buildDefinitionCombo;
    private UUID defaultConfigurationUUID;
    private Map<UUID, BuildDefinitionElement> buildDefinitionMap;
    private ModeledElementLabelProvider labelProvider;
    private IMemento modifyWorkItemStateMemento;
    private boolean arePreviousStatesDirty;

    protected abstract String[] getBuildDefinitionTemplateIds();

    protected abstract void setConfigurationDefinitionLabel(Composite var1, FormToolkit var2);

    public void restoreState(IMemento memento) {
        this.modifyWorkItemStateMemento = memento.getChild("modifyWorkItemState");
    }

    private void readPreviousSavedStates() {
        IMemento[] buildElements;
        if (this.modifyWorkItemStateMemento == null) {
            return;
        }
        IMemento[] iMementoArray = buildElements = this.modifyWorkItemStateMemento.getChildren("buildDefinition");
        int n = buildElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento buildElement = iMementoArray[n2];
            UUID buildUUID = buildElement.getBoolean("default") != null && buildElement.getBoolean("default") != false ? this.defaultConfigurationUUID : UUID.valueOf((String)buildElement.getString("uuid"));
            BuildDefinitionElement build = this.buildDefinitionMap.get(buildUUID);
            if (build != null) {
                IMemento[] categoryElements;
                IMemento[] iMementoArray2 = categoryElements = buildElement.getChildren("category");
                int n3 = categoryElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento categoryElement = iMementoArray2[n4];
                    CategoryElement category = build.getCategory(categoryElement.getID());
                    if (category != null) {
                        IMemento[] typeElements;
                        IMemento[] iMementoArray3 = typeElements = categoryElement.getChildren("type");
                        int n5 = typeElements.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IMemento[] stateElements;
                            IMemento typeElement = iMementoArray3[n6];
                            TypeElement type = category.getType(typeElement.getID());
                            if (type != null && (stateElements = typeElement.getChildren("state")).length > 0) {
                                StateElement state = category.getAvailableState(stateElements[0].getID());
                                if (state != null) {
                                    type.addState(state);
                                } else if (!this.arePreviousStatesDirty) {
                                    this.arePreviousStatesDirty = true;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                build.setDirty();
            }
            ++n2;
        }
    }

    public boolean saveState(IMemento memento) {
        IMemento modifyWorkItemStateElement = memento.createChild("modifyWorkItemState");
        for (BuildDefinitionElement build : this.buildDefinitionMap.values()) {
            if (!build.isDirty()) continue;
            IMemento buildElement = modifyWorkItemStateElement.createChild("buildDefinition");
            if (build.isDefault()) {
                buildElement.putBoolean("default", true);
            } else {
                buildElement.putString("uuid", build.getUUID().getUuidValue());
            }
            for (CategoryElement category : build.getCategories()) {
                IMemento categoryElement = null;
                for (TypeElement type : category.getTypes()) {
                    if (!type.hasStates()) continue;
                    if (categoryElement == null) {
                        categoryElement = buildElement.createChild("category", category.getIdentifier());
                    }
                    IMemento typeElement = categoryElement.createChild("type", type.getIdentifier());
                    if (type.getStates().size() <= 0) continue;
                    typeElement.createChild("state", ((StateElement)type.getStates().get(0)).getIdentifier());
                }
            }
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        Composite topComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(topComposite);
        this.setConfigurationDefinitionLabel(topComposite, toolkit);
        this.buildDefinitionCombo = new Combo(topComposite, 0x80000C);
        GridDataFactory.fillDefaults().grab(true, false).minSize(200, -1).applyTo((Control)this.buildDefinitionCombo);
        this.buildDefinitionCombo.add(Messages.RetrieveBuildDefinitionJob_PENDING_LABEL);
        this.buildDefinitionCombo.select(0);
        this.buildDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AbstractModifyWorkItemStateEditor.this.statesViewer != null) {
                    AbstractModifyWorkItemStateEditor.this.statesViewer.setInput((Object)AbstractModifyWorkItemStateEditor.this.getCurrentEditBuild().getCategories());
                    AbstractModifyWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        this.readBuildDefinitions();
        Composite bottomComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(bottomComposite);
        Tree tree = new Tree(bottomComposite, 67588);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 180).applyTo((Control)tree);
        tree.setHeaderVisible(true);
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(250);
        treeColumn.setResizable(true);
        treeColumn.setText(Messages.RequiredWorkItemStateEditor_CATEGORY_OR_TYPE_LABEL);
        treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(250);
        treeColumn.setResizable(true);
        treeColumn.setText(Messages.ModifyWorkItemStateEditor_STATE_LABEL);
        this.statesViewer = new TreeViewer(tree);
        this.labelProvider = new ModeledElementLabelProvider(this.getAspect());
        this.statesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.statesViewer.setContentProvider((IContentProvider)new ModeledElementContentProvider());
        this.statesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractModifyWorkItemStateEditor.this.editState((IStructuredSelection)AbstractModifyWorkItemStateEditor.this.statesViewer.getSelection());
                AbstractModifyWorkItemStateEditor.this.getCurrentEditBuild().setDirty();
                AbstractModifyWorkItemStateEditor.this.setDirty();
                if (AbstractModifyWorkItemStateEditor.this.statesViewer != null) {
                    AbstractModifyWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        Composite bottomRightComposite = toolkit.createComposite(bottomComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(bottomRightComposite);
        GridDataFactory.fillDefaults().grab(false, true).indent(-1, this.statesViewer.getTree().getHeaderHeight()).applyTo((Control)bottomRightComposite);
        final Button editButton = toolkit.createButton(bottomRightComposite, Messages.RequiredWorkItemStateEditor_EDIT, 0x800000);
        editButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractModifyWorkItemStateEditor.this.editState((IStructuredSelection)AbstractModifyWorkItemStateEditor.this.statesViewer.getSelection());
                AbstractModifyWorkItemStateEditor.this.getCurrentEditBuild().setDirty();
                AbstractModifyWorkItemStateEditor.this.setDirty();
                if (AbstractModifyWorkItemStateEditor.this.statesViewer != null) {
                    AbstractModifyWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        final Button clearButton = toolkit.createButton(bottomRightComposite, Messages.ModifyWorkItemStateEditor_CLEAR, 0x800000);
        clearButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        clearButton.setEnabled(false);
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractModifyWorkItemStateEditor.this.clearState((IStructuredSelection)AbstractModifyWorkItemStateEditor.this.statesViewer.getSelection());
                AbstractModifyWorkItemStateEditor.this.getCurrentEditBuild().setDirty();
                AbstractModifyWorkItemStateEditor.this.setDirty();
                if (AbstractModifyWorkItemStateEditor.this.statesViewer != null) {
                    AbstractModifyWorkItemStateEditor.this.statesViewer.refresh();
                }
            }
        });
        this.statesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!editButton.isDisposed()) {
                    editButton.setEnabled(((IStructuredSelection)AbstractModifyWorkItemStateEditor.this.statesViewer.getSelection()).size() == 1);
                }
                if (!clearButton.isDisposed()) {
                    boolean enabled = false;
                    if (((IStructuredSelection)AbstractModifyWorkItemStateEditor.this.statesViewer.getSelection()).size() == 1) {
                        TypeElement type = (TypeElement)((IStructuredSelection)AbstractModifyWorkItemStateEditor.this.statesViewer.getSelection()).getFirstElement();
                        enabled = type.hasStates();
                    }
                    clearButton.setEnabled(enabled);
                }
            }
        });
    }

    private void clearState(IStructuredSelection selection) {
        AbstractModeledElement element = (AbstractModeledElement)selection.getFirstElement();
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement type = (TypeElement)element;
        type.clearStates();
    }

    private void editState(IStructuredSelection selection) {
        EditWorkItemStateDialog dialog;
        int rc;
        String dialogTitle;
        AbstractModeledElement element = (AbstractModeledElement)selection.getFirstElement();
        CategoryElement category = null;
        TypeElement type = null;
        if (element instanceof CategoryElement) {
            category = (CategoryElement)element;
        } else if (element instanceof TypeElement) {
            type = (TypeElement)element;
            category = type.getCategory();
        }
        StateElement selectedState = null;
        if (type != null) {
            dialogTitle = NLS.bind((String)Messages.EditWorkItemStateDialog_TITLE, (Object)type.getName());
            if (type.getStates().size() > 0) {
                selectedState = (StateElement)type.getStates().get(0);
            }
        } else {
            dialogTitle = NLS.bind((String)Messages.EditWorkItemStateDialog_TITLE, (Object)category.getName());
        }
        if ((rc = (dialog = new EditWorkItemStateDialog(Display.getCurrent().getActiveShell(), category, dialogTitle, selectedState)).open()) == 0) {
            Object[] selectedObjects = dialog.getResult();
            type.clearStates();
            if (selectedObjects.length > 0) {
                type.addState((StateElement)selectedObjects[0]);
            }
        }
    }

    private void readCategories() {
        ModelElement workItemTypeElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
        ModelElement workFlowBindingElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding");
        Map<String, String> workFlowBindings = AspectEditorUtil.getWorkFlowBindings(workFlowBindingElement);
        ModelElement workFlowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
        this.configurationCategories = AspectEditorUtil.readTypeCategories(workItemTypeElement, workFlowBindings, workFlowElement);
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.readCategories();
        this.modifyWorkItemStateMemento = null;
        this.arePreviousStatesDirty = false;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    private void readBuildDefinitions() {
        final IProcessAreaWorkingCopy processArea = (IProcessAreaWorkingCopy)this.getAspect().getProcessContainerWorkingCopy();
        Job job = new Job(Messages.RetrieveBuildDefinitionJob_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IBuildDefinition[] buildDefinitions = AspectEditorUtil.getBuildDefinitions(AbstractModifyWorkItemStateEditor.this.getBuildDefinitionTemplateIds(), processArea.getUnderlyingProcessArea().getProjectArea(), monitor);
                    AbstractModifyWorkItemStateEditor.this.buildDefinitionMap = new HashMap();
                    IBuildDefinition[] iBuildDefinitionArray = buildDefinitions;
                    int n = buildDefinitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildDefinition buildDefinition = iBuildDefinitionArray[n2];
                        AbstractModifyWorkItemStateEditor.this.buildDefinitionMap.put(buildDefinition.getItemId(), new BuildDefinitionElement(buildDefinition, AbstractModifyWorkItemStateEditor.this.configurationCategories));
                        ++n2;
                    }
                    AbstractModifyWorkItemStateEditor.this.defaultConfigurationUUID = UUID.generate();
                    AbstractModifyWorkItemStateEditor.this.buildDefinitionMap.put(AbstractModifyWorkItemStateEditor.this.defaultConfigurationUUID, new BuildDefinitionElement(null, AbstractModifyWorkItemStateEditor.this.configurationCategories));
                    AbstractModifyWorkItemStateEditor.this.readPreviousSavedStates();
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.process.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractModifyWorkItemStateEditor.this.buildDefinitionCombo != null && !AbstractModifyWorkItemStateEditor.this.buildDefinitionCombo.isDisposed()) {
                            AbstractModifyWorkItemStateEditor.this.fillBuildDefinitionCombo();
                            AbstractModifyWorkItemStateEditor.this.buildDefinitionCombo.select(0);
                            AbstractModifyWorkItemStateEditor.this.statesViewer.setInput((Object)AbstractModifyWorkItemStateEditor.this.getCurrentEditBuild().getCategories());
                            AbstractModifyWorkItemStateEditor.this.statesViewer.refresh();
                            if (AbstractModifyWorkItemStateEditor.this.arePreviousStatesDirty) {
                                AbstractModifyWorkItemStateEditor.this.setDirty(AbstractModifyWorkItemStateEditor.this.arePreviousStatesDirty);
                            }
                        }
                    }
                });
            }
        });
    }

    private void fillBuildDefinitionCombo() {
        this.buildDefinitionCombo.removeAll();
        for (BuildDefinitionElement buildElement : this.buildDefinitionMap.values()) {
            if (buildElement.isDefault()) {
                this.buildDefinitionCombo.add(buildElement.getName(), 0);
                this.buildDefinitionCombo.setData(buildElement.getName(), (Object)this.defaultConfigurationUUID);
                continue;
            }
            this.buildDefinitionCombo.add(buildElement.getName());
            this.buildDefinitionCombo.setData(buildElement.getName(), (Object)buildElement.getUUID());
        }
    }

    private BuildDefinitionElement getCurrentEditBuild() {
        String buildDefinition = this.buildDefinitionCombo.getText();
        UUID buildDefintionUUID = (UUID)this.buildDefinitionCombo.getData(buildDefinition);
        return this.buildDefinitionMap.get(buildDefintionUUID);
    }
}

