/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.internal.common.common.process.BuildDefinitionElement;
import com.ibm.team.enterprise.internal.process.ui.aspect.AspectEditorUtil;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractAddWorkItemTagsEditor
extends OperationDetailsAspectEditor {
    private Combo buildDefinitionCombo;
    private UUID defaultConfigurationUUID;
    private Map<UUID, BuildDefinitionElement> buildDefinitionMap;
    private Text tagsTextField;
    private TagsModifyListener tagsModifyListener;
    private IMemento addWorkItemTagsMemento;

    protected abstract void setConfigurationDefinitionLabel(Composite var1, FormToolkit var2);

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.addWorkItemTagsMemento = null;
    }

    public void restoreState(IMemento memento) {
        this.addWorkItemTagsMemento = memento.getChild("addWorkItemTags");
    }

    private void readPreviousSavedStates() {
        IMemento[] buildElements;
        if (this.addWorkItemTagsMemento == null) {
            return;
        }
        IMemento[] iMementoArray = buildElements = this.addWorkItemTagsMemento.getChildren("buildDefinition");
        int n = buildElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento tagsElement;
            IMemento buildElement = iMementoArray[n2];
            UUID buildUUID = buildElement.getBoolean("default") != null && buildElement.getBoolean("default") != false ? this.defaultConfigurationUUID : UUID.valueOf((String)buildElement.getString("uuid"));
            BuildDefinitionElement build = this.buildDefinitionMap.get(buildUUID);
            if (build != null && (tagsElement = buildElement.getChild("tags")) != null) {
                build.setWorkItemTags(tagsElement.getString("value"));
                build.setDirty();
            }
            ++n2;
        }
    }

    public boolean saveState(IMemento memento) {
        IMemento addWorkItemTagsElement = memento.createChild("addWorkItemTags");
        for (BuildDefinitionElement build : this.buildDefinitionMap.values()) {
            if (!build.isDirty() || build.getWorkItemTags() == null || build.getWorkItemTags().trim().length() <= 0) continue;
            IMemento buildElement = addWorkItemTagsElement.createChild("buildDefinition");
            if (build.isDefault()) {
                buildElement.putBoolean("default", true);
            } else {
                buildElement.putString("uuid", build.getUUID().getUuidValue());
            }
            IMemento tagsElement = buildElement.createChild("tags");
            tagsElement.putString("value", build.getWorkItemTags());
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.tagsModifyListener = new TagsModifyListener();
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        Composite topComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(topComposite);
        this.setConfigurationDefinitionLabel(topComposite, toolkit);
        this.buildDefinitionCombo = new Combo(topComposite, 0x80000C);
        GridDataFactory.fillDefaults().grab(true, false).minSize(200, -1).applyTo((Control)this.buildDefinitionCombo);
        this.buildDefinitionCombo.add(Messages.RetrieveBuildDefinitionJob_PENDING_LABEL);
        this.buildDefinitionCombo.select(0);
        this.buildDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AbstractAddWorkItemTagsEditor.this.tagsTextField != null) {
                    AbstractAddWorkItemTagsEditor.this.tagsTextField.removeModifyListener((ModifyListener)AbstractAddWorkItemTagsEditor.this.tagsModifyListener);
                    AbstractAddWorkItemTagsEditor.this.tagsTextField.setText(AbstractAddWorkItemTagsEditor.this.getCurrentEditBuild().getWorkItemTags());
                    AbstractAddWorkItemTagsEditor.this.tagsTextField.addModifyListener((ModifyListener)AbstractAddWorkItemTagsEditor.this.tagsModifyListener);
                }
            }
        });
        this.readBuildDefinitions();
        Composite bottomComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(bottomComposite);
        Label tagsLabel = new Label(topComposite, 16384);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)tagsLabel);
        tagsLabel.setText(Messages.AddWorkItemTagsEditor_TAGS_LABEL);
        this.tagsTextField = toolkit.createText(topComposite, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).minSize(200, -1).applyTo((Control)this.tagsTextField);
        this.tagsTextField.addModifyListener((ModifyListener)this.tagsModifyListener);
    }

    public void dispose() {
    }

    private void readBuildDefinitions() {
        final IProcessAreaWorkingCopy processArea = (IProcessAreaWorkingCopy)this.getAspect().getProcessContainerWorkingCopy();
        Job job = new Job(Messages.RetrieveBuildDefinitionJob_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IBuildDefinition[] buildDefinitions = AspectEditorUtil.getBuildDefinitions(AbstractAddWorkItemTagsEditor.this.getBuildDefinitionTemplateIds(), processArea.getUnderlyingProcessArea().getProjectArea(), monitor);
                    AbstractAddWorkItemTagsEditor.this.buildDefinitionMap = new HashMap();
                    IBuildDefinition[] iBuildDefinitionArray = buildDefinitions;
                    int n = buildDefinitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildDefinition buildDefinition = iBuildDefinitionArray[n2];
                        AbstractAddWorkItemTagsEditor.this.buildDefinitionMap.put(buildDefinition.getItemId(), new BuildDefinitionElement(buildDefinition));
                        ++n2;
                    }
                    AbstractAddWorkItemTagsEditor.this.defaultConfigurationUUID = UUID.generate();
                    AbstractAddWorkItemTagsEditor.this.buildDefinitionMap.put(AbstractAddWorkItemTagsEditor.this.defaultConfigurationUUID, new BuildDefinitionElement(null));
                    AbstractAddWorkItemTagsEditor.this.readPreviousSavedStates();
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.process.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractAddWorkItemTagsEditor.this.buildDefinitionCombo != null && !AbstractAddWorkItemTagsEditor.this.buildDefinitionCombo.isDisposed()) {
                            AbstractAddWorkItemTagsEditor.this.fillBuildDefinitionCombo();
                            AbstractAddWorkItemTagsEditor.this.buildDefinitionCombo.select(0);
                            AbstractAddWorkItemTagsEditor.this.tagsTextField.removeModifyListener((ModifyListener)AbstractAddWorkItemTagsEditor.this.tagsModifyListener);
                            AbstractAddWorkItemTagsEditor.this.tagsTextField.setText(AbstractAddWorkItemTagsEditor.this.getCurrentEditBuild().getWorkItemTags());
                            AbstractAddWorkItemTagsEditor.this.tagsTextField.addModifyListener((ModifyListener)AbstractAddWorkItemTagsEditor.this.tagsModifyListener);
                        }
                    }
                });
            }
        });
    }

    private void fillBuildDefinitionCombo() {
        this.buildDefinitionCombo.removeAll();
        for (BuildDefinitionElement buildElement : this.buildDefinitionMap.values()) {
            if (buildElement.isDefault()) {
                this.buildDefinitionCombo.add(buildElement.getName(), 0);
                this.buildDefinitionCombo.setData(buildElement.getName(), (Object)this.defaultConfigurationUUID);
                continue;
            }
            this.buildDefinitionCombo.add(buildElement.getName());
            this.buildDefinitionCombo.setData(buildElement.getName(), (Object)buildElement.getUUID());
        }
        this.buildDefinitionCombo.select(0);
    }

    private BuildDefinitionElement getCurrentEditBuild() {
        String buildDefinition = this.buildDefinitionCombo.getText();
        UUID buildDefintionUUID = (UUID)this.buildDefinitionCombo.getData(buildDefinition);
        return this.buildDefinitionMap.get(buildDefintionUUID);
    }

    protected abstract String[] getBuildDefinitionTemplateIds();

    class TagsModifyListener
    implements ModifyListener {
        TagsModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            BuildDefinitionElement buildDefinition = AbstractAddWorkItemTagsEditor.this.getCurrentEditBuild();
            buildDefinition.setWorkItemTags(AbstractAddWorkItemTagsEditor.this.tagsTextField.getText());
            buildDefinition.setDirty();
            AbstractAddWorkItemTagsEditor.this.setDirty();
        }
    }
}

