/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.aspect;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.internal.common.common.process.BuildDefinitionElement;
import com.ibm.team.enterprise.internal.process.ui.aspect.AspectEditorUtil;
import com.ibm.team.enterprise.internal.process.ui.nls.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractAddWorkItemCommentEditor
extends OperationDetailsAspectEditor {
    private Combo buildDefinitionCombo;
    private UUID defaultConfigurationUUID;
    private Map<UUID, BuildDefinitionElement> buildDefinitionMap;
    private Text commentTextArea;
    private CommentModifyListener commentModifyListener;
    private IMemento addWorkItemCommentMemento;

    protected abstract void setConfigurationDefinitionLabel(Composite var1, FormToolkit var2);

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.addWorkItemCommentMemento = null;
    }

    public void restoreState(IMemento memento) {
        this.addWorkItemCommentMemento = memento.getChild("addWorkItemComment");
    }

    private void readPreviousSavedStates() {
        IMemento[] buildElements;
        if (this.addWorkItemCommentMemento == null) {
            return;
        }
        IMemento[] iMementoArray = buildElements = this.addWorkItemCommentMemento.getChildren("buildDefinition");
        int n = buildElements.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento commentElement;
            IMemento buildElement = iMementoArray[n2];
            UUID buildUUID = buildElement.getBoolean("default") != null && buildElement.getBoolean("default") != false ? this.defaultConfigurationUUID : UUID.valueOf((String)buildElement.getString("uuid"));
            BuildDefinitionElement build = this.buildDefinitionMap.get(buildUUID);
            if (build != null && (commentElement = buildElement.getChild("comment")) != null) {
                build.setWorkItemComment(commentElement.getString("value"));
                build.setDirty();
            }
            ++n2;
        }
    }

    public boolean saveState(IMemento memento) {
        IMemento addWorkItemCommentElement = memento.createChild("addWorkItemComment");
        for (BuildDefinitionElement build : this.buildDefinitionMap.values()) {
            if (!build.isDirty() || build.getWorkItemComment() == null || build.getWorkItemComment().trim().length() <= 0) continue;
            IMemento buildElement = addWorkItemCommentElement.createChild("buildDefinition");
            if (build.isDefault()) {
                buildElement.putBoolean("default", true);
            } else {
                buildElement.putString("uuid", build.getUUID().getUuidValue());
            }
            IMemento commentElement = buildElement.createChild("comment");
            commentElement.putString("value", build.getWorkItemComment());
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.commentModifyListener = new CommentModifyListener();
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        Composite topComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(topComposite);
        this.setConfigurationDefinitionLabel(topComposite, toolkit);
        this.buildDefinitionCombo = new Combo(topComposite, 0x80000C);
        GridDataFactory.fillDefaults().grab(true, false).minSize(200, -1).applyTo((Control)this.buildDefinitionCombo);
        this.buildDefinitionCombo.add(Messages.RetrieveBuildDefinitionJob_PENDING_LABEL);
        this.buildDefinitionCombo.select(0);
        this.buildDefinitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AbstractAddWorkItemCommentEditor.this.commentTextArea != null) {
                    AbstractAddWorkItemCommentEditor.this.commentTextArea.removeModifyListener((ModifyListener)AbstractAddWorkItemCommentEditor.this.commentModifyListener);
                    AbstractAddWorkItemCommentEditor.this.commentTextArea.setText(AbstractAddWorkItemCommentEditor.this.getCurrentEditBuild().getWorkItemComment());
                    AbstractAddWorkItemCommentEditor.this.commentTextArea.addModifyListener((ModifyListener)AbstractAddWorkItemCommentEditor.this.commentModifyListener);
                }
            }
        });
        this.readBuildDefinitions();
        Composite bottomComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(bottomComposite);
        Label commentLabel = new Label(topComposite, 16384);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)commentLabel);
        commentLabel.setText(Messages.AddWorkItemCommentEditor_COMMENT_LABEL);
        this.commentTextArea = toolkit.createText(topComposite, "", 2114);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).minSize(400, 150).applyTo((Control)this.commentTextArea);
        this.commentTextArea.addModifyListener((ModifyListener)this.commentModifyListener);
    }

    public void dispose() {
    }

    private void readBuildDefinitions() {
        final IProcessAreaWorkingCopy processArea = (IProcessAreaWorkingCopy)this.getAspect().getProcessContainerWorkingCopy();
        Job job = new Job(Messages.RetrieveBuildDefinitionJob_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IBuildDefinition[] buildDefinitions = AspectEditorUtil.getBuildDefinitions(AbstractAddWorkItemCommentEditor.this.getBuildDefinitionTemplateIds(), processArea.getUnderlyingProcessArea().getProjectArea(), monitor);
                    AbstractAddWorkItemCommentEditor.this.buildDefinitionMap = new HashMap();
                    IBuildDefinition[] iBuildDefinitionArray = buildDefinitions;
                    int n = buildDefinitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildDefinition buildDefinition = iBuildDefinitionArray[n2];
                        AbstractAddWorkItemCommentEditor.this.buildDefinitionMap.put(buildDefinition.getItemId(), new BuildDefinitionElement(buildDefinition));
                        ++n2;
                    }
                    AbstractAddWorkItemCommentEditor.this.defaultConfigurationUUID = UUID.generate();
                    AbstractAddWorkItemCommentEditor.this.buildDefinitionMap.put(AbstractAddWorkItemCommentEditor.this.defaultConfigurationUUID, new BuildDefinitionElement(null));
                    AbstractAddWorkItemCommentEditor.this.readPreviousSavedStates();
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.process.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractAddWorkItemCommentEditor.this.buildDefinitionCombo != null && !AbstractAddWorkItemCommentEditor.this.buildDefinitionCombo.isDisposed()) {
                            AbstractAddWorkItemCommentEditor.this.fillBuildDefinitionCombo();
                            AbstractAddWorkItemCommentEditor.this.buildDefinitionCombo.select(0);
                            AbstractAddWorkItemCommentEditor.this.commentTextArea.removeModifyListener((ModifyListener)AbstractAddWorkItemCommentEditor.this.commentModifyListener);
                            AbstractAddWorkItemCommentEditor.this.commentTextArea.setText(AbstractAddWorkItemCommentEditor.this.getCurrentEditBuild().getWorkItemComment());
                            AbstractAddWorkItemCommentEditor.this.commentTextArea.addModifyListener((ModifyListener)AbstractAddWorkItemCommentEditor.this.commentModifyListener);
                        }
                    }
                });
            }
        });
    }

    private void fillBuildDefinitionCombo() {
        this.buildDefinitionCombo.removeAll();
        for (BuildDefinitionElement buildElement : this.buildDefinitionMap.values()) {
            if (buildElement.isDefault()) {
                this.buildDefinitionCombo.add(buildElement.getName(), 0);
                this.buildDefinitionCombo.setData(buildElement.getName(), (Object)this.defaultConfigurationUUID);
                continue;
            }
            this.buildDefinitionCombo.add(buildElement.getName());
            this.buildDefinitionCombo.setData(buildElement.getName(), (Object)buildElement.getUUID());
        }
        this.buildDefinitionCombo.select(0);
    }

    private BuildDefinitionElement getCurrentEditBuild() {
        String buildDefinition = this.buildDefinitionCombo.getText();
        UUID buildDefintionUUID = (UUID)this.buildDefinitionCombo.getData(buildDefinition);
        return this.buildDefinitionMap.get(buildDefintionUUID);
    }

    protected abstract String[] getBuildDefinitionTemplateIds();

    class CommentModifyListener
    implements ModifyListener {
        CommentModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            BuildDefinitionElement buildDefinition = AbstractAddWorkItemCommentEditor.this.getCurrentEditBuild();
            buildDefinition.setWorkItemComment(AbstractAddWorkItemCommentEditor.this.commentTextArea.getText());
            buildDefinition.setDirty();
            AbstractAddWorkItemCommentEditor.this.setDirty();
        }
    }
}

