/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.advice;

import com.ibm.team.enterprise.internal.process.ui.advice.nls.Messages;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.ide.ui.advice.AdviceElementDetailProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IRepositoryRoot;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RequireWorkItemStatesDetailProvider
extends AdviceElementDetailProvider {
    public RequireWorkItemStatesDetailProvider(IAdvisorInfo info) {
        super((Object)info);
    }

    public boolean requiresLongOp() {
        return this.fElement != null && ((IAdvisorInfo)this.fElement).getData() != null;
    }

    protected String createDetailText() {
        if (this.fElement != null) {
            return ((IAdvisorInfo)this.fElement).getSummary();
        }
        return "";
    }

    protected String createDetailText(IProgressMonitor monitor) {
        IAdvisorInfo info = (IAdvisorInfo)this.fElement;
        StringBuffer buffer = new StringBuffer();
        this.appendBodyAndTableStart(buffer, info.getSeverity());
        buffer.append("<b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)Messages.AdviceDetailProvider_PROBLEM));
        this.appendProblem(info, buffer, monitor);
        this.appendQuickFixes(info, buffer);
        this.appendExplainOperationLink(info, buffer);
        buffer.append("</td></tr></table></body>");
        return buffer.toString();
    }

    protected void appendProblem(IAdvisorInfo info, StringBuffer buffer, IProgressMonitor monitor) {
        Element root = this.toElement(info.getData());
        if (root != null) {
            ITeamRepository teamRepository = this.getTeamRepository(root);
            NodeList errorList = root.getElementsByTagName("error");
            int i = 0;
            while (i < errorList.getLength()) {
                Element errorElement = (Element)errorList.item(i);
                buffer.append(errorElement.getAttribute("value")).append("<p>");
                buffer.append("<ul>");
                NodeList nodeList = errorElement.getElementsByTagName("workItem");
                int j = 0;
                while (j < nodeList.getLength()) {
                    buffer.append("<li>");
                    Element element = (Element)nodeList.item(j);
                    String text = element.getAttribute("label");
                    this.appendHyperlink(text, text, buffer, new OpenWorkItemRunnable(UUID.valueOf((String)element.getAttribute("uuid")), teamRepository));
                    buffer.append("</li>");
                    ++j;
                }
                buffer.append("</ul>");
                ++i;
            }
        }
    }

    private ITeamRepository getTeamRepository(Element root) {
        NodeList nodeList = root.getElementsByTagName("repositoryRoot");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element repositoryRootElement = (Element)nodeList.item(0);
        UUID repositoryRootUUID = UUID.valueOf((String)repositoryRootElement.getAttribute("uuid"));
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository repository = repositories[i];
            IRepositoryRoot repositoryRoot = repository.root();
            if (repositoryRoot != null && repositoryRoot.getItemId().equals((Object)repositoryRootUUID)) {
                return repository;
            }
            ++i;
        }
        return null;
    }

    private Element toElement(String data) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(data.getBytes()));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            return null;
        }
    }

    private IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    class OpenWorkItemRunnable
    implements Runnable {
        private final ITeamRepository repository;
        private final IWorkItemHandle workItemHandle;

        public OpenWorkItemRunnable(UUID uuid, ITeamRepository repository) {
            this.workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(uuid, null);
            this.repository = repository;
        }

        @Override
        public void run() {
            try {
                IWorkItemClient workItemClient = (IWorkItemClient)this.repository.getClientLibrary(IWorkItemClient.class);
                IWorkItem workItem = (IWorkItem)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)this.workItemHandle, IWorkItem.FULL_PROFILE, null);
                IWorkbenchPage page = RequireWorkItemStatesDetailProvider.this.getWorkbenchPage();
                if (page != null) {
                    WorkItemUI.open((IWorkbenchPage)page, (Object)workItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

