/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.advice;

import com.ibm.team.enterprise.internal.process.ui.advice.nls.Messages;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.ide.ui.process.AbstractFileAdvisorDetailProvider;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class PreventUnintendedIgnoresDetailProvider
extends AbstractFileAdvisorDetailProvider {
    public PreventUnintendedIgnoresDetailProvider(IAdvisorInfo info) {
        super(info);
    }

    protected void appendProblem(IAdvisorInfo info, StringBuffer buffer, IProgressMonitor monitor) {
        List shareablesWithUnintendedIgnores = (List)info.getProblemObject();
        final ArrayList<Object> filesWithUnintendedIgnores = new ArrayList<Object>();
        for (Object shareable : shareablesWithUnintendedIgnores) {
            filesWithUnintendedIgnores.add(((IShareable)shareable).getAdapter(IFile.class));
        }
        Collections.sort(filesWithUnintendedIgnores, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof IFile && arg1 instanceof IFile) {
                    RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance();
                    return collator.compare(((IFile)arg0).getName(), ((IFile)arg1).getName());
                }
                return 0;
            }
        });
        int numFiles = filesWithUnintendedIgnores.size();
        if (numFiles > 0) {
            int maxFilesToShow = 10;
            if (numFiles == 1) {
                buffer.append(Messages.PreventUnintendedIgnoresDetailProvider_0);
            } else {
                buffer.append(NLS.bind((String)Messages.PreventUnintendedIgnoresDetailProvider_1, (Object)numFiles));
            }
            int i = 0;
            while (i < filesWithUnintendedIgnores.size() && i < maxFilesToShow) {
                IFile file = (IFile)filesWithUnintendedIgnores.get(i);
                buffer.append("<br>&nbsp;&nbsp;");
                this.appendFileLink(buffer, file);
                ++i;
            }
            if (numFiles > maxFilesToShow) {
                buffer.append("<br>&nbsp;&nbsp;");
                this.appendHyperlink(NLS.bind((String)Messages.PreventUnintendedIgnoresDetailProvider_2, (Object)(numFiles - maxFilesToShow)), Messages.PreventUnintendedIgnoresDetailProvider_3, buffer, new Runnable(){

                    @Override
                    public void run() {
                        PreventUnintendedIgnoresDetailProvider.this.showAllFiles(filesWithUnintendedIgnores);
                    }
                });
            }
        }
    }
}

