/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.advice;

import com.ibm.team.enterprise.internal.process.ui.advice.AbstractShareableAdvisor;
import com.ibm.team.enterprise.internal.process.ui.advice.nls.Messages;
import com.ibm.team.enterprise.process.ui.IIgnoreChangeConstants;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PreventUnintendedIgnoresAdvisor
extends AbstractShareableAdvisor
implements IIgnoreChangeConstants {
    private List<IShareable> fFilesWithUnintendedIgnores;

    @Override
    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fFilesWithUnintendedIgnores = new ArrayList<IShareable>();
        super.run(operation, advisorConfiguration, collector, monitor);
        if (this.fFilesWithUnintendedIgnores.size() > 0) {
            IAdvisorInfo problem = collector.createProblemInfo(Messages.PreventUnintendedIgnoresAdvisor_0, Messages.PreventUnintendedIgnoresAdvisor_1, "com.ibm.teamz.build.changes.process.preventUnintendedIgnoresProblem");
            problem.setProblemObject(this.fFilesWithUnintendedIgnores);
            collector.addInfo((IReportInfo)problem);
        }
    }

    @Override
    protected IReportInfo getProblem(IShareable shareable, IVersionableHandle beforeVersionableHandle, ITeamRepository teamRepository, IAdvisorInfoCollector collector, IProgressMonitor monitor) {
        block5: {
            monitor.beginTask(Messages.PreventUnintendedIgnoresAdvisor_2, 1);
            try {
                IMetadataProperties metadataProperties = shareable.getMetadataProperties(monitor);
                if (!Boolean.parseBoolean((String)metadataProperties.getOriginalProperties().get("team.enterprise.build.changes.ignoreForDependencyBuild")) || beforeVersionableHandle == null) break block5;
                try {
                    IVersionable beforeVersionable = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).versionableManager().fetchCompleteState(beforeVersionableHandle, monitor);
                    if (beforeVersionable != null && Boolean.parseBoolean((String)beforeVersionable.getUserProperties().get("team.enterprise.build.changes.ignoreForDependencyBuild"))) {
                        this.fFilesWithUnintendedIgnores.add(shareable);
                    }
                }
                catch (TeamRepositoryException e) {
                    return collector.createExceptionInfo(NLS.bind((String)Messages.PreventUnintendedIgnoresAdvisor_3, (Object)shareable.getFullPath().toString()), (Throwable)e);
                }
            }
            catch (FileSystemException e) {
                return collector.createExceptionInfo(NLS.bind((String)Messages.PreventUnintendedIgnoresAdvisor_3, (Object)shareable.getFullPath().toString()), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected void appendToProblemData(Element dataElement, Object custom, Document doc) {
    }
}

