/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.process.ui.advice;

import com.ibm.team.enterprise.internal.process.ui.advice.nls.Messages;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ide.ui.process.AbstractFileAdvisorDetailProvider;
import com.ibm.team.filesystem.ide.ui.process.AbstractSourceControlAdvisorDetailProvider;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IgnoreChangesPermissionCheckDetailProvider
extends AbstractFileAdvisorDetailProvider {
    public static final String ID_IGNORE_CHANGES_PERMISSION_PROBLEM = "com.ibm.teamz.build.changes.process.ignoreChangesPermissionProblem";
    private static final int MAX_FILES_TO_SHOW = 10;

    public IgnoreChangesPermissionCheckDetailProvider(IAdvisorInfo info) {
        super(info);
    }

    public boolean requiresLongOp() {
        return true;
    }

    protected void appendProblem(IAdvisorInfo info, StringBuffer buffer, IProgressMonitor progress) {
        ProblemDescription desc;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        try {
            desc = IgnoreChangesPermissionCheckDetailProvider.getFiles(info, (IProgressMonitor)monitor.newChild(1));
        }
        catch (ParseException e) {
            buffer.append(e.complaint);
            return;
        }
        assert (desc.wsHandle != null);
        Collections.sort(desc.localFiles, new Comparator<IFile>(){

            @Override
            public int compare(IFile arg0, IFile arg1) {
                if (arg0 instanceof IFile && arg1 instanceof IFile) {
                    Collator collator = Collator.getInstance();
                    return collator.compare(arg0.getName(), arg1.getName());
                }
                return 0;
            }
        });
        int numFiles = desc.localFiles.size();
        if (numFiles > 0) {
            if (numFiles == 1) {
                buffer.append(Messages.IgnoreChangesPermissionCheckDetailProvider_OneFile);
            } else {
                buffer.append(NLS.bind((String)Messages.IgnoreChangesPermissionCheckDetailProvider_MultiFiles, (Object)numFiles));
            }
            int i = 0;
            while (i < desc.localFiles.size() && i < 10) {
                IFile file = desc.localFiles.get(i);
                this.appendListItemPrefix(buffer);
                this.appendFileLink(buffer, file);
                ++i;
            }
            if (numFiles > 10) {
                this.appendListItemPrefix(buffer);
                this.appendHyperlink(NLS.bind((String)Messages.IgnoreChangesPermissionCheckDetailProvider_More, (Object)(numFiles - 10)), Messages.IgnoreChangesPermissionCheckDetailProvider_ViewAll, buffer, new Runnable(){

                    @Override
                    public void run() {
                        IgnoreChangesPermissionCheckDetailProvider.this.showAllFiles(desc.localFiles);
                    }
                });
            }
        }
    }

    private void appendListItemPrefix(StringBuffer buffer) {
        buffer.append("<br>&nbsp;&nbsp;");
    }

    public static ProblemDescription getFiles(IAdvisorInfo info, IProgressMonitor monitor) throws ParseException {
        IWorkspaceHandle wsHandle;
        UUID repoRoot;
        ArrayList<IFile> resolved = new ArrayList();
        List<String> unresolved = null;
        Object problemObject = info.getProblemObject();
        if (problemObject instanceof List) {
            resolved = (List)problemObject;
            repoRoot = null;
            wsHandle = null;
        } else {
            Element dataElement = AbstractSourceControlAdvisorDetailProvider.getDataElement((String)info.getData());
            if (dataElement == null) {
                throw new ParseException(Messages.IgnoreChangesPermissionCheckDetailProvider_ERROR_INVALID_DATA_FIELD);
            }
            String repoStr = dataElement.getAttribute("repositoryRoot");
            if ("".equals(repoStr)) {
                throw new ParseException(Messages.IgnoreChangesPermissionCheckDetailProvider_ERROR_INVALID_DATA_FIELD);
            }
            repoRoot = UUID.valueOf((String)repoStr);
            String wsId = dataElement.getAttribute("sourceWorkspaceId");
            repoRoot = null;
            wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wsId), null);
            IComponentHandle componentHandle = null;
            String compId = dataElement.getAttribute("componentItemId");
            if ("".equals(compId)) {
                throw new ParseException(Messages.IgnoreChangesPermissionCheckDetailProvider_ERROR_MISSING_COMPONENT_ID);
            }
            componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)compId), null);
            if (dataElement != null) {
                NodeList fileElements = dataElement.getElementsByTagName("file");
                int i = 0;
                while (i < fileElements.getLength()) {
                    Element fileElement = (Element)fileElements.item(i);
                    UUID fileItemId = UUID.valueOf((String)fileElement.getAttribute("fileItemId"));
                    IFileItemHandle fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(fileItemId, null);
                    ISharingManager sharingManager = FileSystemCore.getSharingManager();
                    try {
                        Collection shareables = sharingManager.findShareables((IContextHandle)wsHandle, componentHandle, (IVersionableHandle)fileItemHandle, monitor);
                        for (IShareable shareable : shareables) {
                            IFile file = (IFile)shareable.getAdapter(IFile.class);
                            if (file == null) continue;
                            resolved.add(file);
                        }
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        return new ProblemDescription(repoRoot, wsHandle, resolved, unresolved);
    }

    protected static class ParseException
    extends Exception {
        private static final long serialVersionUID = 6488252718698662555L;
        final String complaint;

        public ParseException(String complaint) {
            this.complaint = complaint;
        }
    }

    protected static class ProblemDescription {
        final UUID repoRoot;
        final IWorkspaceHandle wsHandle;
        final List<IFile> localFiles;
        final List<String> unresolvableFiles;

        public ProblemDescription(UUID repoRoot, IWorkspaceHandle wsHandle, List<IFile> modifiedFiles, List<String> unresolvableFiles) {
            this.repoRoot = repoRoot;
            this.wsHandle = wsHandle;
            this.localFiles = modifiedFiles;
            this.unresolvableFiles = unresolvableFiles;
        }
    }
}

