/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui.listeners;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.enterprise.automation.ui.AbstractAutomationNode;
import com.ibm.team.enterprise.automation.ui.listeners.AbstractAutomationNodeChangeListener;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.packaging.ui.PackagingDefinitionQueryNode;
import com.ibm.team.enterprise.packaging.ui.PackagingNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

public class PackagingNodeChangeListener
extends AbstractAutomationNodeChangeListener {
    private static final String PACKAGING_PATH_ID = "Packages";

    public PackagingNodeChangeListener(EnterpriseExtensionsDomainContentProvider contentProvider, IProjectAreaHandle projectAreaHandle, PackagingNode parent, List<BuildDefinitionQueryNode> children) {
        super(contentProvider, projectAreaHandle, (AbstractAutomationNode)parent, children);
    }

    protected void addBuildDefinitions(HashSet<IItem> itemsToAdd) {
        List buildDefinitions = this.getItemsOfType(itemsToAdd, IBuildDefinition.class);
        if (!buildDefinitions.isEmpty()) {
            ArrayList<PackagingDefinitionQueryNode> nodes = new ArrayList<PackagingDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                if (!EnterpriseHelper.isPackagingTemplate((String)definition.getPropertyValue("com.ibm.team.build.internal.template.id", null)) || !((PackagingNode)((Object)this.getParent())).getPathId().equals(PACKAGING_PATH_ID) || this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue()) != null) continue;
                IBuildDefinitionStatusRecord record = this.getBuildDefinitionStatusRecord(definition);
                PackagingDefinitionQueryNode node = new PackagingDefinitionQueryNode((ITeamRepository)definition.getOrigin(), record);
                node.setParent((IEnterpriseExtensionsNode)((PackagingNode)((Object)this.getParent())));
                node.setDomainSubtreeRoot(((PackagingNode)((Object)this.getParent())).getDomainSubtreeRoot());
                node.setProjectAreaHandle(this.getProjectAreaHandle());
                node.setId(node.getBuildDefinitionId());
                node.setPathId(String.valueOf(((PackagingNode)((Object)this.getParent())).getPathId()) + "/" + node.getId());
                node.setViewer((Viewer)this.getViewer());
                nodes.add(node);
                this.getItemIdToNodesMap().put(definition.getItemId().getUuidValue(), node);
            }
            if (!nodes.isEmpty()) {
                this.addNodesToViewer(this.getParent(), nodes.toArray());
            }
        }
    }
}

