/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui.jfs.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.automation.internal.ui.actions.OpenBrowserAction;
import com.ibm.team.enterprise.automation.internal.ui.view.IBindingSelection;
import com.ibm.team.enterprise.automation.internal.ui.view.IDefaultActionHandlerAction;
import com.ibm.team.enterprise.automation.internal.ui.view.Util;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.internal.build.client.packaging.IBMiPackageHtmlTranslator;
import com.ibm.team.enterprise.internal.build.client.packaging.ZOSPackageHtmlTranslator;
import com.ibm.team.enterprise.packaging.common.jfs.IPackage;
import com.ibm.team.enterprise.packaging.ui.jfs.actions.Messages;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class OpenPackageAction
extends Action
implements IDefaultActionHandlerAction {
    private IBindingSelection bindingSelection;

    public void open() {
        if (this.bindingSelection.getSelectResult() != null) {
            String buildDefinitionUUID = Util.getBindingValue((SelectResult)this.bindingSelection.getSelectResult(), (String)"packageDefinitionUUID");
            String buildResultUUID = Util.getBindingValue((SelectResult)this.bindingSelection.getSelectResult(), (String)"packageResultUUID");
            if (!buildDefinitionUUID.equals("") && !buildResultUUID.equals("")) {
                IPackageJFSClient client = (IPackageJFSClient)this.bindingSelection.getRepository().getClientLibrary(IPackageJFSClient.class);
                try {
                    IPackage pkg = client.getPackage(UUID.valueOf((String)buildResultUUID), UUID.valueOf((String)buildDefinitionUUID));
                    IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefinitionUUID), null);
                    IBuildDefinition definition = (IBuildDefinition)this.bindingSelection.getRepository().itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, null);
                    String templateId = definition.getProperty("com.ibm.team.build.internal.template.id").getValue();
                    String htmlContent = templateId.equals("com.ibm.team.enterprise.packaging.nonseq.zos") ? new ZOSPackageHtmlTranslator().translate(pkg) : new IBMiPackageHtmlTranslator().translate(pkg);
                    new OpenBrowserAction().open(NLS.bind((String)Messages.OpenPackageAction_DIALOG_TITLE, (Object)pkg.getLabel()), htmlContent);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void aboutToOpen(IBindingSelection bindingSelection) {
        this.bindingSelection = bindingSelection;
    }

    public void init(Shell shell) {
    }
}

