/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.enterprise.automation.internal.ui.view.ISelectResultInput;
import com.ibm.team.enterprise.automation.internal.ui.view.SelectResultView;
import com.ibm.team.enterprise.automation.internal.ui.view.Util;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.packaging.internal.ui.PackageSelectResultInput;
import com.ibm.team.enterprise.packaging.ui.PackagingDefinitionQueryNode;
import com.ibm.team.enterprise.packaging.ui.actions.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class ShowAllPackagesAction
extends Action {
    private ISelection selection;

    public ShowAllPackagesAction(ISelection selection, Shell shell) {
        this.setText(Messages.ShowAllPackagesAction_LABEL);
        this.selection = selection;
    }

    public void run() {
        Object object;
        if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty() && (object = ((IStructuredSelection)this.selection).getFirstElement()) instanceof PackagingDefinitionQueryNode) {
            BuildQueryByDefinition queryByType = (BuildQueryByDefinition)((PackagingDefinitionQueryNode)((Object)object)).getQuery();
            final IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)queryByType.getBuildDefinitionHandles().get(0);
            final ITeamRepository repository = ((PackagingDefinitionQueryNode)((Object)object)).getTeamRepository();
            final IPackageJFSClient client = (IPackageJFSClient)repository.getClientLibrary(IPackageJFSClient.class);
            final SelectResultView view = Util.openQueryView();
            view.setInput(null);
            Job job = new Job(Messages.ShowAllPackagesAction_JOB_NAME){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        List results = client.queryAllPackages(buildDefinitionHandle.getItemId());
                        final PackageSelectResultInput input = new PackageSelectResultInput(results, repository);
                        UIJob uiJob = new UIJob(Messages.ShowAllPackagesAction_JOB_UI_UPDATE_NAME){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                view.setInput((ISelectResultInput)input);
                                return Status.OK_STATUS;
                            }
                        };
                        uiJob.schedule();
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

