/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.enterprise.packaging.dialogs.RequestPackagingDialog;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.PackagingDefinitionQueryNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class RequestPackagingAction
extends Action {
    private final IStructuredSelection fSelection;
    private final Shell fShell;

    public RequestPackagingAction(IStructuredSelection selection, Shell shell, boolean showIcon) {
        ValidationHelper.validateNotNull((String)"selection", (Object)selection);
        ValidationHelper.validateNotNull((String)"shell", (Object)shell);
        this.fSelection = selection;
        this.fShell = shell;
        this.setText(this.getActionText());
        this.setToolTipText(this.getActionText());
        if (showIcon) {
            this.setImageDescriptor(BuildUIPlugin.getImageDescriptor((String)"icons/elcl16/rquebuild.gif"));
        }
        this.setEnabled(true);
    }

    protected String getActionText() {
        return Messages.PackageDefinitionActionHelper_CREATE_PACKAGE;
    }

    public void run() {
        IBuildDefinitionHandle buildDefinition = null;
        IStructuredSelection selection = this.getSelection();
        if (selection.getFirstElement() instanceof PackagingDefinitionQueryNode) {
            PackagingDefinitionQueryNode node = (PackagingDefinitionQueryNode)((Object)selection.getFirstElement());
            BuildQueryByDefinition queryByType = (BuildQueryByDefinition)node.getQuery();
            buildDefinition = (IBuildDefinitionHandle)queryByType.getBuildDefinitionHandles().get(0);
        }
        RequestPackagingDialog dialog = this.createDialog(this.getShell(), buildDefinition);
        dialog.open();
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected RequestPackagingDialog createDialog(Shell shell, IBuildDefinitionHandle buildDefinition) {
        return new RequestPackagingDialog(shell, buildDefinition);
    }
}

