/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui.actions;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.views.query.ShowHistoryAction;
import com.ibm.team.enterprise.automation.common.internal.summary.NodeFactory;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IPackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.WorkItemPackagingWizard;
import com.ibm.team.enterprise.packaging.ui.PackagingDefinitionQueryNode;
import com.ibm.team.enterprise.packaging.ui.actions.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class PackageWIAction
implements IAction {
    private final Shell shell;
    private final IStructuredSelection selection;

    public PackageWIAction(Shell shell, IStructuredSelection selection) {
        this.shell = shell;
        this.selection = selection;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
    }

    public int getAccelerator() {
        return 0;
    }

    public String getActionDefinitionId() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return null;
    }

    public HelpListener getHelpListener() {
        return null;
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return null;
    }

    public String getId() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IMenuCreator getMenuCreator() {
        return null;
    }

    public int getStyle() {
        return 0;
    }

    public String getText() {
        return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemDialog_ACTION_TITLE;
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isChecked() {
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
    }

    public void run() {
        WorkItemPackagingWizard wizard = new WorkItemPackagingWizard(this.selection);
        WizardDialog wizardDialog = new WizardDialog(this.shell, (IWizard)wizard);
        wizardDialog.create();
        if (wizardDialog.open() == 1) {
            return;
        }
        final IPackagingWizardConfiguration config = wizard.getConfiguration();
        if (config != null) {
            final boolean includeWorkItemChildren = config.isIncludeChildren();
            final boolean includeImpactedObjects = config.isIncludeImpactedObjects();
            final List selectedHandles = config.getSelectionResult();
            String workItemPackagingString = config.getPackageType();
            final boolean workItemPackaging = "workitem".equals(workItemPackagingString);
            ITeamRepository targetRepository = config.getTeamRepository();
            final IPackagingClient packagingClient = (IPackagingClient)targetRepository.getClientLibrary(IPackagingClient.class);
            Object selectedElement = this.selection.getFirstElement();
            final IBuildDefinition packagingDefinition = selectedElement instanceof PackagingDefinitionQueryNode ? ((PackagingDefinitionQueryNode)((Object)this.selection.getFirstElement())).getBuildDefinition() : (IBuildDefinition)config.getChosenDefinition().getWorkingCopy();
            List oringinalBuildProperties = packagingDefinition.getProperties();
            List<IBuildProperty> workingCopyBuildProperties = wizard.getWorkingCopyProperties();
            Vector<IBuildProperty> deletedBuildProperties = new Vector<IBuildProperty>();
            boolean hasIncludeShiplist = false;
            if (oringinalBuildProperties != null) {
                for (IBuildProperty originalProperty : oringinalBuildProperties) {
                    boolean deleted = true;
                    if (!hasIncludeShiplist && originalProperty.getName().equals("team.package.common.include.binaries") && !"".equals(originalProperty.getValue())) {
                        hasIncludeShiplist = true;
                    }
                    if (!hasIncludeShiplist && originalProperty.getName().equals("team.package.common.include.hfs.binaries") && !"".equals(originalProperty.getValue())) {
                        hasIncludeShiplist = true;
                    }
                    for (IBuildProperty newProperty : workingCopyBuildProperties) {
                        if (!newProperty.getName().equals(originalProperty.getName())) continue;
                        deleted = false;
                        break;
                    }
                    if (!deleted) continue;
                    deletedBuildProperties.add(originalProperty);
                }
                IBuildProperty includeHFSProperty = null;
                IBuildProperty excludeHFSProperty = null;
                for (IBuildProperty newProperty : workingCopyBuildProperties) {
                    if (newProperty.getName().equals("team.package.common.include.binaries") && config.getIncludeShiplist() != null) {
                        newProperty.setValue(config.getIncludeShiplist());
                        hasIncludeShiplist = true;
                        continue;
                    }
                    if (newProperty.getName().equals("team.package.common.exclude.binaries") && config.getExcludeShiplist() != null) {
                        newProperty.setValue(config.getExcludeShiplist());
                        continue;
                    }
                    if (newProperty.getName().equals("team.package.common.include.hfs.binaries")) {
                        includeHFSProperty = newProperty;
                        continue;
                    }
                    if (newProperty.getName().equals("team.package.common.exclude.hfs.binaries")) {
                        excludeHFSProperty = newProperty;
                        continue;
                    }
                    if (newProperty.getName().equals("team.package.restore.mapping") && config.getContainerMappings() != null) {
                        newProperty.setValue(config.getContainerMappings());
                        continue;
                    }
                    if (!newProperty.getName().equals("team.package.common.packageBinariesSinceTimestamp") || workItemPackaging || config.getTimestamp() == null) continue;
                    newProperty.setValue(config.getTimestamp());
                }
                if (config.getIncludeHFSShiplist() != null) {
                    hasIncludeShiplist = true;
                    if (includeHFSProperty == null) {
                        includeHFSProperty = BuildItemFactory.createBuildProperty((String)"team.package.common.include.hfs.binaries", (String)config.getIncludeHFSShiplist());
                        workingCopyBuildProperties.add(includeHFSProperty);
                    } else {
                        includeHFSProperty.setValue(config.getIncludeHFSShiplist());
                    }
                }
                if (config.getExcludeHFSShiplist() != null) {
                    if (excludeHFSProperty == null) {
                        excludeHFSProperty = BuildItemFactory.createBuildProperty((String)"team.package.common.exclude.hfs.binaries", (String)config.getExcludeHFSShiplist());
                        workingCopyBuildProperties.add(excludeHFSProperty);
                    } else {
                        excludeHFSProperty.setValue(config.getExcludeHFSShiplist());
                    }
                }
            }
            workingCopyBuildProperties.add(BuildItemFactory.createBuildProperty((String)"team.package.common.preview", (String)Boolean.toString(config.getIsPreviewMode())));
            String ucdVersionNamePrompt = config.getUcdVersionNamePrompt();
            if (ucdVersionNamePrompt != null && !"".equals(ucdVersionNamePrompt.trim())) {
                workingCopyBuildProperties.add(BuildItemFactory.createBuildProperty((String)"team.package.ucd.versionName.prompt", (String)ucdVersionNamePrompt));
            }
            if (config.getIsPreviewMode()) {
                workingCopyBuildProperties.add(BuildItemFactory.createBuildProperty((String)"buildLabelPrefix", (String)(String.valueOf(Messages.PreviewPackage_BUILD_LABEL) + " ")));
            }
            final IBuildProperty[] newProperties = workingCopyBuildProperties.toArray(new IBuildProperty[0]);
            final IBuildProperty[] deletedProperties = deletedBuildProperties.toArray(new IBuildProperty[0]);
            try {
                IWorkbenchWindow window;
                if (!hasIncludeShiplist) {
                    if (workItemPackaging) {
                        if (!config.skipWISummary()) {
                            String xmlContent = packagingClient.getWorkItemPackagingSummary2(selectedHandles.toArray(new IWorkItemHandle[selectedHandles.size()]), new String[]{Boolean.toString(config.isIncludeChildren()), Boolean.toString(config.isIncludeImpactedObjects())}, packagingDefinition, null);
                            if (!NodeFactory.getInstance().hasOutputs(xmlContent)) {
                                throw new TeamRepositoryException(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingWorkItemWizardPage_NO_OUTPUTS_FOUND_TO_PACKAGE_EMPTY_WORKITEMS);
                            }
                        }
                    } else {
                        throw new TeamRepositoryException(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingWorkItemWizardPage_NO_OUTPUTS_FOUND_TO_PACKAGE_EMPTY_SHIPLIST);
                    }
                }
                final IWorkbenchPage activePage = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null ? window.getActivePage() : null;
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                service.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IBuildProperty[] internalProperties;
                            IWorkItemHandle[] workItemHandles;
                            IWorkItemHandle wiHandle;
                            if (selectedHandles != null && (wiHandle = packagingClient.createPackageFromWorkItems2(workItemHandles = selectedHandles.toArray(new IWorkItemHandle[selectedHandles.size()]), (IBuildDefinitionHandle)packagingDefinition, internalProperties = new IBuildProperty[]{BuildItemFactory.createBuildProperty((String)"team.package.common.includeChildrenWorkitem", (String)Boolean.toString(includeWorkItemChildren)), BuildItemFactory.createBuildProperty((String)"team.package.common.workItemPackaging", (String)Boolean.toString(workItemPackaging)), BuildItemFactory.createBuildProperty((String)"team.enterprise.packaging.includeImpactedObjects", (String)Boolean.toString(includeImpactedObjects))}, newProperties, deletedProperties, monitor)) != null && config.isOpenReportWorkItem() && activePage != null) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        WorkItemUI.openEditor((IWorkbenchPage)activePage, (Object)wiHandle);
                                    }
                                });
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                IProcessArea processArea = (IProcessArea)targetRepository.itemManager().fetchCompleteItem((IItemHandle)packagingDefinition.getProcessArea(), 0, (IProgressMonitor)new NullProgressMonitor());
                this.showBuildsView(processArea.getProjectArea(), packagingDefinition);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.shell, (String)com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemDialog_ERROR_TITLE, (String)e.getTargetException().getLocalizedMessage());
            }
            catch (TeamRepositoryException e) {
                MessageDialog.openError((Shell)this.shell, (String)com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemDialog_ERROR_TITLE, (String)e.getLocalizedMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void showBuildsView(IProjectAreaHandle projectAreaHandle, IBuildDefinition buildDefinition) {
        IWorkbenchPage page;
        Boolean showPersonalBuilds = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ShowHistoryAction action = new ShowHistoryAction(buildDefinition, showPersonalBuilds);
            action.run();
        }
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void setAccelerator(int keycode) {
    }

    public void setActionDefinitionId(String id) {
    }

    public void setChecked(boolean checked) {
    }

    public void setDescription(String text) {
    }

    public void setDisabledImageDescriptor(ImageDescriptor newImage) {
    }

    public void setEnabled(boolean enabled) {
    }

    public void setHelpListener(HelpListener listener) {
    }

    public void setHoverImageDescriptor(ImageDescriptor newImage) {
    }

    public void setId(String id) {
    }

    public void setImageDescriptor(ImageDescriptor newImage) {
    }

    public void setMenuCreator(IMenuCreator creator) {
    }

    public void setText(String text) {
    }

    public void setToolTipText(String text) {
    }
}

