/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.PackagingDefinitionQueryNode;
import com.ibm.team.enterprise.packaging.ui.actions.PackageWIAction;
import com.ibm.team.enterprise.packaging.ui.actions.RequestPackagingAction;
import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class CreatePackageAction
extends Action {
    private final IStructuredSelection fSelection;
    private final Shell fShell;

    public CreatePackageAction(IStructuredSelection selection, Shell shell, boolean showIcon) {
        ValidationHelper.validateNotNull((String)"selection", (Object)selection);
        ValidationHelper.validateNotNull((String)"shell", (Object)shell);
        this.fSelection = selection;
        this.fShell = shell;
        this.setText(this.getActionText());
        this.setToolTipText(this.getActionText());
        if (showIcon) {
            this.setImageDescriptor(BuildUIPlugin.getImageDescriptor((String)"icons/elcl16/rquebuild.gif"));
        }
        this.setEnabled(true);
    }

    protected String getActionText() {
        return Messages.PackageDefinitionActionHelper_CREATE_PACKAGE;
    }

    public void run() {
        IBuildDefinitionHandle buildDefinitionHandle = null;
        IStructuredSelection selection = this.getSelection();
        if (selection.getFirstElement() instanceof PackagingDefinitionQueryNode) {
            try {
                String templateId;
                PackagingDefinitionQueryNode node = (PackagingDefinitionQueryNode)((Object)selection.getFirstElement());
                BuildQueryByDefinition queryByType = (BuildQueryByDefinition)node.getQuery();
                buildDefinitionHandle = (IBuildDefinitionHandle)queryByType.getBuildDefinitionHandles().get(0);
                IBuildDefinition buildDefinition = (IBuildDefinition)node.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, (IProgressMonitor)new NullProgressMonitor());
                Object action = null;
                IBuildProperty workItemProperty = buildDefinition.getProperty("team.package.common.workitem.option");
                String workItemOption = null;
                if (workItemProperty != null) {
                    workItemOption = workItemProperty.getValue();
                }
                action = (templateId = buildDefinition.getProperty("com.ibm.team.build.internal.template.id").getValue()).equals("com.ibm.team.enterprise.packaging.nonseq.zos") || templateId.equals("com.ibm.team.enterprise.packaging.nonseq.ibmi") || workItemOption != null && workItemOption.equals("true") && templateId != null && templateId.equals("com.ibm.team.enterprise.packaging.zos") ? new PackageWIAction(this.fShell, this.fSelection) : new RequestPackagingAction(this.fSelection, this.fShell, false);
                action.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected Shell getShell() {
        return this.fShell;
    }
}

