/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class TimestampPackageRequestBuildSection
extends RequestBuildSection {
    private static final String ibmiDef = "com.ibm.team.enterprise.packaging.ibmi";
    private static final String luwDef = "com.ibm.team.enterprise.packaging.luw";
    private static final String templateDefPropertyId = "com.ibm.team.build.internal.template.id";
    private static final int MAX_NUM_BUILD_RESULTS = 5;
    private Composite fTimestampPackageOptionsComposite;
    private Text fShipListFilterText;
    private Combo fLastPackageTimestampCombo;
    private String shipListFilter = "";
    private String packageTimestamp = "";
    private String[] previousPackageTimestamps = null;

    public TimestampPackageRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
    }

    protected String getSectionName() {
        return Messages.TIMESTAMP_PACKAGE_OPTIONS_SECTION_TITLE;
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        ((GridData)this.getSection().getLayoutData()).exclude = true;
        this.getSection().setVisible(false);
    }

    protected void createSectionContent(Section section) {
        if (this.fTimestampPackageOptionsComposite != null && !this.fTimestampPackageOptionsComposite.isDisposed()) {
            this.fTimestampPackageOptionsComposite.dispose();
        }
        this.fTimestampPackageOptionsComposite = new Composite((Composite)section, 0);
        this.fTimestampPackageOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 10;
        this.fTimestampPackageOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.fTimestampPackageOptionsComposite);
        if (this.isPackageDefinition()) {
            ((GridData)this.getSection().getLayoutData()).exclude = false;
            this.getSection().setVisible(this.isVisible());
            Label label = new Label(this.fTimestampPackageOptionsComposite, 64);
            label.setText(Messages.SHIP_LIST_FILE_LABEL);
            GridData gridData = new GridData(768);
            label.setLayoutData((Object)gridData);
            this.fShipListFilterText = new Text(this.fTimestampPackageOptionsComposite, 2048);
            GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).applyTo((Control)this.fShipListFilterText);
            this.fShipListFilterText.setText(this.shipListFilter);
            this.fShipListFilterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TimestampPackageRequestBuildSection.this.shipListFilter = TimestampPackageRequestBuildSection.this.fShipListFilterText.getText();
                    TimestampPackageRequestBuildSection.this.getSite().revalidate();
                }
            });
            label = new Label(this.fTimestampPackageOptionsComposite, 64);
            label.setText(Messages.PACKAGE_BINARIES_NEWER_THAN_TIMESTAMP_LABEL);
            gridData = new GridData(768);
            label.setLayoutData((Object)gridData);
            this.fLastPackageTimestampCombo = new Combo(this.fTimestampPackageOptionsComposite, 2052);
            GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).applyTo((Control)this.fLastPackageTimestampCombo);
            this.fLastPackageTimestampCombo.setItems(this.previousPackageTimestamps);
            this.fLastPackageTimestampCombo.pack();
            this.fLastPackageTimestampCombo.select(0);
            this.fLastPackageTimestampCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TimestampPackageRequestBuildSection.this.packageTimestamp = TimestampPackageRequestBuildSection.this.fLastPackageTimestampCombo.getText();
                    TimestampPackageRequestBuildSection.this.getSite().revalidate();
                }
            });
            this.getSection().setExpanded(true);
        }
    }

    private boolean isVisible() {
        String templateId;
        boolean isVisible = false;
        IBuildDefinition buildDef = this.getSite().getBuildDefinition();
        IBuildProperty property = buildDef.getProperty(templateDefPropertyId);
        if (property != null && (templateId = property.getValue()) != null && templateId.equals(luwDef)) {
            isVisible = true;
        }
        return isVisible;
    }

    public void initialize(IProgressMonitor monitor) throws Exception {
        if (this.isPackageDefinition()) {
            if (this.getSite().isRebuild()) {
                this.shipListFilter = this.getShipListFilterPathFromPreviousPackageDefinitionResult(this.getSite().getBuildRequest());
                this.packageTimestamp = this.getPackageBinariesSinceTimestampFrompreviousPackageDefinitionResult(this.getSite().getBuildRequest());
            } else {
                this.shipListFilter = this.getShipListFilterPathFromPackageDefinition(this.getSite().getBuildDefinition());
                this.previousPackageTimestamps = this.getPackageTimestampsFromPreviousPackageDefinitionResult(this.getSite().getBuildRequest(), false, monitor);
                this.packageTimestamp = this.previousPackageTimestamps.length > 0 ? this.previousPackageTimestamps[0] : "";
            }
        }
    }

    protected String getShipListFilterPathFromPackageDefinition(IBuildDefinition buildDefinition) {
        String packageDefShipListFilterPath = "";
        IBuildProperty property = buildDefinition.getProperty("team.package.common.shiplistFilePath");
        if (property != null) {
            packageDefShipListFilterPath = property.getValue();
        }
        return packageDefShipListFilterPath;
    }

    protected String getShipListFilterPathFromPreviousPackageDefinitionResult(IBuildRequest buildRequest) {
        String packageDefShipListFilterPath = "";
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty property = instance.getProperty("team.package.common.shiplistFilePath");
        if (property != null) {
            packageDefShipListFilterPath = property.getValue();
        }
        return packageDefShipListFilterPath;
    }

    protected String getPackageBinariesSinceTimestampFrompreviousPackageDefinitionResult(IBuildRequest buildRequest) {
        String packageBinariesSinceTimestamp = "";
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty property = instance.getProperty("team.package.common.packageBinariesSinceTimestamp");
        if (property != null) {
            packageBinariesSinceTimestamp = property.getValue();
        }
        return packageBinariesSinceTimestamp;
    }

    protected String[] getPackageTimestampsFromPreviousPackageDefinitionResult(IBuildRequest buildRequest, boolean includePersonalBuilds, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<String> timestamps = new ArrayList<String>();
        IBuildDefinition buildDefinition = this.getSite().getBuildDefinition();
        ITeamRepository teamRepository = this.getSite().getTeamRepository();
        BuildState[] buildStates = new BuildState[]{BuildState.COMPLETED};
        ITeamBuildRecordClient teamRecordBuildClient = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        IBuildResultRecordIterator buildResultRecords = teamRecordBuildClient.getBuildResultRecords(new IBuildDefinitionHandle[]{buildDefinition}, buildStates, IBuildResult.PROPERTIES_VIEW_ITEM, monitor);
        int i = 0;
        while (buildResultRecords.hasNext() && i < 5) {
            IBuildResultRecord buildResultRecord = buildResultRecords.next(monitor);
            if (buildResultRecord != null && buildResultRecord.getBuildResult() != null && buildResultRecord.getBuildResult().getStatus() != null && buildResultRecord.getBuildResult().getStatus() != BuildStatus.ERROR) {
                IBuildResult buildResult = buildResultRecord.getBuildResult();
                timestamps.add(buildResult.getLabel());
            }
            ++i;
        }
        return timestamps.toArray(new String[timestamps.size()]);
    }

    protected boolean isPackageDefinition() {
        String templateId;
        IBuildProperty property;
        IBuildDefinition buildDef = this.getSite().getBuildDefinition();
        return buildDef != null && (property = buildDef.getProperty(templateDefPropertyId)) != null && (templateId = property.getValue()) != null && (templateId.equals(ibmiDef) || templateId.equals(luwDef)) && buildDef.getConfigurationElement("com.ibm.team.enterprise.packaging") != null;
    }

    public String validate() {
        if (this.fShipListFilterText != null && this.fShipListFilterText.getText().trim().length() == 0) {
            return Messages.SHIPLIST_FILTER_PATH_ERROR_MESSAGE;
        }
        return null;
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        if (this.isPackageDefinition()) {
            buildDefinition.setProperty("team.package.common.shiplistFilePath", this.shipListFilter);
            buildDefinition.setProperty("team.package.common.packageBinariesSinceTimestamp", this.packageTimestamp);
        }
    }
}

