/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

public class PackagingOptionsRequestBuildSection
extends RequestBuildSection {
    private static final String ibmiDef = "com.ibm.team.enterprise.packaging.ibmi";
    private static final String zOSDef = "com.ibm.team.enterprise.packaging.zos";
    private static final String luwDef = "com.ibm.team.enterprise.packaging.luw";
    private static final String templateDefPropertyId = "com.ibm.team.build.internal.template.id";
    private static final String versionProperty = "team.package.common.definition.version";
    private static final String shiplistProperty = "team.package.common.shiplist.option";
    private Composite fPackageOptionsComposite;
    Button openSummaryWorkItemButton;
    Boolean openSummaryWorkItem;

    public PackagingOptionsRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
    }

    protected String getSectionName() {
        return Messages.PACKAGE_OPTIONS_SECTION_TITLE;
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        ((GridData)this.getSection().getLayoutData()).exclude = true;
        this.getSection().setVisible(false);
    }

    protected void createSectionContent(Section section) {
        if (this.fPackageOptionsComposite != null && !this.fPackageOptionsComposite.isDisposed()) {
            this.fPackageOptionsComposite.dispose();
        }
        this.fPackageOptionsComposite = new Composite((Composite)section, 0);
        this.fPackageOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 10;
        this.fPackageOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.fPackageOptionsComposite);
        if (this.isPackageDefinition()) {
            ((GridData)this.getSection().getLayoutData()).exclude = false;
            this.getSection().setVisible(true);
            this.openSummaryWorkItemButton = new Button(this.fPackageOptionsComposite, 32);
            this.openSummaryWorkItemButton.setText(Messages.OPEN_SUMMARY_WORK_ITEM);
            this.openSummaryWorkItemButton.setLayoutData((Object)new GridData(768));
            this.openSummaryWorkItem = Boolean.parseBoolean(this.getSite().getBuildDefinition().getProperty("team.package.common.openSummaryWorkItem").getValue());
            this.openSummaryWorkItemButton.setSelection(this.openSummaryWorkItem.booleanValue());
            this.openSummaryWorkItemButton.addSelectionListener(this.getSummaryWorkItemListener());
            this.getSection().setExpanded(true);
            this.loadPreference();
        }
    }

    private void loadPreference() {
        IBuildDefinition buildDefinitionWorkingCopy = (IBuildDefinition)this.getSite().getBuildDefinition().getWorkingCopy();
        String typeOpenSummary = PackagingUIPlugin.getDefault().getPreferenceStore().getString("openSummaryWI" + buildDefinitionWorkingCopy.getId());
        if (typeOpenSummary != null) {
            this.openSummaryWorkItem = Boolean.parseBoolean(typeOpenSummary);
            this.openSummaryWorkItemButton.setSelection(this.openSummaryWorkItem.booleanValue());
        }
    }

    protected SelectionListener getSummaryWorkItemListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingOptionsRequestBuildSection.this.openSummaryWorkItem = PackagingOptionsRequestBuildSection.this.openSummaryWorkItemButton.getSelection();
                PackagingUIPlugin.getDefault().getPreferenceStore().setValue("openSummaryWI" + ((IBuildDefinition)PackagingOptionsRequestBuildSection.this.getSite().getBuildDefinition().getWorkingCopy()).getId(), PackagingOptionsRequestBuildSection.this.openSummaryWorkItem.booleanValue());
            }
        };
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        if (this.isPackageDefinition()) {
            buildDefinition.setProperty("team.package.common.openSummaryWorkItem", Boolean.toString(this.openSummaryWorkItem));
        }
    }

    protected boolean isPackageDefinition() {
        IBuildDefinition buildDef = this.getSite().getBuildDefinition();
        if (buildDef != null) {
            IBuildProperty property = buildDef.getProperty(templateDefPropertyId);
            IBuildProperty property2 = buildDef.getProperty(shiplistProperty);
            if (property != null && property2 != null) {
                String version;
                String templateId = property.getValue();
                String shiplistOption = property2.getValue();
                if (templateId != null && (templateId.equals(ibmiDef) || templateId.equals(luwDef) || templateId.equals(zOSDef) && Boolean.parseBoolean(shiplistOption)) && buildDef.getConfigurationElement("com.ibm.team.enterprise.packaging") != null && (property = buildDef.getProperty(versionProperty)) != null && (version = property.getValue()) != null) {
                    return version.compareTo("3.0.0") > 0;
                }
            }
        }
        return false;
    }
}

