/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.enterprise.automation.ui.AbstractAutomationNode;
import com.ibm.team.enterprise.automation.ui.AutomationDefinitionQueryNode;
import com.ibm.team.enterprise.automation.ui.AutomationUtil;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.PackagingDefinitionQueryNode;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import com.ibm.team.enterprise.packaging.ui.listeners.PackagingNodeChangeListener;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class PackagingNode
extends AbstractAutomationNode {
    public static final String DEPLOYMENT_PACKAGE_OPERATION_ID = "com.ibm.teamz.deployment.package";

    public String getLabel() {
        return Messages.PACKAGES_NODE_LABEL;
    }

    public Image getIcon() {
        return PackagingUIPlugin.getImage("icons/obj16/packages_obj.gif");
    }

    protected AutomationDefinitionQueryNode createAutomationDefinitionQueryNode(ITeamRepository repository, IBuildDefinitionStatusRecord record) {
        return new PackagingDefinitionQueryNode(repository, record);
    }

    public boolean includeBuildDefinition(IBuildDefinition definition) {
        return AutomationUtil.getInstance().includeExistingDefinition(definition, "com.ibm.team.enterprise.packaging");
    }

    protected String[] getOperationIds() {
        return new String[]{DEPLOYMENT_PACKAGE_OPERATION_ID};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDefinitionListeners(IProjectAreaHandle projectAreaHandle, List<BuildDefinitionQueryNode> nodes) {
        PackagingNodeChangeListener packagingChangeListener = new PackagingNodeChangeListener((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider(), projectAreaHandle, this, nodes);
        PackagingNode packagingNode = this;
        synchronized (packagingNode) {
            ((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider()).addPackagingListener(projectAreaHandle, (AbstractBuildDefinitionChangeListener)packagingChangeListener);
        }
        this.addDefinitionItemListener(projectAreaHandle, packagingChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDefinitionListeners(IProjectAreaHandle projectAreaHandle) {
        PackagingNodeChangeListener oldPackagingChangeListener;
        PackagingNode packagingNode = this;
        synchronized (packagingNode) {
            oldPackagingChangeListener = (PackagingNodeChangeListener)((EnterpriseExtensionsDomainContentProvider)this.getDomain().getContentProvider()).removePackagingListener(projectAreaHandle);
        }
        if (oldPackagingChangeListener != null) {
            this.removeDefinitionItemListener(projectAreaHandle, oldPackagingChangeListener);
        }
    }

    private void addDefinitionItemListener(IProjectAreaHandle projectAreaHandle, PackagingNodeChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    private void removeDefinitionItemListener(IProjectAreaHandle projectAreaHandle, PackagingNodeChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }
}

