/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui;

import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.automation.ui.table.IAutomationObjectsNode;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.PackagedObjectsIBMiTree;
import com.ibm.team.enterprise.packaging.ui.PackagedObjectsUnixTree;
import com.ibm.team.enterprise.packaging.ui.PackagedObjectsZTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class PackagedObjectsPage
extends BuildResultPage {
    private final IBuildResultContribution[] fContributions;
    private final IBuildResultContribution summaryContribution;
    ITeamRepository repository;
    private final IProgressMonitor monitor;
    private boolean isZosWorkItemPackaging = false;

    public PackagedObjectsPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext, IBuildResultContribution[] fContributions, IBuildResultContribution summaryContribution, IProgressMonitor monitor, boolean isZosWorkItemPackaging) {
        super(editor, id, title, contributionIds, buildResultContext);
        this.fContributions = fContributions;
        this.summaryContribution = summaryContribution;
        this.monitor = monitor;
        this.isZosWorkItemPackaging = isZosWorkItemPackaging;
        this.repository = this.getBuildResultContext().getTeamRepository();
    }

    protected void doCreatePageContent(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.addSummary(parent, toolkit);
        this.addPackagedObjectsControl(parent, toolkit);
    }

    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.ADDITIONS;
    }

    private void addSummary(Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        section.setText(Messages.PackagedObjectsPage_SUMMARY_TITLE);
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.createSummaryLabel(composite, Messages.PackagedObjectsPage_PACKAGE_LABEL, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_LABEL), toolkit);
        this.createSummaryLabel(composite, Messages.PackagedObjectsPage_APPLICATION_NAME, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME), toolkit);
        this.createSummaryLabel(composite, Messages.PackagedObjectsPage_VERSION, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION), toolkit);
        this.createSummaryLabel(composite, Messages.PackagedObjectsPage_APPLICATION_DESCRIPTION, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_DESCRIPTION), toolkit);
        this.createSummaryLabel(composite, Messages.PackagedObjectsPage_HOSTNAME, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_HOST_NAME), toolkit);
        this.createSummaryLabel(composite, Messages.PackagedObjectsPage_PACKAGE_DIR, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_PACKAGE_DIR), toolkit);
        String timestamp = this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_TIMESTAMP);
        String formatedTime = timestamp == null ? null : TimeFormatHelper.getDateString((long)Long.parseLong(timestamp));
        this.createSummaryLabel(composite, Messages.PackagedObjectsPage_TIMESTAMP, formatedTime, toolkit);
        String summaryWorkItemId = this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM);
        if (summaryWorkItemId == null || summaryWorkItemId.equals("-1")) {
            this.createSummaryLabel(composite, Messages.PackagedObjectsPage_SUMMARY_WORK_ITEM, Messages.PackagedObjectsSummaryPage_SUMMARY_WORK_ITEM_NOT_CREATED, toolkit);
        } else {
            this.createHyperlink(composite, Messages.PackagedObjectsPage_SUMMARY_WORK_ITEM, summaryWorkItemId, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_SUMMARY_WORKITEM_UUID), toolkit);
        }
    }

    private void createHyperlink(Composite parent, String label, String workItemNumber, final String workItemUUID, FormToolkit toolkit) {
        if (workItemNumber != null && workItemUUID != null) {
            toolkit.createLabel(parent, label);
            Hyperlink summaryHyperlink = toolkit.createHyperlink(parent, workItemNumber, 0);
            summaryHyperlink.setEnabled(true);
            summaryHyperlink.setUnderlined(true);
            summaryHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUUID), null);
                    ArrayList<String> properties = new ArrayList<String>();
                    properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
                    properties.add(IWorkItem.ID_PROPERTY);
                    try {
                        IWorkItem workItem = (IWorkItem)PackagedObjectsPage.this.repository.itemManager().fetchPartialItem((IItemHandle)workItemHandle, 0, properties, PackagedObjectsPage.this.monitor);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null) {
                            WorkItemUI.open((IWorkbenchPage)window.getActivePage(), (Object)workItem);
                        }
                    }
                    catch (TeamRepositoryException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
    }

    private void createSummaryLabel(Composite parent, String label, String value, FormToolkit toolkit) {
        if (value == null) {
            return;
        }
        toolkit.createLabel(parent, label);
        toolkit.createLabel(parent, value);
    }

    private void addPackagedObjectsControl(Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        section.setText(Messages.PackagedObjectsContributionProvider_SUMMARY_TITLE);
        Composite outerComposite = toolkit.createComposite((Composite)section);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outerComposite);
        GridLayoutFactory.fillDefaults().applyTo(outerComposite);
        section.setClient((Control)outerComposite);
        if (this.fContributions.length == 0) {
            toolkit.createLabel(outerComposite, Messages.PackagedObjectsTable_NO_OBJECTS_PACKAGED);
        } else if (this.summaryContribution.getLabel().equals("ibmi")) {
            toolkit.createLabel(outerComposite, Messages.PackagedObjectsTable_DOUBLECLICK_MSG);
            PackagedObjectsIBMiTree tree = new PackagedObjectsIBMiTree(toolkit, false, this.fContributions);
            tree.createContents(outerComposite);
            TreeViewer treeViewer = tree.getTreeViewer();
            treeViewer.addDoubleClickListener(this.getDoubleClickListener(treeViewer));
            tree.getTree().setToolTipText(Messages.PackagedObjectsTable_DOUBLECLICK_HOVER_MSG);
        } else if (this.summaryContribution.getLabel().equals("luw")) {
            PackagedObjectsUnixTree tree = new PackagedObjectsUnixTree(toolkit, false, this.fContributions);
            tree.createContents(outerComposite);
        } else if (this.summaryContribution.getLabel().equals("zos")) {
            toolkit.createLabel(outerComposite, Messages.PackagedObjectsTable_DOUBLECLICK_MSG);
            PackagedObjectsZTree tree = new PackagedObjectsZTree(toolkit, this.isZosWorkItemPackaging, this.fContributions);
            tree.createContents(outerComposite);
            TreeViewer treeViewer = tree.getTreeViewer();
            treeViewer.addDoubleClickListener(this.getDoubleClickListener(treeViewer));
            tree.getTree().setToolTipText(Messages.PackagedObjectsTable_DOUBLECLICK_HOVER_MSG);
        }
    }

    private IDoubleClickListener getDoubleClickListener(final TreeViewer treeViewer) {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = treeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                try {
                    IAutomationObjectsNode node;
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IAutomationObjectsNode && (node = (IAutomationObjectsNode)element).getWorkItemUUID() != null) {
                        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)node.getWorkItemUUID()), null);
                        ArrayList<String> properties = new ArrayList<String>();
                        properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
                        properties.add(IWorkItem.ID_PROPERTY);
                        IWorkItem item = (IWorkItem)PackagedObjectsPage.this.repository.itemManager().fetchPartialItem((IItemHandle)workItemHandle, 0, properties, PackagedObjectsPage.this.monitor);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        WorkItemUI.open((IWorkbenchPage)window.getActivePage(), (Object)item);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        };
    }

    protected Viewer getViewer() {
        return null;
    }
}

