/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.ui;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.enterprise.automation.common.resultcontributions.AutomationResultContribution;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.PackagedObjectsPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

public class PackagedObjectContributionProvider
extends AbstractBuildResultContributionProvider {
    private IBuildResultContribution[] fContributions;
    private IBuildResultContribution summaryContribution;
    private IProgressMonitor monitor;
    private boolean isZosWorkItemPackaging = false;

    public PackagedObjectContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fContributions = this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.PACKAGED_OBJECT_EXTENDED_CONTRIBUTION_ID});
        IBuildResultContribution[] workItemContributions = this.getBuildResultContext().getBuildResultContributions(new String[]{"fixedWorkItems"});
        if (workItemContributions != null && workItemContributions.length > 0) {
            this.isZosWorkItemPackaging = true;
        }
        if (this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.PACKAGING_OVERVIEW_EXTENDED_CONTRIBUTION_ID}).length > 0) {
            this.summaryContribution = this.getBuildResultContext().getBuildResultContributions(new String[]{AutomationResultContribution.PACKAGING_OVERVIEW_EXTENDED_CONTRIBUTION_ID})[0];
        }
        this.monitor = monitor;
    }

    public String[] getExtendedContributionIds() {
        return new String[]{AutomationResultContribution.PACKAGED_OBJECT_EXTENDED_CONTRIBUTION_ID, AutomationResultContribution.PACKAGING_OVERVIEW_EXTENDED_CONTRIBUTION_ID};
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public boolean isSummaryLink() {
        return this.summaryContribution != null;
    }

    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    public String getSummaryTitle() {
        return Messages.PackagedObjects_SUMMARY_TITLE;
    }

    public String getSummaryText() {
        if (this.fContributions.length > 1) {
            if (this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME) != null) {
                return NLS.bind((String)Messages.PackagedObjectsContributionProvider_SUMMARY_TEXT_MULTIPLE_CONTRIBUTIONS, (Object[])new Object[]{this.fContributions.length, this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME), this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION)});
            }
            return NLS.bind((String)Messages.PackagedObjectsContributionProvider_SUMMARY_TEXT_MULTIPLE_CONTRIBUTIONS_NO_APPNAME, (Object[])new Object[]{this.fContributions.length});
        }
        if (this.fContributions.length == 1) {
            if (this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME) != null) {
                return NLS.bind((String)Messages.PackagedObjectsContributionProvider_SUMMARY_TEXT_ONE_CONTRIBUTION, (Object)this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_APPLICATION_NAME), (Object)this.summaryContribution.getExtendedContributionProperty(AutomationResultContribution.PROPERTY_NAME_VERSION));
            }
            return Messages.PackagedObjectsContributionProvider_SUMMARY_TEXT_ONE_CONTRIBUTION_NO_APPNAME;
        }
        return Messages.PackagedObjectsContributionProvider_SUMMARY_TEXT_NO_CONTRIBUTION;
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return new PackagedObjectsPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.PackagedObjectsContributionProvider_SUMMARY_TITLE, this.getExtendedContributionIds(), this.getBuildResultContext(), this.fContributions, this.summaryContribution, this.monitor, this.isZosWorkItemPackaging);
    }
}

