/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemAutomationWizard;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IPackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingIncludeShiplistWizardPage;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingRestoreMappingWizardPage;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingTypeSelectionWizardPage;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingWorkItemSummaryWizardPage;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingWorkItemWizardPage;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class WorkItemPackagingWizard
extends AbstractWorkItemAutomationWizard {
    private IPackagingWizardConfiguration configuration;
    private static final String templateDefPropertyId = "com.ibm.team.build.internal.template.id";
    private String fPackageDefinitionTemplateId = null;
    protected IWizardPage packageTypeSelectionPage;
    protected IWizardPage workItemSelectionPage;
    protected IWizardPage packagingSummaryPage;
    protected IWizardPage packageRestMapPage;
    protected IWizardPage packageIncShipPage;
    protected IWizardPage packageExcShipPage;
    private String packageType = "";
    public List<IBuildProperty> workingCopyProperties = new ArrayList<IBuildProperty>();
    protected IStructuredSelection selection;
    IBuildDefinition fBuildDefinitionWorkingCopy;

    public WorkItemPackagingWizard(IStructuredSelection selection) {
        this.init(selection);
        this.setWindowTitle(Messages.PackageWorkItemDialog_DIALOG_TITLE);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        Object firstElement = this.selection.getFirstElement();
        if (firstElement instanceof IWorkItemHandle) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    public IWizardPage getStartingPage() {
        Object firstElement = this.selection.getFirstElement();
        if (firstElement instanceof IWorkItemHandle) {
            IWizardPage[] pages = this.getPages();
            return pages[1];
        }
        return super.getStartingPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.configuration.getChosenDefinition() != null) {
            if (page instanceof PackagingTypeSelectionWizardPage) {
                this.packageType = ((PackagingTypeSelectionWizardPage)page).getPackageType();
                if (this.packageType.equals("workitem")) {
                    return super.getNextPage(page);
                }
                IWizardPage[] pages = this.getPages();
                return pages[3];
            }
            if (this.packageType.equals("workitem")) {
                IWizardPage nextPage = super.getNextPage(page);
                if (nextPage instanceof PackagingWorkItemSummaryWizardPage && this.configuration.skipWISummary()) {
                    nextPage = super.getNextPage(nextPage);
                }
                return nextPage;
            }
            return super.getNextPage(page);
        }
        IWizardPage[] pages = this.getPages();
        return pages[2];
    }

    public boolean canFinish() {
        String promptedVersionName;
        IBuildProperty ucdVersionNameConvention;
        IBuildProperty ucdGenerateProperty;
        this.packageType = this.configuration.getPackageType();
        if (this.fBuildDefinitionWorkingCopy != null && (ucdGenerateProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ucd.generate")) != null && Boolean.valueOf(ucdGenerateProperty.getValue()).booleanValue() && (ucdVersionNameConvention = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ucd.versionName.convention")) != null && ("WORKITEM".equals(ucdVersionNameConvention.getValue()) ? this.configuration.getSelectionResult() == null : "PROMPT".equals(ucdVersionNameConvention.getValue()) && ((promptedVersionName = this.configuration.getUcdVersionNamePrompt()) == null || "".equals(promptedVersionName.trim())))) {
            return false;
        }
        if (this.packageType.equals("shiplist")) {
            IWizardPage[] pages = this.getPages();
            int i = 0;
            while (i < pages.length) {
                IWizardPage page = pages[i];
                if (!(page instanceof PackagingWorkItemWizardPage || page instanceof PackagingWorkItemSummaryWizardPage || page.isPageComplete())) {
                    return false;
                }
                ++i;
            }
        } else {
            return super.canFinish();
        }
        return true;
    }

    public void init(IStructuredSelection selection) {
        Object firstElement;
        this.selection = selection;
        this.configuration = new PackagingWizardConfiguration();
        Object object = firstElement = selection == null ? null : selection.getFirstElement();
        if (firstElement == null || firstElement instanceof IWorkItemHandle) {
            this.configuration.setPackageType("workitem");
        }
    }

    public void addPages() {
        this.packageTypeSelectionPage = this.createPackageTypeSelectionPage();
        this.workItemSelectionPage = this.createWorkItemSelectionPage();
        this.packagingSummaryPage = this.createPackageSummaryPage();
        if (this.configuration.getChosenDefinition() != null) {
            IBuildProperty property;
            this.fBuildDefinitionWorkingCopy = (IBuildDefinition)this.configuration.getChosenDefinition().getWorkingCopy();
            if (this.fBuildDefinitionWorkingCopy != null && (property = this.fBuildDefinitionWorkingCopy.getProperty(templateDefPropertyId)) != null) {
                this.fPackageDefinitionTemplateId = property.getValue();
                if (this.fPackageDefinitionTemplateId.contains("nonseq")) {
                    this.packageRestMapPage = this.createRestoreMappingPage(this.fPackageDefinitionTemplateId);
                    this.packageIncShipPage = this.createIncludeShiplistPage();
                    this.packageExcShipPage = this.createExcludeShiplistPage();
                    this.addPage(this.packageTypeSelectionPage);
                    this.addPage(this.workItemSelectionPage);
                    this.addPage(this.packagingSummaryPage);
                    this.addPage(this.packageRestMapPage);
                    this.addPage(this.packageIncShipPage);
                    this.addPage(this.packageExcShipPage);
                    return;
                }
                this.addPage(this.workItemSelectionPage);
                this.addPage(this.packagingSummaryPage);
                return;
            }
        }
        this.addPage(this.packageTypeSelectionPage);
        this.addPage(this.workItemSelectionPage);
        this.addPage(this.packagingSummaryPage);
    }

    public IWizardPage createExcludeShiplistPage() {
        return new PackagingIncludeShiplistWizardPage(this.getShell(), this.configuration, "exclude");
    }

    public IWizardPage createIncludeShiplistPage() {
        return new PackagingIncludeShiplistWizardPage(this.getShell(), this.configuration, "include");
    }

    protected IWizardPage createRestoreMappingPage(String templateId) {
        return new PackagingRestoreMappingWizardPage(this.getShell(), this.configuration, templateId);
    }

    protected IWizardPage createPackageSummaryPage() {
        return new PackagingWorkItemSummaryWizardPage(this.getShell(), this.configuration);
    }

    protected IWizardPage createWorkItemSelectionPage() {
        return new PackagingWorkItemWizardPage((IWizard)this, this.getShell(), this.selection, this.configuration);
    }

    protected IWizardPage createPackageTypeSelectionPage() {
        return new PackagingTypeSelectionWizardPage(this.getShell(), this.configuration);
    }

    protected IWizardPage getRestoreMapppingPage() {
        return this.packageRestMapPage;
    }

    protected IWizardPage getPackageTypeSelectionPage() {
        return this.packageTypeSelectionPage;
    }

    protected IWizardPage getWorkItemSelectionPage() {
        return this.workItemSelectionPage;
    }

    protected IWizardPage getPackageSummaryPage() {
        return this.packagingSummaryPage;
    }

    protected IWizardPage getPackageIncludeShiplistPage() {
        return this.packageIncShipPage;
    }

    protected IWizardPage getPackageExcludeShiplistPage() {
        return this.packageExcShipPage;
    }

    public IPackagingWizardConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<IBuildProperty> getWorkingCopyProperties() {
        return this.workingCopyProperties;
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof PackagingTypeSelectionWizardPage) {
                Object firstElement = this.selection.getFirstElement();
                if (firstElement instanceof IWorkItemHandle) {
                    this.getConfiguration().setPackageType("workitem");
                }
                PackagingUIPlugin.getDefault().getPreferenceStore().setValue("typeOfPackage" + this.getConfiguration().getChosenDefinition().getId(), this.getConfiguration().getPackageType());
                PackagingUIPlugin.getDefault().getPreferenceStore().setValue("includeChildren" + this.getConfiguration().getChosenDefinition().getId(), this.getConfiguration().isIncludeChildren());
                PackagingUIPlugin.getDefault().getPreferenceStore().setValue("includeImpacted" + this.getConfiguration().getChosenDefinition().getId(), this.getConfiguration().isIncludeImpactedObjects());
                PackagingUIPlugin.getDefault().getPreferenceStore().setValue("openSummaryWI" + this.getConfiguration().getChosenDefinition().getId(), this.getConfiguration().isOpenReportWorkItem());
                PackagingUIPlugin.getDefault().savePluginPreferences();
            } else if (page instanceof PackagingWorkItemWizardPage && this.fPackageDefinitionTemplateId != null && !this.fPackageDefinitionTemplateId.contains("nonseq")) {
                this.getConfiguration().setPackageType("workitem");
            }
            ++n2;
        }
        if (((PackagingTypeSelectionWizardPage)this.packageTypeSelectionPage).returnBuildDefWorkingCopy() != null) {
            for (RequestBuildSection section : ((PackagingTypeSelectionWizardPage)this.packageTypeSelectionPage).getSections()) {
                section.applyProperties(((PackagingTypeSelectionWizardPage)this.packageTypeSelectionPage).returnBuildDefWorkingCopy());
            }
            this.workingCopyProperties.addAll(((PackagingTypeSelectionWizardPage)this.packageTypeSelectionPage).returnBuildDefWorkingCopy().getProperties());
        } else {
            this.workingCopyProperties.addAll(((IBuildDefinition)this.getConfiguration().getChosenDefinition().getWorkingCopy()).getProperties());
        }
        return true;
    }
}

