/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationWorkItemWizardPage;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemChooser;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableContentProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableLabelProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IPackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingIncludeShiplistWizardPage;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingRestoreMappingWizardPage;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingWorkItemChooser;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.WorkItemPackagingWizard;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class PackagingWorkItemWizardPage
extends AbstractAutomationWorkItemWizardPage {
    private final IPackagingWizardConfiguration configuration;
    protected Button includeChildrenButton;
    protected Button includeImpactedOutputs;
    protected Button skipWISummary;
    private WorkItemTableContentProvider fWorkItemTableContentProvider = null;
    private WorkItemTableLabelProvider fWorkItemTableLabelProvider = null;
    private final String workItemType = "packaging";
    private IWizardPage packageRestMapPage;
    private IWizardPage packageIncShipPage;
    private IWizardPage packageExcShipPage;
    private final IWizard wizard;
    private final Shell parent;
    private static final String templateDefPropertyId = "com.ibm.team.build.internal.template.id";
    private IBuildDefinition fBuildDefinitionWorkingCopy;

    public PackagingWorkItemWizardPage(IWizard wizard, Shell parent, IStructuredSelection selection, IPackagingWizardConfiguration config) {
        super(parent, selection, (IAutomationWizardConfiguration)config);
        this.wizard = wizard;
        this.setWorkItemType("packaging");
        this.configuration = config;
        this.parent = parent;
    }

    public void createCustomContentUpper(Composite parent) {
        this.loadWorkingCopy();
        Composite packagingComposite = new Composite(parent, 0);
        packagingComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(5, 0).create());
        packagingComposite.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 0).grab(true, false).create());
        this.includeChildrenButton = new Button(packagingComposite, 32);
        this.includeChildrenButton.setText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemDialog_INCLUDE_CHILDREN_BUTTON);
        this.includeChildrenButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).create());
        this.includeChildrenButton.addSelectionListener((SelectionListener)this);
        this.includeImpactedOutputs = new Button(packagingComposite, 32);
        this.includeImpactedOutputs.setText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingWorkItemWizardPage_INCLUDE_IMPACTED_OUTPUTS);
        this.includeImpactedOutputs.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).create());
        this.includeImpactedOutputs.addSelectionListener((SelectionListener)this);
        this.skipWISummary = new Button(packagingComposite, 32);
        this.skipWISummary.setText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingWorkItemWizardPage_SKIP_WI_SUMMARY);
        this.skipWISummary.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).create());
        this.skipWISummary.addSelectionListener((SelectionListener)this);
    }

    public AbstractWorkItemTableContentProvider getCommonContentProvider() {
        if (this.fWorkItemTableContentProvider == null) {
            this.fWorkItemTableContentProvider = new WorkItemTableContentProvider();
        }
        return this.fWorkItemTableContentProvider;
    }

    public AbstractWorkItemTableLabelProvider getCommonLabelProvider() {
        if (this.fWorkItemTableLabelProvider == null) {
            this.fWorkItemTableLabelProvider = new WorkItemTableLabelProvider();
        }
        return this.fWorkItemTableLabelProvider;
    }

    public String getConfigurationElementID() {
        return "com.ibm.team.enterprise.packaging";
    }

    public String getNonSeqConfigurationElementID() {
        return "com.ibm.team.enterprise.packaging.nonseq";
    }

    public String getDialogFinishLabel() {
        return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemDialog_FINISH_BUTTON;
    }

    public String getDialogTitle() {
        return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemDialog_DIALOG_TITLE;
    }

    public AbstractWorkItemChooser getWorkItemChooser() {
        return new PackagingWorkItemChooser(this.getShell(), this.configuration.getTeamRepository());
    }

    private void loadWorkingCopy() {
        IPackagingWizardConfiguration config = ((WorkItemPackagingWizard)this.wizard).getConfiguration();
        if (config != null && config.getChosenDefinition() != null) {
            this.fBuildDefinitionWorkingCopy = (IBuildDefinition)config.getChosenDefinition().getWorkingCopy();
        }
    }

    private void loadPreference() {
        if (this.fBuildDefinitionWorkingCopy != null) {
            String typeIncludeChildren = PackagingUIPlugin.getDefault().getPreferenceStore().getString("includeChildren" + this.fBuildDefinitionWorkingCopy.getId());
            String typeIncludeImpacted = PackagingUIPlugin.getDefault().getPreferenceStore().getString("includeImpacted" + this.fBuildDefinitionWorkingCopy.getId());
            String typeOpenSummary = PackagingUIPlugin.getDefault().getPreferenceStore().getString("openSummaryWI" + this.fBuildDefinitionWorkingCopy.getId());
            if (typeIncludeChildren != null) {
                this.includeChildrenButton.setSelection(Boolean.parseBoolean(typeIncludeChildren));
                this.configuration.setIncludeChildren(Boolean.parseBoolean(typeIncludeChildren));
            }
            if (typeIncludeImpacted != null) {
                this.includeImpactedOutputs.setSelection(Boolean.parseBoolean(typeIncludeImpacted));
                this.configuration.setIncludeImpactedObjects(Boolean.parseBoolean(typeIncludeImpacted));
            }
            if (typeOpenSummary != null) {
                this.openReportWorkItemButton.setSelection(Boolean.parseBoolean(typeOpenSummary));
                this.configuration.setOpenReportWorkItem(Boolean.parseBoolean(typeOpenSummary));
            }
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.loadPreference();
        this.init();
    }

    private void init() {
        IBuildProperty propertySkipWISummary;
        Boolean skipWISummaryValue = null;
        if (this.fBuildDefinitionWorkingCopy != null && (propertySkipWISummary = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.workitem.skipWorkitemSummary")) != null) {
            skipWISummaryValue = Boolean.valueOf(propertySkipWISummary.getValue());
        }
        this.skipWISummary.setVisible(skipWISummaryValue != null);
        boolean isSkipWISummary = skipWISummaryValue != null && skipWISummaryValue != false;
        this.skipWISummary.setSelection(isSkipWISummary);
        this.configuration.setSkipWISummary(isSkipWISummary);
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.includeChildrenButton) {
            this.configuration.setIncludeChildren(this.includeChildrenButton.getSelection());
        } else if (eventSource == this.includeImpactedOutputs) {
            this.configuration.setIncludeImpactedObjects(this.includeImpactedOutputs.getSelection());
        } else if (eventSource == this.skipWISummary) {
            this.configuration.setSkipWISummary(this.skipWISummary.getSelection());
        } else if (eventSource == this.browseDefinitionButton) {
            PackagingDefinitionSelectionDialog selectionDialog = new PackagingDefinitionSelectionDialog(this.getShell());
            if (selectionDialog.open() == 0) {
                IBuildDefinition definition = selectionDialog.getFirstSelectedBuildDefinition();
                this.definitionText.setData((Object)definition.getItemId().getUuidValue());
                this.definitionText.setText(definition.getId());
                this.configuration.setChosenDefinition(definition);
                if (this.configuration.getChosenDefinition() != null) {
                    String templateId;
                    IBuildProperty property;
                    this.fBuildDefinitionWorkingCopy = (IBuildDefinition)this.configuration.getChosenDefinition().getWorkingCopy();
                    if (this.fBuildDefinitionWorkingCopy != null && (property = this.fBuildDefinitionWorkingCopy.getProperty(templateDefPropertyId)) != null && (templateId = property.getValue()).contains("nonseq")) {
                        this.packageRestMapPage = new PackagingRestoreMappingWizardPage(this.parent, this.configuration, templateId);
                        this.packageIncShipPage = new PackagingIncludeShiplistWizardPage(this.parent, this.configuration, "include");
                        this.packageExcShipPage = new PackagingIncludeShiplistWizardPage(this.parent, this.configuration, "exclude");
                        ((Wizard)this.wizard).addPage(this.packageRestMapPage);
                        ((Wizard)this.wizard).addPage(this.packageIncShipPage);
                        ((Wizard)this.wizard).addPage(this.packageExcShipPage);
                    }
                }
            }
            if (this.buildOptionsButton != null) {
                this.buildOptionsButton.setEnabled(!this.definitionText.getText().equalsIgnoreCase(""));
            }
            this.validate();
        } else {
            super.widgetSelected(event);
        }
    }

    public String getDialogDescription() {
        return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemDialog_DIALOG_DESCRIPTION;
    }

    protected String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_package_workitem_selection";
    }

    public void createCustomContentLower(Composite parent) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                final Boolean isDisableWorkitemCreation = PackagingWorkItemWizardPage.this.isDisableWorkItemCreation();
                UIJob uiJob = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (isDisableWorkitemCreation.booleanValue()) {
                            PackagingWorkItemWizardPage.this.openReportWorkItemButton.setSelection(false);
                            PackagingWorkItemWizardPage.this.openReportWorkItemButton.setEnabled(false);
                            PackagingWorkItemWizardPage.this.configuration.setOpenReportWorkItem(false);
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private boolean isDisableWorkItemCreation() {
        boolean disabled = false;
        try {
            IProcessArea processArea = this.getProcessArea();
            if (processArea == null) {
                return disabled;
            }
            IProcessClientService processService = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            IProcessConfigurationData data = clientProcess.getProjectConfigurationData("com.ibm.team.enterprise.process.configuration.packaging.resultWorkItem", null);
            if (data != null) {
                IProcessConfigurationElement[] elements = data.getElements();
                int i = 0;
                while (i < elements.length) {
                    IProcessConfigurationElement element = elements[i];
                    if ("resultWorkItem".equals(element.getName())) {
                        disabled = Boolean.parseBoolean(element.getAttribute("disable"));
                    }
                    ++i;
                }
            }
        }
        catch (TeamRepositoryException ex) {
            ex.printStackTrace();
        }
        return disabled;
    }

    protected IStatus validateDefinition() {
        IBuildProperty property = this.configuration.getChosenDefinition().getProperty("team.package.zos.buildDefinition.uuid");
        if (property == null) {
            property = this.configuration.getChosenDefinition().getProperty("team.package.common.buildDefinition.uuid");
        }
        if (property == null || property.getValue().equals("")) {
            return new Status(4, "com.ibm.team.enterprise.packaging.ui", com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingWorkItemWizardPage_NOT_SUPPORTED_PACKAGE_DEFINITION_FOR_WORK_ITEM_PACKAGING);
        }
        IBuildDefinition sourceDefinition = this.resolveBuildDefinition(property.getValue());
        if (sourceDefinition != null && IBuildUtility.isOldDependencyBuild((IBuildDefinition)sourceDefinition)) {
            return new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.DEPRECATED_TEMPLATE_NOT_SUPPORTED);
        }
        return Status.OK_STATUS;
    }

    private IBuildDefinition resolveBuildDefinition(String uuidValue) {
        if (this.getTeamRepository() != null && !uuidValue.isEmpty()) {
            IItemHandle definitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuidValue), null);
            try {
                return (IBuildDefinition)this.getTeamRepository().itemManager().fetchCompleteItem(definitionHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return null;
    }

    protected void initializeDefinitionText() {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PackagingWorkItemWizardPage.this.updateBuildOptionsState();
                PackagingWorkItemWizardPage.this.validate();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public boolean isPageComplete() {
        return !this.definitionText.getText().equalsIgnoreCase("") && this.workItemTableViewer.getCheckedElements().length != 0;
    }

    protected class PackagingDefinitionSelectionDialog
    extends BuildDefinitionSelectionDialog {
        public PackagingDefinitionSelectionDialog(Shell parent) {
            super(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_PAGE_TITLE, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_PAGE_DESCRIPTION, false, false);
        }

        public void setListElements(Object[] elements) {
            ArrayList<IBuildDefinition> buildDefs = null;
            boolean isAtLeastOneBuildDefinition = false;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object currObject = objectArray[n2];
                if (currObject instanceof IBuildDefinition) {
                    if (!isAtLeastOneBuildDefinition) {
                        isAtLeastOneBuildDefinition = true;
                    }
                    if (buildDefs == null) {
                        buildDefs = new ArrayList<IBuildDefinition>();
                    }
                    if (((IBuildDefinition)currObject).getConfigurationElement(PackagingWorkItemWizardPage.this.getConfigurationElementID()) != null) {
                        buildDefs.add((IBuildDefinition)currObject);
                    } else if (((IBuildDefinition)currObject).getConfigurationElement(PackagingWorkItemWizardPage.this.getNonSeqConfigurationElementID()) != null) {
                        buildDefs.add((IBuildDefinition)currObject);
                    }
                }
                ++n2;
            }
            if (buildDefs != null && !buildDefs.isEmpty()) {
                super.setListElements(buildDefs.toArray());
            } else if (isAtLeastOneBuildDefinition) {
                super.setListElements(buildDefs.toArray());
            } else {
                super.setListElements(elements);
            }
        }
    }

    protected class WorkItemTableContentProvider
    extends AbstractWorkItemTableContentProvider {
        private List<IWorkItemHandle> contentList = null;

        protected WorkItemTableContentProvider() {
        }

        public Object[] getElements(Object arg0) {
            return this.contentList == null ? null : this.contentList.toArray();
        }

        public void dispose() {
            if (this.contentList != null) {
                this.contentList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Object input = newInput;
            if (input != null) {
                if (this.contentList == null) {
                    this.contentList = new ArrayList<IWorkItemHandle>();
                } else if (!this.contentList.isEmpty()) {
                    this.contentList.clear();
                }
                if (input instanceof IWorkItemHandle) {
                    this.contentList.add((IWorkItemHandle)input);
                } else if (input instanceof List && ((List)input).get(0) instanceof IWorkItemHandle) {
                    this.contentList.addAll((List)input);
                }
            }
        }

        public List<IWorkItemHandle> getElementsAsList() {
            return this.contentList;
        }
    }

    protected class WorkItemTableLabelProvider
    extends AbstractWorkItemTableLabelProvider {
        private String currentText = null;

        protected WorkItemTableLabelProvider() {
        }

        public Image getColumnImage(Object item, int arg1) {
            return null;
        }

        public String getColumnText(Object item, final int col) {
            final IWorkItemHandle itemHandle = (IWorkItemHandle)item;
            final IWorkItemClient workItemClient = (IWorkItemClient)PackagingWorkItemWizardPage.this.configuration.getTeamRepository().getClientLibrary(IWorkItemClient.class);
            Job resolveWorkItemJob = new Job(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemWizardPage_JOBNAME_RESOLVEWORKITEM){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IWorkItem workItem = (IWorkItem)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)itemHandle, IWorkItem.FULL_PROFILE, null);
                        if (col == 0) {
                            int itemId = workItem.getId();
                            WorkItemTableLabelProvider.this.setCurrentText(String.valueOf(itemId));
                        } else {
                            WorkItemTableLabelProvider.this.setCurrentText(workItem.getHTMLSummary().getPlainText());
                        }
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            resolveWorkItemJob.setUser(false);
            resolveWorkItemJob.schedule();
            try {
                resolveWorkItemJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.getCurrentText();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        private String getCurrentText() {
            return this.currentText;
        }

        private void setCurrentText(String currentText) {
            this.currentText = currentText;
        }
    }
}

