/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.enterprise.automation.common.internal.summary.NodeFactory;
import com.ibm.team.enterprise.automation.common.internal.summary.SummaryNode;
import com.ibm.team.enterprise.automation.common.summary.INode;
import com.ibm.team.enterprise.automation.common.summary.IOutputNode;
import com.ibm.team.enterprise.automation.common.summary.ISummaryNode;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationWorkItemSummaryWizardPage;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AutomationViewerFilter;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IPackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class PackagingWorkItemSummaryWizardPage
extends AbstractAutomationWorkItemSummaryWizardPage {
    private ISummaryNode summaryNode;
    private IPackagingWizardConfiguration configuration;
    private Job currentJob;
    private String previousSettings;

    public PackagingWorkItemSummaryWizardPage(Shell parent, IPackagingWizardConfiguration config) {
        super(parent, (IAutomationWizardConfiguration)config);
        this.setImageDescriptor(PackagingUIPlugin.getImageDescriptor("icons/wizban/packagesummary_wizban.gif"));
        this.configuration = config;
    }

    public void createCustomContent(Composite parent) {
        this.setDescription(Messages.PackageWorkItemSummaryWizardPage_PAGE_DESCRIPTION);
        Composite treeComposite = new Composite(parent, 0);
        treeComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).create());
        treeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
    }

    public void setMessageText(Composite parent) {
        Label treeLabel = new Label(parent, 0);
        treeLabel.setText(Messages.PackageWorkItemSummaryWizardPage_SUMMARYTREE_LABEL);
        treeLabel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    protected ISummaryNode getSummaryNode() {
        return this.getSummaryNode(false);
    }

    public ISummaryNode getSummaryNode(boolean wait) {
        String currSettings = this.createSettingsState();
        if (this.previousSettings == null || !this.previousSettings.equals(currSettings)) {
            this.summaryNode = null;
        }
        if (this.summaryNode == null) {
            this.previousSettings = currSettings;
            this.summaryNode = new SummaryNode("");
            if (this.configuration.skipWISummary()) {
                return this.summaryNode;
            }
            this.summaryNode.addChild((INode)new SummaryNode(Messages.PackagingWorkItemSummaryWizardPage_QUERYING_MSG_TEXT));
            if (this.currentJob != null && this.currentJob.getState() == 4) {
                this.currentJob.cancel();
            }
            this.currentJob = new Job(Messages.PackagingWorkItemSummaryWizardPage_QUERY_JOB_NAME){

                /*
                 * Unable to fully structure code
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    block3: {
                        try {
                            workItemHandles = PackagingWorkItemSummaryWizardPage.access$0(PackagingWorkItemSummaryWizardPage.this).getSelectionResult();
                            repository = PackagingWorkItemSummaryWizardPage.access$0(PackagingWorkItemSummaryWizardPage.this).getTeamRepository();
                            packagingClient = (IPackagingClient)repository.getClientLibrary(IPackagingClient.class);
                            xmlContent = packagingClient.getWorkItemPackagingSummary2(workItemHandles.toArray(new IWorkItemHandle[workItemHandles.size()]), new String[]{Boolean.toString(PackagingWorkItemSummaryWizardPage.access$0(PackagingWorkItemSummaryWizardPage.this).isIncludeChildren()), Boolean.toString(PackagingWorkItemSummaryWizardPage.access$0(PackagingWorkItemSummaryWizardPage.this).isIncludeImpactedObjects())}, PackagingWorkItemSummaryWizardPage.access$0(PackagingWorkItemSummaryWizardPage.this).getChosenDefinition(), null);
                            PackagingWorkItemSummaryWizardPage.access$1(PackagingWorkItemSummaryWizardPage.this, NodeFactory.getInstance().toSummary(xmlContent));
                            break block3;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            PackagingWorkItemSummaryWizardPage.access$1(PackagingWorkItemSummaryWizardPage.this, (ISummaryNode)new SummaryNode(""));
                            var7_10 = lines = e.getLocalizedMessage().split("\n");
                            var6_11 = lines.length;
                            var5_9 = 0;
                            ** while (var5_9 < var6_11)
                        }
lbl-1000:
                        // 1 sources

                        {
                            line = var7_10[var5_9];
                            PackagingWorkItemSummaryWizardPage.access$2(PackagingWorkItemSummaryWizardPage.this).addChild((INode)new SummaryNode(line));
                            ++var5_9;
                            continue;
                        }
                    }
                    uiJob = new UIJob(Messages.PackagingWorkItemSummaryWizardPage_UI_QUERY_UPDATE_JOB_NAME){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!PackagingWorkItemSummaryWizardPage.this.summaryTree.getControl().isDisposed()) {
                                PackagingWorkItemSummaryWizardPage.this.summaryTree.setInput((Object)PackagingWorkItemSummaryWizardPage.this.summaryNode);
                                PackagingWorkItemSummaryWizardPage.this.summaryTree.refresh();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                    return Status.OK_STATUS;
                }
            };
            this.currentJob.schedule();
            if (wait) {
                try {
                    this.currentJob.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else if (wait && this.currentJob != null && this.currentJob.getState() != 0) {
            try {
                this.currentJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.summaryNode;
    }

    private String createSettingsState() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.configuration.isIncludeChildren());
        buf.append('|');
        buf.append(this.configuration.isIncludeImpactedObjects());
        buf.append('|');
        buf.append(this.configuration.skipWISummary());
        buf.append('|');
        if (this.configuration.getChosenDefinition() != null) {
            buf.append(this.configuration.getChosenDefinition().getItemId().getUuidValue());
            buf.append('|');
        }
        ArrayList sortedWorkItems = new ArrayList(this.configuration.getSelectionResult());
        Collections.sort(sortedWorkItems, new Comparator<IWorkItemHandle>(){

            @Override
            public int compare(IWorkItemHandle object1, IWorkItemHandle object2) {
                return object1.getItemId().compareTo((Object)object2.getItemId());
            }
        });
        for (IWorkItemHandle wi : sortedWorkItems) {
            buf.append(wi.getItemId().getUuidValue());
            buf.append(',');
        }
        return buf.toString();
    }

    protected List<AutomationViewerFilter> getSummaryFilters() {
        List packagingFilters = super.getSummaryFilters();
        packagingFilters.add(new AutomationViewerFilter(Messages.PackageWorkItemSummaryWizardPage_SUMMARYTREE_TOOLBAR_FILTER_OUTPUTS, (ViewerFilter)new AbstractAutomationOutputViewerFilter()));
        return packagingFilters;
    }

    protected String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_package_workitem_summary";
    }

    protected boolean provideViewChangeSetOption() {
        return false;
    }

    static /* synthetic */ IPackagingWizardConfiguration access$0(PackagingWorkItemSummaryWizardPage packagingWorkItemSummaryWizardPage) {
        return packagingWorkItemSummaryWizardPage.configuration;
    }

    static /* synthetic */ void access$1(PackagingWorkItemSummaryWizardPage packagingWorkItemSummaryWizardPage, ISummaryNode iSummaryNode) {
        packagingWorkItemSummaryWizardPage.summaryNode = iSummaryNode;
    }

    class AbstractAutomationOutputViewerFilter
    extends ViewerFilter {
        AbstractAutomationOutputViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof IOutputNode);
        }
    }
}

