/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtension;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialogSectionExtensionManager;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationPackagingSelectionWizardPage;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IPackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.Messages;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class PackagingTypeSelectionWizardPage
extends AbstractAutomationPackagingSelectionWizardPage {
    private final IPackagingWizardConfiguration configuration;
    protected Button workItemPackage;
    protected Button shiplistPackage;
    protected Button previewPackage;
    protected Combo timestampCombo;
    private Boolean isShiplist;
    private String packageType = "";
    private String selectedPackageLabel;
    private Label timeStampLabel;
    private Text ucdVersionNamePrompt;
    IBuildDefinition fBuildDefinitionWorkingCopy;
    protected List<RequestBuildSection> fSections = new ArrayList<RequestBuildSection>();
    protected IBuildEngine fHandlingEngine;
    private TeamBuildJob fInitializationJob;
    protected IBuildDefinition fBuildDefinition;
    protected IBuildResult fBuildResult;
    protected IBuildRequest fBuildRequest;
    protected boolean fIsRebuild;
    protected boolean fIsPersonalBuild;
    protected List<IBuildProperty> fOriginalBuildProperties;
    protected IBuildDefinitionHandle fBuildDefinitionHandle;

    public PackagingTypeSelectionWizardPage(Shell parent, IPackagingWizardConfiguration config) {
        super(parent, (IAutomationWizardConfiguration)config);
        this.setImageDescriptor(PackagingUIPlugin.getImageDescriptor("icons/wizban/packagesummary_wizban.gif"));
        this.configuration = config;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.PackagingTypeSelectionWizardPage_TITLE);
        this.setDescription(Messages.PackagingTypeSelectionWizardPage_DESCRIPTION);
        Composite dialogAreaComposite = new Composite(parent, 0);
        dialogAreaComposite.setLayout((Layout)new GridLayout(1, false));
        dialogAreaComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite packagingOptionsComposite = new Composite(dialogAreaComposite, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        packagingOptionsComposite.setLayout((Layout)filterLayout);
        packagingOptionsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 3));
        this.previewPackage = new Button(packagingOptionsComposite, 32);
        this.previewPackage.setText(Messages.PackagingTypeSelectionWizardPage_PACKAGE_PREVIEW);
        this.previewPackage.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        this.previewPackage.addSelectionListener(this.getPreviewPackageListener());
        Label label2 = new Label(packagingOptionsComposite, 0);
        GridDataFactory.fillDefaults().span(2, 1).hint(-1, 5).applyTo((Control)label2);
        this.workItemPackage = new Button(packagingOptionsComposite, 16);
        this.workItemPackage.setText(Messages.PackagingTypeSelectionWizardPage_WORK_ITEM_PACKAGING_OPTION);
        this.workItemPackage.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        this.workItemPackage.addSelectionListener(this.getWorkItemPackageButtonSelectionListener());
        this.shiplistPackage = new Button(packagingOptionsComposite, 16);
        this.shiplistPackage.setText(Messages.PackagingTypeSelectionWizardPage_SHIPLIST_PACKAGING_OPTION);
        this.shiplistPackage.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        this.shiplistPackage.setSelection(true);
        this.shiplistPackage.addSelectionListener(this.getShipListPackageButtonSelectionListener());
        if (this.configuration.getChosenDefinition() != null) {
            this.fBuildDefinitionWorkingCopy = (IBuildDefinition)this.configuration.getChosenDefinition().getWorkingCopy();
            if (this.fBuildDefinitionWorkingCopy != null) {
                IBuildProperty buildUUIDProperty;
                String typeSelection;
                this.timeStampLabel = new Label(packagingOptionsComposite, 0);
                this.timeStampLabel.setFont(parent.getFont());
                this.timeStampLabel.setText(Messages.PackagingTypeSelectionWizardPage_TIMESTAMP_LABEL);
                this.timeStampLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
                this.timestampCombo = new Combo(packagingOptionsComposite, 4);
                GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.timestampCombo);
                ITeamRepository repo = (ITeamRepository)this.fBuildDefinitionWorkingCopy.getProcessArea().getOrigin();
                final IPackageJFSClient clientLibrary = (IPackageJFSClient)repo.getClientLibrary(IPackageJFSClient.class);
                final UUID packageDefinitionUUID = this.fBuildDefinitionWorkingCopy.getItemId();
                this.timestampCombo.setText(Messages.PackagingTypeSelectionWizardPage_PENDING);
                Job job = new Job(Messages.PackagingTypeSelectionWizardPage_JOB_NAME_QUERYING_LAST_FIVE_PACKAGES){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            final List packageHandles = clientLibrary.getLastFivePackageHandles(packageDefinitionUUID);
                            UIJob uiJob = new UIJob(Messages.PackagingTypeSelectionWizardPage_UI_JOB_NAME_UPDATING_TIMESTAMPS_BASED_ON_LAST_FIVE_PACKAGES_QUERY){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    if (!(this).PackagingTypeSelectionWizardPage.this.timestampCombo.isDisposed()) {
                                        for (IPackageHandle packageHandle : packageHandles) {
                                            (this).PackagingTypeSelectionWizardPage.this.timestampCombo.add(packageHandle.getLabel());
                                            (this).PackagingTypeSelectionWizardPage.this.timestampCombo.setData(packageHandle.getLabel(), (Object)packageHandle);
                                        }
                                        if ((this).PackagingTypeSelectionWizardPage.this.timestampCombo.getItemCount() > 0) {
                                            (this).PackagingTypeSelectionWizardPage.this.timestampCombo.select(0);
                                            PackagingTypeSelectionWizardPage.this.selectedPackageLabel = ((IPackageHandle)(this).PackagingTypeSelectionWizardPage.this.timestampCombo.getData((this).PackagingTypeSelectionWizardPage.this.timestampCombo.getText())).getLabel();
                                            PackagingTypeSelectionWizardPage.this.configuration.setTimestamp(PackagingTypeSelectionWizardPage.this.selectedPackageLabel);
                                        } else {
                                            (this).PackagingTypeSelectionWizardPage.this.timestampCombo.setText("");
                                        }
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.schedule();
                        }
                        catch (TeamRepositoryException e1) {
                            e1.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                this.timestampCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        PackagingTypeSelectionWizardPage.this.validateAndSetTimestamp();
                    }
                });
                new TooltipSupport((Control)this.timestampCombo, true, false){

                    protected String getMarkup(Object element, boolean isFocus) {
                        return Messages.PackagingTypeSelectionWizardPage_TIMESTAMP_TOOLTIP;
                    }

                    public Object getElement(Control control, int x, int y) {
                        return PackagingTypeSelectionWizardPage.this.timestampCombo;
                    }
                };
                IBuildProperty ucdVersionNameConvention = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ucd.versionName.convention");
                if (ucdVersionNameConvention != null && "PROMPT".equals(ucdVersionNameConvention.getValue())) {
                    Label ucdVersionNamePromptLabel = new Label(packagingOptionsComposite, 0);
                    ucdVersionNamePromptLabel.setFont(parent.getFont());
                    ucdVersionNamePromptLabel.setText(Messages.PackagingTypeSelectionWizardPage_UCD_VERSION_NAME_PROMPT);
                    ucdVersionNamePromptLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
                    this.ucdVersionNamePrompt = new Text(packagingOptionsComposite, 2048);
                    this.ucdVersionNamePrompt.setFont(parent.getFont());
                    this.ucdVersionNamePrompt.setText("");
                    this.ucdVersionNamePrompt.setEnabled(true);
                    this.ucdVersionNamePrompt.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            String ucdVersionNameValue = PackagingTypeSelectionWizardPage.this.ucdVersionNamePrompt.getText();
                            PackagingTypeSelectionWizardPage.this.configuration.setUcdVersionNamePrompt(ucdVersionNameValue);
                            PackagingTypeSelectionWizardPage.this.getWizard().getContainer().updateButtons();
                        }
                    });
                    GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.ucdVersionNamePrompt);
                }
                if ((typeSelection = PackagingUIPlugin.getDefault().getPreferenceStore().getString("typeOfPackage" + this.fBuildDefinitionWorkingCopy.getId())) != null && !typeSelection.equals("")) {
                    if (typeSelection.equals("shiplist")) {
                        this.shiplistPackage.setSelection(true);
                        this.workItemPackage.setSelection(false);
                        this.packageType = "shiplist";
                        this.configuration.setPackageType("shiplist");
                        this.timestampCombo.setEnabled(true);
                    } else if (typeSelection.equals("workitem")) {
                        this.shiplistPackage.setSelection(false);
                        this.workItemPackage.setSelection(true);
                        this.packageType = "workitem";
                        this.configuration.setPackageType("workitem");
                        this.timestampCombo.setEnabled(false);
                    }
                }
                if ((buildUUIDProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.package.zos.buildDefinition.uuid")) == null) {
                    buildUUIDProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.buildDefinition.uuid");
                }
                if (buildUUIDProperty == null || "".equals(buildUUIDProperty.getValue())) {
                    this.packageType = "shiplist";
                    this.configuration.setPackageType("shiplist");
                    this.shiplistPackage.setSelection(true);
                    this.workItemPackage.setEnabled(false);
                    this.setMessage(Messages.PackagingTypeSelectionWizardPage_WORK_ITEM_PACKAGING_DISABLED_MESSAGE, 1);
                    if (this.timestampCombo != null) {
                        this.timestampCombo.setEnabled(true);
                        this.timestampCombo.setFocus();
                    }
                } else {
                    IBuildDefinition sourceBuildDefinition = this.resolveBuildDefinition(buildUUIDProperty.getValue());
                    if (sourceBuildDefinition != null && IBuildUtility.isOldDependencyBuild((IBuildDefinition)sourceBuildDefinition)) {
                        this.setErrorMessage(com.ibm.team.enterprise.build.common.Messages.DEPRECATED_TEMPLATE_NOT_SUPPORTED);
                        this.setPageComplete(false);
                    }
                }
            }
        }
        Composite mainComposite = new Composite(dialogAreaComposite, 0);
        mainComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create());
        mainComposite.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).grab(true, false).create());
        Label label = new Label(mainComposite, 0);
        GridDataFactory.fillDefaults().span(3, 1).hint(-1, 5).applyTo((Control)label);
        this.fSections = this.createSections();
        Composite sectionsComposite = new Composite(mainComposite, 0);
        GridDataFactory.fillDefaults().indent(5, 0).grab(true, true).span(3, 1).applyTo((Control)sectionsComposite);
        GridLayoutFactory.fillDefaults().applyTo(sectionsComposite);
        Group optionsGroup = new Group(sectionsComposite, 0);
        optionsGroup.setText(Messages.PackagingTypeSelectionWizardPage_BUILDOPTION);
        optionsGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        optionsGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        for (RequestBuildSection section : this.fSections) {
            section.createContent((Composite)optionsGroup);
        }
        this.initializeInBackground();
        this.setControl((Control)dialogAreaComposite);
    }

    protected SelectionListener getShipListPackageButtonSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PackagingTypeSelectionWizardPage.this.packageType = "shiplist";
                PackagingTypeSelectionWizardPage.this.configuration.setPackageType("shiplist");
                PackagingTypeSelectionWizardPage.this.validateAndSetTimestamp();
                PackagingTypeSelectionWizardPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected SelectionListener getPreviewPackageListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PackagingTypeSelectionWizardPage.this.configuration.setPreviewMode(PackagingTypeSelectionWizardPage.this.previewPackage.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected SelectionListener getWorkItemPackageButtonSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PackagingTypeSelectionWizardPage.this.isShiplist = PackagingTypeSelectionWizardPage.this.shiplistPackage.getSelection();
                if (PackagingTypeSelectionWizardPage.this.timestampCombo != null) {
                    PackagingTypeSelectionWizardPage.this.timestampCombo.setEnabled(PackagingTypeSelectionWizardPage.this.isShiplist.booleanValue());
                }
                PackagingTypeSelectionWizardPage.this.packageType = "workitem";
                PackagingTypeSelectionWizardPage.this.configuration.setPackageType("workitem");
                PackagingTypeSelectionWizardPage.this.validateAndSetTimestamp();
                PackagingTypeSelectionWizardPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected List<RequestBuildSection> createSections() {
        RequestBuildDialogSectionExtension[] extensions;
        RequestBuildSectionSite site = this.createSectionSite();
        ArrayList<RequestBuildSection> sections = new ArrayList<RequestBuildSection>();
        RequestBuildDialogSectionExtension[] requestBuildDialogSectionExtensionArray = extensions = RequestBuildDialogSectionExtensionManager.getInstance().getRequestBuildDialogSectionExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            RequestBuildDialogSectionExtension extension = requestBuildDialogSectionExtensionArray[n2];
            if (extension.getClassAttribute().equals("com.ibm.rational.buildforge.buildagent.internal.ui.dialogs.ClientCredentialSection$Factory") || extension.getClassAttribute().equals("com.ibm.team.build.internal.ui.dialogs.PropertiesSection$Factory")) {
                try {
                    sections.add(extension.createSectionFactory().createRequestBuildSection(site));
                }
                catch (Exception e) {
                    BuildUIPlugin.log((Throwable)e);
                }
            }
            ++n2;
        }
        return sections;
    }

    protected RequestBuildSectionSite createSectionSite() {
        return new RequestBuildSectionSite(){

            public void setProperty(String propertyName, Object value) {
                if ("handlingEngine".equals(propertyName)) {
                    PackagingTypeSelectionWizardPage.this.fHandlingEngine = (IBuildEngine)value;
                }
                PackagingTypeSelectionWizardPage.this.notifyPropertyChanged(propertyName);
            }

            public void revalidate() {
            }

            public void layoutChanged() {
                PackagingTypeSelectionWizardPage.this.handleLayoutChanged();
            }

            public boolean isRebuild() {
                return PackagingTypeSelectionWizardPage.this.fIsRebuild;
            }

            public boolean isPersonalBuild() {
                return PackagingTypeSelectionWizardPage.this.fIsPersonalBuild;
            }

            public IBuildResult getBuildResult() {
                return PackagingTypeSelectionWizardPage.this.fBuildResult;
            }

            public IBuildRequest getBuildRequest() {
                return PackagingTypeSelectionWizardPage.this.fBuildRequest;
            }

            public IBuildDefinition getBuildDefinition() {
                return PackagingTypeSelectionWizardPage.this.fBuildDefinition;
            }

            public ITeamRepository getTeamRepository() {
                return PackagingTypeSelectionWizardPage.this.fBuildDefinition == null ? null : (ITeamRepository)PackagingTypeSelectionWizardPage.this.fBuildDefinition.getOrigin();
            }

            public List<IBuildProperty> getOriginalBuildProperties() {
                return PackagingTypeSelectionWizardPage.this.fOriginalBuildProperties;
            }

            public IBuildEngine getHandlingEngine() {
                return PackagingTypeSelectionWizardPage.this.fHandlingEngine;
            }

            public void addErrorMessage(Object id, String errorMessage) {
            }

            public void removeErrorMessage(Object id) {
            }

            public void addWarningMessage(Object id, String warningMessage) {
            }

            public void removeWarningMessage(Object id) {
            }
        };
    }

    public String getPackageType() {
        return this.packageType;
    }

    private void handleLayoutChanged() {
        this.getShell().pack(true);
    }

    protected void notifyPropertyChanged(String propertyName) {
        for (RequestBuildSection section : this.fSections) {
            section.handlePropertyChanged(propertyName);
        }
    }

    private void initializeInBackground() {
        ITeamRepository jobTeamRepository = null;
        this.fBuildDefinition = this.configuration.getChosenDefinition();
        if (this.fBuildDefinitionHandle != null) {
            jobTeamRepository = (ITeamRepository)this.fBuildDefinitionHandle.getOrigin();
        }
        String jobName = Messages.PackagingTypeSelectionWizardPage_INITIALIZING_FIELDS;
        this.fInitializationJob = new TeamBuildJob(jobName, true, jobTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                for (RequestBuildSection section : PackagingTypeSelectionWizardPage.this.fSections) {
                    section.initialize(monitor);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PackagingTypeSelectionWizardPage.this.handleInitializationComplete();
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
            }
        };
        this.fInitializationJob.schedule();
    }

    protected void handleInitializationComplete() {
        if (this.fBuildDefinition != null) {
            this.fOriginalBuildProperties = this.fBuildDefinition.getProperties();
            this.fBuildDefinition = (IBuildDefinition)this.fBuildDefinition.getWorkingCopy();
            if (this.fIsRebuild) {
                List requestProperties = this.fBuildRequest.getBuildDefinitionInstance().getProperties();
                this.fBuildDefinition.getProperties().clear();
                for (IBuildProperty requestProperty : requestProperties) {
                    if (requestProperty.getName().equals("scheduledBuild")) continue;
                    IBuildProperty newProperty = requestProperty.copyProperty();
                    this.fBuildDefinition.getProperties().add(newProperty);
                }
            }
            for (RequestBuildSection section : this.fSections) {
                section.initializationComplete();
            }
        }
    }

    private IBuildDefinition resolveBuildDefinition(String uuidValue) {
        if (this.configuration.getTeamRepository() != null && !uuidValue.isEmpty()) {
            IItemHandle definitionHandle = IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuidValue), null);
            try {
                return (IBuildDefinition)this.configuration.getTeamRepository().itemManager().fetchCompleteItem(definitionHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return null;
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public List<RequestBuildSection> getSections() {
        return this.fSections;
    }

    public IBuildDefinition returnBuildDefWorkingCopy() {
        return this.fBuildDefinition;
    }

    protected String getHelpText() {
        return "";
    }

    public boolean validateAndSetTimestamp() {
        block5: {
            if (this.packageType.equals("shiplist")) {
                try {
                    SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd-HHmmss");
                    if (this.timestampCombo.getText().isEmpty() || date.parse(this.timestampCombo.getText()) != null) {
                        this.selectedPackageLabel = this.timestampCombo.getText();
                        this.configuration.setTimestamp(this.selectedPackageLabel);
                        this.setErrorMessage(null);
                        break block5;
                    }
                    this.setErrorMessage(Messages.PackagingTypeSelectionWizardPage_TIMESTAMP_TOOLTIP);
                }
                catch (ParseException ex) {
                    this.setErrorMessage(Messages.PackagingTypeSelectionWizardPage_TIMESTAMP_TOOLTIP);
                }
            } else {
                this.setErrorMessage(null);
            }
        }
        boolean isValid = this.getErrorMessage() == null;
        this.setPageComplete(isValid);
        return isValid;
    }
}

