/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationIncludeShiplistWizardPage;
import com.ibm.team.enterprise.automation.internal.ui.wizards.IAutomationWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IPackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IncludeExcludeShiplistComposite;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PackagingIncludeShiplistWizardPage
extends AbstractAutomationIncludeShiplistWizardPage {
    private IPackagingWizardConfiguration configuration;
    protected IncludeExcludeShiplistComposite includeShipComposite;
    private String shiplistType;

    public PackagingIncludeShiplistWizardPage(Shell parent, IPackagingWizardConfiguration config, String shipType) {
        super(parent, (IAutomationWizardConfiguration)config);
        this.setImageDescriptor(PackagingUIPlugin.getImageDescriptor("icons/wizban/packagesummary_wizban.gif"));
        this.shiplistType = shipType;
        this.configuration = config;
    }

    public void createMappingContent(Composite parent) {
        if (this.shiplistType == "include") {
            this.setTitle(Messages.PackagingIncludeShiplistWizardPage_INCLUDE_TITLE);
            this.setDescription(Messages.PackagingIncludeShiplistWizardPage_INCLUDE_DESCRIPTION);
        } else if (this.shiplistType == "exclude") {
            this.setTitle(Messages.PackagingIncludeShiplistWizardPage_EXCLUDE_TITLE);
            this.setDescription(Messages.PackagingIncludeShiplistWizardPage_EXCLUDE_DESCRIPTION);
        }
        Composite treeComposite = new Composite(parent, 0);
        treeComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).create());
        treeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createIncludeShipControl(treeComposite);
    }

    public void createIncludeShipControl(Composite parent) {
        IBuildDefinition fBuildDefinitionWorkingCopy = (IBuildDefinition)this.configuration.getChosenDefinition().getWorkingCopy();
        this.includeShipComposite = new IncludeExcludeShiplistComposite(parent, this, null, fBuildDefinitionWorkingCopy, this.shiplistType);
        this.includeShipComposite.setLayoutData(GridDataFactory.fillDefaults().hint(400, -1).grab(true, true).create());
    }

    public void setMessageText(Composite parent) {
        Label treeLabel = new Label(parent, 0);
        treeLabel.setText(Messages.PackageWorkItemSummaryWizardPage_SUMMARYTREE_LABEL);
        treeLabel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    protected String getHelpText() {
        return "com.ibm.team.build.ui.wizard_enterprise_package_workitem_summary";
    }

    public IncludeExcludeShiplistComposite getIncludeShipComposite() {
        return this.includeShipComposite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.includeShipComposite != null && !this.includeShipComposite.isDisposed()) {
            this.includeShipComposite.setVisible(visible);
        }
    }
}

