/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.automation.common.summary.INode;
import com.ibm.team.enterprise.automation.common.summary.IOutputNode;
import com.ibm.team.enterprise.automation.common.summary.ISummaryNode;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractAutomationIncludeShiplistWizardPage;
import com.ibm.team.enterprise.automation.ui.table.AutomationViewerComparator;
import com.ibm.team.enterprise.packaging.common.util.CreateShiplistUtil;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.AddEditHFSShiplistFilterDialog;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.AddEditShiplistFilterDialog;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.ButtonUtils;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IPackagingWizardConfiguration;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.Messages;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingWorkItemSummaryWizardPage;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeMember;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableContentProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelIBMiProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelZProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class IncludeExcludeShiplistComposite
extends Composite {
    public TreeViewer treeViewer;
    private AutomationViewerComparator comparator;
    private AbstractAutomationIncludeShiplistWizardPage page;
    private AbstractConfigurationElementEditor editor;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private boolean isZos;
    public Button addButton;
    public Button editButton;
    public Button removeButton;
    private Hashtable<String, IncludeExcludeMember> members = new Hashtable();
    protected Hashtable<String, IncludeExcludeMember> hfsMembers = new Hashtable();
    private final Set<String> workItemDeletionMembers = new HashSet<String>();
    private final boolean isInclude;
    private PackagingWorkItemSummaryWizardPage summaryPage;
    private ISummaryNode currentSummaryNode;
    private boolean isWorkItemPackaging;
    private final String membersProperty;
    private final String hfsMembersProperty;

    public IncludeExcludeShiplistComposite(Composite parent, AbstractAutomationIncludeShiplistWizardPage page, AbstractConfigurationElementEditor editor, IBuildDefinition fBuildDefinitionWorking, String shiplistType) {
        super(parent, 0);
        IncludeExcludeTableLabelProvider labelProvider;
        Assert.isTrue((boolean)(page == null ^ editor == null));
        this.page = page;
        this.editor = editor;
        this.fBuildDefinitionWorkingCopy = fBuildDefinitionWorking;
        this.isZos = this.isZosPackageDef(this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.build.internal.template.id"));
        this.isInclude = "include".equals(shiplistType);
        if (this.isInclude) {
            this.membersProperty = "team.package.common.include.binaries";
            this.hfsMembersProperty = "team.package.common.include.hfs.binaries";
        } else {
            this.membersProperty = "team.package.common.exclude.binaries";
            this.hfsMembersProperty = "team.package.common.exclude.hfs.binaries";
        }
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Composite treeComposite = new Composite((Composite)this, 0);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeColumnLayout);
        GridDataFactory.fillDefaults().indent(5, 0).hint(-1, 250).grab(true, false).applyTo((Control)treeComposite);
        Tree resultsTree = new Tree(treeComposite, 68354);
        TreeColumn fromColumn = new TreeColumn(resultsTree, 16384, 0);
        if (this.isInclude) {
            fromColumn.setText(Messages.IncludeExcludeShiplistComposite_INCLUDE_COLUMN_LABEL);
        } else {
            fromColumn.setText(Messages.IncludeExcludeShiplistComposite_EXCLUDE_COLUMN_LABEL);
        }
        fromColumn.addSelectionListener(this.getColumnSelectionListener(resultsTree, fromColumn, 0));
        treeColumnLayout.setColumnData((Widget)fromColumn, (ColumnLayoutData)new ColumnWeightData(100));
        this.treeViewer = new TreeViewer(resultsTree);
        resultsTree.setHeaderVisible(true);
        resultsTree.setLinesVisible(true);
        resultsTree.setSortColumn(resultsTree.getColumn(0));
        resultsTree.setSortDirection(128);
        if (this.isInclude) {
            labelProvider = !this.isZos ? new IncludeExcludeTableLabelIBMiProvider(){

                @Override
                public Image getColumnImage(Object element, int columnIndex) {
                    String key;
                    if (IncludeExcludeShiplistComposite.this.isWorkItemPackaging && (key = this.getColumnText(element, columnIndex)) != null && IncludeExcludeShiplistComposite.this.workItemDeletionMembers.contains(key)) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_WARNING");
                    }
                    return null;
                }
            } : new IncludeExcludeTableLabelZProvider(){

                @Override
                public Image getColumnImage(Object element, int columnIndex) {
                    String key;
                    if (IncludeExcludeShiplistComposite.this.isWorkItemPackaging && (key = this.getColumnText(element, columnIndex)) != null && IncludeExcludeShiplistComposite.this.workItemDeletionMembers.contains(key)) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_WARNING");
                    }
                    return null;
                }
            };
            new TooltipSupport(this.treeViewer.getControl(), false, false){

                protected String getMarkup(Object element, boolean isFocus) {
                    String key;
                    if (IncludeExcludeShiplistComposite.this.isWorkItemPackaging && (key = labelProvider.getColumnText(element, 0)) != null && IncludeExcludeShiplistComposite.this.workItemDeletionMembers.contains(key)) {
                        return Messages.IncludeExcludeShiplistComposite_WARNING_MEMBER_DELETED;
                    }
                    return null;
                }
            };
        } else {
            labelProvider = !this.isZos ? new IncludeExcludeTableLabelIBMiProvider() : new IncludeExcludeTableLabelZProvider();
        }
        this.treeViewer.setContentProvider((IContentProvider)new IncludeExcludeTableContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.comparator = new IncludeExcludeComparator();
        this.comparator.setColumn(0);
        this.treeViewer.setComparator((ViewerComparator)this.comparator);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IncludeExcludeShiplistComposite.this.updateButtonsEnablement();
            }
        });
        this.members = this.retrievePreviousMembers(this.fBuildDefinitionWorkingCopy.getPropertyValue(this.membersProperty, ""));
        this.hfsMembers = this.retrievePreviousHFSMembers(this.fBuildDefinitionWorkingCopy.getPropertyValue(this.hfsMembersProperty, ""));
        this.treeViewer.setInput((Object)new IncludeExcludeTableContentProvider.IncludeExcludeInput(this.members, this.hfsMembers, this.isZos));
        this.treeViewer.expandAll();
        Composite buttonBar = new Composite((Composite)this, 0);
        buttonBar.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        buttonBar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.addButton = new Button(buttonBar, 8);
        this.addButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.addButton.setText(Messages.IncludeExcludeShiplistComposite_ADD_BUTTON_TEXT);
        if (!this.isZos) {
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String property = "team.package.common.exclude.binaries";
                    if (IncludeExcludeShiplistComposite.this.isInclude) {
                        property = "team.package.common.include.binaries";
                    }
                    new AddAction(IncludeExcludeShiplistComposite.this.treeViewer, IncludeExcludeShiplistComposite.this.members, property).run();
                }
            });
        } else {
            MenuManager addFileMenu = new MenuManager("#Popup");
            addFileMenu.add((IAction)new AddAction(this.treeViewer, this.members, this.membersProperty));
            addFileMenu.add((IAction)new AddHFSAction(this.treeViewer, this.hfsMembers, this.hfsMembersProperty));
            ButtonUtils.installMenu(this.addButton, addFileMenu);
        }
        this.editButton = new Button(buttonBar, 8);
        this.editButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.editButton.setText(Messages.IncludeExcludeShiplistComposite_EDIT_BUTTON_TEXT);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((IStructuredSelection)IncludeExcludeShiplistComposite.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof IncludeExcludeMember) {
                    IncludeExcludeShiplistComposite.this.edit((IncludeExcludeMember)selection);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selection = ((IStructuredSelection)IncludeExcludeShiplistComposite.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof IncludeExcludeMember) {
                    IncludeExcludeShiplistComposite.this.edit((IncludeExcludeMember)selection);
                }
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(buttonBar, 8);
        this.removeButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.removeButton.setText(Messages.IncludeExcludeShiplistComposite_REMOVE_BUTTON_TEXT);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ((IStructuredSelection)IncludeExcludeShiplistComposite.this.treeViewer.getSelection()).toList();
                IncludeExcludeShiplistComposite.this.removeEntries(IncludeExcludeShiplistComposite.this.treeViewer, IncludeExcludeShiplistComposite.this.members, IncludeExcludeShiplistComposite.this.hfsMembers, selection, IncludeExcludeShiplistComposite.this.membersProperty, IncludeExcludeShiplistComposite.this.hfsMembersProperty);
            }
        });
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    List selection = ((IStructuredSelection)IncludeExcludeShiplistComposite.this.treeViewer.getSelection()).toList();
                    IncludeExcludeShiplistComposite.this.removeEntries(IncludeExcludeShiplistComposite.this.treeViewer, IncludeExcludeShiplistComposite.this.members, IncludeExcludeShiplistComposite.this.hfsMembers, selection, IncludeExcludeShiplistComposite.this.membersProperty, IncludeExcludeShiplistComposite.this.hfsMembersProperty);
                }
            }
        });
        this.removeButton.setEnabled(false);
    }

    private void edit(IncludeExcludeMember member) {
        if (member.isHFS()) {
            this.getAddEditHFSShiplistDialog(member.getContainerName(), member.getResourceName(), this.treeViewer, this.hfsMembers, this.hfsMembersProperty, true);
        } else {
            String containerName = member.getContainerName();
            String resourceName = member.getResourceName();
            if (member.isSequential().booleanValue()) {
                if (resourceName != null && resourceName.length() > 0) {
                    containerName = String.valueOf(containerName) + '.' + resourceName;
                }
                resourceName = "";
            }
            this.getAddEditShiplistDialog(containerName, resourceName, member.getType(), this.treeViewer, this.members, this.membersProperty, true);
        }
    }

    protected SelectionListener getColumnSelectionListener(final Tree tree, final TreeColumn treeColumn, final int columnNum) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeExcludeShiplistComposite.this.comparator.setColumn(columnNum);
                if (tree.getSortColumn() == treeColumn) {
                    if (tree.getSortDirection() == 1024) {
                        tree.setSortDirection(128);
                    } else {
                        tree.setSortDirection(1024);
                    }
                } else {
                    tree.setSortColumn(treeColumn);
                    tree.setSortDirection(128);
                }
                IncludeExcludeShiplistComposite.this.treeViewer.refresh();
            }
        };
    }

    protected void getAddEditShiplistDialog(String dataSetFilter, String memberFilter, String typeFilter, final TreeViewer viewer, final Hashtable<String, IncludeExcludeMember> members, String propertyName, boolean editType) {
        Object[] results;
        String buildDefUUID = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.package.common.buildDefinition.uuid", "");
        ITeamRepository repository = this.getRepository(this.fBuildDefinitionWorkingCopy);
        AddEditShiplistFilterDialog dialog = new AddEditShiplistFilterDialog(this.getShell(), buildDefUUID, repository, dataSetFilter, memberFilter, typeFilter, this.isZos, this.isInclude, editType);
        if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0) {
            final int originalSize = members.size();
            if (!"".equals(dataSetFilter)) {
                if (!this.isZos) {
                    if (!"".equals(memberFilter)) {
                        members.remove(String.valueOf(dataSetFilter) + "(" + memberFilter + ") OBJTYPE(" + typeFilter + ")");
                    }
                } else {
                    String key = memberFilter.length() > 0 ? String.valueOf(dataSetFilter) + "(" + memberFilter + ")" : dataSetFilter;
                    members.remove(key);
                }
            }
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String resourceName;
                Object result = objectArray[n2];
                IncludeExcludeMember member = (IncludeExcludeMember)result;
                String key = null;
                key = member.isSequential().booleanValue() ? ((resourceName = ((IncludeExcludeMember)result).getResourceName()) == null || resourceName.length() <= 0 ? ((IncludeExcludeMember)result).getContainerName() : String.valueOf(((IncludeExcludeMember)result).getContainerName()) + "." + resourceName) : String.valueOf(((IncludeExcludeMember)result).getContainerName()) + "(" + ((IncludeExcludeMember)result).getResourceName() + ")";
                if (!this.isZos) {
                    key = String.valueOf(key) + " OBJTYPE(" + ((IncludeExcludeMember)result).getType() + ")";
                }
                members.put(key, (IncludeExcludeMember)result);
                ++n2;
            }
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Object[] expanded = IncludeExcludeShiplistComposite.this.treeViewer.getExpandedElements();
                    viewer.setInput(viewer.getInput());
                    if (originalSize == 0 && members.size() > 0) {
                        viewer.expandAll();
                    } else {
                        viewer.setExpandedElements(expanded);
                    }
                    IncludeExcludeShiplistComposite.this.validate();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            this.saveMembersList(members.keySet(), propertyName);
        }
    }

    private ITeamRepository getRepository(IBuildDefinition def) {
        if (def != null) {
            IProcessAreaHandle paHandle;
            ITeamRepository repository = (ITeamRepository)def.getOrigin();
            if (repository == null && (paHandle = def.getProcessArea()) != null) {
                repository = (ITeamRepository)paHandle.getOrigin();
            }
            return repository;
        }
        return null;
    }

    protected void getAddEditHFSShiplistDialog(String directoryFilter, String patternFilter, final TreeViewer viewer, final Hashtable<String, IncludeExcludeMember> members, String propertyName, boolean editType) {
        Object[] results;
        String buildDefUUID = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.package.common.buildDefinition.uuid", "");
        ITeamRepository repository = this.getRepository(this.fBuildDefinitionWorkingCopy);
        AddEditHFSShiplistFilterDialog dialog = new AddEditHFSShiplistFilterDialog(this.getShell(), buildDefUUID, repository, directoryFilter, patternFilter, this.isZos, this.isInclude, editType);
        if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0) {
            final int originalSize = members.size();
            if (editType) {
                String key = CreateShiplistUtil.joinHFSSegments((String)directoryFilter, (String)patternFilter);
                members.remove(key);
            }
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                IncludeExcludeMember member = (IncludeExcludeMember)result;
                String key = CreateShiplistUtil.joinHFSSegments((String)member.getContainerName(), (String)member.getResourceName());
                members.put(key, member);
                ++n2;
            }
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Object[] expanded = IncludeExcludeShiplistComposite.this.treeViewer.getExpandedElements();
                    viewer.setInput(viewer.getInput());
                    if (originalSize == 0 && members.size() > 0) {
                        viewer.expandAll();
                    } else {
                        viewer.setExpandedElements(expanded);
                    }
                    IncludeExcludeShiplistComposite.this.validate();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            this.saveHFSMembersList(members.values(), propertyName);
        }
    }

    public void saveMembersList(Set<String> members, String propertyName) {
        String delimiter = ";";
        if (!this.isZos) {
            delimiter = ";;";
        }
        String stringRepresentation = "";
        for (String member : members) {
            stringRepresentation = String.valueOf(stringRepresentation) + member + delimiter;
        }
        if (stringRepresentation.length() == 1) {
            stringRepresentation = "";
        }
        if (this.page == null) {
            this.fBuildDefinitionWorkingCopy.setProperty(propertyName, stringRepresentation);
        } else if (this.isInclude) {
            ((IPackagingWizardConfiguration)this.page.getConfiguration()).setIncludeShiplist(stringRepresentation);
        } else {
            ((IPackagingWizardConfiguration)this.page.getConfiguration()).setExcludeShiplist(stringRepresentation);
        }
        if (this.editor != null) {
            this.editor.setDirty(true);
            this.editor.validate();
        }
    }

    protected void saveHFSMembersList(Collection<IncludeExcludeMember> members, String propertyName) {
        ArrayList<String> segments = new ArrayList<String>();
        for (IncludeExcludeMember member : members) {
            segments.add(member.getContainerName());
            segments.add(member.getResourceName());
        }
        String stringRepresentation = CreateShiplistUtil.convertHFSEntriesToProperty(segments);
        if (this.page == null) {
            this.fBuildDefinitionWorkingCopy.setProperty(propertyName, stringRepresentation);
            this.fBuildDefinitionWorkingCopy.getProperty(propertyName).setGenericEditAllowed(false);
        } else if (this.isInclude) {
            ((IPackagingWizardConfiguration)this.page.getConfiguration()).setIncludeHFSShiplist(stringRepresentation);
        } else {
            ((IPackagingWizardConfiguration)this.page.getConfiguration()).setExcludeHFSShiplist(stringRepresentation);
        }
        if (this.editor != null) {
            this.editor.setDirty(true);
            this.editor.validate();
        }
    }

    protected Hashtable<String, IncludeExcludeMember> retrievePreviousMembers(String storedValue) {
        Hashtable<String, IncludeExcludeMember> members = new Hashtable<String, IncludeExcludeMember>();
        String delimiter = ";";
        if (!this.isZos) {
            delimiter = ";;";
        }
        StringTokenizer tokenizer = new StringTokenizer(storedValue, delimiter);
        while (tokenizer.hasMoreElements()) {
            String memberString;
            String pds;
            String token = tokenizer.nextToken();
            int index = token.indexOf("(");
            if (index < 0) {
                pds = token;
                memberString = "";
            } else {
                pds = token.substring(0, index);
                memberString = token.substring(index + 1, token.length() - 1);
            }
            String type = "";
            if (!this.isZos) {
                int index2 = token.indexOf(") ");
                memberString = token.substring(index + 1, index2);
                int index3 = token.indexOf("OBJTYPE(");
                type = token.substring(index3 + 8, token.length() - 1);
            }
            IncludeExcludeMember member = new IncludeExcludeMember(memberString, pds, type, true, false);
            members.put(token, member);
        }
        return members;
    }

    protected Hashtable<String, IncludeExcludeMember> retrievePreviousHFSMembers(String storedValue) {
        List segments = CreateShiplistUtil.parseHFSEntries((String)storedValue);
        Hashtable<String, IncludeExcludeMember> members = new Hashtable<String, IncludeExcludeMember>(segments.size() / 2);
        int i = 0;
        while (i + 1 < segments.size()) {
            IncludeExcludeMember member = new IncludeExcludeMember((String)segments.get(i + 1), (String)segments.get(i), "", true, true);
            String key = CreateShiplistUtil.joinHFSSegments((String)member.getContainerName(), (String)member.getResourceName());
            members.put(key, member);
            i += 2;
        }
        return members;
    }

    protected void removeEntries(final TreeViewer treeViewer, final Hashtable<String, IncludeExcludeMember> members, final Hashtable<String, IncludeExcludeMember> hfsMembers, List<IncludeExcludeMember> selection, String propertyName, String hfsPropertyName) {
        boolean hfsModified = false;
        boolean modified = false;
        IncludeExcludeTableContentProvider.IncludeExcludeCategory selectedCategory = null;
        IncludeExcludeTableContentProvider.IncludeExcludeCategory selectedHFSCategory = null;
        for (IncludeExcludeMember element : selection) {
            String key;
            if (element instanceof IncludeExcludeTableContentProvider.IncludeExcludeCategory) {
                if (!((IncludeExcludeTableContentProvider.IncludeExcludeCategory)((Object)element)).isHFS()) {
                    selectedCategory = (IncludeExcludeTableContentProvider.IncludeExcludeCategory)((Object)element);
                    continue;
                }
                selectedHFSCategory = (IncludeExcludeTableContentProvider.IncludeExcludeCategory)((Object)element);
                continue;
            }
            if (!(element instanceof IncludeExcludeMember)) continue;
            IncludeExcludeMember item = element;
            if (item.isHFS()) {
                key = CreateShiplistUtil.joinHFSSegments((String)item.getContainerName(), (String)item.getResourceName());
                if (hfsMembers.remove(key) == null) continue;
                hfsModified = true;
                continue;
            }
            if (!this.isZos) {
                key = String.valueOf(item.getContainerName()) + "(" + item.getResourceName() + ") OBJTYPE(" + item.getType() + ")";
            } else {
                String containerName = item.getContainerName();
                String resourceName = item.getResourceName();
                key = item.isSequential().booleanValue() ? (resourceName == null || resourceName.isEmpty() ? containerName : String.valueOf(containerName) + "." + resourceName) : String.valueOf(containerName) + "(" + resourceName + ")";
            }
            if (members.remove(key) == null) continue;
            modified = true;
        }
        if (!modified && selectedCategory != null) {
            members.clear();
            modified = true;
        }
        if (!hfsModified && selectedHFSCategory != null) {
            hfsMembers.clear();
            hfsModified = true;
        }
        if (modified) {
            this.saveMembersList(members.keySet(), propertyName);
        }
        if (hfsModified) {
            this.saveHFSMembersList(hfsMembers.values(), hfsPropertyName);
        }
        if (modified || hfsModified) {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Object[] expanded = treeViewer.getExpandedElements();
                    treeViewer.setInput(treeViewer.getInput());
                    if (members.size() > 0 && hfsMembers.size() > 0) {
                        treeViewer.setExpandedElements(expanded);
                    }
                    IncludeExcludeShiplistComposite.this.validate();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isInclude && this.page != null) {
            boolean oldIsWorkItemPackaging = this.isWorkItemPackaging;
            this.isWorkItemPackaging = "workitem".equals(((IPackagingWizardConfiguration)this.page.getConfiguration()).getPackageType());
            if (this.isWorkItemPackaging) {
                if (this.summaryPage == null) {
                    IWizardPage[] iWizardPageArray = this.page.getWizard().getPages();
                    int n = iWizardPageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWizardPage next = iWizardPageArray[n2];
                        if (next instanceof PackagingWorkItemSummaryWizardPage) {
                            this.summaryPage = (PackagingWorkItemSummaryWizardPage)next;
                            break;
                        }
                        ++n2;
                    }
                }
                if (this.summaryPage != null) {
                    new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            ISummaryNode node = IncludeExcludeShiplistComposite.this.summaryPage.getSummaryNode(true);
                            if (IncludeExcludeShiplistComposite.this.currentSummaryNode == null || !IncludeExcludeShiplistComposite.this.currentSummaryNode.equals(node)) {
                                IncludeExcludeShiplistComposite.this.currentSummaryNode = node;
                                IncludeExcludeShiplistComposite.this.workItemDeletionMembers.clear();
                                if (IncludeExcludeShiplistComposite.this.currentSummaryNode != null) {
                                    IncludeExcludeShiplistComposite.this.collectDeletedMembers((INode)IncludeExcludeShiplistComposite.this.currentSummaryNode);
                                }
                                new UIJob(""){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (!(this).IncludeExcludeShiplistComposite.this.treeViewer.getTree().isDisposed()) {
                                            (this).IncludeExcludeShiplistComposite.this.treeViewer.refresh();
                                            IncludeExcludeShiplistComposite.this.validate();
                                        }
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            } else if (this.isWorkItemPackaging != oldIsWorkItemPackaging) {
                this.treeViewer.refresh();
            }
        }
    }

    protected void collectDeletedMembers(INode node) {
        if (node == null) {
            return;
        }
        if (node.getType() == INode.Type.OUTPUT && ((IOutputNode)node).isDeletion()) {
            int space;
            int slash;
            IOutputNode output = (IOutputNode)node;
            String label = output.getLabel();
            if (!this.isZos && (slash = label.indexOf(47)) != -1 && (space = label.indexOf(32, slash)) != -1) {
                label = String.valueOf(label.substring(0, slash)) + "(" + label.substring(slash + 1, space) + ")" + label.substring(space);
            }
            this.workItemDeletionMembers.add(label);
        }
        if (node.hasChildren()) {
            for (INode kid : node.getChildren()) {
                this.collectDeletedMembers(kid);
            }
        }
    }

    protected void validate() {
        if (this.page == null) {
            return;
        }
        boolean valid = true;
        if (!this.workItemDeletionMembers.isEmpty() && !this.members.isEmpty()) {
            for (String nextDeletion : this.workItemDeletionMembers) {
                if (!this.members.containsKey(nextDeletion)) continue;
                valid = false;
                this.page.setMessage(Messages.IncludeExcludeShiplistComposite_WARNING_MEMBERS_DELETED, 2);
                break;
            }
        }
        if (valid) {
            this.page.setMessage(null);
        }
    }

    protected boolean isZosPackageDef(IBuildProperty property) {
        if (property == null) {
            return false;
        }
        String value = property.getValue();
        return "com.ibm.team.enterprise.packaging.zos".equals(value) || "com.ibm.team.enterprise.packaging.nonseq.zos".equals(value);
    }

    protected void updateButtonsEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        this.editButton.setEnabled(selection.size() == 1 && selection.getFirstElement() instanceof IncludeExcludeMember);
        this.removeButton.setEnabled(selection.size() >= 1);
    }

    public void setBuildDefinitionWorkingCopy(IBuildDefinition buildDefinitionWorkingCopy) {
        this.fBuildDefinitionWorkingCopy = buildDefinitionWorkingCopy;
    }

    private class AddAction
    extends Action {
        TreeViewer viewer;
        String propertyName;
        Hashtable<String, IncludeExcludeMember> members;

        AddAction(TreeViewer viewer, Hashtable<String, IncludeExcludeMember> members, String propertyName) {
            super(IncludeExcludeShiplistComposite.this.isZos ? com.ibm.team.enterprise.automation.internal.ui.nls.Messages.AbstractAutomationConfigurationEditor_ADD_MVS : com.ibm.team.enterprise.automation.internal.ui.nls.Messages.AbstractAutomationConfigurationEditor_ADD_LIBRARY_OBJECTS);
            this.viewer = viewer;
            this.propertyName = propertyName;
            this.members = members;
        }

        public void run() {
            if (this.viewer != null) {
                IncludeExcludeShiplistComposite.this.getAddEditShiplistDialog("", "", "", this.viewer, this.members, this.propertyName, false);
            }
        }
    }

    private class AddHFSAction
    extends AddAction {
        AddHFSAction(TreeViewer viewer, Hashtable<String, IncludeExcludeMember> members, String propertyName) {
            super(viewer, members, propertyName);
            this.setText(com.ibm.team.enterprise.automation.internal.ui.nls.Messages.AbstractAutomationConfigurationEditor_ADD_HFS);
        }

        @Override
        public void run() {
            if (this.viewer != null) {
                IncludeExcludeShiplistComposite.this.getAddEditHFSShiplistDialog("", "", this.viewer, this.members, this.propertyName, false);
            }
        }
    }

    public static class IncludeExcludeComparator
    extends AutomationViewerComparator {
        public int category(Object element) {
            if (element instanceof IncludeExcludeTableContentProvider.IncludeExcludeCategory) {
                if (((IncludeExcludeTableContentProvider.IncludeExcludeCategory)element).isHFS()) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
    }
}

