/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.packaging.common.util.FilteringIterator;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeMember;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableContentProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelIBMiProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelZProvider;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.progress.UIJob;

public class AddEditShiplistFilterDialog
extends SelectionStatusDialog {
    protected Button runQueryButton;
    protected Button addGenericFilter;
    protected Button useSpecificFilter;
    protected Button selectAll;
    protected Button deselectAll;
    protected Text dataSetFilter;
    protected Text memberFilter;
    protected Text typeFilter;
    protected Table resultsTable;
    protected String buildDefUUID = null;
    protected CheckboxTableViewer fTableViewer;
    protected Composite filterComposite = null;
    private final ITeamRepository repository;
    private final MappingValidation fValidator;
    private IEnterpriseConfiguration configuration = null;
    private List<IncludeExcludeMember> filteredResults = null;
    private final boolean isZos;
    private final boolean isInclude;
    private final boolean editType;
    private boolean isSpecificObjectFilter;
    private boolean dsFilterNeverEdited = false;
    private String datasetFilterString;
    private String memberFilterString = null;
    private String typeFilterString;
    private String resourcePrefixString = null;
    private String errorMessage = "";

    public AddEditShiplistFilterDialog(Shell parent, String buildDefUUID, ITeamRepository repository, String dataSetFilter, String memberFilter, String typeFilter, boolean isZos, boolean isInclude, boolean editType) {
        super(parent);
        this.setStatusLineAboveButtons(true);
        this.datasetFilterString = dataSetFilter;
        this.memberFilterString = memberFilter;
        this.typeFilterString = typeFilter;
        this.buildDefUUID = buildDefUUID;
        this.repository = repository;
        this.isZos = isZos;
        this.isInclude = isInclude;
        this.editType = editType;
        this.setTitle(Messages.AddEditShiplistFilterDialog_TITLE);
        this.setHelpAvailable(false);
        if (repository == null) {
            this.buildDefUUID = "";
        }
        if (this.buildDefUUID != null && !this.buildDefUUID.isEmpty()) {
            IBuildDefinitionHandle buildHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefUUID), null);
            IBuildDefinition buildDefinition = null;
            try {
                buildDefinition = (IBuildDefinition)repository.itemManager().fetchCompleteItem((IItemHandle)buildHandle, 0, (IProgressMonitor)new NullProgressMonitor());
                IProcessAreaHandle processAreaHandle = buildDefinition.getProcessArea();
                IProcessArea processArea = null;
                processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, (IProgressMonitor)new NullProgressMonitor());
                IProjectAreaHandle projectArea = processArea.getProjectArea();
                this.configuration = EnterpriseConfigurationCache.getInstance().fetch(repository, projectArea);
                if (this.datasetFilterString.isEmpty()) {
                    this.resourcePrefixString = buildDefinition.getPropertyValue("team.enterprise.scm.resourcePrefix", "");
                    this.datasetFilterString = String.valueOf(this.resourcePrefixString) + "*";
                    this.dsFilterNeverEdited = true;
                    if (this.memberFilterString.isEmpty()) {
                        this.memberFilterString = "*";
                    }
                    if (this.typeFilterString.isEmpty()) {
                        this.typeFilterString = "*";
                    }
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        this.fValidator = new MappingValidation(this.configuration);
    }

    protected void computeResult() {
    }

    public Object[] getResult() {
        if (!this.isSpecificObjectFilter) {
            if (this.isZos) {
                this.memberFilterString = this.memberFilterString.toUpperCase();
                this.datasetFilterString = this.datasetFilterString.toUpperCase();
            }
            return new IncludeExcludeMember[]{new IncludeExcludeMember(this.memberFilterString, this.datasetFilterString, this.typeFilterString, true, false)};
        }
        ArrayList<IncludeExcludeMember> results = new ArrayList<IncludeExcludeMember>();
        if (this.filteredResults != null) {
            for (IncludeExcludeMember result : this.filteredResults) {
                if (!result.getAddToShiplist()) continue;
                results.add(result);
            }
        }
        return results.toArray();
    }

    protected Control createDialogArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout headerLayout = new GridLayout(1, false);
        headerLayout.marginRight = 0;
        result.setLayout((Layout)headerLayout);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.minimumHeight = 350;
        data.minimumWidth = 800;
        result.setLayoutData((Object)data);
        this.createInputControl(result);
        this.createFilterControls(result);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void createFilterControls(Composite parent) {
        this.filterComposite = new Composite(parent, 0);
        GridLayout filterLayout = new GridLayout(7, false);
        filterLayout.marginRight = 0;
        this.filterComposite.setLayout((Layout)filterLayout);
        this.filterComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite tableComposite = new Composite(this.filterComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(6, 1).applyTo((Control)tableComposite);
        this.resultsTable = new Table(tableComposite, 68386);
        TableColumnLayout tcl = new TableColumnLayout();
        TableColumn column = new TableColumn(this.resultsTable, 0);
        column.setText(Messages.AddEditShiplistFilterDialog_MATCHED_MEMBERS_COLUMN_LABEL);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100));
        tableComposite.setLayout((Layout)tcl);
        if (this.buildDefUUID.length() == 0 || this.editType) {
            this.resultsTable.setEnabled(false);
        }
        this.fTableViewer = new CheckboxTableViewer(this.resultsTable);
        IncludeExcludeTableContentProvider contentProvider = new IncludeExcludeTableContentProvider();
        IncludeExcludeTableLabelProvider labelProvider = !this.isZos ? new IncludeExcludeTableLabelIBMiProvider() : new IncludeExcludeTableLabelZProvider();
        this.fTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTableViewer.addCheckStateListener(this.getCheckStateListener());
        Composite buttonBar = new Composite(this.filterComposite, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.horizontalSpacing = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.marginWidth = 0;
        buttonBar.setLayout((Layout)buttonLayout);
        this.selectAll = new Button(buttonBar, 0);
        if (this.buildDefUUID.length() == 0 || this.editType) {
            this.selectAll.setEnabled(false);
        }
        this.selectAll.setText(Messages.AddEditShiplistFilterDialog_SELECT_ALL_BUTTON_TEXT);
        this.selectAll.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.selectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddEditShiplistFilterDialog.this.fTableViewer.setAllChecked(true);
                for (IncludeExcludeMember member : AddEditShiplistFilterDialog.this.filteredResults) {
                    member.setAddToShiplit(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deselectAll = new Button(buttonBar, 0);
        this.deselectAll.setText(Messages.AddEditShiplistFilterDialog_DESELECT_ALL_BUTTON_TEXT);
        this.deselectAll.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (this.buildDefUUID.length() == 0 || this.editType) {
            this.deselectAll.setEnabled(false);
        }
        this.deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddEditShiplistFilterDialog.this.fTableViewer.setAllChecked(false);
                for (IncludeExcludeMember member : AddEditShiplistFilterDialog.this.filteredResults) {
                    member.setAddToShiplit(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.buildDefUUID.length() == 0) {
            this.runQueryButton.setEnabled(false);
            if (!this.isZos) {
                this.errorMessage = Messages.AddEditShiplistFilterDialog_NO_BUILD_DEF_OPTION_IBMi;
                this.updateStatus((IStatus)new Status(1, Messages.AddEditShiplistFilterDialog_INFO_MSG_PLUGINID, 1, this.errorMessage, null));
            } else {
                this.errorMessage = Messages.AddEditShiplistFilterDialog_NO_BUILD_DEF_OPTION_ZOS;
                this.updateStatus((IStatus)new Status(1, Messages.AddEditShiplistFilterDialog_INFO_MSG_PLUGINID, 1, this.errorMessage, null));
            }
        } else if (this.editType) {
            this.runQueryButton.setEnabled(false);
        }
    }

    protected void createInputControl(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout headerLayout = new GridLayout(7, false);
        headerLayout.verticalSpacing = 0;
        header.setLayout((Layout)headerLayout);
        GridData data = new GridData(4, 0x1000000, true, false, 2, 1);
        data.minimumWidth = 400;
        header.setLayoutData((Object)data);
        String desc = "";
        desc = !this.isZos ? (this.isInclude ? Messages.AddEditShiplistFilterDialog_INCLUDE_SHIPLIST_DESC_IBMI : Messages.AddEditShiplistFilterDialog_EXCLUDE_SHIPLIST_DESC_IBMI) : (this.isInclude ? Messages.AddEditShiplistFilterDialog_INCLUDE_SHIPLIST_DESC_ZOS : Messages.AddEditShiplistFilterDialog_EXCLUDE_SHIPLIST_DESC_ZOS);
        Label shiplistDesc = new Label(header, 0);
        shiplistDesc.setLayoutData((Object)new GridData(4, 128, true, false, 7, 1));
        shiplistDesc.setText(desc);
        Label spacer = new Label(header, 0);
        spacer.setText("");
        spacer.setLayoutData((Object)new GridData(4, 128, true, false, 7, 1));
        this.addGenericFilter = new Button(header, 16);
        this.addGenericFilter.setText(Messages.AddEditShiplistFilterDialog_AddGenericFilter);
        this.addGenericFilter.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        if (this.buildDefUUID.length() == 0) {
            this.addGenericFilter.setSelection(true);
            this.isSpecificObjectFilter = false;
        } else if (this.editType) {
            this.addGenericFilter.setSelection(true);
            this.isSpecificObjectFilter = false;
        } else {
            this.addGenericFilter.setSelection(false);
            this.isSpecificObjectFilter = true;
        }
        this.addGenericFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddEditShiplistFilterDialog.this.isSpecificObjectFilter = AddEditShiplistFilterDialog.this.useSpecificFilter.getSelection();
                AddEditShiplistFilterDialog.this.runQueryButton.setEnabled(AddEditShiplistFilterDialog.this.isSpecificObjectFilter);
                AddEditShiplistFilterDialog.this.resultsTable.setEnabled(AddEditShiplistFilterDialog.this.isSpecificObjectFilter);
                AddEditShiplistFilterDialog.this.selectAll.setEnabled(AddEditShiplistFilterDialog.this.isSpecificObjectFilter);
                AddEditShiplistFilterDialog.this.deselectAll.setEnabled(AddEditShiplistFilterDialog.this.isSpecificObjectFilter);
                if (AddEditShiplistFilterDialog.this.dsFilterNeverEdited) {
                    if (AddEditShiplistFilterDialog.this.isSpecificObjectFilter) {
                        AddEditShiplistFilterDialog.this.datasetFilterString = String.valueOf(AddEditShiplistFilterDialog.this.resourcePrefixString) + "*";
                    } else {
                        AddEditShiplistFilterDialog.this.datasetFilterString = AddEditShiplistFilterDialog.this.resourcePrefixString;
                    }
                    AddEditShiplistFilterDialog.this.dataSetFilter.setText(AddEditShiplistFilterDialog.this.datasetFilterString);
                    AddEditShiplistFilterDialog.this.dsFilterNeverEdited = true;
                }
                AddEditShiplistFilterDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new TooltipSupport((Control)this.addGenericFilter, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                if (!AddEditShiplistFilterDialog.this.isZos) {
                    return Messages.AddEditShiplistFilterDialog_IBMi_Generic_Filter_Tooltip;
                }
                return Messages.AddEditShiplistFilterDialog_ZOS_Generic_Filter_Tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return AddEditShiplistFilterDialog.this.addGenericFilter;
            }
        };
        this.useSpecificFilter = new Button(header, 16);
        this.useSpecificFilter.setLayoutData((Object)new GridData(16384, 128, false, false, 5, 1));
        if (this.buildDefUUID.length() == 0) {
            this.useSpecificFilter.setSelection(false);
            this.isSpecificObjectFilter = false;
        } else if (this.editType) {
            this.useSpecificFilter.setEnabled(false);
        } else {
            this.useSpecificFilter.setSelection(true);
            this.isSpecificObjectFilter = true;
        }
        if (!this.isZos) {
            this.useSpecificFilter.setText(Messages.AddEditShiplistFilterDialog_SelectSpecificObjectsFromBuild);
        } else {
            this.useSpecificFilter.setText(Messages.AddEditShiplistFilterDialog_SelectSpecificMembersFromBuild);
        }
        if (this.buildDefUUID.length() == 0) {
            this.useSpecificFilter.setEnabled(false);
        }
        this.useSpecificFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddEditShiplistFilterDialog.this.isSpecificObjectFilter = AddEditShiplistFilterDialog.this.useSpecificFilter.getSelection();
                AddEditShiplistFilterDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new TooltipSupport((Control)this.useSpecificFilter, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                if (!AddEditShiplistFilterDialog.this.isZos) {
                    return Messages.AddEditShiplistFilterDialog_IBMi_SelectSpecific_Filter_Tooltip;
                }
                return Messages.AddEditShiplistFilterDialog_ZOS_SelectSpecific_Filter_Tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return AddEditShiplistFilterDialog.this.useSpecificFilter;
            }
        };
        Label DataSetLabel = new Label(header, 0);
        DataSetLabel.setFont(parent.getFont());
        if (!this.isZos) {
            DataSetLabel.setText(Messages.AddEditShiplistFilterDialog_Library);
        } else {
            DataSetLabel.setText(Messages.AddEditShiplistFilterDialog_DataSetFiler);
        }
        DataSetLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.dataSetFilter = new Text(header, 2048);
        this.dataSetFilter.forceFocus();
        if (!this.isZos) {
            this.dataSetFilter.setTextLimit(10);
        }
        this.dataSetFilter.setText(this.datasetFilterString);
        this.dataSetFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.dataSetFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditShiplistFilterDialog.this.datasetFilterString = AddEditShiplistFilterDialog.this.dataSetFilter.getText();
                AddEditShiplistFilterDialog.this.dsFilterNeverEdited = false;
                AddEditShiplistFilterDialog.this.validate();
            }
        });
        new TooltipSupport((Control)this.dataSetFilter, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                if (!AddEditShiplistFilterDialog.this.isZos) {
                    return Messages.AddEditShiplistFilterDialog_IBMi_DatasetFilter_Tooltip;
                }
                return Messages.AddEditShiplistFilterDialog_ZOS_DatasetFilter_Tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return AddEditShiplistFilterDialog.this.dataSetFilter;
            }
        };
        Label MemberLabel = new Label(header, 0);
        MemberLabel.setFont(parent.getFont());
        if (!this.isZos) {
            MemberLabel.setText(Messages.AddEditShiplistFilterDialog_Object);
        } else {
            MemberLabel.setText(Messages.AddEditShiplistFilterDialog_MemberFilter);
        }
        MemberLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.memberFilter = new Text(header, 2048);
        this.memberFilter.setFont(header.getFont());
        this.memberFilter.setText(this.memberFilterString);
        this.memberFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.memberFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditShiplistFilterDialog.this.memberFilterString = AddEditShiplistFilterDialog.this.memberFilter.getText();
                AddEditShiplistFilterDialog.this.validate();
            }
        });
        if (!this.isZos) {
            Label TypeLabel = new Label(header, 0);
            TypeLabel.setFont(parent.getFont());
            TypeLabel.setText(Messages.AddEditShiplistFilterDialog_Type);
            TypeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.typeFilter = new Text(header, 2048);
            this.typeFilter.setFont(header.getFont());
            this.typeFilter.setText(this.typeFilterString);
            this.typeFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.typeFilter.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditShiplistFilterDialog.this.typeFilterString = AddEditShiplistFilterDialog.this.typeFilter.getText();
                    AddEditShiplistFilterDialog.this.validate();
                }
            });
        }
        this.runQueryButton = new Button(header, 0);
        this.runQueryButton.setText(Messages.AddEditShiplistFilterDialog_RUN_BUTTON_TEXT);
        this.runQueryButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        if (this.buildDefUUID.length() == 0 || this.editType) {
            this.runQueryButton.setEnabled(false);
        }
        this.runQueryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddEditShiplistFilterDialog.this.runQueryAndUpdateTable(AddEditShiplistFilterDialog.this.datasetFilterString, AddEditShiplistFilterDialog.this.memberFilterString, AddEditShiplistFilterDialog.this.typeFilterString);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void runQueryAndUpdateTable(final String datasetFilter, final String memberFilter, final String typeFilter) {
        String jobName = Messages.AddEditShiplistFilterDialog_RUNNING_QUERY_JOB_NAME;
        ArrayList<IncludeExcludeMember> querying = new ArrayList<IncludeExcludeMember>();
        querying.add(new IncludeExcludeMember("", Messages.AddEditShiplistFilterDialog_QUERYING_MSG_TEXT, "", true, false));
        this.fTableViewer.setInput(querying);
        this.fTableViewer.setAllChecked(false);
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AddEditShiplistFilterDialog.this.filteredResults = AddEditShiplistFilterDialog.this.runQuery(datasetFilter, memberFilter, typeFilter);
                    UIJob job = new UIJob(Messages.AddEditShiplistFilterDialog_UI_UPDATE_JOB_NAME){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!(this).AddEditShiplistFilterDialog.this.fTableViewer.getControl().isDisposed()) {
                                if (AddEditShiplistFilterDialog.this.filteredResults.isEmpty()) {
                                    ArrayList<IncludeExcludeMember> emptyResults = new ArrayList<IncludeExcludeMember>();
                                    emptyResults.add(new IncludeExcludeMember("", Messages.AddEditShiplistFilterDialog_EMPTY_RESULTS_MSG_TEXT, "", false, false));
                                    (this).AddEditShiplistFilterDialog.this.fTableViewer.setInput(emptyResults);
                                    (this).AddEditShiplistFilterDialog.this.fTableViewer.setAllGrayed(true);
                                    (this).AddEditShiplistFilterDialog.this.fTableViewer.setAllChecked(false);
                                } else {
                                    (this).AddEditShiplistFilterDialog.this.fTableViewer.setInput((Object)AddEditShiplistFilterDialog.this.filteredResults);
                                    (this).AddEditShiplistFilterDialog.this.fTableViewer.setAllChecked(true);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected List<IncludeExcludeMember> runQuery(String datasetFilter, String memberFilter, String typeFilter) throws TeamBuildException {
        ArrayList<IncludeExcludeMember> memberList = new ArrayList<IncludeExcludeMember>();
        try {
            FilteringIterator<IDataRow> results = this.runSelectQuery(datasetFilter, memberFilter, typeFilter);
            while (results.hasNext()) {
                IDataRow row = (IDataRow)results.next();
                String resourcePrefix = row.getString(0);
                String buildPath = row.getString(1);
                String buildFile = row.getString(2);
                String type = row.getString(4);
                boolean sequential = row.getBoolean(5);
                if (buildPath.startsWith("${team.enterprise.scm.resourcePrefix}")) {
                    buildPath = String.valueOf(resourcePrefix) + buildPath.substring(37);
                } else if (buildPath.startsWith("${teamz.scm.dataset.prefix}")) {
                    buildPath = String.valueOf(resourcePrefix) + buildPath.substring(27);
                }
                if (this.isZos) {
                    buildPath = buildPath.toUpperCase();
                }
                memberList.add(new IncludeExcludeMember(buildFile, buildPath, type, true, Boolean.toString(sequential), false));
            }
            return memberList;
        }
        catch (Exception e) {
            throw new TeamBuildException(Messages.AddEditShiplistFilterDialog_ERROR_PARSING, (Throwable)e);
        }
    }

    private Set<String> readMemberFilterFile(URI memberFilterFileURI) {
        HashSet<String> result = new HashSet<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(URIUtil.toFile((URI)memberFilterFileURI)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String member = line.trim().toUpperCase();
                    if (!this.validateMemberName(member)) continue;
                    result.add(member);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.errorMessage = NLS.bind((String)Messages.AddEditShiplistFilterDialog_ERROR_PARSING_MEMBER_FILE, (Object)memberFilterFileURI, (Object)e);
            new UIJob(Messages.AddEditShiplistFilterDialog_UI_UPDATE_JOB_NAME){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AddEditShiplistFilterDialog.this.updateStatus((IStatus)new Status(4, Messages.AddEditShiplistFilterDialog_INFO_MSG_PLUGINID, 4, AddEditShiplistFilterDialog.this.errorMessage, null));
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        return result;
    }

    private static URI getMemberFilterFile(String memberFilter) {
        URI result = null;
        try {
            URL url = new URL(memberFilter);
            result = url.toURI();
        }
        catch (Exception e) {
            try {
                URL url = new URL(memberFilter);
                result = URIUtil.toURI((URL)url);
            }
            catch (Exception e1) {
                result = null;
            }
        }
        if (result != null && !URIUtil.isFileURI((URI)result)) {
            result = null;
        }
        return result;
    }

    private FilteringIterator.Filter<IDataRow> generateMemberFilter(String buildPathFilter, URI uri) throws TeamBuildException {
        final Set<String> members = this.readMemberFilterFile(uri);
        return new FilteringIterator.Filter<IDataRow>(buildPathFilter){
            final Pattern correctedBuildPathFilter;
            final Pattern correctedBuildPathFilterOriginalCase;
            final boolean isBuildPathFiltering;
            {
                this.correctedBuildPathFilter = AddEditShiplistFilterDialog.getCorrectedBuildPathFilter(string, true);
                this.correctedBuildPathFilterOriginalCase = AddEditShiplistFilterDialog.getCorrectedBuildPathFilter(string, false);
                this.isBuildPathFiltering = string != null && string.trim().length() > 0;
            }

            public boolean accept(IDataRow row) {
                String resourcePrefix = this.isBuildPathFiltering ? row.getString(0) : null;
                String buildPath = this.isBuildPathFiltering ? row.getString(1) : null;
                String buildFile = row.getString(2);
                if (this.isBuildPathFiltering) {
                    buildPath = AddEditShiplistFilterDialog.handlePrefix(resourcePrefix, buildPath);
                }
                return members.contains(buildFile) && (!this.isBuildPathFiltering || this.correctedBuildPathFilter.matcher(buildPath).matches() || this.correctedBuildPathFilterOriginalCase.matcher(buildPath).matches());
            }
        };
    }

    private static String handlePrefix(String resourcePrefix, String buildPath) {
        if (buildPath.startsWith("${team.enterprise.scm.resourcePrefix}")) {
            buildPath = String.valueOf(resourcePrefix) + buildPath.substring(37);
        } else if (buildPath.startsWith("${teamz.scm.dataset.prefix}")) {
            buildPath = String.valueOf(resourcePrefix) + buildPath.substring(27);
        }
        return buildPath;
    }

    private static Pattern getCorrectedBuildPathFilter(String buildPathFilter, boolean uppercase) {
        return Pattern.compile((uppercase ? buildPathFilter.toUpperCase() : buildPathFilter).replace(".", "\\.").replace("*", ".*"));
    }

    private FilteringIterator.Filter<IDataRow> generatePatternMatchingFilter(String buildPathFilter, String buildFileFilter, String typeFilter) {
        return new FilteringIterator.Filter<IDataRow>(buildPathFilter, buildFileFilter, typeFilter){
            final Pattern correctedBuildPathFilter;
            final Pattern correctedBuildPathFilterOriginalCase;
            final Pattern correctedBuildFileFilter;
            final Pattern correctedTypeFilter;
            {
                this.correctedBuildPathFilter = AddEditShiplistFilterDialog.getCorrectedBuildPathFilter(string, true);
                this.correctedBuildPathFilterOriginalCase = AddEditShiplistFilterDialog.getCorrectedBuildPathFilter(string, false);
                this.correctedBuildFileFilter = Pattern.compile(string2.toUpperCase().replace("*", ".*"));
                this.correctedTypeFilter = Pattern.compile(string3.toUpperCase().replace("*", ".*"));
            }

            public boolean accept(IDataRow row) {
                String resourcePrefix = row.getString(0);
                String buildPath = row.getString(1);
                String buildFile = row.getString(2);
                String type = row.getString(4);
                buildPath = AddEditShiplistFilterDialog.handlePrefix(resourcePrefix, buildPath);
                return !(!this.correctedBuildFileFilter.matcher(buildFile).matches() || !this.correctedBuildPathFilter.matcher(buildPath).matches() && !this.correctedBuildPathFilterOriginalCase.matcher(buildPath).matches() || !AddEditShiplistFilterDialog.this.isZos && !this.correctedTypeFilter.matcher(type).matches());
            }
        };
    }

    protected FilteringIterator<IDataRow> runSelectQuery(String buildPathFilter, String buildFileFilter, String typeFilter) throws TeamRepositoryException {
        Iterator<IDataRow> unfilteredResults = this.getAllOutputs();
        URI memberFilterFileURI = AddEditShiplistFilterDialog.getMemberFilterFile(buildFileFilter);
        FilteringIterator.Filter<IDataRow> filter = memberFilterFileURI != null ? this.generateMemberFilter(buildPathFilter, memberFilterFileURI) : this.generatePatternMatchingFilter(buildPathFilter, buildFileFilter, typeFilter);
        return new FilteringIterator(unfilteredResults, filter);
    }

    private Iterator<IDataRow> getAllOutputs() throws TeamRepositoryException {
        IPackagingClient packagingClient = (IPackagingClient)this.repository.getClientLibrary(IPackagingClient.class);
        Iterator unfilteredResults = packagingClient.getAllOutputs(UUID.valueOf((String)this.buildDefUUID), Boolean.valueOf(false));
        return unfilteredResults;
    }

    protected void refreshResults() {
    }

    protected ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IncludeExcludeMember filterResult = (IncludeExcludeMember)event.getElement();
                filterResult.setAddToShiplit(event.getChecked());
            }
        };
    }

    protected void validate() {
        Status status = new Status(0, "com.ibm.team.enterprise.packaging.ui", "");
        if (!this.useSpecificFilter.getSelection() && !this.isZos) {
            if (this.dataSetFilter.getText().trim().equals("") || !IBMiLibraryValidator.isValidLibraryName((String)this.dataSetFilter.getText().trim())) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_VALIDLIBRARY);
            }
        } else if (!this.useSpecificFilter.getSelection() && this.fValidator.isValidDSName(this.dataSetFilter.getText().trim()) != 0) {
            status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_VALIDPDS);
        }
        if (!this.isSpecificObjectFilter && this.datasetFilterString.equals("*") && this.memberFilterString.equals("*")) {
            if (!this.isZos && this.typeFilterString.equals("*")) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_GENERICVALUEIBMI);
            } else if (this.isZos) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_GENERICVALUEZOS);
            }
        } else if (!this.isSpecificObjectFilter && this.datasetFilterString.equals("") && this.memberFilterString.equals("")) {
            if (!this.isZos && this.typeFilterString.equals("")) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_VALUESMISSING_IBMI);
            } else if (this.isZos) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_VALUESMISSING_ZOS);
            }
        } else if (!this.isSpecificObjectFilter && this.datasetFilterString.equals("")) {
            status = !this.isZos ? new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_LIBRARYMISSING) : new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_PDSMISSING);
        } else if (!this.isSpecificObjectFilter && this.memberFilterString.equals("")) {
            if (!this.isZos) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_OBJECTMISSING);
            }
        } else if (!this.isSpecificObjectFilter && !this.isZos && this.typeFilterString.equals("")) {
            status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditShiplistFilterDialog_ERROR_TYPEMISSING);
        }
        this.updateStatus((IStatus)status);
        this.updateButtonsEnableState((IStatus)status);
    }

    private boolean validateMemberName(String memberName) {
        return this.isZos ? this.fValidator.isValidMemberName(memberName) == 0 : IBMiLibraryValidator.isValidLibraryName((String)memberName);
    }
}

