/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.wizards;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.enterprise.packaging.common.util.CreateShiplistUtil;
import com.ibm.team.enterprise.packaging.common.util.FilteringIterator;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeMember;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableContentProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelIBMiProvider;
import com.ibm.team.enterprise.packaging.ui.IncludeExcludeTableLabelZProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.progress.UIJob;

public class AddEditHFSShiplistFilterDialog
extends SelectionStatusDialog {
    private String buildDefUUID;
    private final ITeamRepository repository;
    private final String directoryFilter;
    private final String patternFilter;
    private final boolean isZos;
    private final boolean isInclude;
    private final boolean editType;
    private Button addGenericFilter;
    private Button useSpecificFilter;
    private Button selectAll;
    private Button deselectAll;
    private Composite genericComposite;
    private Composite specificComposite;
    private Text genericDirectoryText;
    private Text genericPatternText;
    private Text specificPathFilterText;
    private CheckboxTableViewer specificTableViewer;

    public AddEditHFSShiplistFilterDialog(Shell parent, String buildDefUUID, ITeamRepository repository, String directoryFilter, String patternFilter, boolean isZos, boolean isInclude, boolean editType) {
        super(parent);
        this.setStatusLineAboveButtons(true);
        this.buildDefUUID = buildDefUUID;
        this.repository = repository;
        this.directoryFilter = directoryFilter;
        this.patternFilter = patternFilter;
        this.isZos = isZos;
        this.isInclude = isInclude;
        this.editType = editType;
        this.setTitle(Messages.AddEditShiplistFilterDialog_TITLE);
        this.setHelpAvailable(false);
        if (repository == null) {
            this.buildDefUUID = "";
        }
    }

    protected Control createDialogArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout headerLayout = new GridLayout(1, false);
        headerLayout.marginRight = 0;
        result.setLayout((Layout)headerLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).minSize(800, 350).applyTo((Control)result);
        this.createInputControl(result);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void createInputControl(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout headerLayout = new GridLayout(2, false);
        headerLayout.verticalSpacing = 0;
        header.setLayout((Layout)headerLayout);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).minSize(400, 0).applyTo((Control)header);
        String desc = this.isInclude ? Messages.AddEditHFSShiplistFilterDialog_INCLUDE_SHIPLIST_DESC : Messages.AddEditHFSShiplistFilterDialog_EXCLUDE_SHIPLIST_DESC;
        Label shiplistDesc = new Label(header, 0);
        shiplistDesc.setText(desc);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)shiplistDesc);
        this.createSpacer(header, 2);
        this.addGenericFilter = new Button(header, 16);
        this.addGenericFilter.setText(Messages.AddEditShiplistFilterDialog_AddGenericFilter);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.addGenericFilter);
        this.addGenericFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditHFSShiplistFilterDialog.this.updateVisibility();
                AddEditHFSShiplistFilterDialog.this.validate();
            }
        });
        new TooltipSupport((Control)this.addGenericFilter, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return AddEditHFSShiplistFilterDialog.this.addGenericFilter;
            }
        };
        this.useSpecificFilter = new Button(header, 16);
        GridDataFactory.fillDefaults().align(16384, 128).grab(false, false).applyTo((Control)this.useSpecificFilter);
        this.useSpecificFilter.setText(Messages.AddEditHFSShiplistFilterDialog_SelectSpecificObjectsFromBuild);
        this.useSpecificFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditHFSShiplistFilterDialog.this.updateVisibility();
                AddEditHFSShiplistFilterDialog.this.validate();
            }
        });
        new TooltipSupport((Control)this.useSpecificFilter, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return Messages.AddEditHFSShiplistFilterDialog_SelectSpecific_Filter_Tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return AddEditHFSShiplistFilterDialog.this.useSpecificFilter;
            }
        };
        this.createSpacer(header, 2);
        this.createGenericControls(header);
        this.createSpecificControls(header);
        if (this.buildDefUUID.isEmpty() || this.editType) {
            this.useSpecificFilter.setEnabled(false);
            this.addGenericFilter.setSelection(true);
            this.genericDirectoryText.setFocus();
        } else {
            this.useSpecificFilter.setSelection(true);
            this.specificPathFilterText.setFocus();
        }
        this.updateVisibility();
        this.validate();
    }

    protected void createGenericControls(Composite parent) {
        this.genericComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.genericComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.genericComposite);
        Label genericDesc = new Label(this.genericComposite, 64);
        genericDesc.setText(Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Description);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)genericDesc);
        Label directoryLabel = new Label(this.genericComposite, 0);
        directoryLabel.setText(Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Directory);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)directoryLabel);
        this.genericDirectoryText = new Text(this.genericComposite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.genericDirectoryText);
        if (this.directoryFilter != null) {
            this.genericDirectoryText.setText(this.directoryFilter);
        }
        this.genericDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditHFSShiplistFilterDialog.this.validate();
            }
        });
        Label patternLabel = new Label(this.genericComposite, 0);
        patternLabel.setText(Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Pattern);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)patternLabel);
        this.genericPatternText = new Text(this.genericComposite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.genericPatternText);
        if (this.patternFilter != null) {
            this.genericPatternText.setText(this.patternFilter);
        }
        this.genericPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditHFSShiplistFilterDialog.this.validate();
            }
        });
        this.createSpacer(this.genericComposite, 2);
        Label example = new Label(this.genericComposite, 0);
        example.setText(Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Example_Label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)example);
        example.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(16));
        Label exampleDirectoryLabel = new Label(this.genericComposite, 0);
        exampleDirectoryLabel.setText(Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Directory);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)exampleDirectoryLabel);
        exampleDirectoryLabel.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(16));
        Text exampleDirectoryText = new Text(this.genericComposite, 2060);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)exampleDirectoryText);
        exampleDirectoryText.setText(Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Example_Directory);
        exampleDirectoryText.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(16));
        Label examplePatternLabel = new Label(this.genericComposite, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)examplePatternLabel);
        examplePatternLabel.setText(Messages.AddEditHFSShiplistFilterDialog_Generic_Filter_Pattern);
        examplePatternLabel.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(16));
        Text examplePatternText = new Text(this.genericComposite, 2060);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)examplePatternText);
        examplePatternText.setText("**/*.jar");
        examplePatternText.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(16));
    }

    protected void createSpecificControls(Composite parent) {
        this.specificComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.specificComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(this.specificComposite);
        final Label filterLabel = new Label(this.specificComposite, 0);
        filterLabel.setText(Messages.AddEditHFSShiplistFilterDialog_Specific_Filter_Path_Filter_Label);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)filterLabel);
        this.specificPathFilterText = new Text(this.specificComposite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.specificPathFilterText);
        new TooltipSupport((Control)filterLabel, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return Messages.AddEditHFSShiplistFilterDialog_Specific_Filter_Path_Filter_Tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return filterLabel;
            }
        };
        new TooltipSupport((Control)this.specificPathFilterText, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return Messages.AddEditHFSShiplistFilterDialog_Specific_Filter_Path_Filter_Tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return AddEditHFSShiplistFilterDialog.this.specificPathFilterText;
            }
        };
        Button runButton = new Button(this.specificComposite, 8);
        runButton.setText(Messages.AddEditShiplistFilterDialog_RUN_BUTTON_TEXT);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(false, false).applyTo((Control)runButton);
        runButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditHFSShiplistFilterDialog.this.runQueryAndUpdateTable(AddEditHFSShiplistFilterDialog.this.specificPathFilterText.getText().trim());
            }
        });
        Composite tableComposite = new Composite(this.specificComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).minSize(200, 200).applyTo((Control)tableComposite);
        Table resultsTable = new Table(tableComposite, 68386);
        TableColumnLayout tcl = new TableColumnLayout();
        TableColumn column = new TableColumn(resultsTable, 0);
        column.setText(Messages.AddEditHFSShiplistFilterDialog_Specific_Filter_Table_Column);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100));
        tableComposite.setLayout((Layout)tcl);
        this.specificTableViewer = new CheckboxTableViewer(resultsTable);
        this.specificTableViewer.setContentProvider((IContentProvider)new IncludeExcludeTableContentProvider());
        if (!this.isZos) {
            this.specificTableViewer.setLabelProvider((IBaseLabelProvider)new IncludeExcludeTableLabelIBMiProvider());
        } else {
            this.specificTableViewer.setLabelProvider((IBaseLabelProvider)new IncludeExcludeTableLabelZProvider());
        }
        Composite buttonBar = new Composite(this.specificComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, true).applyTo((Control)buttonBar);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.horizontalSpacing = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.marginWidth = 0;
        buttonBar.setLayout((Layout)buttonLayout);
        this.selectAll = new Button(buttonBar, 0);
        this.selectAll.setText(Messages.AddEditShiplistFilterDialog_SELECT_ALL_BUTTON_TEXT);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.selectAll);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditHFSShiplistFilterDialog.this.specificTableViewer.setAllChecked(true);
            }
        });
        this.deselectAll = new Button(buttonBar, 0);
        this.deselectAll.setText(Messages.AddEditShiplistFilterDialog_DESELECT_ALL_BUTTON_TEXT);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.deselectAll);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditHFSShiplistFilterDialog.this.specificTableViewer.setAllChecked(false);
            }
        });
    }

    protected void createSpacer(Composite parent, int colspan) {
        Label spacer = new Label(parent, 0);
        spacer.setText("");
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(colspan, 1).applyTo((Control)spacer);
    }

    protected void runQueryAndUpdateTable(final String pathFilter) {
        ArrayList<IncludeExcludeMember> querying = new ArrayList<IncludeExcludeMember>();
        querying.add(new IncludeExcludeMember("", Messages.AddEditShiplistFilterDialog_QUERYING_MSG_TEXT, "", false, false));
        this.specificTableViewer.setInput(querying);
        this.specificTableViewer.setAllChecked(false);
        this.specificTableViewer.getTable().setEnabled(false);
        this.selectAll.setEnabled(false);
        this.deselectAll.setEnabled(false);
        new Job(Messages.AddEditShiplistFilterDialog_RUNNING_QUERY_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final List<IncludeExcludeMember> filteredResults = AddEditHFSShiplistFilterDialog.this.runQuery(pathFilter);
                    new UIJob(Messages.AddEditShiplistFilterDialog_UI_UPDATE_JOB_NAME){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!AddEditHFSShiplistFilterDialog.this.specificTableViewer.getControl().isDisposed()) {
                                if (filteredResults.isEmpty()) {
                                    ArrayList<IncludeExcludeMember> emptyResults = new ArrayList<IncludeExcludeMember>();
                                    emptyResults.add(new IncludeExcludeMember("", Messages.AddEditShiplistFilterDialog_EMPTY_RESULTS_MSG_TEXT, "", false, false));
                                    AddEditHFSShiplistFilterDialog.this.specificTableViewer.setInput(emptyResults);
                                    AddEditHFSShiplistFilterDialog.this.specificTableViewer.setAllChecked(false);
                                } else {
                                    AddEditHFSShiplistFilterDialog.this.specificTableViewer.setInput((Object)filteredResults);
                                    AddEditHFSShiplistFilterDialog.this.specificTableViewer.setAllChecked(true);
                                    AddEditHFSShiplistFilterDialog.this.specificTableViewer.getTable().setEnabled(true);
                                    AddEditHFSShiplistFilterDialog.this.selectAll.setEnabled(true);
                                    AddEditHFSShiplistFilterDialog.this.deselectAll.setEnabled(true);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected List<IncludeExcludeMember> runQuery(String pathFilter) throws TeamBuildException {
        ArrayList<IncludeExcludeMember> fileList = new ArrayList<IncludeExcludeMember>();
        try {
            FilteringIterator<IDataRow> results = this.runSelectQuery(pathFilter);
            while (results.hasNext()) {
                IDataRow row = (IDataRow)results.next();
                String directory = row.getString(1);
                String pattern = row.getString(2);
                if (pattern.trim().isEmpty()) {
                    pattern = "**";
                }
                fileList.add(new IncludeExcludeMember(pattern, directory, "", true, true));
            }
            return fileList;
        }
        catch (Exception e) {
            throw new TeamBuildException(Messages.AddEditShiplistFilterDialog_ERROR_PARSING, (Throwable)e);
        }
    }

    protected FilteringIterator<IDataRow> runSelectQuery(String pathFilter) throws TeamRepositoryException {
        final StringMatcher matcher = pathFilter.isEmpty() ? null : new StringMatcher("*" + pathFilter.trim() + "*", true, false);
        IPackagingClient packagingClient = (IPackagingClient)this.repository.getClientLibrary(IPackagingClient.class);
        Iterator unfilteredResults = packagingClient.getAllOutputs(UUID.valueOf((String)this.buildDefUUID), Boolean.valueOf(true));
        return new FilteringIterator(unfilteredResults, (FilteringIterator.Filter)new FilteringIterator.Filter<IDataRow>(){

            public boolean accept(IDataRow row) {
                if (matcher == null) {
                    return true;
                }
                String directory = row.getString(1);
                String pattern = row.getString(2);
                String joined = CreateShiplistUtil.joinHFSSegments((String)directory, (String)pattern);
                return matcher.match(joined.toString());
            }
        });
    }

    protected void updateVisibility() {
        Control c;
        Composite toHide;
        Composite toShow;
        if (this.addGenericFilter.getSelection()) {
            toShow = this.genericComposite;
            toHide = this.specificComposite;
        } else {
            toShow = this.specificComposite;
            toHide = this.genericComposite;
        }
        toShow.setVisible(true);
        ((GridData)toShow.getLayoutData()).exclude = false;
        Control[] controlArray = toShow.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            c.setVisible(true);
            ++n2;
        }
        toHide.setVisible(false);
        ((GridData)toHide.getLayoutData()).exclude = true;
        controlArray = toHide.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            c.setVisible(false);
            ++n2;
        }
        toShow.getParent().getParent().layout(true);
    }

    protected void validate() {
        Status status = new Status(0, "com.ibm.team.enterprise.packaging.ui", "");
        if (this.addGenericFilter.getSelection()) {
            if (status.isOK() && this.genericPatternText.getText().trim().isEmpty()) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditHFSShiplistFilterDialog_ERROR_NO_PATTERN);
            }
            if (status.isOK() && this.genericDirectoryText.getText().trim().startsWith("/")) {
                status = new Status(4, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditHFSShiplistFilterDialog_WARNING_ABSOLUTE_DIRECTORY);
            }
        }
        if (status.isOK() && this.buildDefUUID.isEmpty()) {
            status = new Status(1, "com.ibm.team.enterprise.packaging.ui", Messages.AddEditHFSShiplistFilterDialog_NO_BUILD_DEF);
        }
        this.updateStatus((IStatus)status);
        this.updateButtonsEnableState((IStatus)status);
    }

    protected void computeResult() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.useSpecificFilter.getSelection()) {
            Object[] objectArray = this.specificTableViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                result.add(element);
                ++n2;
            }
        } else {
            result.add(new IncludeExcludeMember(this.genericPatternText.getText(), this.genericDirectoryText.getText(), "", true, true));
        }
        this.setResult(result);
    }
}

