/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.automation.internal.ui.editors.AbstractAutomationConfigurationEditor;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.ui.RestoreMappingComposite;
import com.ibm.team.enterprise.automation.ui.RestoreMappingMember;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.packaging.dialogs.IBMiBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.packaging.dialogs.zOSBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.IncludeExcludeShiplistComposite;
import com.ibm.team.enterprise.packaging.ui.PackagingUIPlugin;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PackagingNonSequentialConfigurationEditor
extends AbstractAutomationConfigurationEditor {
    private static final String PACKAGE_DIRECTORY_VARIABLE = "$\\{team.package.common.package.dir}";
    private static final String PACKAGE_HFS_DIRECTORY_VARIABLE = "$\\{team.enterprise.packaging.hfs.buildRoot.dir}";
    protected Text packageRootDirText;
    protected Text hfsRootDirText;
    protected Text packagePreCommandText;
    protected Text packagePostCommandText;
    protected Text zosPackageScriptText;
    protected Text ibmiSaveFileLibraryText;
    protected Text ibmiSaveFileOptionsText;
    protected Text luwBuildRootDirText;
    protected Text fBuildDefinitionNameText;
    protected Button publishManifest;
    protected Button publishPackage;
    protected Button publishIntermediates;
    protected Button fSelectBuildDefinitionButton;
    private Button deleteOutputsButton;
    protected RestoreMappingComposite restoreMappingComposite;
    protected CTabFolder tabFolder;
    private int tabFolderIndex = 0;
    protected CTabItem packageTab;
    protected CTabItem publishTab;
    protected Button autoClean;
    protected Button concurrentSafe;
    protected Button ucdPackageTypeButton;
    protected Button ucdPackageGeneration;
    protected Text ucdPackageComponentText;
    protected Button ucdPackageApplyPrefixButton;
    protected Text ucdPackageVersionPrefixText;
    protected Button ucdVersionName_Timestamp_Button;
    protected Button ucdVersionName_Workitem_Button;
    protected Button ucdVersionName_Prompt_Button;
    protected Text ucdToolkitScriptText;
    protected Text ucdPropertyManifestFileText;
    protected Button ucdVerboseLogging;
    protected Button ucdIncludeBuildmapInfoButton;
    protected Button ucdDeferRepositoryAddress;
    protected IncludeExcludeShiplistComposite includeShiplistComposite;
    protected IncludeExcludeShiplistComposite excludeShiplistComposite;
    protected boolean isUcd = false;
    protected boolean isUcdBuildmapInfo = false;

    public PackagingNonSequentialConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected void createApplicationProperties(Composite parent, FormToolkit toolkit) {
    }

    protected void createCommonPlatformPropertySection(Composite parent, FormToolkit toolkit) {
        Section fPlatformSection = toolkit.createSection(parent, 0);
        fPlatformSection.setLayoutData((Object)new TableWrapData(256, 256));
        fPlatformSection.setLayout((Layout)new TableWrapLayout());
        Composite fPlatformPropertyComposite = toolkit.createComposite((Composite)fPlatformSection);
        fPlatformPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fPlatformPropertyComposite.setLayout((Layout)this.getTableWrapLayout());
        this.createPlatformProperties(fPlatformPropertyComposite, toolkit);
        fPlatformSection.setClient((Control)fPlatformPropertyComposite);
    }

    protected void createBuildDefinitionSelectionSection(Composite parent, FormToolkit toolkit) {
        Section fBuildDefinitionSection = toolkit.createSection(parent, 4096);
        fBuildDefinitionSection.setLayoutData((Object)new TableWrapData(256, 256));
        fBuildDefinitionSection.setLayout((Layout)new TableWrapLayout());
        Composite fBuildDefinitionComposite = toolkit.createComposite((Composite)fBuildDefinitionSection);
        fBuildDefinitionComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        fBuildDefinitionComposite.setLayout((Layout)layout);
        this.fBuildDefinitionTitleHyperlink = toolkit.createHyperlink(fBuildDefinitionComposite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PACKAGING_SECTION_BUILDDEF_LABEL, 0);
        this.fBuildDefinitionTitleHyperlink.addHyperlinkListener(this.getBuildDefinitionHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fBuildDefinitionTitleHyperlink.getForeground();
        TableWrapData data = new TableWrapData(2, 32);
        this.fBuildDefinitionTitleHyperlink.setLayoutData((Object)data);
        this.fBuildDefinitionNameText = toolkit.createText(fBuildDefinitionComposite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fBuildDefinitionNameText.getForeground();
        this.fBuildDefinitionNameText.setEnabled(false);
        this.fBuildDefinitionNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fBuildDefinitionNameText.setLayoutData((Object)layoutData);
        this.fSelectBuildDefinitionButton = toolkit.createButton(fBuildDefinitionComposite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PACKACING_BUILDDEF_SELECTION_BUTTON_LABEL, 0);
        this.fSelectBuildDefinitionButton.addSelectionListener(this.getSelectzOSBuildDefinitionListener());
        this.fSelectBuildDefinitionButton.setLayoutData((Object)new TableWrapData(4, 32));
        String BuildDefUUID = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.package.common.buildDefinition.uuid", "");
        if (BuildDefUUID.length() == 0) {
            this.setBuildDefinitionNameText("", false);
        } else {
            this.setBuildDefinitionNameText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PACKAGING_HYPERLINK_JOB, false);
            final IBuildDefinitionHandle buildHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)BuildDefUUID), null);
            String jobName = com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PACKAGING_HYPERLINK_JOB_FETCH;
            Job job = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PackagingNonSequentialConfigurationEditor.this.fBuildDefinition = PackagingNonSequentialConfigurationEditor.this.fetchBuildDefinition(buildHandle, monitor);
                        PackagingNonSequentialConfigurationEditor.this.handleUpdateBuildDefinitionText(PackagingNonSequentialConfigurationEditor.this.fBuildDefinition.getId(), true);
                    }
                    catch (Exception e) {
                        PackagingNonSequentialConfigurationEditor.this.handleUpdateBuildDefinitionText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_BUILD_DEFINITION_DELETED_ERROR, false);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        data = new TableWrapData(128, 256);
        Section packageSection = toolkit.createSection(parent, 4096);
        packageSection.setLayoutData((Object)data);
        packageSection.setLayout((Layout)new TableWrapLayout());
        Composite fpackageComposite = toolkit.createComposite((Composite)packageSection);
        fpackageComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fpackageComposite.setLayout((Layout)this.getTableWrapLayoutWithoutIndent());
        this.createPackageProperties(fpackageComposite, toolkit);
        this.createPlatformProperties(fpackageComposite, toolkit);
        this.createUrbanCodeProperties(fpackageComposite, toolkit);
        packageSection.setClient((Control)fpackageComposite);
        fBuildDefinitionSection.setClient((Control)fBuildDefinitionComposite);
        data = new TableWrapData(256, 256);
        Section includeExcludeSection = toolkit.createSection(parent, 256);
        includeExcludeSection.setLayoutData((Object)data);
        includeExcludeSection.setLayout((Layout)new TableWrapLayout());
        includeExcludeSection.setText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_SECTION_INCLUDE_EXCLUDE_FILTERS_TITLE);
        Composite includeExcludeComposite = toolkit.createComposite((Composite)includeExcludeSection);
        layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        includeExcludeComposite.setLayoutData((Object)new TableWrapData(256, 256));
        includeExcludeComposite.setLayout((Layout)layout);
        this.createIncludeTableControl(includeExcludeComposite);
        this.createExcludeTableControl(includeExcludeComposite);
        includeExcludeSection.setClient((Control)includeExcludeComposite);
    }

    protected void createRestoreMappingControlSection(Composite parent, FormToolkit toolkit) {
        Section RestoreMappingSection = toolkit.createSection(parent, 4480);
        if (this.isIBMiPackageDef()) {
            RestoreMappingSection.setDescription(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_SECTION_RESTOREMAPPING_DESCRIPTION_IBMi);
        } else {
            RestoreMappingSection.setDescription(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_SECTION_RESTOREMAPPING_DESCRIPTION_zOS);
        }
        RestoreMappingSection.setTitleBarBorderColor(Display.getCurrent().getSystemColor(1));
        RestoreMappingSection.setTitleBarBackground(Display.getCurrent().getSystemColor(1));
        RestoreMappingSection.setLayoutData((Object)new TableWrapData(256, 256));
        RestoreMappingSection.setLayout((Layout)new TableWrapLayout());
        Composite RestoreMappingComposite2 = toolkit.createComposite((Composite)RestoreMappingSection);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.leftMargin = 20;
        RestoreMappingComposite2.setLayout((Layout)layout);
        RestoreMappingComposite2.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, 3);
        tableWrapData.heightHint = 0;
        Label hiddenLabel = toolkit.createLabel(RestoreMappingComposite2, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_RESTORE_MAPPING_TABLE_HIDDEN_LABEL);
        hiddenLabel.setVisible(false);
        hiddenLabel.setLayoutData((Object)tableWrapData);
        this.createRestoreMappingControl(RestoreMappingComposite2);
        RestoreMappingSection.setClient((Control)RestoreMappingComposite2);
    }

    protected void createExcludeTableControl(Composite parent) {
        this.excludeShiplistComposite = new IncludeExcludeShiplistComposite(parent, null, (AbstractConfigurationElementEditor)this, this.fBuildDefinitionWorkingCopy, "exclude");
        TableWrapData data = new TableWrapData(256, 256, 1, 2);
        data.heightHint = 300;
        data.maxWidth = 100;
        this.excludeShiplistComposite.setLayoutData(data);
    }

    public void createRestoreMappingControl(Composite parent) {
        this.restoreMappingComposite = new RestoreMappingComposite(parent, "team.package.restore.mapping", (AbstractAutomationConfigurationEditor)this, this.fBuildDefinitionWorkingCopy);
    }

    protected void createIncludeTableControl(Composite parent) {
        this.includeShiplistComposite = new IncludeExcludeShiplistComposite(parent, null, (AbstractConfigurationElementEditor)this, this.fBuildDefinitionWorkingCopy, "include");
        TableWrapData data = new TableWrapData(256, 256, 1, 2);
        data.heightHint = 300;
        data.maxWidth = 100;
        this.includeShiplistComposite.setLayoutData(data);
    }

    public Control getFocusControl() {
        return this.packageRootDirText;
    }

    protected void createApplicationPropertySection(Composite parent, FormToolkit toolkit) {
    }

    protected void createExtensibleContributionSection(Composite parent, FormToolkit toolkit) {
    }

    protected void createPackageProperties(Composite parent, FormToolkit toolkit) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.packageRoot.dir");
        this.packageRootDirText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_PACKAGEROOT_DIR, property.getValue());
        this.packageRootDirText.addModifyListener(this.getTextModifyListener("team.package.common.packageRoot.dir", this.packageRootDirText));
        if (this.isZosPackageDefNonSeq()) {
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.packaging.hfs.buildRoot.dir");
            this.hfsRootDirText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_TEXT_HFSROOT_DIR, property == null ? "" : property.getValue(), com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_TEXT_HFSROOT_DIR_TOOLTIP);
            this.hfsRootDirText.addModifyListener(this.getTextModifyListener("team.enterprise.packaging.hfs.buildRoot.dir", this.hfsRootDirText, true));
        }
        this.createRuntimeProperties(parent, toolkit);
    }

    protected Button createCheckbox(Composite parent, FormToolkit toolkit, String label, IBuildProperty property, String propertyName, boolean defaultValue, int colspan, TableWrapData buttonData) {
        Button button = toolkit.createButton(parent, label, 32);
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            button.setSelection(propertyValue);
        } else {
            button.setSelection(defaultValue);
        }
        buttonData.colspan = colspan;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    protected void createUrbanCodeProperties(Composite parent, FormToolkit toolkit) {
        if (!this.isZosPackageDef()) {
            return;
        }
        int colspan = 1;
        Section section = toolkit.createSection(parent, 384);
        TableWrapData sectionData = new TableWrapData(256, 256);
        sectionData.colspan = 2;
        section.setLayoutData((Object)sectionData);
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_SECTION_UCD_TITLE);
        section.setDescription(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_SECTION_UCD_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)section);
        TableWrapData compositeData = new TableWrapData(256, 256);
        compositeData.colspan = 2;
        composite.setLayoutData((Object)compositeData);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        IBuildProperty ucdTypeProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ucd.type");
        if (ucdTypeProperty != null) {
            this.isUcd = Boolean.parseBoolean(ucdTypeProperty.getValue());
        }
        TableWrapData buttonData = new TableWrapData(2, 32);
        this.ucdPackageTypeButton = this.createCheckbox(composite, toolkit, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_PACKAGE_TYPE, ucdTypeProperty, "team.package.ucd.type", false, colspan, buttonData);
        this.ucdPackageTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingNonSequentialConfigurationEditor.this.isUcd = PackagingNonSequentialConfigurationEditor.this.ucdPackageTypeButton.getSelection();
                PackagingNonSequentialConfigurationEditor.this.validate();
                PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.package.ucd.type", Boolean.toString(PackagingNonSequentialConfigurationEditor.this.isUcd));
                PackagingNonSequentialConfigurationEditor.this.ucdPackageGeneration.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdPackageComponentText.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdPackageVersionPrefixText.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Workitem_Button.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Timestamp_Button.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Prompt_Button.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdToolkitScriptText.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdPropertyManifestFileText.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdVerboseLogging.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdIncludeBuildmapInfoButton.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd);
                PackagingNonSequentialConfigurationEditor.this.ucdDeferRepositoryAddress.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcd && PackagingNonSequentialConfigurationEditor.this.isUcdBuildmapInfo);
                PackagingNonSequentialConfigurationEditor.this.setDirty(true);
            }
        });
        String propertyName = "team.package.ucd.generate";
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        buttonData = new TableWrapData(256, 256);
        this.ucdPackageGeneration = this.createCheckbox(composite, toolkit, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_PACKAGE_GENERATE, property, "team.package.ucd.generate", false, colspan, buttonData);
        this.ucdPackageGeneration.setEnabled(this.isUcd);
        this.ucdPackageGeneration.addSelectionListener(this.getButtonSelectionListener(propertyName, this.ucdPackageGeneration));
        new TooltipSupport((Control)this.ucdPackageGeneration, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.UcdPackageGenerateTooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return PackagingNonSequentialConfigurationEditor.this.ucdPackageGeneration;
            }
        };
        propertyName = "team.package.ucd.includeBuildmapInfo";
        property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        buttonData = new TableWrapData(256, 256);
        this.ucdIncludeBuildmapInfoButton = this.createCheckbox(composite, toolkit, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_RTC_BUILDMAP_INFO, property, "team.package.ucd.includeBuildmapInfo", false, colspan, buttonData);
        this.ucdIncludeBuildmapInfoButton.setEnabled(this.isUcd);
        if (property != null) {
            this.isUcdBuildmapInfo = Boolean.parseBoolean(property.getValue());
        }
        this.ucdIncludeBuildmapInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingNonSequentialConfigurationEditor.this.isUcdBuildmapInfo = PackagingNonSequentialConfigurationEditor.this.ucdIncludeBuildmapInfoButton.getSelection();
                PackagingNonSequentialConfigurationEditor.this.validate();
                PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.package.ucd.includeBuildmapInfo", Boolean.toString(PackagingNonSequentialConfigurationEditor.this.isUcdBuildmapInfo));
                PackagingNonSequentialConfigurationEditor.this.ucdDeferRepositoryAddress.setEnabled(PackagingNonSequentialConfigurationEditor.this.isUcdBuildmapInfo);
                PackagingNonSequentialConfigurationEditor.this.setDirty(true);
            }
        });
        new TooltipSupport((Control)this.ucdIncludeBuildmapInfoButton, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.UcdPackageIncludeBuildmapInfoTooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return PackagingNonSequentialConfigurationEditor.this.ucdIncludeBuildmapInfoButton;
            }
        };
        propertyName = "team.package.ucd.deferRepositoryAddress";
        property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        buttonData = new TableWrapData(256, 256);
        this.ucdDeferRepositoryAddress = this.createCheckbox(composite, toolkit, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_DEFER_RTC_REPOSITORY_ADDRESS, property, "team.package.ucd.deferRepositoryAddress", false, colspan, buttonData);
        this.ucdDeferRepositoryAddress.setEnabled(this.isUcdBuildmapInfo);
        this.ucdDeferRepositoryAddress.addSelectionListener(this.getButtonSelectionListener(propertyName, this.ucdDeferRepositoryAddress));
        new TooltipSupport((Control)this.ucdDeferRepositoryAddress, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.UcdPackageDeferRepositoryAddressTooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return PackagingNonSequentialConfigurationEditor.this.ucdDeferRepositoryAddress;
            }
        };
        propertyName = "team.package.ucd.verbose";
        property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        buttonData = new TableWrapData(256, 256);
        this.ucdVerboseLogging = this.createCheckbox(composite, toolkit, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_VERBOSE, property, "team.package.ucd.verbose", false, 2, buttonData);
        this.ucdVerboseLogging.setEnabled(this.isUcd);
        this.ucdVerboseLogging.addSelectionListener(this.getButtonSelectionListener(propertyName, this.ucdVerboseLogging));
        propertyName = "team.package.ucd.tk.script";
        property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        String stringPropertyValue = "";
        if (property != null) {
            stringPropertyValue = property.getValue();
        }
        this.ucdToolkitScriptText = this.createLabeledText(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_UCD_TOOLKIT_SCRIPTT, stringPropertyValue);
        this.ucdToolkitScriptText.addModifyListener(this.getTextModifyListener(propertyName, this.ucdToolkitScriptText));
        this.ucdToolkitScriptText.setEnabled(this.isUcd);
        propertyName = "team.package.ucd.propertyManifestFile";
        property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        stringPropertyValue = "";
        if (property != null) {
            stringPropertyValue = property.getValue();
        }
        this.ucdPropertyManifestFileText = this.createLabeledText(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_UCD_PROPERTY_MANIFEST_FILE, stringPropertyValue);
        this.ucdPropertyManifestFileText.addModifyListener(this.getTextModifyListener(propertyName, this.ucdPropertyManifestFileText));
        this.ucdPropertyManifestFileText.setEnabled(this.isUcd);
        new TooltipSupport((Control)this.ucdPropertyManifestFileText, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.UcdPropertyManifestTooltip;
            }

            public Object getElement(Control control, int x, int y) {
                return PackagingNonSequentialConfigurationEditor.this.ucdPropertyManifestFileText;
            }
        };
        propertyName = "team.package.ucd.component";
        property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        stringPropertyValue = "";
        if (property != null) {
            stringPropertyValue = property.getValue();
        }
        this.ucdPackageComponentText = this.createLabeledText(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_UCD_COMPONENT, stringPropertyValue);
        this.ucdPackageComponentText.addModifyListener(this.getTextModifyListener(propertyName, this.ucdPackageComponentText));
        this.ucdPackageComponentText.setEnabled(this.isUcd);
        this.createUcdVersionNameConventionRadioButton(composite, toolkit, this.isUcd);
        propertyName = "team.package.ucd.versionName.prefix";
        property = this.fBuildDefinitionWorkingCopy.getProperty(propertyName);
        stringPropertyValue = "";
        if (property != null) {
            stringPropertyValue = property.getValue();
        }
        this.ucdPackageVersionPrefixText = this.createLabeledText(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_UCD_VERSION_PREFIX, stringPropertyValue);
        this.ucdPackageVersionPrefixText.addModifyListener(this.getTextModifyListener(propertyName, this.ucdPackageVersionPrefixText));
        this.ucdPackageVersionPrefixText.setEnabled(this.isUcd);
        section.setClient((Control)composite);
    }

    protected SelectionListener getUcdVersionNameTimestampListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Timestamp_Button.getSelection()) {
                    PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.package.ucd.versionName.convention", "TIMESTAMP");
                    PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Prompt_Button.setSelection(false);
                    PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Workitem_Button.setSelection(false);
                    PackagingNonSequentialConfigurationEditor.this.validate();
                    PackagingNonSequentialConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected SelectionListener getUcdVersionNameWorkitemListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Workitem_Button.getSelection()) {
                    PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.package.ucd.versionName.convention", "WORKITEM");
                    PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Prompt_Button.setSelection(false);
                    PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Timestamp_Button.setSelection(false);
                    PackagingNonSequentialConfigurationEditor.this.validate();
                    PackagingNonSequentialConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected SelectionListener getUcdVersionNamePromptListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Prompt_Button.getSelection()) {
                    PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.package.ucd.versionName.convention", "PROMPT");
                    PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Timestamp_Button.setSelection(false);
                    PackagingNonSequentialConfigurationEditor.this.ucdVersionName_Workitem_Button.setSelection(false);
                    PackagingNonSequentialConfigurationEditor.this.validate();
                    PackagingNonSequentialConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected void createUcdVersionNameConventionRadioButton(Composite parent, FormToolkit toolkit, boolean isUcd) {
        Composite composite = toolkit.createComposite(parent);
        TableWrapData compositeData = new TableWrapData(256, 256);
        compositeData.colspan = 2;
        composite.setLayoutData((Object)compositeData);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.leftMargin = 0;
        composite.setLayout((Layout)layout);
        boolean ucdVersionNameConventionNotSet = false;
        IBuildProperty ucdVersionNameConvention = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ucd.versionName.convention");
        if (ucdVersionNameConvention == null || ucdVersionNameConvention.getValue() == null) {
            this.fBuildDefinitionWorkingCopy.setProperty("team.package.ucd.versionName.convention", "TIMESTAMP");
            ucdVersionNameConventionNotSet = true;
        }
        Label ucdNameConventionLabel = toolkit.createLabel(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_UCD_VERSION_NAME_CONVENTION);
        ucdNameConventionLabel.setLayoutData((Object)new TableWrapData());
        this.ucdVersionName_Timestamp_Button = toolkit.createButton(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_VERSION_NAME_CONVENTION_1, 16);
        boolean selected = ucdVersionNameConventionNotSet || "TIMESTAMP".equals(ucdVersionNameConvention.getValue());
        this.ucdVersionName_Timestamp_Button.setSelection(selected);
        this.ucdVersionName_Timestamp_Button.setData((Object)"TIMESTAMP");
        this.ucdVersionName_Timestamp_Button.setEnabled(isUcd);
        this.ucdVersionName_Timestamp_Button.addSelectionListener(this.getUcdVersionNameTimestampListener());
        this.ucdVersionName_Timestamp_Button.setLayoutData((Object)new TableWrapData());
        this.createSpacer(composite, 1, 1, toolkit);
        this.ucdVersionName_Workitem_Button = toolkit.createButton(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_VERSION_NAME_CONVENTION_2, 16);
        selected = !ucdVersionNameConventionNotSet && "WORKITEM".equals(ucdVersionNameConvention.getValue());
        this.ucdVersionName_Workitem_Button.setSelection(selected);
        this.ucdVersionName_Workitem_Button.setData((Object)"WORKITEM");
        this.ucdVersionName_Workitem_Button.setEnabled(isUcd);
        this.ucdVersionName_Workitem_Button.addSelectionListener(this.getUcdVersionNameWorkitemListener());
        this.ucdVersionName_Workitem_Button.setLayoutData((Object)new TableWrapData());
        this.createSpacer(composite, 1, 1, toolkit);
        this.ucdVersionName_Prompt_Button = toolkit.createButton(composite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_UCD_VERSION_NAME_CONVENTION_3, 16);
        selected = !ucdVersionNameConventionNotSet && "PROMPT".equals(ucdVersionNameConvention.getValue());
        this.ucdVersionName_Prompt_Button.setSelection(selected);
        this.ucdVersionName_Prompt_Button.setData((Object)"PROMPT");
        this.ucdVersionName_Prompt_Button.setEnabled(isUcd);
        this.ucdVersionName_Prompt_Button.addSelectionListener(this.getUcdVersionNamePromptListener());
        this.ucdVersionName_Prompt_Button.setLayoutData((Object)new TableWrapData());
    }

    protected void createRuntimeProperties(Composite parent, FormToolkit toolkit) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.prePackageCommand");
        String commandTooltip = null;
        if (this.isZosPackageDefNonSeq()) {
            commandTooltip = NLS.bind((String)Messages.CommandPropertiesTooltip, (Object)"$\\{team.package.common.package.dir}<br>$\\{team.enterprise.packaging.hfs.buildRoot.dir}");
        }
        this.packagePreCommandText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_PACKAGE_PRECOMMAND, property.getValue(), commandTooltip);
        this.packagePreCommandText.addModifyListener(this.getTextModifyListener("team.package.common.prePackageCommand", this.packagePreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.postPackageCommand");
        this.packagePostCommandText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_TEXT_PACKAGE_POSTCOMMAND, property.getValue(), commandTooltip);
        this.packagePostCommandText.addModifyListener(this.getTextModifyListener("team.package.common.postPackageCommand", this.packagePostCommandText));
    }

    protected void createPublishProperties(Composite parent, FormToolkit toolkit) {
        boolean propertyValue;
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.isManifestPublished");
        this.publishManifest = toolkit.createButton(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_PUBLISHMANIFEST, 32);
        if (property != null) {
            boolean propertyValue2 = Boolean.parseBoolean(property.getValue());
            this.publishManifest.setSelection(propertyValue2);
        } else {
            this.publishManifest.setSelection(false);
        }
        TableWrapData buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishManifest.setLayoutData((Object)buttonData);
        this.publishManifest.addSelectionListener(this.getButtonSelectionListener("team.package.common.isManifestPublished", this.publishManifest));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.isPackagePublished");
        this.publishPackage = toolkit.createButton(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_PUBLISHPACKAGE, 32);
        if (property != null) {
            propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishPackage.setSelection(propertyValue);
        } else {
            this.publishPackage.setSelection(false);
        }
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishPackage.setLayoutData((Object)buttonData);
        this.publishPackage.addSelectionListener(this.getButtonSelectionListener("team.package.common.isPackagePublished", this.publishPackage));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.isIntermediatesPublished");
        this.publishIntermediates = toolkit.createButton(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_PUBLISHINTERMEDIATES, 32);
        if (property != null) {
            propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishIntermediates.setSelection(propertyValue);
        } else {
            this.publishIntermediates.setSelection(false);
        }
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishIntermediates.setLayoutData((Object)buttonData);
        this.publishIntermediates.addSelectionListener(this.getButtonSelectionListener("team.package.common.isIntermediatesPublished", this.publishIntermediates));
    }

    protected void createAutoCleanProperties(Composite parent, FormToolkit toolkit) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.isAutoClean");
        this.autoClean = toolkit.createButton(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_AUTOCLEAN, 32);
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            this.autoClean.setSelection(propertyValue);
        } else {
            this.autoClean.setSelection(false);
        }
        TableWrapData buttonData = new TableWrapData(2, 32);
        buttonData.colspan = 2;
        this.autoClean.setLayoutData((Object)buttonData);
        this.autoClean.addSelectionListener(this.getButtonSelectionListener("team.package.common.isAutoClean", this.autoClean));
    }

    protected void createConcurrentSafeProperty(Composite parent, FormToolkit toolkit) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.isConcurrentSafe");
        this.concurrentSafe = toolkit.createButton(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_CONCURRENTSAFE, 32);
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            this.concurrentSafe.setSelection(propertyValue);
        } else {
            this.concurrentSafe.setSelection(false);
        }
        TableWrapData buttonData = new TableWrapData(2, 32);
        buttonData.colspan = 2;
        this.concurrentSafe.setLayoutData((Object)buttonData);
        this.concurrentSafe.addSelectionListener(this.getButtonSelectionListener("team.package.common.isConcurrentSafe", this.concurrentSafe));
    }

    protected void createPlatformProperties(Composite parent, FormToolkit toolkit) {
        if (this.isZosPackageDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.zos.script");
            String zosScript = null;
            if (property == null || property.getValue().trim().isEmpty()) {
                zosScript = Utils.getDefaultIspfGatewayLocation();
                this.fBuildDefinitionWorkingCopy.setProperty("team.package.zos.script", zosScript);
            } else {
                zosScript = property.getValue();
            }
            this.zosPackageScriptText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.ZOS_PACKAGING_SCRIPT, zosScript);
            this.zosPackageScriptText.addModifyListener(this.getTextModifyListener("team.package.zos.script", this.zosPackageScriptText));
            this.deleteOutputsButton = toolkit.createButton(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_DELETEOUTPUTS, 32);
            TableWrapData buttonData = new TableWrapData(2, 32);
            buttonData.colspan = 2;
            this.deleteOutputsButton.setLayoutData((Object)buttonData);
            this.addControlDecorator((Control)this.deleteOutputsButton, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_BUTTON_DELETEOUTPUTS_DESC, 131072);
            IBuildProperty deleteProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.packaging.deleteObsoleteOutputs");
            if (deleteProperty != null && !deleteProperty.getValue().isEmpty()) {
                this.deleteOutputsButton.setSelection(Boolean.parseBoolean(deleteProperty.getValue()));
            } else {
                this.deleteOutputsButton.setSelection(false);
            }
            this.deleteOutputsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PackagingNonSequentialConfigurationEditor.this.validate();
                    IBuildProperty buildProperty = PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.packaging.deleteObsoleteOutputs");
                    if (buildProperty == null) {
                        PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.packaging.deleteObsoleteOutputs", Boolean.toString(PackagingNonSequentialConfigurationEditor.this.deleteOutputsButton.getSelection()));
                    } else {
                        buildProperty.setValue(Boolean.toString(PackagingNonSequentialConfigurationEditor.this.deleteOutputsButton.getSelection()));
                    }
                    PackagingNonSequentialConfigurationEditor.this.setDirty(true);
                }
            });
        } else if (this.isIBMiPackageDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ibmi.intermediateSaveFileLibrary");
            this.ibmiSaveFileLibraryText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.IBMI_PACKAGING_SAVEFILE_LIBRARY, property.getValue());
            this.ibmiSaveFileLibraryText.addModifyListener(this.getTextModifyListener("team.package.ibmi.intermediateSaveFileLibrary", this.ibmiSaveFileLibraryText));
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ibmi.savefileOptions");
            this.ibmiSaveFileOptionsText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.IBMI_PACKAGING_SAVEFILE_OPTIONS, property.getValue());
            this.ibmiSaveFileOptionsText.addModifyListener(this.getTextModifyListener("team.package.ibmi.savefileOptions", this.ibmiSaveFileOptionsText));
        } else {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.luw.buildRoot.dir");
            this.luwBuildRootDirText = this.createLabeledText(parent, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.LUW_PACKAGING_BUILD_ROOT_DIR, property.getValue());
            this.luwBuildRootDirText.addModifyListener(this.getTextModifyListener("team.package.luw.buildRoot.dir", this.luwBuildRootDirText));
        }
    }

    protected void addControlDecorator(Control targetControl, String descriptionText, int style) {
        final ControlDecoration dec = new ControlDecoration(targetControl, style);
        if (targetControl instanceof Text) {
            dec.setMarginWidth(2);
        }
        dec.setDescriptionText(descriptionText);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        dec.hide();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    dec.show();
                }
                if (event.type == 27) {
                    dec.hide();
                }
            }
        };
        targetControl.addListener(26, listener);
        targetControl.addListener(27, listener);
    }

    protected ModifyListener getTextModifyListener(final String propertyID, final Text propertyWidget, final boolean forceNotEditable) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackagingNonSequentialConfigurationEditor.this.validate();
                PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty(propertyID, propertyWidget.getText().trim());
                if (forceNotEditable) {
                    PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty(propertyID).setGenericEditAllowed(false);
                }
                PackagingNonSequentialConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected boolean validateProperties() {
        boolean isValid = true;
        if (this.packageRootDirText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.packageRootDirText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_ERROR_PACKAGEROOTDIRMISSING, (Control)this.packageRootDirText);
            isValid = false;
        } else {
            this.removeMessage(this.packageRootDirText, (Control)this.packageRootDirText);
        }
        if (this.isIBMiPackageDef()) {
            String[] s;
            this.removeMessage(this.ibmiSaveFileLibraryText, (Control)this.ibmiSaveFileLibraryText);
            this.removeMessage(this.restoreMappingComposite, (Control)this.restoreMappingComposite);
            this.removeMessage(this.ibmiSaveFileOptionsText, (Control)this.ibmiSaveFileOptionsText);
            if (this.ibmiSaveFileLibraryText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.ibmiSaveFileLibraryText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.IBMI_SAVEFILE_ERROR_MESSAGE, (Control)this.ibmiSaveFileLibraryText);
                isValid = false;
            } else if (!this.ibmiSaveFileLibraryText.getText().trim().startsWith("${") && !IBMiLibraryValidator.isValidLibraryName((String)this.ibmiSaveFileLibraryText.getText().trim())) {
                this.addErrorMessageForRequiredField(this.ibmiSaveFileLibraryText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_SAVE_FILE_LIBARY_NAME_NOT_VALID, (Control)this.ibmiSaveFileLibraryText);
                isValid = false;
            }
            String saveFileOptions = this.ibmiSaveFileOptionsText.getText().trim();
            String[] o = saveFileOptions.split("[ ]");
            boolean saveFileOptionsValid = false;
            if (o.length == 1 && (s = saveFileOptions.split("[()]")).length == 2 && s[0].trim().toUpperCase().compareToIgnoreCase("TGTRLS") == 0) {
                saveFileOptionsValid = true;
            }
            if (!saveFileOptionsValid) {
                this.addErrorMessageForRequiredField(this.ibmiSaveFileOptionsText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_SAVE_FILE_OPTIONS_NOT_VALID, (Control)this.ibmiSaveFileOptionsText);
                isValid = false;
            }
            if (this.restoreMappingComposite.isToContainerMissing()) {
                this.addErrorMessageForRequiredField(this.restoreMappingComposite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_ERROR_VALIDATECONTAINERMAPPING_TOLIBRARY, (Control)this.restoreMappingComposite);
                isValid = false;
            }
        } else if (this.isZosPackageDef()) {
            if (this.zosPackageScriptText.getText().trim().length() == 0) {
                this.addErrorMessageForRequiredField(this.zosPackageScriptText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.ZOS_SCRIPT_ERROR_MESSAGE, (Control)this.zosPackageScriptText);
                isValid = false;
            } else {
                this.removeMessage(this.zosPackageScriptText, (Control)this.zosPackageScriptText);
            }
            this.removeMessage(this.ucdToolkitScriptText, (Control)this.ucdToolkitScriptText);
            this.removeMessage(this.ucdPackageComponentText, (Control)this.ucdPackageComponentText);
            if (this.isUcd) {
                this.removeMessage(this.restoreMappingComposite, (Control)this.restoreMappingComposite);
                boolean isUcdGenerated = this.ucdPackageGeneration.getSelection();
                if (isUcdGenerated) {
                    String ucdTkString = this.ucdToolkitScriptText.getText();
                    if (ucdTkString == null || "".equals(ucdTkString.trim())) {
                        this.addErrorMessageForRequiredField(this.ucdToolkitScriptText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.UCD_NO_TOOLKIT_SCRIPT_ERROR_MESSAGE, (Control)this.ucdToolkitScriptText);
                        isValid = false;
                    } else {
                        this.removeMessage(this.ucdToolkitScriptText, (Control)this.ucdToolkitScriptText);
                    }
                    String ucdComponentString = this.ucdPackageComponentText.getText();
                    if (ucdComponentString != null && "".equals(ucdComponentString.trim())) {
                        this.addErrorMessageForRequiredField(this.ucdPackageComponentText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.UCD_NO_COMPONENT_ERROR_MESSAGE, (Control)this.ucdPackageComponentText);
                        isValid = false;
                    } else {
                        this.removeMessage(this.ucdPackageComponentText, (Control)this.ucdPackageComponentText);
                    }
                }
            } else {
                this.removeMessage(this.restoreMappingComposite, (Control)this.restoreMappingComposite);
                if (this.restoreMappingComposite.isToContainerMissing()) {
                    this.addErrorMessageForRequiredField(this.restoreMappingComposite, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_ERROR_VALIDATECONTAINERMAPPING_TOPDS, (Control)this.restoreMappingComposite);
                    isValid = false;
                }
            }
        } else if (this.luwBuildRootDirText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.luwBuildRootDirText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.LUW_BUILD_ROOT_ERROR_MESSAGE, (Control)this.luwBuildRootDirText);
            isValid = false;
        } else {
            this.removeMessage(this.luwBuildRootDirText, (Control)this.luwBuildRootDirText);
        }
        if (this.hfsRootDirText != null) {
            String hfsShiplist = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.package.common.include.hfs.binaries", "");
            if (this.hfsRootDirText.getText().trim().isEmpty() && !hfsShiplist.isEmpty()) {
                this.addErrorMessageForRequiredField(this.hfsRootDirText, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_ERROR_NO_HFS_DIR, (Control)this.hfsRootDirText);
                isValid = false;
            } else {
                this.removeMessage(this.hfsRootDirText, (Control)this.hfsRootDirText);
            }
        }
        return isValid;
    }

    protected void runRestoreMappingQuery(final String BuildDefUUID) {
        String jobName = com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_RUNNING_QUERY_JOB_NAME;
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List<RestoreMappingMember> members = PackagingNonSequentialConfigurationEditor.this.runQuery(BuildDefUUID);
                    PackagingNonSequentialConfigurationEditor.this.restoreMappingComposite.mergeRestoreMappingMembers(members);
                }
                catch (Exception e) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected List<RestoreMappingMember> runQuery(String BuildDefUUID) {
        Hashtable<String, RestoreMappingMember> restoreMappingMembers = new Hashtable<String, RestoreMappingMember>();
        try {
            IPackagingClient packagingClient = (IPackagingClient)((ITeamRepository)this.fBuildDefinition.getOrigin()).getClientLibrary(IPackagingClient.class);
            Iterator results = packagingClient.getAllOutputs(UUID.valueOf((String)BuildDefUUID), Boolean.valueOf(false));
            while (results.hasNext()) {
                IDataRow row = (IDataRow)results.next();
                String resourcePrefix = row.getString(0);
                String buildPath = row.getString(1);
                if (buildPath.startsWith("${teamz.scm.dataset.prefix}")) {
                    buildPath = String.valueOf(resourcePrefix) + buildPath.substring(27);
                } else if (buildPath.startsWith("${team.enterprise.scm.resourcePrefix}")) {
                    buildPath = String.valueOf(resourcePrefix) + buildPath.substring(37);
                }
                if (this.isZosPackageDefNonSeq() || this.isZosPackageDef()) {
                    buildPath = buildPath.toUpperCase();
                }
                restoreMappingMembers.put(buildPath, new RestoreMappingMember(buildPath, ""));
            }
            return new ArrayList<RestoreMappingMember>(restoreMappingMembers.values());
        }
        catch (Exception exception) {
            return new ArrayList<RestoreMappingMember>(restoreMappingMembers.values());
        }
    }

    protected SelectionListener getSelectzOSBuildDefinitionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiBuildDefinitionSelectionDialog dialog1;
                if (PackagingNonSequentialConfigurationEditor.this.isZosPackageDef()) {
                    zOSBuildDefinitionSelectionDialog dialog = new zOSBuildDefinitionSelectionDialog(PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionTitleHyperlink.getShell(), PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy != null ? PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProcessArea() : null);
                    if (dialog.open() == 0) {
                        IBuildDefinition selectedBuildDef = dialog.getFirstSelectedBuildDefinition();
                        PackagingNonSequentialConfigurationEditor.this.setBuildDefinition(selectedBuildDef);
                    }
                } else if (PackagingNonSequentialConfigurationEditor.this.isIBMiPackageDef() && (dialog1 = new IBMiBuildDefinitionSelectionDialog(PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionTitleHyperlink.getShell(), PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy != null ? PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProcessArea() : null)).open() == 0) {
                    IBuildDefinition selectedBuildDef = dialog1.getFirstSelectedBuildDefinition();
                    PackagingNonSequentialConfigurationEditor.this.setBuildDefinition(selectedBuildDef);
                }
            }
        };
    }

    protected void handleUpdateBuildDefinitionText(final String packageDefName, final boolean valid) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PackagingNonSequentialConfigurationEditor.this.fBuildDefinitionNameText.isDisposed()) {
                    PackagingNonSequentialConfigurationEditor.this.setBuildDefinitionNameText(packageDefName, valid);
                }
            }
        });
    }

    protected void setBuildDefinition(IBuildDefinition buildDefinition) {
        String hfsRoot;
        this.fBuildDefinition = buildDefinition;
        this.fBuildDefinitionWorkingCopy.setProperty("team.package.common.buildDefinition.uuid", this.fBuildDefinition.getItemId().getUuidValue());
        if (this.hfsRootDirText != null && this.hfsRootDirText.getText().trim().isEmpty() && (hfsRoot = this.fBuildDefinition.getPropertyValue("team.enterprise.build.hfs.outputdir", null)) != null) {
            this.hfsRootDirText.setText(hfsRoot);
        }
        this.setDirty(true);
        this.setBuildDefinitionNameText(this.fBuildDefinition.getId(), true);
        this.runRestoreMappingQuery(this.fBuildDefinition.getItemId().getUuidValue());
        this.validate();
    }

    private void setBuildDefinitionNameText(String text, boolean workspaceSet) {
        this.fBuildDefinitionNameText.setText(text);
        this.fBuildDefinitionNameText.setEnabled(workspaceSet);
        this.setBuildDefinitionTitleHyperlinkEnablement(workspaceSet);
    }

    protected String getConfigurationId() {
        return "com.ibm.team.enterprise.packaging";
    }

    protected String getApplicationDescriptionPropertyName() {
        return "team.package.common.applicationDescription";
    }

    protected String getApplicationNamePropertyName() {
        return "team.package.common.applicationName";
    }

    protected String getApplicationVersionPropertyName() {
        return "team.package.common.version";
    }

    protected String getIsCompletePackagePropertyName() {
        return "team.package.common.isCompletePackage";
    }

    public void createContent(Composite parent, FormToolkit kit) {
        this.toolkit = kit;
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData(256, 256);
        parent.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        if (this.isZosPackageDef()) {
            this.tabFolder = new CTabFolder(parent, 0x800080);
            this.toolkit.adapt((Control)this.tabFolder, true, true);
            this.tabFolder.setLayout((Layout)new TableWrapLayout());
            this.tabFolder.setLayoutData((Object)data);
            this.toolkit.paintBordersFor((Composite)this.tabFolder);
            this.toolkit.getColors().initializeSectionToolBarColors();
            Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
            this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{100}, true);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PackagingNonSequentialConfigurationEditor.this.tabFolderIndex = PackagingNonSequentialConfigurationEditor.this.tabFolder.getSelectionIndex();
                }
            });
            this.createTabs(this.toolkit);
            this.tabFolder.setSelection(this.tabFolderIndex);
            this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
            this.packageTab.setControl((Control)this.createPackageTab((Composite)this.tabFolder, this.toolkit));
            this.publishTab.setControl((Control)this.createOptionTab((Composite)this.tabFolder, this.toolkit));
        } else if (this.isIBMiPackageDef()) {
            this.tabFolder = new CTabFolder(parent, 0x800080);
            this.toolkit.adapt((Control)this.tabFolder, true, true);
            this.tabFolder.setLayout((Layout)new TableWrapLayout());
            this.tabFolder.setLayoutData((Object)data);
            this.toolkit.paintBordersFor((Composite)this.tabFolder);
            this.toolkit.getColors().initializeSectionToolBarColors();
            Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
            this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{100}, true);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PackagingNonSequentialConfigurationEditor.this.tabFolderIndex = PackagingNonSequentialConfigurationEditor.this.tabFolder.getSelectionIndex();
                }
            });
            this.createTabs(this.toolkit);
            this.tabFolder.setSelection(this.tabFolderIndex);
            this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
            this.packageTab.setControl((Control)this.createPackageTab((Composite)this.tabFolder, this.toolkit));
            this.publishTab.setControl((Control)this.createOptionTab((Composite)this.tabFolder, this.toolkit));
        }
    }

    private void createTabs(FormToolkit toolkit) {
        this.packageTab = this.createTab(toolkit, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_PACKAGE);
        this.packageTab.setImage(PackagingUIPlugin.getImage("icons/obj16/package_tab.gif"));
        this.publishTab = this.createTab(toolkit, com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_OPTIONS);
        this.publishTab.setImage(PackagingUIPlugin.getImage("icons/obj16/options.gif"));
    }

    private CTabItem createTab(FormToolkit toolkit, String title) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(title);
        return item;
    }

    private Composite createOptionTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createRestoreMappingControlSection(parent, toolkit);
        this.createConcurrentSafePropertySection(parent, toolkit);
        this.createAutocleanPropertySection(parent, toolkit);
        this.createCommonPublishPropertySection(parent, toolkit);
        return parent;
    }

    private Composite createPackageTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createBuildDefinitionSelectionSection(parent, toolkit);
        this.createExtensibleContributionSection(parent, toolkit);
        this.createApplicationPropertySection(parent, toolkit);
        return parent;
    }

    protected void createCommonPublishPropertySection(Composite parent, FormToolkit toolkit) {
        Section fPublishSection = toolkit.createSection(parent, 128);
        fPublishSection.setDescription(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingConfigurationEditor_SECTION_PUBLISH_DESCRIPTION);
        fPublishSection.setLayoutData((Object)new TableWrapData(256, 256));
        fPublishSection.setLayout((Layout)new TableWrapLayout());
        Composite fPublishPropertyComposite = toolkit.createComposite((Composite)fPublishSection);
        fPublishPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fPublishPropertyComposite.setLayout((Layout)this.getTableWrapLayoutWithoutIndent());
        this.createPublishProperties(fPublishPropertyComposite, toolkit);
        fPublishSection.setClient((Control)fPublishPropertyComposite);
    }

    private void createAutocleanPropertySection(Composite parent, FormToolkit toolkit) {
        Section fAutocleanSection = toolkit.createSection(parent, 128);
        fAutocleanSection.setDescription(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackagingNonSequentialConfigurationEditor_AUTO_CLEAN_DESCRIPTION);
        fAutocleanSection.setLayoutData((Object)new TableWrapData(256, 256));
        fAutocleanSection.setLayout((Layout)new TableWrapLayout());
        Composite fAutocleanPropertyComposite = toolkit.createComposite((Composite)fAutocleanSection);
        fAutocleanPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fAutocleanPropertyComposite.setLayout((Layout)this.getTableWrapLayoutWithoutIndent());
        this.createAutoCleanProperties(fAutocleanPropertyComposite, toolkit);
        fAutocleanSection.setClient((Control)fAutocleanPropertyComposite);
    }

    private void createConcurrentSafePropertySection(Composite parent, FormToolkit toolkit) {
        Section concurrentSafeSection = toolkit.createSection(parent, 0);
        concurrentSafeSection.setLayoutData((Object)new TableWrapData(256, 256));
        concurrentSafeSection.setLayout((Layout)new TableWrapLayout());
        Composite concurrentSafePropertyComposite = toolkit.createComposite((Composite)concurrentSafeSection);
        concurrentSafePropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        concurrentSafePropertyComposite.setLayout((Layout)this.getTableWrapLayoutWithoutIndent());
        this.createConcurrentSafeProperty(concurrentSafePropertyComposite, toolkit);
        concurrentSafeSection.setClient((Control)concurrentSafePropertyComposite);
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        super.setWorkingCopy(definition);
        if (this.restoreMappingComposite != null) {
            this.restoreMappingComposite.setBuildDefinitionWorkingCopy(definition);
        }
        if (this.includeShiplistComposite != null) {
            this.includeShiplistComposite.setBuildDefinitionWorkingCopy(definition);
        }
        if (this.excludeShiplistComposite != null) {
            this.excludeShiplistComposite.setBuildDefinitionWorkingCopy(definition);
        }
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public CTabItem getOptionsTab() {
        return this.publishTab;
    }

    public void postSave(boolean saveSucceeded) {
        if (saveSucceeded && this.isZosPackageDef()) {
            Utils.saveDefaultIspfGatewayLocation((String)this.zosPackageScriptText.getText());
        }
    }
}

