/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.automation.internal.ui.editors.AbstractAutomationConfigurationEditor;
import com.ibm.team.enterprise.packaging.dialogs.zOSBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.repository.common.UUID;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PackagingConfigurationEditor
extends AbstractAutomationConfigurationEditor
implements SelectionListener {
    private final List<Character> applicationNameCharList = new ArrayList<Character>();
    private final List<Character> applicationVersionCharList = new ArrayList<Character>();
    private Text applicationNameText;
    private Text applicationDescriptionText;
    private Text applicationVersionText;
    private Text shipListFilePathText;
    private Text restoreMappingPathText;
    private Text excludeFilePathText;
    private Text optionalShiplistText;
    private Text packageRootDirText;
    private Text packagePreCommandText;
    private Text packagePostCommandText;
    private Text zosPackageScriptText;
    private Text ibmiSaveFileLibraryText;
    private Text ibmiSaveFileOptionsText;
    private Text luwBuildRootDirText;
    private Text fBuildDefinitionNameText;
    private Button publishManifest;
    private Button publishPackage;
    private Button BuildDefinitionOptionButton;
    private Button ShiplistOptionButton;
    private Button fSelectBuildDefinitionButton;
    private Label shiplistLabel;
    private Label optionalShiplistLabel;
    private Label excludeFileLabel;

    public PackagingConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected void createApplicationProperties(Composite parent, FormToolkit toolkit) {
    }

    protected void createBuildDefinitionSelectionSection(Composite parent, FormToolkit toolkit) {
        TableWrapData data;
        Section fBuildDefinitionSection = toolkit.createSection(parent, 322);
        fBuildDefinitionSection.setLayoutData((Object)new TableWrapData(256, 256));
        fBuildDefinitionSection.setLayout((Layout)new TableWrapLayout());
        fBuildDefinitionSection.setText(Messages.PACKAGE_OPTIONS_SECTION);
        Composite fBuildDefinitionComposite = toolkit.createComposite((Composite)fBuildDefinitionSection);
        fBuildDefinitionComposite.setLayoutData((Object)new TableWrapData(256, 256));
        if (this.isZosPackageDef()) {
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 3;
            layout.horizontalSpacing = 10;
            layout.leftMargin = 20;
            fBuildDefinitionComposite.setLayout((Layout)layout);
            this.BuildDefinitionOptionButton = toolkit.createButton(fBuildDefinitionComposite, Messages.PACKAGING_WORKITEM_OPTION_LABEL, 16);
            this.BuildDefinitionOptionButton.setSelection(Boolean.parseBoolean(this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.workitem.option").getValue()));
            data = new TableWrapData(2, 32);
            data.colspan = 3;
            this.BuildDefinitionOptionButton.setLayoutData((Object)data);
            this.BuildDefinitionOptionButton.addSelectionListener(this.getZOSPackagingObjectsOptionsListener());
            this.fBuildDefinitionTitleHyperlink = toolkit.createHyperlink(fBuildDefinitionComposite, Messages.PACKAGING_SECTION_BUILDDEF_LABEL, 0);
            this.fBuildDefinitionTitleHyperlink.addHyperlinkListener(this.getBuildDefinitionHyperlinkListener());
            this.fEnabledHyperlinkForegroundColor = this.fBuildDefinitionTitleHyperlink.getForeground();
            data = new TableWrapData(2, 32);
            data.indent = 30;
            this.fBuildDefinitionTitleHyperlink.setLayoutData((Object)data);
            this.fBuildDefinitionNameText = toolkit.createText(fBuildDefinitionComposite, "", 0);
            this.fDisabledHyperlinkForegroundColor = this.fBuildDefinitionNameText.getForeground();
            this.fBuildDefinitionNameText.setEnabled(false);
            this.fBuildDefinitionNameText.setEditable(false);
            TableWrapData layoutData = new TableWrapData(256, 32);
            this.fBuildDefinitionNameText.setLayoutData((Object)layoutData);
            this.fSelectBuildDefinitionButton = toolkit.createButton(fBuildDefinitionComposite, Messages.PACKACING_BUILDDEF_SELECTION_BUTTON_LABEL, 0);
            this.fSelectBuildDefinitionButton.addSelectionListener(this.getSelectzOSBuildDefinitionListener());
            this.fSelectBuildDefinitionButton.setLayoutData((Object)new TableWrapData(4, 32));
            String BuildDefUUID = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.package.zos.buildDefinition.uuid", "");
            if (BuildDefUUID.length() == 0) {
                this.setBuildDefinitionNameText("", false);
            } else {
                this.setBuildDefinitionNameText(Messages.PACKAGING_HYPERLINK_JOB, false);
                final IBuildDefinitionHandle buildHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)BuildDefUUID), null);
                String jobName = Messages.PACKAGING_HYPERLINK_JOB_FETCH;
                Job job = new Job(jobName){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            PackagingConfigurationEditor.this.fBuildDefinition = PackagingConfigurationEditor.this.fetchBuildDefinition(buildHandle, monitor);
                            PackagingConfigurationEditor.this.handleUpdateBuildDefinitionText(PackagingConfigurationEditor.this.fBuildDefinition.getId());
                        }
                        catch (Exception e) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
            this.optionalShiplistLabel = this.createIndentedLabel(Messages.PACKAGING_SECTION_OPTIONAL_SHIPLIST_LABEL, toolkit, fBuildDefinitionComposite);
            this.optionalShiplistText = this.createWideText("team.package.zos.optional.shiplistFilePath", toolkit, fBuildDefinitionComposite);
            this.optionalShiplistText.addModifyListener(this.getTextModifyListener("team.package.zos.optional.shiplistFilePath", this.optionalShiplistText));
            this.excludeFileLabel = this.createIndentedLabel(Messages.PACKAGING_SECTION_EXCLUDE_LABEL, toolkit, fBuildDefinitionComposite);
            this.excludeFilePathText = this.createWideText("team.package.common.excludeFilePath", toolkit, fBuildDefinitionComposite);
            this.excludeFilePathText.addModifyListener(this.getTextModifyListener("team.package.common.excludeFilePath", this.excludeFilePathText));
            this.ShiplistOptionButton = toolkit.createButton(fBuildDefinitionComposite, Messages.PACKAGING_SHIPLIST_OPTION_LABEL, 16);
            this.ShiplistOptionButton.setSelection(Boolean.parseBoolean(this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.shiplist.option").getValue()));
            data = new TableWrapData(2, 32);
            data.colspan = 3;
            this.ShiplistOptionButton.setLayoutData((Object)data);
            this.ShiplistOptionButton.addSelectionListener(this.getZOSPackagingObjectsOptionsListener());
            this.shiplistLabel = this.createIndentedLabel(Messages.PACKAGING_SECTION_SHIPLIST_LABEL, toolkit, fBuildDefinitionComposite);
            this.shipListFilePathText = this.createWideText("team.package.common.shiplistFilePath", toolkit, fBuildDefinitionComposite);
            this.shipListFilePathText.addModifyListener(this.getTextModifyListener("team.package.common.shiplistFilePath", this.shipListFilePathText));
            this.initializeZOSPackagingOptions();
            this.createSpacer(fBuildDefinitionComposite, 3, 3, toolkit);
            data = new TableWrapData(128, 256);
            data.colspan = 3;
        } else {
            fBuildDefinitionComposite.setLayout((Layout)this.getTableWrapLayout());
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.shiplistFilePath");
            this.shipListFilePathText = this.createLabeledText(fBuildDefinitionComposite, Messages.PACKAGING_SECTION_SHIPLIST_LABEL2, property.getValue());
            this.shipListFilePathText.addModifyListener(this.getTextModifyListener("team.package.common.shiplistFilePath", this.shipListFilePathText));
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.excludeFilePath");
            this.excludeFilePathText = this.createLabeledText(fBuildDefinitionComposite, Messages.PACKAGING_SECTION_EXCLUDE_LABEL, property.getValue());
            this.excludeFilePathText.addModifyListener(this.getTextModifyListener("team.package.common.excludeFilePath", this.excludeFilePathText));
            this.createSpacer(fBuildDefinitionComposite, 3, 2, toolkit);
            data = new TableWrapData(128, 256);
            data.colspan = 2;
        }
        Section packageSection = toolkit.createSection(fBuildDefinitionComposite, 4096);
        packageSection.setLayoutData((Object)data);
        packageSection.setLayout((Layout)new TableWrapLayout());
        Composite fpackageComposite = toolkit.createComposite((Composite)packageSection);
        fpackageComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fpackageComposite.setLayout((Layout)this.getTableWrapLayoutWithoutIndent());
        this.createPackageProperties(fpackageComposite, toolkit);
        packageSection.setClient((Control)fpackageComposite);
        fBuildDefinitionSection.setClient((Control)fBuildDefinitionComposite);
    }

    private Label createIndentedLabel(String labelValue, FormToolkit toolkit, Composite composite) {
        TableWrapData data = new TableWrapData(2, 32);
        data.indent = 30;
        Label label = toolkit.createLabel(composite, labelValue);
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createWideText(String property, FormToolkit toolkit, Composite composite) {
        IBuildProperty buildProperty = this.fBuildDefinitionWorkingCopy.getProperty(property);
        Text text = toolkit.createText(composite, buildProperty.getValue());
        TableWrapData data = new TableWrapData(128, 32);
        data.colspan = 2;
        text.setLayoutData((Object)data);
        return text;
    }

    public Control getFocusControl() {
        return this.applicationNameText;
    }

    protected void createApplicationPropertySection(Composite parent, FormToolkit toolkit) {
        Section fApplicationSection = toolkit.createSection(parent, 322);
        fApplicationSection.setLayoutData((Object)new TableWrapData(256, 256));
        fApplicationSection.setLayout((Layout)new TableWrapLayout());
        fApplicationSection.setText(Messages.PackagingConfigurationEditor_SECTION_APPLICATION);
        Composite fApplicationPropertyComposite = toolkit.createComposite((Composite)fApplicationSection);
        fApplicationPropertyComposite.setLayoutData((Object)new TableWrapData(256, 256));
        fApplicationPropertyComposite.setLayout((Layout)this.getTableWrapLayout());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty(this.getApplicationNamePropertyName());
        this.applicationNameText = this.createLabeledText(fApplicationPropertyComposite, Messages.PackagingConfigurationEditor_TEXT_APPLICATION_NAME, property.getValue());
        this.applicationNameText.addModifyListener(this.getTextModifyListener(this.getApplicationNamePropertyName(), this.applicationNameText));
        this.applicationNameText.addKeyListener(this.getTextKeyListener(this.getApplicationNamePropertyName(), this.applicationNameText));
        property = this.fBuildDefinitionWorkingCopy.getProperty(this.getApplicationDescriptionPropertyName());
        this.applicationDescriptionText = this.createLabeledText(fApplicationPropertyComposite, Messages.PackagingConfigurationEditor_TEXT_APPLICATION_DESCRIPTION, property.getValue());
        this.applicationDescriptionText.addModifyListener(this.getTextModifyListener(this.getApplicationDescriptionPropertyName(), this.applicationDescriptionText));
        property = this.fBuildDefinitionWorkingCopy.getProperty(this.getApplicationVersionPropertyName());
        this.applicationVersionText = this.createLabeledText(fApplicationPropertyComposite, Messages.PackagingConfigurationEditor_TEXT_APPLICATION_VERSION, property.getValue());
        this.applicationVersionText.addModifyListener(this.getTextModifyListener(this.getApplicationVersionPropertyName(), this.applicationVersionText));
        this.applicationVersionText.addKeyListener(this.getTextKeyListener(this.getApplicationVersionPropertyName(), this.applicationVersionText));
        this.createApplicationProperties(fApplicationPropertyComposite, toolkit);
        fApplicationSection.setClient((Control)fApplicationPropertyComposite);
    }

    protected void createExtensibleContributionSection(Composite parent, FormToolkit toolkit) {
    }

    protected void createPackageProperties(Composite parent, FormToolkit toolkit) {
        this.createCompletePackageButton(parent, toolkit, Messages.PackagingConfigurationEditor_BUTTON_COMPLETEPACKAGE);
        this.createSpacer(parent, 10, 2, toolkit);
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.packageRoot.dir");
        this.packageRootDirText = this.createLabeledText(parent, Messages.PackagingConfigurationEditor_TEXT_PACKAGEROOT_DIR, property.getValue());
        this.packageRootDirText.addModifyListener(this.getTextModifyListener("team.package.common.packageRoot.dir", this.packageRootDirText));
        this.createRuntimeProperties(parent, toolkit);
    }

    protected void createRuntimeProperties(Composite parent, FormToolkit toolkit) {
        IBuildProperty property;
        if (!this.isLUWPackageDef()) {
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.restoreMappingPath");
            this.restoreMappingPathText = this.createLabeledText(parent, Messages.PackagingConfigurationEditor_TEXT_RESTOREMAPPINGFILE, property.getValue());
            this.restoreMappingPathText.addModifyListener(this.getTextModifyListener("team.package.common.restoreMappingPath", this.restoreMappingPathText));
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.prePackageCommand");
        this.packagePreCommandText = this.createLabeledText(parent, Messages.PackagingConfigurationEditor_TEXT_PACKAGE_PRECOMMAND, property.getValue());
        this.packagePreCommandText.addModifyListener(this.getTextModifyListener("team.package.common.prePackageCommand", this.packagePreCommandText));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.postPackageCommand");
        this.packagePostCommandText = this.createLabeledText(parent, Messages.PackagingConfigurationEditor_TEXT_PACKAGE_POSTCOMMAND, property.getValue());
        this.packagePostCommandText.addModifyListener(this.getTextModifyListener("team.package.common.postPackageCommand", this.packagePostCommandText));
    }

    protected void createPublishProperties(Composite parent, FormToolkit toolkit) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.isManifestPublished");
        this.publishManifest = toolkit.createButton(parent, Messages.PackagingConfigurationEditor_BUTTON_PUBLISHMANIFEST, 32);
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishManifest.setSelection(propertyValue);
        } else {
            this.publishManifest.setSelection(false);
        }
        TableWrapData buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishManifest.setLayoutData((Object)buttonData);
        this.publishManifest.addSelectionListener(this.getButtonSelectionListener("team.package.common.isManifestPublished", this.publishManifest));
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.common.isPackagePublished");
        this.publishPackage = toolkit.createButton(parent, Messages.PackagingConfigurationEditor_BUTTON_PUBLISHPACKAGE, 32);
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            this.publishPackage.setSelection(propertyValue);
        } else {
            this.publishPackage.setSelection(false);
        }
        buttonData = new TableWrapData(256, 256);
        buttonData.colspan = 2;
        this.publishPackage.setLayoutData((Object)buttonData);
        this.publishPackage.addSelectionListener(this.getButtonSelectionListener("team.package.common.isPackagePublished", this.publishPackage));
    }

    protected void createPlatformProperties(Composite parent, FormToolkit toolkit) {
        if (this.isZosPackageDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.zos.script");
            this.zosPackageScriptText = this.createLabeledText(parent, Messages.ZOS_PACKAGING_SCRIPT, property.getValue());
            this.zosPackageScriptText.addModifyListener(this.getTextModifyListener("team.package.zos.script", this.zosPackageScriptText));
        } else if (this.isIBMiPackageDef()) {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ibmi.intermediateSaveFileLibrary");
            this.ibmiSaveFileLibraryText = this.createLabeledText(parent, Messages.IBMI_PACKAGING_SAVEFILE_LIBRARY, property.getValue());
            this.ibmiSaveFileLibraryText.addModifyListener(this.getTextModifyListener("team.package.ibmi.intermediateSaveFileLibrary", this.ibmiSaveFileLibraryText));
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.ibmi.savefileOptions");
            this.ibmiSaveFileOptionsText = this.createLabeledText(parent, Messages.IBMI_PACKAGING_SAVEFILE_OPTIONS, property.getValue());
            this.ibmiSaveFileOptionsText.addModifyListener(this.getTextModifyListener("team.package.ibmi.savefileOptions", this.ibmiSaveFileOptionsText));
        } else {
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.package.luw.buildRoot.dir");
            this.luwBuildRootDirText = this.createLabeledText(parent, Messages.LUW_PACKAGING_BUILD_ROOT_DIR, property.getValue());
            this.luwBuildRootDirText.addModifyListener(this.getTextModifyListener("team.package.luw.buildRoot.dir", this.luwBuildRootDirText));
        }
    }

    protected ModifyListener getTextModifyListener(final String propertyID, final Text propertyWidget) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackagingConfigurationEditor.this.validate();
                PackagingConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty(propertyID, propertyWidget.getText().trim());
                PackagingConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected KeyListener getTextKeyListener(String propertyID, final Text propertyWidget) {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                char newChar = e.character;
                if (propertyWidget == PackagingConfigurationEditor.this.applicationNameText) {
                    List<Character> charList = PackagingConfigurationEditor.this.getApplicationNameCharList();
                    if (Character.isLetterOrDigit(newChar) && !charList.contains(new Character(newChar))) {
                        charList.add(new Character(newChar));
                    }
                } else if (propertyWidget == PackagingConfigurationEditor.this.applicationVersionText) {
                    List<Character> charList = PackagingConfigurationEditor.this.getApplicationVersionCharList();
                    if (Character.isLetterOrDigit(newChar) && !charList.contains(new Character(newChar))) {
                        charList.add(new Character(newChar));
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
    }

    protected boolean validateProperties() {
        List<Character> charList;
        boolean isValid = true;
        if (this.applicationNameText.getText().trim().length() == 0) {
            this.addErrorMessage(this.applicationNameText, Messages.PackagingConfigurationEditor_ERROR_APPLICATIONNAMEMISSING, (Control)this.applicationNameText);
            isValid = false;
        } else if (this.applicationNameText.getText().indexOf(" ") != -1) {
            this.addErrorMessage(this.applicationNameText, Messages.PackagingConfigurationEditor_ERROR_APPLICATIONNAMESPACES, (Control)this.applicationNameText);
            isValid = false;
        } else if (this.applicationNameText.getText().indexOf("\"") != -1) {
            this.addErrorMessage(this.applicationNameText, Messages.PackagingConfigurationEditor_ERROR_APPLICATIONNAMEQUOTES, (Control)this.applicationNameText);
            isValid = false;
        } else if (!this.getApplicationNameCharList().isEmpty()) {
            charList = this.getApplicationNameCharList();
            this.cleanSearchList(this.applicationNameText.getText(), charList);
            isValid = this.validateDBCSCharacters(charList, this.applicationNameText);
        } else {
            this.removeMessage(this.applicationNameText, (Control)this.applicationNameText);
        }
        if (this.applicationVersionText.getText().trim().length() == 0) {
            this.addErrorMessage(this.applicationVersionText, Messages.PackagingConfigurationEditor_ERROR_APPLICATIONVERSIONMISSING, (Control)this.applicationVersionText);
            isValid = false;
        } else if (!this.getApplicationVersionCharList().isEmpty()) {
            charList = this.getApplicationVersionCharList();
            this.cleanSearchList(this.applicationVersionText.getText(), charList);
            isValid = this.validateDBCSCharacters(charList, this.applicationVersionText);
        } else {
            this.removeMessage(this.applicationVersionText, (Control)this.applicationVersionText);
        }
        if (!this.isZosPackageDef() && this.shipListFilePathText.getText().trim().length() == 0) {
            this.addErrorMessage(this.shipListFilePathText, Messages.MISSING_SHIPLIST_FILE_ERROR_MESSAGE, (Control)this.shipListFilePathText);
            isValid = false;
        } else {
            this.removeMessage(this.shipListFilePathText, (Control)this.shipListFilePathText);
        }
        if (this.packageRootDirText.getText().trim().length() == 0) {
            this.addErrorMessage(this.packageRootDirText, Messages.PackagingConfigurationEditor_ERROR_PACKAGEROOTDIRMISSING, (Control)this.packageRootDirText);
            isValid = false;
        } else {
            this.removeMessage(this.packageRootDirText, (Control)this.packageRootDirText);
        }
        if (this.isIBMiPackageDef()) {
            if (this.ibmiSaveFileLibraryText.getText().trim().length() == 0) {
                this.addErrorMessage(this.ibmiSaveFileLibraryText, Messages.IBMI_SAVEFILE_ERROR_MESSAGE, (Control)this.ibmiSaveFileLibraryText);
                isValid = false;
            } else {
                this.removeMessage(this.ibmiSaveFileLibraryText, (Control)this.ibmiSaveFileLibraryText);
            }
        } else if (this.isZosPackageDef()) {
            if (this.zosPackageScriptText.getText().trim().length() == 0) {
                this.addErrorMessage(this.zosPackageScriptText, Messages.ZOS_SCRIPT_ERROR_MESSAGE, (Control)this.zosPackageScriptText);
                isValid = false;
            } else {
                this.removeMessage(this.zosPackageScriptText, (Control)this.zosPackageScriptText);
            }
            if (this.BuildDefinitionOptionButton.getSelection() && this.fBuildDefinitionNameText.getText().trim().length() == 0) {
                this.addErrorMessage(this.fBuildDefinitionNameText, Messages.ZOS_MISSING_BUILDDEF_ERROR_MESSAGE, (Control)this.fBuildDefinitionNameText);
                isValid = false;
            } else {
                this.removeMessage(this.fBuildDefinitionNameText, (Control)this.fBuildDefinitionNameText);
            }
            if (this.ShiplistOptionButton.getSelection() && this.shipListFilePathText.getText().trim().length() == 0) {
                this.addErrorMessage(this.shipListFilePathText, Messages.MISSING_SHIPLIST_FILE_ERROR_MESSAGE, (Control)this.shipListFilePathText);
                isValid = false;
            } else {
                this.removeMessage(this.shipListFilePathText, (Control)this.shipListFilePathText);
            }
            if (this.fBuildDefinitionWorkingCopy.getBuildSchedule().isScheduleEnabled() && this.BuildDefinitionOptionButton.getSelection()) {
                this.addErrorMessage(this.BuildDefinitionOptionButton, Messages.SCHEDULING_AND_WORKITEM_WARNING, (IStatus)new Status(2, "com.ibm.team.enterprise.packaging.ui", Messages.SCHEDULING_AND_WORKITEM_DIALOG_WARNING));
            } else {
                this.removeMessage(this.BuildDefinitionOptionButton);
            }
        } else if (this.luwBuildRootDirText.getText().trim().length() == 0) {
            this.addErrorMessage(this.luwBuildRootDirText, Messages.LUW_BUILD_ROOT_ERROR_MESSAGE, (Control)this.luwBuildRootDirText);
            isValid = false;
        } else {
            this.removeMessage(this.luwBuildRootDirText, (Control)this.luwBuildRootDirText);
        }
        return isValid;
    }

    private void cleanSearchList(String currText, List<Character> searchList) {
        char[] currTextChars = currText.toCharArray();
        Arrays.sort(currTextChars);
        int i = searchList.size() - 1;
        while (i >= 0) {
            Character c = searchList.get(i);
            if (Arrays.binarySearch(currTextChars, c.charValue()) < 0) {
                searchList.remove(c);
            }
            --i;
        }
    }

    private boolean validateDBCSCharacters(List<Character> searchList, Text textWidget) {
        int byteLength = -1;
        for (Character c : searchList) {
            char lastCharacter = c.charValue();
            try {
                byteLength = String.valueOf(lastCharacter).getBytes("UTF8").length;
            }
            catch (UnsupportedEncodingException e) {
                this.addErrorMessage(textWidget, NLS.bind((String)Messages.PackagingConfigurationEditor_ERROR_DOUBLEBYTECHARACTERS, (Object)Character.valueOf(lastCharacter)), (Control)textWidget);
                return false;
            }
            if (byteLength <= 1) continue;
            this.addErrorMessage(textWidget, NLS.bind((String)Messages.PackagingConfigurationEditor_ERROR_DOUBLEBYTECHARACTERS, (Object)Character.valueOf(lastCharacter)), (Control)textWidget);
            return false;
        }
        this.removeMessage(textWidget, (Control)textWidget);
        return true;
    }

    protected void initializeZOSPackagingOptions() {
        if (this.BuildDefinitionOptionButton.getSelection()) {
            this.fSelectBuildDefinitionButton.setEnabled(true);
            this.fBuildDefinitionNameText.setEnabled(true);
            this.setBuildDefinitionTitleHyperlinkEnablement(this.fBuildDefinitionNameText.getText().trim().length() != 0);
            this.optionalShiplistLabel.setEnabled(true);
            this.optionalShiplistText.setEnabled(true);
            this.excludeFileLabel.setEnabled(true);
            this.excludeFilePathText.setEnabled(true);
            this.shipListFilePathText.setEnabled(false);
            this.shiplistLabel.setEnabled(false);
        } else {
            this.shipListFilePathText.setEnabled(true);
            this.shiplistLabel.setEnabled(true);
            this.fSelectBuildDefinitionButton.setEnabled(false);
            this.fBuildDefinitionNameText.setEnabled(false);
            this.setBuildDefinitionTitleHyperlinkEnablement(false);
            this.optionalShiplistLabel.setEnabled(false);
            this.optionalShiplistText.setEnabled(false);
            this.excludeFileLabel.setEnabled(false);
            this.excludeFilePathText.setEnabled(false);
        }
    }

    protected SelectionListener getZOSPackagingObjectsOptionsListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingConfigurationEditor.this.validate();
                PackagingConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.package.common.workitem.option", Boolean.toString(PackagingConfigurationEditor.this.BuildDefinitionOptionButton.getSelection()));
                PackagingConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.package.common.shiplist.option", Boolean.toString(PackagingConfigurationEditor.this.ShiplistOptionButton.getSelection()));
                PackagingConfigurationEditor.this.initializeZOSPackagingOptions();
                PackagingConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getSelectzOSBuildDefinitionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                zOSBuildDefinitionSelectionDialog dialog = new zOSBuildDefinitionSelectionDialog(PackagingConfigurationEditor.this.fBuildDefinitionTitleHyperlink.getShell());
                if (dialog.open() == 0) {
                    IBuildDefinition selectedBuildDef = dialog.getFirstSelectedBuildDefinition();
                    PackagingConfigurationEditor.this.setBuildDefinition(selectedBuildDef);
                }
            }
        };
    }

    protected void handleUpdateBuildDefinitionText(final String packageDefName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PackagingConfigurationEditor.this.fBuildDefinitionNameText.isDisposed()) {
                    PackagingConfigurationEditor.this.setBuildDefinitionNameText(packageDefName, true);
                }
            }
        });
    }

    protected void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.fBuildDefinition = buildDefinition;
        this.fBuildDefinitionWorkingCopy.setProperty("team.package.zos.buildDefinition.uuid", this.fBuildDefinition.getItemId().getUuidValue());
        this.setDirty(true);
        this.setBuildDefinitionNameText(this.fBuildDefinition.getId(), true);
        this.validate();
    }

    private void setBuildDefinitionNameText(String text, boolean workspaceSet) {
        this.fBuildDefinitionNameText.setText(text);
        this.fBuildDefinitionNameText.setEnabled(workspaceSet && this.BuildDefinitionOptionButton.getSelection());
        this.setBuildDefinitionTitleHyperlinkEnablement(workspaceSet && this.BuildDefinitionOptionButton.getSelection());
    }

    protected String getConfigurationId() {
        return "com.ibm.team.enterprise.packaging";
    }

    protected String getApplicationDescriptionPropertyName() {
        return "team.package.common.applicationDescription";
    }

    protected String getApplicationNamePropertyName() {
        return "team.package.common.applicationName";
    }

    protected String getApplicationVersionPropertyName() {
        return "team.package.common.version";
    }

    protected String getIsCompletePackagePropertyName() {
        return "team.package.common.isCompletePackage";
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource != this.publishManifest) {
            // empty if block
        }
    }

    public List<Character> getApplicationNameCharList() {
        return this.applicationNameCharList;
    }

    public List<Character> getApplicationVersionCharList() {
        return this.applicationVersionCharList;
    }
}

