/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.build.ui.properties.ISchedulePropertyEditor;
import com.ibm.team.enterprise.packaging.internal.ui.editors.PackageWorkItemSchedulePropertyDialog;
import com.ibm.team.enterprise.packaging.internal.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;

public class PackageWorkItemSchedulePropertyEditor
extends AbstractBuildPropertyEditor
implements ISchedulePropertyEditor {
    private Job resolveWorkItemJob;
    private IBuildDefinition fWorkingCopy;
    private Map<String, String> fUUIDLabelMap;
    private PackageWorkItemSchedulePropertyDialog dialog = null;

    public boolean editProperty(IBuildPropertyEditorContext context) {
        String propertyValue = this.openPackageWorkItemScheduleDialog(context.getShell(), context.getTeamRepository(), context.getProperty().getValue());
        if (propertyValue != null) {
            context.getProperty().setValue(propertyValue);
            return true;
        }
        return false;
    }

    private String openPackageWorkItemScheduleDialog(Shell shell, ITeamRepository repo, String initialValue) {
        this.dialog = new PackageWorkItemSchedulePropertyDialog(shell, repo, this.fWorkingCopy, initialValue);
        if (this.dialog != null && this.dialog.open() == 0) {
            this.fUUIDLabelMap = this.dialog.getWorkItemUUIDToLabelMap();
            return this.dialog.getSchedulePropertyValue();
        }
        return null;
    }

    public String getPropertyValueLabel(IBuildPropertyEditorContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        String propertyValue = context.getProperty().getValue();
        if (this.fUUIDLabelMap == null || this.fUUIDLabelMap.isEmpty()) {
            this.resolvePropertyIDs(context);
        }
        String valueString = "";
        StringTokenizer strTokenizer = new StringTokenizer(propertyValue, ";");
        if (this.resolveWorkItemJob != null) {
            try {
                this.resolveWorkItemJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (strTokenizer.hasMoreElements()) {
            String keyValue;
            String valueValue;
            if (!valueString.equalsIgnoreCase("")) {
                valueString = valueString.concat(", ");
            }
            if ((valueValue = this.fUUIDLabelMap.get(keyValue = strTokenizer.nextToken())) == null) continue;
            valueString = valueString.concat(valueValue);
        }
        return valueString;
    }

    public void setWorkingCopy(IBuildDefinition workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    private void resolvePropertyIDs(final IBuildPropertyEditorContext context) {
        final IWorkItemClient workItemClient = (IWorkItemClient)context.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        this.resolveWorkItemJob = new Job(Messages.PackageWorkItemWizardPage_JOBNAME_RESOLVEWORKITEM){

            protected IStatus run(IProgressMonitor monitor) {
                StringTokenizer strTokenizer = new StringTokenizer(context.getProperty().getValue(), ";");
                while (strTokenizer.hasMoreElements()) {
                    String workItemUUID = strTokenizer.nextToken();
                    try {
                        IWorkItemHandle itemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUUID), null);
                        IWorkItem workItem = (IWorkItem)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)itemHandle, IWorkItem.FULL_PROFILE, null);
                        if (PackageWorkItemSchedulePropertyEditor.this.fUUIDLabelMap == null) {
                            PackageWorkItemSchedulePropertyEditor.this.fUUIDLabelMap = new HashMap();
                        }
                        PackageWorkItemSchedulePropertyEditor.this.fUUIDLabelMap.put(workItemUUID, String.valueOf(workItem.getId()));
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.resolveWorkItemJob.setUser(false);
        this.resolveWorkItemJob.schedule();
    }
}

