/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.packaging.internal.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.ui.properties.AbstractSchedulePropertyDialog;
import com.ibm.team.enterprise.automation.internal.ui.nls.Messages;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemChooser;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableContentProvider;
import com.ibm.team.enterprise.automation.internal.ui.wizards.AbstractWorkItemTableLabelProvider;
import com.ibm.team.enterprise.packaging.internal.ui.wizards.PackagingWorkItemChooser;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.rcp.ui.internal.queries.QuerySelectionDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class PackageWorkItemSchedulePropertyDialog
extends AbstractSchedulePropertyDialog
implements SelectionListener,
ICheckStateListener {
    private String selectionValue = "";
    private final ITeamRepository fTeamRepository;
    private final IBuildDefinition fWorkingCopy;
    private final Map<String, String> fUUIDLabelMap;
    private Table workItemTable;
    private CheckboxTableViewer workItemTableViewer;
    private WorkItemTableContentProvider fWorkItemTableContentProvider = null;
    private WorkItemTableLabelProvider fWorkItemTableLabelProvider = null;
    private Button selectAllButton;
    private Button selectNoneButton;
    private Button addWorkItemButton;
    private Button queryWorkItemButton;

    public PackageWorkItemSchedulePropertyDialog(Shell parentShell, ITeamRepository repository, IBuildDefinition workingCopy, String initialSelectionValue) {
        super(parentShell);
        this.fTeamRepository = repository;
        this.fWorkingCopy = workingCopy;
        this.fUUIDLabelMap = new HashMap<String, String>();
        if (!initialSelectionValue.equalsIgnoreCase("")) {
            this.selectionValue = initialSelectionValue;
        }
    }

    protected void createScheduleDialogArea(Composite parent) {
        Label actionLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)actionLabel);
        actionLabel.setText(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemSchedulePropertyDialog_MESSAGE);
        this.createWorkItemTable(parent);
    }

    private void createWorkItemTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).create());
        tableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, false).create());
        Composite wiTableComposite = new Composite(tableComposite, 0);
        this.workItemTable = new Table(wiTableComposite, 68384);
        this.workItemTable.setHeaderVisible(true);
        this.workItemTable.setLinesVisible(true);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        TableColumn idColumn = new TableColumn(this.workItemTable, 0, 0);
        idColumn.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_COLUMN_ID);
        tableColumnLayout.setColumnData((Widget)idColumn, (ColumnLayoutData)new ColumnWeightData(20));
        TableColumn summaryColumn = new TableColumn(this.workItemTable, 0, 1);
        summaryColumn.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_COLUMN_SUMMARY);
        tableColumnLayout.setColumnData((Widget)summaryColumn, (ColumnLayoutData)new ColumnWeightData(80));
        wiTableComposite.setLayout((Layout)tableColumnLayout);
        GridDataFactory.fillDefaults().indent(5, 0).hint(-1, 150).grab(true, true).applyTo((Control)wiTableComposite);
        this.workItemTable.pack();
        this.workItemTableViewer = new CheckboxTableViewer(this.workItemTable);
        AbstractWorkItemTableContentProvider workItemTableContentProvider = this.getCommonContentProvider();
        AbstractWorkItemTableLabelProvider workItemTableLabelProvider = this.getCommonLabelProvider();
        this.workItemTableViewer.setContentProvider((IContentProvider)workItemTableContentProvider);
        this.workItemTableViewer.setLabelProvider((IBaseLabelProvider)workItemTableLabelProvider);
        if (!this.selectionValue.equalsIgnoreCase("")) {
            ArrayList<IWorkItemHandle> workItemList = new ArrayList<IWorkItemHandle>();
            StringTokenizer strTokenizer = new StringTokenizer(this.selectionValue, ";");
            while (strTokenizer.hasMoreElements()) {
                String workItemUUID = strTokenizer.nextToken();
                workItemList.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUUID), null));
            }
            if (!workItemList.isEmpty()) {
                this.workItemTableViewer.setInput(workItemList);
                this.workItemTableViewer.setCheckedElements(workItemList.toArray());
            }
        }
        this.workItemTableViewer.addCheckStateListener((ICheckStateListener)this);
        Composite buttonComposite = new Composite(tableComposite, 0);
        buttonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        buttonComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.selectAllButton = new Button(buttonComposite, 8);
        this.selectAllButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_SELECTALL);
        this.selectAllButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.selectAllButton.addSelectionListener((SelectionListener)this);
        this.selectNoneButton = new Button(buttonComposite, 8);
        this.selectNoneButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.selectNoneButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_DESELECTALL);
        this.selectNoneButton.addSelectionListener((SelectionListener)this);
        this.addWorkItemButton = new Button(buttonComposite, 8);
        this.addWorkItemButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.addWorkItemButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_ADD);
        this.addWorkItemButton.addSelectionListener((SelectionListener)this);
        this.queryWorkItemButton = new Button(buttonComposite, 8);
        this.queryWorkItemButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.queryWorkItemButton.setText(Messages.AbstractAutomationWorkItemWizardPage_WORKITEM_TABLE_BUTTON_RUNQUERY);
        this.queryWorkItemButton.addSelectionListener((SelectionListener)this);
    }

    protected IProcessArea getProcessArea() throws TeamRepositoryException {
        IProcessAreaHandle paHandle = this.getProcessAreaHandle();
        if (paHandle != null) {
            return (IProcessArea)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)paHandle, 0, null);
        }
        return null;
    }

    protected IProcessAreaHandle getProcessAreaHandle() {
        if (this.fWorkingCopy != null) {
            return this.fWorkingCopy.getProcessArea();
        }
        return null;
    }

    public void widgetSelected(SelectionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.addWorkItemButton) {
            List chosenItems;
            AbstractWorkItemChooser chooserDialog = this.getWorkItemChooser();
            if (chooserDialog.open() == 0 && (chosenItems = chooserDialog.getChosenWorkItems()) != null && !chosenItems.isEmpty()) {
                List currentContents = ((AbstractWorkItemTableContentProvider)this.workItemTableViewer.getContentProvider()).getElementsAsList();
                HashMap<String, IWorkItemHandle> currentMap = new HashMap<String, IWorkItemHandle>();
                if (currentContents != null) {
                    for (IWorkItemHandle existingItem : currentContents) {
                        currentMap.put(existingItem.getItemId().getUuidValue(), existingItem);
                    }
                }
                ArrayList<IWorkItemHandle> itemsToCheck = new ArrayList<IWorkItemHandle>();
                if (currentContents == null || currentContents.isEmpty()) {
                    this.workItemTableViewer.setInput((Object)chosenItems);
                    this.workItemTableViewer.setCheckedElements(chosenItems.toArray());
                } else {
                    for (IWorkItemHandle newItem : chosenItems) {
                        String newItemID = newItem.getItemId().getUuidValue();
                        if (currentMap.containsKey(newItemID)) continue;
                        currentMap.put(newItemID, newItem);
                        currentContents.add(newItem);
                        itemsToCheck.add(newItem);
                    }
                }
                this.workItemTableViewer.refresh();
                if (!itemsToCheck.isEmpty()) {
                    ArrayList<Object> allItemsToCheck = new ArrayList<Object>();
                    Object[] existingCheckedElements = this.workItemTableViewer.getCheckedElements();
                    allItemsToCheck.addAll(Arrays.asList(existingCheckedElements));
                    allItemsToCheck.addAll(itemsToCheck);
                    this.workItemTableViewer.setCheckedElements(allItemsToCheck.toArray());
                    this.workItemTableViewer.refresh();
                }
            }
        } else if (eventSource == this.selectAllButton) {
            this.workItemTableViewer.setAllChecked(true);
        } else if (eventSource == this.selectNoneButton) {
            this.workItemTableViewer.setAllChecked(false);
        } else if (eventSource == this.queryWorkItemButton) {
            QuerySelectionDialog queryDialog = new QuerySelectionDialog(this.getShell());
            queryDialog.setTitle(Messages.AbstractAutomationWorkItemWizardPage_QUERYSELECTION_DIALOG_TITLE);
            ITeamRepository currentRepo = this.fTeamRepository;
            if (currentRepo != null) {
                List connectedProjectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(currentRepo);
                queryDialog.configureProjectAreas((Collection)connectedProjectAreas);
            }
            if (queryDialog.open() == 0) {
                final ArrayList workItemList = new ArrayList();
                final List queryList = queryDialog.getSelectedQueries();
                IProgressService ps = PlatformUI.getWorkbench().getProgressService();
                try {
                    ps.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            for (IQueryDescriptorHandle query : queryList) {
                                IQueryClient queryClient = (IQueryClient)PackageWorkItemSchedulePropertyDialog.this.fTeamRepository.getClientLibrary(IQueryClient.class);
                                IQueryDescriptor queryDescriptor = null;
                                try {
                                    queryDescriptor = (IQueryDescriptor)queryClient.getAuditableCommon().resolveAuditable((IAuditableHandle)query, IQueryDescriptor.FULL_PROFILE, null);
                                }
                                catch (TeamRepositoryException e1) {
                                    e1.printStackTrace();
                                }
                                if (queryDescriptor == null) continue;
                                IQueryResult queryResults = queryClient.getResolvedQueryResults(queryDescriptor, IWorkItem.SMALL_PROFILE);
                                IResolvedResult resolvedItems = null;
                                try {
                                    while (queryResults.hasNext(null)) {
                                        resolvedItems = (IResolvedResult)queryResults.next(null);
                                        workItemList.add((IWorkItemHandle)((IWorkItem)resolvedItems.getItem()).getItemHandle());
                                    }
                                }
                                catch (TeamRepositoryException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (workItemList != null && !workItemList.isEmpty()) {
                    List currentContents = ((AbstractWorkItemTableContentProvider)this.workItemTableViewer.getContentProvider()).getElementsAsList();
                    HashMap<String, IWorkItemHandle> currentMap = new HashMap<String, IWorkItemHandle>();
                    if (currentContents != null) {
                        for (IWorkItemHandle existingItem : currentContents) {
                            currentMap.put(existingItem.getItemId().getUuidValue(), existingItem);
                        }
                    }
                    ArrayList<IWorkItemHandle> itemsToCheck = new ArrayList<IWorkItemHandle>();
                    if (currentContents == null || currentContents.isEmpty()) {
                        this.workItemTableViewer.setInput(workItemList);
                        this.workItemTableViewer.setCheckedElements(workItemList.toArray());
                    } else {
                        for (IWorkItemHandle newItem : workItemList) {
                            String newItemID = newItem.getItemId().getUuidValue();
                            if (currentMap.containsKey(newItemID)) continue;
                            currentMap.put(newItemID, newItem);
                            currentContents.add(newItem);
                            itemsToCheck.add(newItem);
                        }
                    }
                    this.workItemTableViewer.refresh();
                    if (!itemsToCheck.isEmpty()) {
                        ArrayList<Object> allItemsToCheck = new ArrayList<Object>();
                        Object[] existingCheckedElements = this.workItemTableViewer.getCheckedElements();
                        allItemsToCheck.addAll(Arrays.asList(existingCheckedElements));
                        allItemsToCheck.addAll(itemsToCheck);
                        this.workItemTableViewer.setCheckedElements(allItemsToCheck.toArray());
                        this.workItemTableViewer.refresh();
                    }
                }
            }
        }
        this.updateSelectionState();
    }

    public AbstractWorkItemChooser getWorkItemChooser() {
        return new PackagingWorkItemChooser(this.getShell(), this.fTeamRepository);
    }

    public AbstractWorkItemTableContentProvider getCommonContentProvider() {
        if (this.fWorkItemTableContentProvider == null) {
            this.fWorkItemTableContentProvider = new WorkItemTableContentProvider();
        }
        return this.fWorkItemTableContentProvider;
    }

    public AbstractWorkItemTableLabelProvider getCommonLabelProvider() {
        if (this.fWorkItemTableLabelProvider == null) {
            this.fWorkItemTableLabelProvider = new WorkItemTableLabelProvider();
        }
        return this.fWorkItemTableLabelProvider;
    }

    protected String getScheduleDialogHelpId() {
        return null;
    }

    protected String getSchedulePropertyEditorTitle() {
        return com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemSchedulePropertyDialog_TITLE;
    }

    public String getSchedulePropertyValue() {
        return this.selectionValue;
    }

    public Map<String, String> getWorkItemUUIDToLabelMap() {
        return this.fUUIDLabelMap;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updateSelectionState();
    }

    private void updateSelectionState() {
        int totalItems;
        int numberChecked = this.workItemTableViewer.getCheckedElements().length;
        this.selectAllButton.setEnabled(numberChecked != (totalItems = this.workItemTableViewer.getTable().getItemCount()));
        this.selectNoneButton.setEnabled(numberChecked != 0);
    }

    protected void okPressed() {
        this.updateSelectionValue();
        this.setReturnCode(0);
        this.close();
    }

    private void updateSelectionValue() {
        String workItemList = new String("");
        List<Object> checkedList = Arrays.asList(this.workItemTableViewer.getCheckedElements());
        for (IWorkItemHandle iWorkItemHandle : checkedList) {
            if (!workItemList.equalsIgnoreCase("")) {
                workItemList = workItemList.concat(";");
            }
            UUID workItemUUID = iWorkItemHandle.getItemId();
            String workItemUUIDValue = workItemUUID.getUuidValue();
            workItemList = workItemList.concat(workItemUUIDValue);
        }
        this.selectionValue = workItemList;
    }

    protected int getDialogWidthHint() {
        return 500;
    }

    protected class WorkItemTableContentProvider
    extends AbstractWorkItemTableContentProvider {
        private List<IWorkItemHandle> contentList = null;

        protected WorkItemTableContentProvider() {
        }

        public Object[] getElements(Object arg0) {
            return this.contentList == null ? null : this.contentList.toArray();
        }

        public void dispose() {
            if (this.contentList != null) {
                this.contentList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Object input = newInput;
            if (input != null) {
                if (this.contentList == null) {
                    this.contentList = new ArrayList<IWorkItemHandle>();
                } else if (!this.contentList.isEmpty()) {
                    this.contentList.clear();
                }
                if (input instanceof IWorkItemHandle) {
                    this.contentList.add((IWorkItemHandle)input);
                } else if (input instanceof List && ((List)input).get(0) instanceof IWorkItemHandle) {
                    this.contentList.addAll((List)input);
                }
            }
        }

        public List<IWorkItemHandle> getElementsAsList() {
            return this.contentList;
        }
    }

    protected class WorkItemTableLabelProvider
    extends AbstractWorkItemTableLabelProvider {
        private String currentText = null;

        protected WorkItemTableLabelProvider() {
        }

        public Image getColumnImage(Object item, int arg1) {
            return null;
        }

        public String getColumnText(Object item, final int col) {
            final IWorkItemHandle itemHandle = (IWorkItemHandle)item;
            final IWorkItemClient workItemClient = (IWorkItemClient)PackageWorkItemSchedulePropertyDialog.this.fTeamRepository.getClientLibrary(IWorkItemClient.class);
            Job resolveWorkItemJob = new Job(com.ibm.team.enterprise.packaging.internal.ui.nls.Messages.PackageWorkItemWizardPage_JOBNAME_RESOLVEWORKITEM){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IWorkItem workItem = (IWorkItem)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)itemHandle, IWorkItem.FULL_PROFILE, null);
                        if (col == 0) {
                            int itemId = workItem.getId();
                            WorkItemTableLabelProvider.this.setCurrentText(String.valueOf(itemId));
                            PackageWorkItemSchedulePropertyDialog.this.fUUIDLabelMap.put(workItem.getItemId().getUuidValue(), String.valueOf(workItem.getId()));
                        } else {
                            WorkItemTableLabelProvider.this.setCurrentText(workItem.getHTMLSummary().getPlainText());
                        }
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            resolveWorkItemJob.setUser(false);
            resolveWorkItemJob.schedule();
            try {
                resolveWorkItemJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.getCurrentText();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        private String getCurrentText() {
            return this.currentText;
        }

        private void setCurrentText(String currentText) {
            this.currentText = currentText;
        }
    }
}

